/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderPaymentDetailMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderShouldAmountMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillDetailAssemblyAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillDetailAssemblyAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillDetailAssemblyAtomRspBO;
import com.tydic.fsc.po.FscOrderPaymentDetailPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderShouldAmountPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillDetailAssemblyAtomServiceImpl
implements FscPayBillDetailAssemblyAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillDetailAssemblyAtomServiceImpl.class);
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPaymentDetailMapper fscOrderPaymentDetailMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderShouldAmountMapper fscOrderShouldAmountMapper;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;

    @Override
    public FscPayBillDetailAssemblyAtomRspBO dealPayBillDetailAssembly(FscPayBillDetailAssemblyAtomReqBO atomReqBO) {
        FscPayBillDetailAssemblyAtomRspBO rspBO = new FscPayBillDetailAssemblyAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!"0".equals(atomReqBO.getIsprofess())) {
            return rspBO;
        }
        this.fscOrderPaymentDetailMapper.deleteByPayOrderId(atomReqBO.getPayOrderId());
        ArrayList<FscOrderPaymentDetailPO> paymentDetailPOList = new ArrayList<FscOrderPaymentDetailPO>();
        List shouldPayIdList = atomReqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getShouldPayId).collect(Collectors.toList());
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setShouldPayIds(shouldPayIdList);
        List shouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
        if (FscConstants.PaymentMethod.PRE_PAY.equals(((FscShouldPayPO)shouldPayPOList.get(0)).getPayMethod())) {
            List<Long> orderIdList = shouldPayPOList.stream().map(FscShouldPayPO::getOrderId).collect(Collectors.toList());
            Map<String, UocPebUpperOrderAbilityBO> orderMap = this.queryOrderInfoMap(orderIdList);
            for (FscOrderPayItemBO bo : atomReqBO.getFscOrderPayItemBOS()) {
                UocPebUpperOrderAbilityBO orderAbilityBO = orderMap.get(bo.getOrderId().toString());
                if (orderAbilityBO == null) {
                    throw new FscBusinessException("194203", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                UocPebChildOrderAbilityBO orderInfo = (UocPebChildOrderAbilityBO)orderAbilityBO.getChildOrderList().get(0);
                if (orderInfo == null) {
                    throw new FscBusinessException("194203", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                FscOrderPaymentDetailPO detailPO = new FscOrderPaymentDetailPO();
                detailPO.setPaymentDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                detailPO.setShouldPayId(bo.getShouldPayId());
                detailPO.setPayOrderId(atomReqBO.getPayOrderId());
                if ("0".equals(atomReqBO.getIsprofess())) {
                    detailPO.setOrderAmount(new BigDecimal(orderInfo.getPurchaseFeeMoney()));
                } else {
                    detailPO.setOrderAmount(new BigDecimal(orderInfo.getSaleFeeMoney()));
                }
                detailPO.setPayAmount(bo.getPayAmount());
                detailPO.setOrderId(bo.getOrderId());
                detailPO.setOrderCode(orderInfo.getSaleVoucherNo());
                detailPO.setRelType("0".equals(atomReqBO.getIsprofess()) ? FscConstants.FscPayRelType.PRO_PAY : FscConstants.FscPayRelType.PUR_PAY);
                detailPO.setSettleType(atomReqBO.getSettleType());
                detailPO.setCreateId(atomReqBO.getUserId().toString());
                detailPO.setCreateTime(new Date());
                detailPO.setCreateName(atomReqBO.getName());
                paymentDetailPOList.add(detailPO);
            }
        } else {
            List fscOrderIdList = shouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList());
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setFscOrderIds(fscOrderIdList);
            List relationPOList = this.fscOrderRelationMapper.getListGroupByOrderId(fscOrderRelationPO);
            Map<Long, List<FscOrderRelationPO>> fscRelationMap = relationPOList.stream().collect(Collectors.groupingBy(FscOrderRelationPO::getFscOrderId));
            List orderPayList = this.fscOrderPaymentDetailMapper.getPayAmountByFscOrderIdList(fscOrderIdList);
            Map<Object, Object> orderPayMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)orderPayList)) {
                orderPayMap = orderPayList.stream().collect(Collectors.toMap(FscOrderPaymentDetailPO::getMapKey, Function.identity()));
            }
            Map shouldPayIdMap = shouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, Function.identity()));
            for (FscOrderPayItemBO bo : atomReqBO.getFscOrderPayItemBOS()) {
                FscShouldPayPO shouldPayPO = (FscShouldPayPO)shouldPayIdMap.get(bo.getShouldPayId());
                BigDecimal payAmount = bo.getPayAmount();
                BigDecimal payRatio = new BigDecimal("1");
                if (FscConstants.FscPayType.FSC_PAY_TYPE_STAGE.equals(shouldPayPO.getPayType())) {
                    payRatio = shouldPayPO.getNodePayRatio().multiply(new BigDecimal("0.01"));
                }
                List<FscOrderRelationPO> orderRelationPOList = fscRelationMap.get(shouldPayPO.getObjectId());
                for (FscOrderRelationPO orderRelationPO : orderRelationPOList) {
                    BigDecimal maxPayAmount;
                    BigDecimal payableAmount;
                    if (payAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    FscOrderPaymentDetailPO orderPaymentDetailPO = (FscOrderPaymentDetailPO)orderPayMap.get("" + orderRelationPO.getOrderId() + shouldPayPO.getShouldPayId());
                    BigDecimal paidAmount = BigDecimal.ZERO;
                    if (orderPaymentDetailPO != null) {
                        paidAmount = orderPaymentDetailPO.getPayAmount();
                    }
                    if ((payableAmount = (maxPayAmount = orderRelationPO.getSettleAmt().multiply(payRatio)).subtract(paidAmount)).compareTo(BigDecimal.ZERO) <= 0) continue;
                    FscOrderPaymentDetailPO detailPO = new FscOrderPaymentDetailPO();
                    detailPO.setPaymentDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                    detailPO.setShouldPayId(bo.getShouldPayId());
                    detailPO.setPayOrderId(atomReqBO.getPayOrderId());
                    detailPO.setOrderAmount(orderRelationPO.getSettleAmt());
                    detailPO.setOrderId(orderRelationPO.getOrderId());
                    detailPO.setOrderCode(orderRelationPO.getOrderNo());
                    detailPO.setFscOrderId(shouldPayPO.getObjectId());
                    detailPO.setFscOrderNo(shouldPayPO.getObjectNo());
                    detailPO.setRelType("0".equals(atomReqBO.getIsprofess()) ? FscConstants.FscPayRelType.PRO_PAY : FscConstants.FscPayRelType.PUR_PAY);
                    detailPO.setSettleType(atomReqBO.getSettleType());
                    detailPO.setCreateId(atomReqBO.getUserId().toString());
                    detailPO.setCreateTime(new Date());
                    detailPO.setCreateName(atomReqBO.getName());
                    if (payAmount.compareTo(payableAmount) > 0) {
                        detailPO.setPayAmount(payableAmount);
                        payAmount = payAmount.subtract(payableAmount);
                    } else {
                        detailPO.setPayAmount(payAmount);
                        payAmount = BigDecimal.ZERO;
                    }
                    paymentDetailPOList.add(detailPO);
                }
                log.error("payAmount, {}", (Object)JSONObject.toJSONString((Object)payAmount));
                if (payAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                throw new FscBusinessException("194203", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u7ed3\u7b97\u5355\u6240\u6709\u8ba2\u5355\u5f85\u4ed8\u6b3e\u91d1\u989d");
            }
        }
        if (CollectionUtils.isEmpty(paymentDetailPOList)) {
            throw new FscBusinessException("194203", "\u8ba2\u5355\u652f\u4ed8\u660e\u7ec6\u4e3a\u7a7a");
        }
        this.fscOrderPaymentDetailMapper.insertBatch(paymentDetailPOList);
        rspBO.setPaymentDetailPOList(paymentDetailPOList);
        return rspBO;
    }

    @Override
    public FscPayBillDetailAssemblyAtomRspBO dealPayBillDetailAssemblyByOrder(FscPayBillDetailAssemblyAtomReqBO atomReqBO) {
        FscPayBillDetailAssemblyAtomRspBO rspBO = new FscPayBillDetailAssemblyAtomRspBO();
        ArrayList<FscOrderPaymentDetailPO> paymentDetailPOList = new ArrayList<FscOrderPaymentDetailPO>();
        if (FscPayTypeEnum.ADVANCE_PAY.getCode().equals(atomReqBO.getShouldPayMethod())) {
            List<Long> orderIdList = atomReqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getOrderId).collect(Collectors.toList());
            Map<String, UocPebUpperOrderAbilityBO> orderMap = this.queryOrderInfoMap(orderIdList);
            for (FscOrderPayItemBO bo : atomReqBO.getFscOrderPayItemBOS()) {
                UocPebUpperOrderAbilityBO orderAbilityBO = orderMap.get(bo.getOrderId().toString());
                if (orderAbilityBO == null) {
                    throw new FscBusinessException("194203", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                UocPebChildOrderAbilityBO orderInfo = (UocPebChildOrderAbilityBO)orderAbilityBO.getChildOrderList().get(0);
                if (orderInfo == null) {
                    throw new FscBusinessException("194203", "\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                FscOrderPaymentDetailPO detailPO = new FscOrderPaymentDetailPO();
                detailPO.setPaymentDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                detailPO.setShouldPayId(bo.getShouldPayId());
                detailPO.setPayOrderId(atomReqBO.getPayOrderId());
                if ("0".equals(atomReqBO.getIsprofess())) {
                    detailPO.setOrderAmount(new BigDecimal(orderInfo.getPurchaseFeeMoney()));
                } else {
                    detailPO.setOrderAmount(new BigDecimal(orderInfo.getSaleFeeMoney()));
                }
                detailPO.setPayAmount(bo.getPayAmount());
                detailPO.setOrderId(bo.getOrderId());
                detailPO.setOrderCode(orderInfo.getSaleVoucherNo());
                detailPO.setRelType("0".equals(atomReqBO.getIsprofess()) ? FscConstants.FscPayRelType.PRO_PAY : FscConstants.FscPayRelType.PUR_PAY);
                detailPO.setSettleType(atomReqBO.getSettleType());
                detailPO.setCreateId(atomReqBO.getUserId().toString());
                detailPO.setCreateTime(new Date());
                detailPO.setCreateName(atomReqBO.getName());
                paymentDetailPOList.add(detailPO);
            }
        } else {
            ArrayList<Long> shouldPayIdList = new ArrayList<Long>();
            ArrayList fscOrderIdList = new ArrayList();
            for (FscOrderPayItemBO bo : atomReqBO.getFscOrderPayItemBOS()) {
                shouldPayIdList.add(bo.getShouldPayId());
                fscOrderIdList.addAll(bo.getFscBillOrderIdList());
            }
            FscOrderShouldAmountPO fscOrderShouldAmountPO = new FscOrderShouldAmountPO();
            fscOrderShouldAmountPO.setShouldPayIdList(shouldPayIdList);
            fscOrderShouldAmountPO.setFscOrderIdList(fscOrderIdList);
            List shouldPayAmountPOList = this.fscOrderShouldAmountMapper.getWriteListByOrder(fscOrderShouldAmountPO);
            Map<Object, Object> writeAmountMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)shouldPayAmountPOList)) {
                writeAmountMap = shouldPayAmountPOList.stream().collect(Collectors.toMap(FscOrderShouldAmountPO::getMapKey, Function.identity()));
            }
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setFscOrderIds(fscOrderIdList);
            List relationPOList = this.fscOrderRelationMapper.getListGroupByOrderId(fscOrderRelationPO);
            Map fscRelationMap = relationPOList.stream().collect(Collectors.toMap(FscOrderRelationPO::getMapKey, Function.identity()));
            List orderPayList = this.fscOrderPaymentDetailMapper.getPayAmountByShoudlPayIdList(shouldPayIdList);
            Map<Object, Object> orderPayMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)orderPayList)) {
                orderPayMap = orderPayList.stream().collect(Collectors.toMap(FscOrderPaymentDetailPO::getMapKey, Function.identity()));
            }
            for (FscOrderPayItemBO bo : atomReqBO.getFscOrderPayItemBOS()) {
                BigDecimal payAmount = bo.getPayAmount();
                for (Long fscOrderId : bo.getFscBillOrderIdList()) {
                    FscOrderRelationPO orderRelationPO;
                    BigDecimal maxPayAmount;
                    BigDecimal payableAmount;
                    if (payAmount.compareTo(BigDecimal.ZERO) == 0) break;
                    FscOrderShouldAmountPO writePO = (FscOrderShouldAmountPO)writeAmountMap.get("" + fscOrderId + bo.getShouldPayId());
                    BigDecimal writeAmount = BigDecimal.ZERO;
                    if (writePO != null) {
                        writeAmount = writePO.getWriteOffAmount();
                    }
                    FscOrderPaymentDetailPO paymentDetailPO = (FscOrderPaymentDetailPO)orderPayMap.get("" + fscOrderId + bo.getShouldPayId());
                    BigDecimal paidAmount = BigDecimal.ZERO;
                    if (paymentDetailPO != null) {
                        paidAmount = paymentDetailPO.getPayAmount();
                    }
                    if ((payableAmount = (maxPayAmount = (orderRelationPO = (FscOrderRelationPO)fscRelationMap.get("" + fscOrderId + bo.getOrderId())).getSettleAmt()).subtract(paidAmount).subtract(writeAmount)).compareTo(BigDecimal.ZERO) <= 0) continue;
                    FscOrderPaymentDetailPO detailPO = new FscOrderPaymentDetailPO();
                    detailPO.setPaymentDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                    detailPO.setShouldPayId(bo.getShouldPayId());
                    detailPO.setPayOrderId(atomReqBO.getPayOrderId());
                    detailPO.setOrderAmount(orderRelationPO.getSettleAmt());
                    detailPO.setOrderId(orderRelationPO.getOrderId());
                    detailPO.setOrderCode(orderRelationPO.getOrderNo());
                    detailPO.setFscOrderId(orderRelationPO.getFscOrderId());
                    detailPO.setFscOrderNo(orderRelationPO.getFscOrderNo());
                    detailPO.setRelType("0".equals(atomReqBO.getIsprofess()) ? FscConstants.FscPayRelType.PRO_PAY : FscConstants.FscPayRelType.PUR_PAY);
                    detailPO.setSettleType(atomReqBO.getSettleType());
                    detailPO.setCreateId(atomReqBO.getUserId().toString());
                    detailPO.setCreateTime(new Date());
                    detailPO.setCreateName(atomReqBO.getName());
                    if (payAmount.compareTo(payableAmount) > 0) {
                        detailPO.setPayAmount(payableAmount);
                        payAmount = payAmount.subtract(payableAmount);
                    } else {
                        detailPO.setPayAmount(payAmount);
                        payAmount = BigDecimal.ZERO;
                    }
                    paymentDetailPOList.add(detailPO);
                }
                if (payAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                throw new FscBusinessException("194203", "\u4ed8\u6b3e\u91d1\u989d\u548c\u7ed3\u7b97\u5355\u8ba2\u5355\u5f85\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5339\u914d");
            }
        }
        if (CollectionUtils.isEmpty(paymentDetailPOList)) {
            throw new FscBusinessException("194203", "\u8ba2\u5355\u652f\u4ed8\u660e\u7ec6\u4e3a\u7a7a");
        }
        this.fscOrderPaymentDetailMapper.insertBatch(paymentDetailPOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPaymentDetailPOList(paymentDetailPOList);
        return rspBO;
    }

    public Map<String, UocPebUpperOrderAbilityBO> queryOrderInfoMap(List<Long> orderIdList) {
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setPageSize(100000);
        saleDetailsReqBO.setOrderIdList(orderIdList);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setIndividually("1");
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        return saleDetailsRspBO.getRows().stream().collect(Collectors.toMap(UocPebUpperOrderAbilityBO::getOrderId, Function.identity()));
    }
}

