/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.FscShouldPayRspBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscContractSettlementDetailMapper;
import com.tydic.fsc.dao.FscDraftInfoMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceEngineeringPayBillUpdateReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceEngineeringPayBillUpdateRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinanceEngineeringPayBillUpdateBusiService;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscContractSettlementDetailPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinanceEngineeringPayBillUpdateBusiServiceImpl
implements FscFinanceEngineeringPayBillUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceEngineeringPayBillUpdateBusiServiceImpl.class);
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Resource
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscDraftInfoMapper fscDraftInfoMapper;
    public static final String BUSI_NAME = "\u652f\u4ed8\u5355\u5220\u9664";
    public static final String BUSI_CODE = "1199";
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceCapitalInfoAtomService fscFinanceCapitalInfoAtomService;
    @Autowired
    private FscContractSettlementDetailMapper fscContractSettlementDetailMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public FscFinanceEngineeringPayBillUpdateRspBO dealFinanceEngineeringPayBillUpdate(FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        FscOrderPO set = new FscOrderPO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderPayItemBOS())) {
            this.returnPayAmt(reqBO);
            BigDecimal totalAmount = this.updateShouldPay(reqBO);
            set.setTotalCharge(totalAmount);
            set.setToPayAmount(totalAmount);
        }
        set.setUpdateOperId(reqBO.getUserName());
        set.setUpdateOperName(reqBO.getName());
        set.setUpdateTime(new Date());
        set.setRemark(reqBO.getRemark());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(reqBO.getFscOrderId());
        ArrayList<Integer> orderStates = new ArrayList<Integer>();
        orderStates.add(FscConstants.FscPayOrderState.CANCEL);
        orderStates.add(FscConstants.FscPayOrderState.FINANCE_BACK);
        where.setOrderStates(orderStates);
        int count = this.fscOrderMapper.updateBy(set, where);
        if (count != 1) {
            throw new FscBusinessException("193204", "\u5de5\u7a0b\u670d\u52a1\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u662f\u8349\u7a3f\u72b6\u6001");
        }
        this.insertAttachment(reqBO.getAttachmentList(), reqBO.getFscOrderId());
        this.updateFinanceInfo(reqBO);
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            this.invokeStatusFlow(reqBO);
        }
        this.insertCapitalInfo(reqBO);
        FscFinanceEngineeringPayBillUpdateRspBO rspBO = new FscFinanceEngineeringPayBillUpdateRspBO();
        rspBO.setFscOrderId(reqBO.getFscOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        return rspBO;
    }

    private void insertCapitalInfo(FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        this.fscFinanceCapitalPlanMapper.deleteByFscOrderId(reqBO.getFscOrderId());
        this.fscFinanceDraftInfoMapper.deleteByFscOrderId(reqBO.getFscOrderId());
        this.fscFinanceBankStatementMapper.deleteByFscOrderId(reqBO.getFscOrderId());
        this.fscFinancePayReduceMapper.deleteByFscOrderId(reqBO.getFscOrderId());
        this.fscFinancePayItemMapper.deleteByFscOrderId(reqBO.getFscOrderId());
        FscFinanceCapitalInfoAtomReqBO atomReqBO = (FscFinanceCapitalInfoAtomReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscFinanceCapitalInfoAtomReqBO.class);
        atomReqBO.setObjId(reqBO.getFscOrderId());
        atomReqBO.setObjNo(orderPO.getOrderNo());
        atomReqBO.setObjType(Integer.valueOf(1));
        atomReqBO.setFscOrderPayItemBOS(reqBO.getFscOrderPayItemBOS());
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            atomReqBO.setOperationType(Integer.valueOf(1));
        } else {
            atomReqBO.setOperationType(Integer.valueOf(0));
        }
        FscFinanceCapitalInfoAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealFinanceCapitalInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u5b58\u50a8\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
    }

    private void updateFinanceInfo(FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)financePO);
        financePO.setUpdateTime(new Date());
        financePO.setUpdateUserId(reqBO.getUserId() + "");
        financePO.setFscOrderId(reqBO.getFscOrderId());
        int count = this.fscOrderFinanceMapper.updateById(financePO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u4ed8\u6b3e\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void returnPayAmt(FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        FscOrderPayItemPO orderPayItemPO = new FscOrderPayItemPO();
        orderPayItemPO.setFscOrderId(reqBO.getFscOrderId());
        List list = this.fscOrderPayItemMapper.getListWithShouldPay(orderPayItemPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (FscOrderPayItemPO oldPayItemPO : list) {
                this.fscShouldPayMapper.updatePayingAmt(oldPayItemPO.getShouldPayId(), oldPayItemPO.getPayAmount());
            }
        }
    }

    private BigDecimal updateShouldPay(FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        ArrayList<FscShouldPayBO> fscShouldPayBOList = new ArrayList<FscShouldPayBO>();
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        ArrayList<Object> fscContractSettlementDetailPOS = new ArrayList<Object>();
        ArrayList<Long> qryShouldPayIds = new ArrayList<Long>();
        Map<Object, Object> contractSettlementDetailPOMap = new HashMap();
        FscContractSettlementDetailPO contractSettlementDetailQry = new FscContractSettlementDetailPO();
        contractSettlementDetailQry.setDetailIds(reqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getObjectId).collect(Collectors.toList()));
        List fscContractSettlementDetailPOList = this.fscContractSettlementDetailMapper.getList(contractSettlementDetailQry);
        if (!CollectionUtils.isEmpty((Collection)fscContractSettlementDetailPOList)) {
            contractSettlementDetailPOMap = fscContractSettlementDetailPOList.stream().collect(Collectors.toMap(FscContractSettlementDetailPO::getDetailId, Function.identity()));
            ArrayList<FscContractSettlementDetailPO> updateDetailPOList = new ArrayList<FscContractSettlementDetailPO>();
            Map fscOrderPayItemBOMap = reqBO.getFscOrderPayItemBOS().stream().collect(Collectors.toMap(FscOrderPayItemBO::getObjectId, Function.identity()));
            for (FscContractSettlementDetailPO po : fscContractSettlementDetailPOList) {
                if (po.getShouldPayId() != null) {
                    qryShouldPayIds.add(po.getShouldPayId());
                }
                FscContractSettlementDetailPO updatePO = new FscContractSettlementDetailPO();
                updatePO.setDetailId(po.getDetailId());
                updatePO.setPayType(reqBO.getPayType());
                updatePO.setPanelPointCode(((FscOrderPayItemBO)fscOrderPayItemBOMap.get(po.getDetailId())).getPanelPointCode());
                updatePO.setPanelPointName(((FscOrderPayItemBO)fscOrderPayItemBOMap.get(po.getDetailId())).getPanelPointName());
                updatePO.setDays(((FscOrderPayItemBO)fscOrderPayItemBOMap.get(po.getDetailId())).getDays());
                updatePO.setPayPercent(((FscOrderPayItemBO)fscOrderPayItemBOMap.get(po.getDetailId())).getPayPercent());
                updatePO.setPlanAmount(((FscOrderPayItemBO)fscOrderPayItemBOMap.get(po.getDetailId())).getPlanAmount());
                if (StringUtils.isEmpty((Object)((FscOrderPayItemBO)fscOrderPayItemBOMap.get(po.getDetailId())).getPaymentType())) {
                    if (reqBO.getPayType() == 0) {
                        updatePO.setPaymentType("YUFK");
                    } else if (reqBO.getPayType() == 2) {
                        updatePO.setPaymentType("YINGFK");
                    } else if (reqBO.getPayType() == 1) {
                        updatePO.setPaymentType("ZBJ");
                    }
                } else {
                    updatePO.setPaymentType(((FscOrderPayItemBO)fscOrderPayItemBOMap.get(po.getDetailId())).getPaymentType());
                }
                updateDetailPOList.add(updatePO);
            }
            if (!CollectionUtils.isEmpty(updateDetailPOList)) {
                this.fscContractSettlementDetailMapper.updateByDetailIdBatch(updateDetailPOList);
            }
        }
        HashMap<Long, Long> shouldItemPayRelationMap = new HashMap<Long, Long>();
        BigDecimal totalAmount = new BigDecimal(0);
        for (FscOrderPayItemBO fscOrderPayItemBO : reqBO.getFscOrderPayItemBOS()) {
            FscShouldPayBO fscShouldPayBO;
            Object fscContractSettlementDetailPO;
            if (contractSettlementDetailPOMap.containsKey(fscOrderPayItemBO.getObjectId())) {
                fscContractSettlementDetailPO = (FscContractSettlementDetailPO)contractSettlementDetailPOMap.get(fscOrderPayItemBO.getObjectId());
                if (fscContractSettlementDetailPO.getShouldPayId() != null) {
                    int count1;
                    FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                    fscShouldPayPO.setShouldPayId(fscContractSettlementDetailPO.getShouldPayId());
                    fscShouldPayPO.setPayAmount(fscOrderPayItemBO.getPayAmount());
                    if (fscOrderPayItemBO.getReduceAmt() != null) {
                        fscShouldPayPO.setPayAmount(fscShouldPayPO.getPayAmount().add(fscOrderPayItemBO.getReduceAmt()));
                    }
                    if ((count1 = this.fscShouldPayMapper.updateAmount(fscShouldPayPO)) != 1) {
                        throw new FscBusinessException("193204", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
                    }
                    shouldItemPayRelationMap.put(fscOrderPayItemBO.getObjectId(), fscContractSettlementDetailPO.getShouldPayId());
                    continue;
                }
                fscShouldPayBO = this.assemableShouldPayPO(fscOrderPayItemBO, reqBO);
                fscShouldPayBOList.add(fscShouldPayBO);
                continue;
            }
            fscContractSettlementDetailPO = new FscContractSettlementDetailPO();
            fscContractSettlementDetailPO.setDetailId(fscOrderPayItemBO.getObjectId());
            fscContractSettlementDetailPO.setContractId(reqBO.getContractId());
            fscContractSettlementDetailPO.setPayType(reqBO.getPayType());
            fscContractSettlementDetailPO.setPanelPointCode(fscOrderPayItemBO.getPanelPointCode());
            fscContractSettlementDetailPO.setPanelPointName(fscOrderPayItemBO.getPanelPointName());
            fscContractSettlementDetailPO.setDays(fscOrderPayItemBO.getDays());
            fscContractSettlementDetailPO.setPayPercent(fscOrderPayItemBO.getPayPercent());
            fscContractSettlementDetailPO.setPlanAmount(fscOrderPayItemBO.getPlanAmount());
            if (StringUtils.isEmpty((Object)fscOrderPayItemBO.getPaymentType())) {
                if (fscContractSettlementDetailPO.getPayType() == 0) {
                    fscContractSettlementDetailPO.setPaymentType("YUFK");
                } else if (reqBO.getPayType() == 2) {
                    fscContractSettlementDetailPO.setPaymentType("YINGFK");
                } else if (reqBO.getPayType() == 1) {
                    fscContractSettlementDetailPO.setPaymentType("ZBJ");
                }
            } else {
                fscContractSettlementDetailPO.setPaymentType(fscOrderPayItemBO.getPaymentType());
            }
            fscContractSettlementDetailPOS.add(fscContractSettlementDetailPO);
            fscShouldPayBO = this.assemableShouldPayPO(fscOrderPayItemBO, reqBO);
            fscShouldPayBOList.add(fscShouldPayBO);
        }
        if (!CollectionUtils.isEmpty(fscShouldPayBOList)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOList);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.saveShouldPayInfo(fscPayShouldPayCreateAtomReqBO);
            if (!CollectionUtils.isEmpty((Collection)fscPayShouldPayCreateAtomRspBO.getFscShouldPayRspBOs())) {
                shouldItemPayRelationMap.putAll(fscPayShouldPayCreateAtomRspBO.getFscShouldPayRspBOs().stream().collect(Collectors.toMap(FscShouldPayRspBO::getObjectId, FscShouldPayRspBO::getShouldPayId)));
            }
            for (FscContractSettlementDetailPO settlementDetailPO : fscContractSettlementDetailPOList) {
                if (settlementDetailPO.getShouldPayId() != null) continue;
                FscContractSettlementDetailPO record = new FscContractSettlementDetailPO();
                record.setShouldPayId((Long)shouldItemPayRelationMap.get(settlementDetailPO.getDetailId()));
                record.setDetailId(settlementDetailPO.getDetailId());
                this.fscContractSettlementDetailMapper.updateShouldPayIdByDetailId(record);
            }
        }
        if (!CollectionUtils.isEmpty(fscContractSettlementDetailPOS)) {
            fscContractSettlementDetailPOS.forEach(o -> o.setShouldPayId((Long)shouldItemPayRelationMap.get(o.getDetailId())));
            this.fscContractSettlementDetailMapper.insertBatch(fscContractSettlementDetailPOS);
        }
        List shouldPayIds = shouldItemPayRelationMap.values().stream().distinct().collect(Collectors.toList());
        FscShouldPayPO qryShouldPO = new FscShouldPayPO();
        qryShouldPO.setShouldPayIds(shouldPayIds);
        List fscShouldPayPOList = this.fscShouldPayMapper.getList(qryShouldPO);
        Map shouldPayMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, Function.identity()));
        for (FscOrderPayItemBO fscOrderPayItemBO : reqBO.getFscOrderPayItemBOS()) {
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(reqBO.getFscOrderId());
            po.setItemNo(fscOrderPayItemBO.getItemNo());
            po.setIsReduce(fscOrderPayItemBO.getIsReduce());
            if (po.getIsReduce() == null) {
                po.setIsReduce(FscConstants.NO);
            }
            po.setPaymentPhase(fscOrderPayItemBO.getPaymentPhase());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            if (fscOrderPayItemBO.getOrderPayItemId() != null) {
                po.setOrderPayItemId(fscOrderPayItemBO.getOrderPayItemId());
            } else {
                po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            po.setShouldPayId((Long)shouldItemPayRelationMap.get(fscOrderPayItemBO.getObjectId()));
            po.setPayAmount(fscOrderPayItemBO.getPayAmount());
            po.setPayAmountLocal(fscOrderPayItemBO.getPayAmountLocal());
            po.setExt3(fscOrderPayItemBO.getExt3());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            if (po.getReduceAmt() == null) {
                po.setReduceAmt(BigDecimal.ZERO);
            }
            po.setExpType(fscOrderPayItemBO.getExpLineType());
            po.setExpTypeId(fscOrderPayItemBO.getExpTypeCode());
            if (StringUtils.isEmpty((Object)fscOrderPayItemBO.getShouldPayItemNo())) {
                po.setShouldPayItemNo(((FscShouldPayPO)shouldPayMap.get(po.getShouldPayId())).getShouldPayNo() + "-01");
            } else {
                po.setShouldPayItemNo(fscOrderPayItemBO.getShouldPayItemNo());
            }
            po.setShouldPayMethod(reqBO.getShouldPayMethod());
            po.setFscBillOrderId(fscOrderPayItemBO.getFscBillOrderId());
            po.setFscBillOrderNo(fscOrderPayItemBO.getFscBillOrderNo());
            fscOrderPayItemBO.setOrderPayItemId(po.getOrderPayItemId());
            fscOrderPayItemBO.setShouldPayItemNo(po.getShouldPayItemNo());
            fscOrderPayItemBO.setShouldPayId(po.getShouldPayId());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO.getPayAmount());
        }
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(reqBO.getFscOrderId());
        this.fscOrderPayItemMapper.deleteBy(fscOrderPayItemPO);
        if (!CollectionUtils.isEmpty(fscOrderPayItemPOs)) {
            this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        }
        return totalAmount;
    }

    private FscShouldPayBO assemableShouldPayPO(FscOrderPayItemBO fscOrderPayItemBO, FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setShouldPayType(reqBO.getShouldPayType());
        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.CONTRACT);
        fscShouldPayBO.setObjectId(fscOrderPayItemBO.getObjectId());
        fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PREP);
        fscShouldPayBO.setShouldPayAmount(fscOrderPayItemBO.getShouldPayAmount());
        fscShouldPayBO.setPayingAmount(fscOrderPayItemBO.getPayAmount());
        fscShouldPayBO.setToPayAmount(fscShouldPayBO.getShouldPayAmount().subtract(Optional.ofNullable(fscShouldPayBO.getPayingAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(fscShouldPayBO.getPaidAmount()).orElse(BigDecimal.ZERO)));
        fscShouldPayBO.setPayeeId(reqBO.getPayeeId());
        fscShouldPayBO.setPayeeName(reqBO.getPayeeName());
        fscShouldPayBO.setPayerId(reqBO.getPayerId());
        fscShouldPayBO.setPayerName(reqBO.getPayerName());
        fscShouldPayBO.setContractId(reqBO.getContractId());
        fscShouldPayBO.setContractNo(reqBO.getContractNo());
        fscShouldPayBO.setContractName(reqBO.getContractName());
        fscShouldPayBO.setBuyerNo(reqBO.getBuynerNo());
        fscShouldPayBO.setBuyerName(reqBO.getBuynerName());
        fscShouldPayBO.setShouldPayMethod(reqBO.getShouldPayMethod());
        fscShouldPayBO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
        fscShouldPayBO.setContractType(reqBO.getContractType());
        fscShouldPayBO.setBusinessType(reqBO.getBusinessType());
        return fscShouldPayBO;
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        FscAttachmentPO deletPo = new FscAttachmentPO();
        deletPo.setFscOrderId(fscOrderId);
        deletPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
        ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletPo);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            this.fscAttachmentMapper.deleteBy(deletPo);
        }
        if (!CollectionUtils.isEmpty(attachmentBOList)) {
            fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : attachmentBOList) {
                FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPo.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                fscAttachmentPo.setAttachmentName(attachmentBO.getAttachmentName());
                fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAYMENT);
                fscAttachmentPo.setObjId(attachmentBO.getObjId());
                fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
                fscAttachmentPo.setFscOrderId(fscOrderId);
                fscAttachmentPOS.add(fscAttachmentPo);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        }
    }

    private void invokeStatusFlow(FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderStatusStartAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(reqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("M003041");
        uacNoTaskAuditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ENGINEERING_PAY_APPLY_ORDER);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(reqBO.getFscOrderId());
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(reqBO.getFscOrderId().toString());
        approvalObjBO.setObjName("\u5de5\u7a0b\u670d\u52a1\u4ed8\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ENGINEERING_PAY_APPLY_ORDER);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        BigDecimal payAmount = BigDecimal.ZERO;
        for (FscOrderPayItemBO payItem : reqBO.getFscOrderPayItemBOS()) {
            payAmount = payAmount.add(payItem.getPayAmount());
        }
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("payAmount", payAmount);
        Long shouldPayId = ((FscOrderPayItemBO)reqBO.getFscOrderPayItemBOS().get(0)).getShouldPayId();
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setShouldPayId(shouldPayId);
        FscShouldPayPO model = this.fscShouldPayMapper.getModelBy(fscShouldPayPo);
        variables.put("payType", 1);
        uacNoTaskAuditCreateReqBO.setVariables(variables);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("193204", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u4ed8\u6b3e\u5ba1\u6279\u6d41\uff01");
        }
        if (uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        fscOrderStatusStartAtomReqBO.setOrderId(reqBO.getFscOrderId());
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.ENGINEERING_SERVICE_PAY);
        fscOrderStatusStartAtomReqBO.setOperId(reqBO.getUserName());
        FscOrderStatusStartAtomRspBO atomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193204", atomRspBO.getRespDesc());
        }
    }

    private FscPayShouldPayCreateAtomRspBO saveShouldPayInfo(FscPayShouldPayCreateAtomReqBO atomReqBO) {
        ArrayList<FscShouldPayRspBO> fscShouldPayRspBOs = new ArrayList<FscShouldPayRspBO>();
        List fscShouldPayPOS = JSON.parseArray((String)JSON.toJSONString((Object)atomReqBO.getFscShouldPayBOS()), FscShouldPayPO.class);
        List serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()) == null) {
            throw new FscBusinessException("194311", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()).getDescr());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(fscShouldPayPOS.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        for (int i = 0; i < fscShouldPayPOS.size(); ++i) {
            Long shouldPayId = Sequence.getInstance().nextId();
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayPOS.get(i);
            fscShouldPayPO.setShouldPayId(shouldPayId);
            fscShouldPayPO.setCreateId(atomReqBO.getUserId());
            fscShouldPayPO.setCreateName(atomReqBO.getName());
            fscShouldPayPO.setCreateAccount(atomReqBO.getUserName());
            fscShouldPayPO.setCreateTime(new Date());
            fscShouldPayPO.setCreateCompanyId(atomReqBO.getCompanyId());
            fscShouldPayPO.setCreateCompanyName(atomReqBO.getCompanyName());
            fscShouldPayPO.setCreateOrgId(atomReqBO.getOrgId());
            fscShouldPayPO.setCreateOrgName(atomReqBO.getOrgName());
            fscShouldPayPO.setPenalty(new BigDecimal(0));
            fscShouldPayPO.setOriginalAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
            fscShouldPayPO.setToPayAmount(fscShouldPayPO.getToPayAmount());
            fscShouldPayPO.setPaidAmount(new BigDecimal(0));
            fscShouldPayPO.setPayingAmount(fscShouldPayPO.getPayingAmount());
            fscShouldPayPO.setShouldPayNo((String)serialNoList.get(i));
            fscShouldPayPO.setPayMethod(fscShouldPayPO.getShouldPayMethod());
            FscShouldPayRspBO bo = new FscShouldPayRspBO();
            bo.setShouldPayId(shouldPayId);
            bo.setObjectId(fscShouldPayPO.getObjectId());
            bo.setOrderId(fscShouldPayPO.getOrderId());
            fscShouldPayRspBOs.add(bo);
        }
        this.fscShouldPayMapper.insertBatch(fscShouldPayPOS);
        FscPayShouldPayCreateAtomRspBO atomRspBO = new FscPayShouldPayCreateAtomRspBO();
        atomRspBO.setFscShouldPayRspBOs(fscShouldPayRspBOs);
        return atomRspBO;
    }
}

