/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemTempMapper;
import com.tydic.fsc.dao.FscFinancePayReduceTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempDeleteReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempDeleteRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePayItemTempDeleteBusiService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinancePayItemTempDeleteBusiServiceImpl
implements FscFinancePayItemTempDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayItemTempDeleteBusiServiceImpl.class);
    @Autowired
    private FscFinancePayItemTempMapper fscFinancePayItemTempMapper;
    @Autowired
    private FscFinancePayReduceTempMapper fscFinancePayReduceTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;

    @Override
    public FscFinancePayItemTempDeleteRspBO dealFinancePayItemTempDelete(FscFinancePayItemTempDeleteReqBO reqBo) {
        this.valid(reqBo);
        int financePayItemResult = this.fscFinancePayItemTempMapper.deleteBatchById(reqBo.getFinancePayItemIdList());
        if (financePayItemResult != reqBo.getFinancePayItemIdList().size() || financePayItemResult < 1) {
            throw new FscBusinessException("191000", "\u6839\u636e\u4ed8\u6b3e\u4fe1\u606fID\u96c6\u5408[financePayItemIdList]\u5220\u9664\u4ed8\u6b3e\u4fe1\u606f\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        this.fscFinancePayReduceTempMapper.deleteBatchByItemNo(reqBo.getItemNoList());
        this.fscFinanceDraftInfoTempMapper.deleteBatchByItemNo(reqBo.getItemNoList());
        FscFinancePayItemTempDeleteRspBO rsqBO = new FscFinancePayItemTempDeleteRspBO();
        rsqBO.setRespCode("0000");
        rsqBO.setRespDesc("\u6210\u529f");
        return rsqBO;
    }

    private void valid(FscFinancePayItemTempDeleteReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getItemNoList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u884c\u53f7\u96c6\u5408[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFinancePayItemIdList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u4fe1\u606fID\u96c6\u5408[financePayItemIdList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

