/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.alibaba.excel.util.CollectionUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscContractSettlementDetailMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayItemTempMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscFinancePayReduceTempMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderPayItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayTempSyncReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayTempSyncRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePayTempSyncBusiService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscAttachmentTempPO;
import com.tydic.fsc.po.FscContractSettlementDetailPO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinancePayItemTempPO;
import com.tydic.fsc.po.FscFinancePayReducePO;
import com.tydic.fsc.po.FscFinancePayReduceTempPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemTempPO;
import com.tydic.fsc.util.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinancePayTempSyncBusiServiceImpl
implements FscFinancePayTempSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayTempSyncBusiServiceImpl.class);
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderPayItemTempMapper fscOrderPayItemTempMapper;
    @Autowired
    private FscFinancePayItemTempMapper fscFinancePayItemTempMapper;
    @Autowired
    private FscFinancePayReduceTempMapper fscFinancePayReduceTempMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscContractSettlementDetailMapper fscContractSettlementDetailMapper;

    @Override
    public FscFinancePayTempSyncRspBO dealFinancePayTempSync(FscFinancePayTempSyncReqBO reqBo) {
        this.valid(reqBo);
        this.saveOrderPayItem(reqBo);
        this.saveFinancePayItem(reqBo);
        this.saveBankInfo(reqBo);
        this.saveCapitalPlan(reqBo);
        this.saveDraftInfo(reqBo);
        this.saveReduce(reqBo);
        this.saveFile(reqBo);
        FscFinancePayTempSyncRspBO rspBO = new FscFinancePayTempSyncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveOrderPayItem(FscFinancePayTempSyncReqBO reqBo) {
        List orderPayItemPOList = this.fscOrderPayItemMapper.getOrderPayItemTempListByFscOrderId(reqBo.getFscOrderId());
        Map<Object, Object> contractSettleMap = new HashMap();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBo.getFscOrderId());
        FscOrderPO fscOrderPOResult = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (fscOrderPOResult != null && FscConstants.OrderFlow.ENGINEERING_SERVICE_PAY.equals(fscOrderPOResult.getOrderFlow())) {
            FscContractSettlementDetailPO fscContractSettlementDetailPO = new FscContractSettlementDetailPO();
            fscContractSettlementDetailPO.setShouldPayIds(orderPayItemPOList.stream().map(FscOrderPayItemTempPO::getShouldPayId).distinct().collect(Collectors.toList()));
            List fscContractSettlementDetailPOList = this.fscContractSettlementDetailMapper.getList(fscContractSettlementDetailPO);
            if (!CollectionUtils.isEmpty((Collection)fscContractSettlementDetailPOList)) {
                contractSettleMap = fscContractSettlementDetailPOList.stream().collect(Collectors.toMap(FscContractSettlementDetailPO::getShouldPayId, Function.identity()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)orderPayItemPOList)) {
            for (FscOrderPayItemTempPO orderPayItemPO : orderPayItemPOList) {
                orderPayItemPO.setDelFlag(FscConstants.DicDelFlag.NO);
                orderPayItemPO.setOrderPayItemTempId(Long.valueOf(Sequence.getInstance().nextId()));
                orderPayItemPO.setTempId(reqBo.getTempId());
                orderPayItemPO.setExt1(DateUtil.dateToStrLong((Date)new Date()));
                if (!contractSettleMap.containsKey(orderPayItemPO.getShouldPayId())) continue;
                FscContractSettlementDetailPO contractSettlePO = (FscContractSettlementDetailPO)contractSettleMap.get(orderPayItemPO.getShouldPayId());
                orderPayItemPO.setExt4(contractSettlePO.getPanelPointCode());
                orderPayItemPO.setExt5(contractSettlePO.getPanelPointName());
                orderPayItemPO.setDays(contractSettlePO.getDays().intValue());
                orderPayItemPO.setPayPercent(contractSettlePO.getPayPercent());
                orderPayItemPO.setPlanAmount(contractSettlePO.getPlanAmount());
            }
            int count = this.fscOrderPayItemTempMapper.insertBatch(orderPayItemPOList);
            if (count != orderPayItemPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }

    private void saveFinancePayItem(FscFinancePayTempSyncReqBO reqBo) {
        List financePayItemPOList = this.fscFinancePayItemMapper.getFinancePayItemTempListByFscOrderId(reqBo.getFscOrderId());
        if (!CollectionUtils.isEmpty((Collection)financePayItemPOList)) {
            for (FscFinancePayItemTempPO orderPayItemPO : financePayItemPOList) {
                orderPayItemPO.setDelFlag(FscConstants.DicDelFlag.NO);
                orderPayItemPO.setTempId(reqBo.getTempId());
                orderPayItemPO.setFinancePayItemTempId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            int count = this.fscFinancePayItemTempMapper.insertBatch(financePayItemPOList);
            if (count != financePayItemPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }

    private void saveBankInfo(FscFinancePayTempSyncReqBO reqBo) {
        int count;
        FscFinanceBankStatementPO bankStatementPO = new FscFinanceBankStatementPO();
        bankStatementPO.setFscOrderId(reqBo.getFscOrderId());
        List statementPOS = this.fscFinanceBankStatementMapper.getListWithContract(bankStatementPO);
        ArrayList<FscFinanceBankStatementTempPO> bankStatementTempList = new ArrayList<FscFinanceBankStatementTempPO>(statementPOS.size());
        for (FscFinanceBankStatementPO statementPO : statementPOS) {
            FscFinanceBankStatementTempPO bankStatementTempPO = new FscFinanceBankStatementTempPO();
            BeanUtils.copyProperties((Object)statementPO, (Object)bankStatementTempPO);
            bankStatementTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
            bankStatementTempPO.setStatementTempId(Long.valueOf(Sequence.getInstance().nextId()));
            bankStatementTempPO.setTempId(reqBo.getTempId());
            bankStatementTempList.add(bankStatementTempPO);
        }
        if (!CollectionUtils.isEmpty(bankStatementTempList) && (count = this.fscFinanceBankStatementTempMapper.insertBatch(bankStatementTempList)) != bankStatementTempList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u94f6\u884c\u6d41\u6c34\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void saveCapitalPlan(FscFinancePayTempSyncReqBO reqBo) {
        int count;
        FscFinanceCapitalPlanPO capitalPlanPO = new FscFinanceCapitalPlanPO();
        capitalPlanPO.setFscOrderId(reqBo.getFscOrderId());
        List planList = this.fscFinanceCapitalPlanMapper.getListWithContract(capitalPlanPO);
        ArrayList<FscFinanceCapitalPlanTempPO> planTempList = new ArrayList<FscFinanceCapitalPlanTempPO>(planList.size());
        for (FscFinanceCapitalPlanPO planPO : planList) {
            FscFinanceCapitalPlanTempPO planTempPO = new FscFinanceCapitalPlanTempPO();
            BeanUtils.copyProperties((Object)planPO, (Object)planTempPO);
            planTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
            planTempPO.setFinanceCapitalPlanTempId(Long.valueOf(Sequence.getInstance().nextId()));
            planTempPO.setTempId(reqBo.getTempId());
            planTempList.add(planTempPO);
        }
        if (!CollectionUtils.isEmpty(planTempList) && (count = this.fscFinanceCapitalPlanTempMapper.insertBatch(planTempList)) != planTempList.size()) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void saveDraftInfo(FscFinancePayTempSyncReqBO reqBo) {
        int count;
        FscFinanceDraftInfoPO draftInfoPO = new FscFinanceDraftInfoPO();
        draftInfoPO.setFscOrderId(reqBo.getFscOrderId());
        List draftList = this.fscFinanceDraftInfoMapper.getListWithContract(draftInfoPO);
        ArrayList<FscFinanceDraftInfoTempPO> draftTempList = new ArrayList<FscFinanceDraftInfoTempPO>(draftList.size());
        for (FscFinanceDraftInfoPO po : draftList) {
            FscFinanceDraftInfoTempPO draftTempPO = new FscFinanceDraftInfoTempPO();
            BeanUtils.copyProperties((Object)po, (Object)draftTempPO);
            draftTempPO.setTempId(reqBo.getTempId());
            draftTempPO.setFinanceDraftTempId(Long.valueOf(Sequence.getInstance().nextId()));
            draftTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
            draftTempList.add(draftTempPO);
        }
        if (!CollectionUtils.isEmpty(draftTempList) && (count = this.fscFinanceDraftInfoTempMapper.insertBatch(draftTempList)) != draftTempList.size()) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u7968\u636e\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void saveReduce(FscFinancePayTempSyncReqBO reqBo) {
        int count;
        FscFinancePayReducePO reducePO = new FscFinancePayReducePO();
        reducePO.setFscOrderId(reqBo.getFscOrderId());
        List reduceList = this.fscFinancePayReduceMapper.getListWithContract(reducePO);
        ArrayList<FscFinancePayReduceTempPO> reduceTempList = new ArrayList<FscFinancePayReduceTempPO>(reduceList.size());
        for (FscFinancePayReducePO payReducePO : reduceList) {
            FscFinancePayReduceTempPO reduceTempPO = new FscFinancePayReduceTempPO();
            BeanUtils.copyProperties((Object)payReducePO, (Object)reduceTempPO);
            reduceTempPO.setFinancePayReduceTempId(Long.valueOf(Sequence.getInstance().nextId()));
            reduceTempPO.setTempId(reqBo.getTempId());
            reduceTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
            reduceTempList.add(reduceTempPO);
        }
        if (!CollectionUtils.isEmpty(reduceTempList) && (count = this.fscFinancePayReduceTempMapper.insertBatch(reduceTempList)) != reduceTempList.size()) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u6838\u51cf\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void saveFile(FscFinancePayTempSyncReqBO reqBo) {
        int count;
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setFscOrderId(reqBo.getFscOrderId());
        List attachmentPOList = this.fscAttachmentMapper.getList(attachmentPO);
        ArrayList<FscAttachmentTempPO> attachmentTempList = new ArrayList<FscAttachmentTempPO>(attachmentPOList.size());
        for (FscAttachmentPO fscAttachmentPO : attachmentPOList) {
            FscAttachmentTempPO tempPO = new FscAttachmentTempPO();
            BeanUtils.copyProperties((Object)fscAttachmentPO, (Object)tempPO);
            tempPO.setFscOrderId(reqBo.getTempId());
            tempPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            attachmentTempList.add(tempPO);
        }
        if (!CollectionUtils.isEmpty(attachmentTempList) && (count = this.fscAttachmentTempMapper.insertBatch(attachmentTempList)) != attachmentTempList.size()) {
            throw new FscBusinessException("190000", "\u5b58\u50a8\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void valid(FscFinancePayTempSyncReqBO reqBO) {
        if (Objects.isNull(reqBO.getTempId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7ed3\u7b97\u5355ID[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

