/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.FscQryAccountsPayableFscOrderInfoListAbilityService;
import com.tydic.fsc.bill.ability.bo.FscQryAccountsPayableFscOrderInfoBO;
import com.tydic.fsc.bill.ability.bo.FscQryAccountsPayableFscOrderInfoListAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscQryAccountsPayableFscOrderInfoListAbilityRspBO;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscQryAccountsPayableFscOrderInfoListAbilityService"})
public class FscQryAccountsPayableFscOrderInfoListAbilityServiceImpl
implements FscQryAccountsPayableFscOrderInfoListAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;

    @PostMapping(value={"qryAccountsPayableFscOrderInfoList"})
    public FscQryAccountsPayableFscOrderInfoListAbilityRspBO qryAccountsPayableFscOrderInfoList(@RequestBody FscQryAccountsPayableFscOrderInfoListAbilityReqBO reqBO) {
        FscQryAccountsPayableFscOrderInfoListAbilityRspBO rspBO = new FscQryAccountsPayableFscOrderInfoListAbilityRspBO();
        FscOrderPO qryOrderPO = new FscOrderPO();
        qryOrderPO.setContractId(reqBO.getContractId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List fscOrderPOList = this.fscOrderMapper.qryAccountsPayableFscOrderInfoList(qryOrderPO, page);
        if (!CollectionUtils.isEmpty((Collection)fscOrderPOList)) {
            List rows = fscOrderPOList.stream().map(e -> {
                FscQryAccountsPayableFscOrderInfoBO fscQryAccountsPayableFscOrderInfoBO = new FscQryAccountsPayableFscOrderInfoBO();
                FscOrderFinancePO fscOrderFinanceReq = new FscOrderFinancePO();
                fscOrderFinanceReq.setFscOrderId(e.getFscOrderId());
                FscOrderFinancePO fscOrderFinance = this.fscOrderFinanceMapper.getModelBy(fscOrderFinanceReq);
                if (fscOrderFinance != null) {
                    BigDecimal exchangeRate = Objects.nonNull(fscOrderFinance.getExchangeRate()) ? fscOrderFinance.getExchangeRate() : BigDecimal.ONE;
                    fscQryAccountsPayableFscOrderInfoBO.setTotalChargeLocal(Objects.nonNull(e.getTotalCharge()) ? e.getTotalCharge().multiply(exchangeRate) : BigDecimal.ZERO);
                    fscQryAccountsPayableFscOrderInfoBO.setPaidAmountLocal(Objects.nonNull(e.getPaidAmount()) ? e.getPaidAmount().multiply(exchangeRate) : BigDecimal.ZERO);
                    fscQryAccountsPayableFscOrderInfoBO.setPayingAmountLocal(Objects.nonNull(e.getPayingAmount()) ? e.getPayingAmount().multiply(exchangeRate) : BigDecimal.ZERO);
                    fscQryAccountsPayableFscOrderInfoBO.setToPayAmountLocal(Objects.nonNull(e.getToPayAmount()) ? e.getToPayAmount().multiply(exchangeRate) : BigDecimal.ZERO);
                }
                return fscQryAccountsPayableFscOrderInfoBO;
            }).collect(Collectors.toList());
            rspBO.setRows(rows);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

