/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscMemPayConfirmAbilityService;
import com.tydic.fsc.pay.ability.bo.FscMemPayConfirmAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscMemPayConfirmAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscMemPayConfirmBusiService;
import com.tydic.fsc.pay.busi.bo.FscMemPayConfirmBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscMemPayConfirmBusiRspBO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscMemPayConfirmAbilityService"})
public class FscMemPayConfirmAbilityServiceImpl
implements FscMemPayConfirmAbilityService {
    @Autowired
    private FscMemPayConfirmBusiService fscMemPayConfirmBusiService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealMemPayConfirm"})
    public FscMemPayConfirmAbilityRspBO dealMemPayConfirm(@RequestBody FscMemPayConfirmAbilityReqBO reqBO) {
        if (Objects.isNull(reqBO.getFscOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2fscOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getPayerId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2payerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayerName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2payerName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getMemType())) {
            throw new FscBusinessException("191000", "\u5165\u53c2memType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getRedirectUrl())) {
            throw new FscBusinessException("191000", "\u5165\u53c2redirectUrl\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getPayAmount())) {
            throw new FscBusinessException("191000", "\u5165\u53c2payAmount\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u91d1\u989d[payAmount]\u4e0d\u80fd\u4e3a0");
        }
        if (Objects.isNull(reqBO.getSupId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2supId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setPayAmount(reqBO.getPayAmount().setScale(2, RoundingMode.HALF_UP));
        FscMemPayConfirmBusiReqBO fscMemPayConfirmBusiRepBO = (FscMemPayConfirmBusiReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscMemPayConfirmBusiReqBO.class));
        FscMemPayConfirmBusiRspBO busiRspBO = this.fscMemPayConfirmBusiService.dealMemPayConfirm(fscMemPayConfirmBusiRepBO);
        return (FscMemPayConfirmAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscMemPayConfirmAbilityRspBO.class);
    }
}

