/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.FscFinanceSelectContractAmountAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountReqBO;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBoList;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscFinanceAttachmentBO;
import com.tydic.fsc.bo.FscPushFinanceAttachmentBO;
import com.tydic.fsc.bo.FscPushFinanceBankBO;
import com.tydic.fsc.bo.FscPushFinancePayBO;
import com.tydic.fsc.bo.FscPushFinancePayCapitalBO;
import com.tydic.fsc.bo.FscPushFinancePayDraftBO;
import com.tydic.fsc.bo.FscPushFinancePayItemBO;
import com.tydic.fsc.bo.FscPushFinancePayRelationBO;
import com.tydic.fsc.bo.FscPushFinancePaySettleBO;
import com.tydic.fsc.bo.FscPushFinancePrePayBO;
import com.tydic.fsc.bo.FscPushFinanceReduceBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceFileUploadAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscFundsclaimBillTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscFinancePushPayBillAbilityService;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePushPayBillAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePushPayBillAbilityRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePushPayBillBusiService;
import com.tydic.fsc.pay.busi.bo.finance.FscFinancePushPayBillBusiReqBO;
import com.tydic.fsc.pay.busi.bo.finance.FscFinancePushPayBillBusiRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinancePayReducePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscFinancePushPayBillAbilityService"})
public class FscFinancePushPayBillAbilityServiceImpl
implements FscFinancePushPayBillAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePushPayBillAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceFileUploadAbilityService fscFinanceFileUploadAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscFinancePushPayBillBusiService fscFinancePushPayBillBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscFinanceSelectContractAmountAbilityService fscFinanceSelectContractAmountAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"pushFinancePayBill"})
    public FscFinancePushPayBillAbilityRspBO pushFinancePayBill(@RequestBody FscFinancePushPayBillAbilityReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", reqBO.getFscOrderId() + "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f!");
        }
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (financePO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u4ed8\u6b3e\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (FscConstants.FscPushStatus.SUCCESS.equals(financePO.getPushFinanceStatus())) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        FscOrderPayItemPO queryVo = new FscOrderPayItemPO();
        queryVo.setFscOrderId(reqBO.getFscOrderId());
        List payItemList = this.fscOrderPayItemMapper.getList(queryVo);
        if (FscConstants.PaymentMethod.PRE_PAY.equals(((FscOrderPayItemPO)payItemList.get(0)).getShouldPayMethod())) {
            return this.dealPushPrePay(reqBO, orderPO, financePO, payItemList);
        }
        return this.dealPushShouldPay(reqBO, orderPO, financePO, payItemList);
    }

    private FscFinancePushPayBillAbilityRspBO dealPushShouldPay(FscFinancePushPayBillAbilityReqBO reqBO, FscOrderPO orderPO, FscOrderFinancePO financePO, List<FscOrderPayItemPO> payItemList) {
        try {
            FscPushFinancePayBO financePayBO = this.buildPayInfo(financePO, orderPO);
            List fscOrderBillIds = payItemList.stream().map(FscOrderPayItemPO::getFscBillOrderId).distinct().map(Long::valueOf).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(fscOrderBillIds)) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u7ed3\u7b97\u5355id\u4fe1\u606f\uff01");
            }
            List invoiceList = this.fscOrderFinanceMapper.getListByFscOrderIds(fscOrderBillIds);
            if (CollectionUtils.isEmpty((Collection)invoiceList)) {
                throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
            }
            Map<Long, BigDecimal> invoiceMap = invoiceList.stream().collect(Collectors.toMap(FscOrderFinancePO::getFscOrderId, FscOrderFinancePO::getExchangeRate));
            List<FscPushFinancePaySettleBO> settleList = this.buildSettleInfo(reqBO, financePO, financePayBO, invoiceMap);
            List<Object> itemList = new ArrayList();
            List<Object> relationList = new ArrayList();
            List<Object> bankList = new ArrayList();
            if (financePO.getPaymentType() == 1) {
                FscFinancePayItemPO queryVo = new FscFinancePayItemPO();
                queryVo.setFscOrderId(financePO.getFscOrderId());
                List poList = this.fscFinancePayItemMapper.getList(queryVo);
                itemList = this.buildPayItemInfo(poList, orderPO);
                relationList = this.buildRelationInfo(reqBO, invoiceMap);
            } else {
                bankList = this.buildBankInfo(reqBO);
                relationList = this.buildBankRelationInfo(reqBO, invoiceMap);
            }
            List<FscPushFinanceAttachmentBO> fileList = this.buildAttachmentInfo(reqBO, financePO);
            List<FscPushFinanceReduceBO> reduceList = this.buildReduceInfo(reqBO);
            List<FscPushFinancePayDraftBO> draftList = this.buildDraftInfo(reqBO);
            List<FscPushFinancePayCapitalBO> capitalList = this.buildCaptialInfo(reqBO);
            financePayBO.setAttachmentNum(Integer.valueOf(fileList.size()));
            BigDecimal payLocalAmt = payItemList.stream().map(FscOrderPayItemPO::getPayAmountLocal).reduce(BigDecimal.ZERO, BigDecimal::add);
            financePayBO.setPayLocalAmt(payLocalAmt);
            if (CollectionUtils.isEmpty(reduceList)) {
                financePayBO.setCarryoverAmt(BigDecimal.ZERO);
                financePayBO.setCarryoverLocalAmt(BigDecimal.ZERO);
            } else {
                BigDecimal reduceAmt = reduceList.stream().map(FscPushFinanceReduceBO::getCarryoverAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                financePayBO.setCarryoverAmt(reduceAmt);
                BigDecimal reduceAmtLocal = reduceList.stream().map(FscPushFinanceReduceBO::getCarryoverLocalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                financePayBO.setCarryoverLocalAmt(reduceAmtLocal);
            }
            JSONObject reqObj = new JSONObject();
            reqObj.put("baseInfoData", (Object)financePayBO);
            reqObj.put("payApplySettleList", settleList);
            reqObj.put("payApplyCarryoverDetailList", reduceList);
            reqObj.put("cmRpList", itemList);
            reqObj.put("cmRpSettleList", relationList);
            reqObj.put("cmRpBillDetailList", draftList);
            reqObj.put("cmCashPlanList", capitalList);
            reqObj.put("cmBankFlowList", bankList);
            reqObj.put("cmAttachmentList", fileList);
            return this.dealPush(orderPO, reqObj, FscConstants.PaymentMethod.SHOULD_PAY);
        }
        catch (Exception e) {
            return this.dealBuildFail(orderPO, e);
        }
    }

    private FscFinancePushPayBillAbilityRspBO dealPushPrePay(FscFinancePushPayBillAbilityReqBO reqBO, FscOrderPO orderPO, FscOrderFinancePO financePO, List<FscOrderPayItemPO> payItemList) {
        try {
            FscPushFinancePrePayBO prePayBO = this.buildPrePayInfo(reqBO, orderPO, financePO, payItemList.get(0).getShouldPayId());
            FscFinancePayItemPO queryVo = new FscFinancePayItemPO();
            queryVo.setFscOrderId(financePO.getFscOrderId());
            List poList = this.fscFinancePayItemMapper.getList(queryVo);
            List<FscPushFinancePayItemBO> itemList = this.buildPayItemInfo(poList, orderPO);
            List<FscPushFinancePayDraftBO> draftList = this.buildDraftInfo(reqBO);
            List<FscPushFinancePayCapitalBO> capitalList = this.buildCaptialInfo(reqBO);
            BigDecimal payLocalAmt = payItemList.stream().map(FscOrderPayItemPO::getPayAmountLocal).reduce(BigDecimal.ZERO, BigDecimal::add);
            prePayBO.setAdvPayLocalAmt(payLocalAmt);
            List<FscPushFinanceAttachmentBO> fileList = this.buildAttachmentInfo(reqBO, financePO);
            prePayBO.setAttachmentNum(Integer.valueOf(fileList.size()));
            JSONObject reqObj = new JSONObject();
            reqObj.put("baseInfoData", (Object)prePayBO);
            reqObj.put("cmRpList", itemList);
            reqObj.put("cmRpBillDetailList", draftList);
            reqObj.put("cmCashPlanList", capitalList);
            reqObj.put("cmAttachmentList", fileList);
            return this.dealPush(orderPO, reqObj, FscConstants.PaymentMethod.PRE_PAY);
        }
        catch (Exception e) {
            return this.dealBuildFail(orderPO, e);
        }
    }

    private FscFinancePushPayBillAbilityRspBO dealPush(FscOrderPO orderPO, JSONObject reqObj, Integer shouldPayMethod) {
        String token = this.getToken();
        FscFinancePushPayBillBusiReqBO busiReqBO = new FscFinancePushPayBillBusiReqBO();
        busiReqBO.setFscOrderId(orderPO.getFscOrderId());
        busiReqBO.setReqData(reqObj);
        busiReqBO.setToken(token);
        busiReqBO.setOrderNo(orderPO.getOrderNo());
        busiReqBO.setShouldPayMethod(shouldPayMethod);
        FscFinancePushPayBillBusiRspBO busiRspBO = this.fscFinancePushPayBillBusiService.dealPushPayBill(busiReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscFinancePushPayBillAbilityRspBO rspBO = new FscFinancePushPayBillAbilityRspBO();
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private FscPushFinancePrePayBO buildPrePayInfo(FscFinancePushPayBillAbilityReqBO reqBO, FscOrderPO orderPO, FscOrderFinancePO financePO, Long shouldPayId) {
        FscPushFinancePrePayBO payBO = new FscPushFinancePrePayBO();
        payBO.setSrcSys("EB");
        payBO.setSrcBillId(orderPO.getFscOrderId() + "");
        payBO.setSrcBillCode(orderPO.getOrderNo());
        payBO.setCreateUser(financePO.getFinanceUserId());
        payBO.setCreateUserName(financePO.getFinanceUserName());
        payBO.setCreateDate(DateUtil.dateToStrLong((Date)orderPO.getCreateTime()));
        payBO.setDeptCode(financePO.getFinanceDeptId());
        payBO.setDeptName(financePO.getFinanceDeptName());
        payBO.setOrgId(financePO.getFinanceOrgId());
        payBO.setOrgName(financePO.getFinanceOrgName());
        payBO.setBillDate(DateUtil.dateToStrYYYYMMdd((Date)orderPO.getCreateTime()));
        payBO.setBizDeptCode(financePO.getBizDeptCode());
        payBO.setBizDeptName(financePO.getBizDeptName());
        payBO.setBizTypeCode(financePO.getBizTypeCode());
        payBO.setBizTypeName(financePO.getBizTypeName());
        payBO.setBizItemCode(financePO.getBusinessItemCode());
        payBO.setBizItemName(financePO.getBusinessItemName());
        payBO.setNote(financePO.getNote());
        payBO.setSegmentCode(financePO.getSegmentCode());
        payBO.setSegmentName(financePO.getSegmentName());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(orderPO.getCreateTime());
        payBO.setBillYear(calendar.get(1) + "");
        payBO.setBillTypeCode(FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getName());
        payBO.setBillTypeName(FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getDescription());
        payBO.setSegCompanyCode(financePO.getCompanySegmentCode());
        payBO.setSegCompanyName(financePO.getCompanySegmentName());
        payBO.setSegProjectCode(financePO.getProjectSegmentCode());
        payBO.setSegProjectName(financePO.getProjectSegmentName());
        payBO.setSegContractCode(financePO.getContractSegmentCode());
        payBO.setSegContractName(financePO.getContractSegmentName());
        payBO.setSegProductCode(null);
        payBO.setSegProductName(null);
        payBO.setSegMainSubjectName(null);
        payBO.setSegMainSubjectCode(null);
        payBO.setSegSubSubjectCode(null);
        payBO.setSegSubSubjectName(null);
        payBO.setSegCorrespondentCode(null);
        payBO.setSegCorrespondentName(null);
        payBO.setSegCalcCostCode(null);
        payBO.setSegCalcCostName(null);
        payBO.setSegProduceStageCode(null);
        payBO.setSegProduceStageName(null);
        payBO.setSegBakCode(null);
        payBO.setSegBakName(null);
        Map paymentPhaseMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAYMENT_PHASE");
        payBO.setPayStageCode(financePO.getPaymentPhase());
        payBO.setPayStageName((String)paymentPhaseMap.get(financePO.getPaymentPhase()));
        FscShouldPayPO shouldPayPO = new FscShouldPayPO();
        shouldPayPO.setShouldPayId(shouldPayId);
        shouldPayPO = this.fscShouldPayMapper.getModelBy(shouldPayPO);
        payBO.setContractName(shouldPayPO.getContractName());
        payBO.setContractCode(shouldPayPO.getContractNo());
        if ("2".equals(shouldPayPO.getContractType().toString()) || FscConstants.OrderFlow.ENGINEERING_SERVICE_PAY.equals(orderPO.getOrderFlow())) {
            FscFinanceSelectContractAmountReqBO amountReqBO = new FscFinanceSelectContractAmountReqBO();
            amountReqBO.setContractIds(Collections.singletonList(shouldPayPO.getContractId()));
            FscFinanceSelectContractAmountRspBo amountRspBo = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(amountReqBO);
            if (CollectionUtils.isEmpty((Collection)amountRspBo.getRows())) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u5408\u540c\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
            if (((FscFinanceSelectContractAmountRspBoList)amountRspBo.getRows().get(0)).getContractAmount() == null) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u5408\u540c\u91d1\u989d\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
            payBO.setContractAmt(((FscFinanceSelectContractAmountRspBoList)amountRspBo.getRows().get(0)).getContractAmount());
        }
        payBO.setSupplierCode(financePO.getExt1());
        payBO.setSupplierName(orderPO.getPayeeName());
        payBO.setSupplierAreaCode(financePO.getVendorSiteId() + "");
        payBO.setSupplierAreaName(financePO.getVendorSiteName());
        Map currencTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_MONEY_UNIT");
        payBO.setCurrencyCode(financePO.getCurrency());
        payBO.setCurrencyName((String)currencTypeMap.get(financePO.getCurrency()));
        payBO.setRate(financePO.getExchangeRate());
        payBO.setAdvPayAmt(orderPO.getTotalCharge());
        payBO.setAdvPayDate(DateUtil.dateToStrYYYYMMdd((Date)financePO.getPayDate()));
        payBO.setIsAgent(financePO.getIsAgent() + "");
        payBO.setAgentCompanyCode(financePO.getAgentCompanyCode());
        payBO.setAgentCompanyName(financePO.getAgentCompanyName());
        payBO.setCashUnitCode(financePO.getCashUnitCode());
        payBO.setCashUnitName(financePO.getCashUnitName());
        payBO.setCashItemCode(financePO.getCashItemCode());
        payBO.setCashItemName(financePO.getCashItemName());
        payBO.setCashItemDetailCode(financePO.getCashDetailCode());
        payBO.setCashItemDetailName(financePO.getCashDetailName());
        payBO.setBizAccountant(financePO.getFinanceAuditAccount());
        payBO.setBizAccountantName(financePO.getFinanceAuditName());
        payBO.setPanDueDate(DateUtil.dateToStrYYYYMMdd((Date)financePO.getBusinessDate()));
        return payBO;
    }

    private List<FscPushFinancePayRelationBO> buildRelationInfo(FscFinancePushPayBillAbilityReqBO reqBO, Map<Long, BigDecimal> invoiceMap) {
        FscOrderPayItemPO queryVo = new FscOrderPayItemPO();
        queryVo.setFscOrderId(reqBO.getFscOrderId());
        List poList = this.fscOrderPayItemMapper.getListWithFinancePayItem(queryVo);
        ArrayList<FscPushFinancePayRelationBO> relationList = new ArrayList<FscPushFinancePayRelationBO>();
        for (FscOrderPayItemPO po : poList) {
            FscPushFinancePayRelationBO bo = new FscPushFinancePayRelationBO();
            bo.setPayAmt(po.getPayAmount());
            bo.setGuid(po.getFinancePayItemId() + "");
            bo.setCmRpCode(po.getPayItemNo());
            bo.setCmRpGuid(po.getFinancePayItemId() + "");
            bo.setPayLocalAmt(po.getPayAmountLocal());
            bo.setSettleBillGuid(po.getFscBillOrderId());
            bo.setContractCode(po.getContractNo());
            bo.setContractName(po.getContractName());
            bo.setSettleBillCode(po.getFscBillOrderNo());
            bo.setExchangeRate(invoiceMap.get(Long.valueOf(po.getFscBillOrderId())));
            relationList.add(bo);
        }
        return relationList;
    }

    private List<FscPushFinancePayRelationBO> buildBankRelationInfo(FscFinancePushPayBillAbilityReqBO reqBO, Map<Long, BigDecimal> invoiceMap) {
        FscOrderPayItemPO queryVo = new FscOrderPayItemPO();
        queryVo.setFscOrderId(reqBO.getFscOrderId());
        List poList = this.fscOrderPayItemMapper.getListWithBank(queryVo);
        ArrayList<FscPushFinancePayRelationBO> relationList = new ArrayList<FscPushFinancePayRelationBO>();
        for (FscOrderPayItemPO po : poList) {
            FscPushFinancePayRelationBO bo = new FscPushFinancePayRelationBO();
            bo.setPayAmt(po.getPayAmount());
            bo.setGuid(po.getStatementId() + "");
            bo.setPayLocalAmt(po.getPayAmountLocal());
            bo.setSettleBillGuid(po.getFscBillOrderId());
            bo.setContractCode(po.getContractNo());
            bo.setContractName(po.getContractName());
            bo.setSettleBillCode(po.getFscBillOrderNo());
            bo.setCmRpCode(po.getPayItemNo());
            bo.setCmRpGuid(po.getStatementId() + "");
            bo.setExchangeRate(invoiceMap.get(Long.valueOf(po.getFscBillOrderId())));
            relationList.add(bo);
        }
        return relationList;
    }

    private List<FscPushFinancePaySettleBO> buildSettleInfo(FscFinancePushPayBillAbilityReqBO reqBO, FscOrderFinancePO financePO, FscPushFinancePayBO financePayBO, Map<Long, BigDecimal> invoiceMap) {
        FscOrderPayItemPO queryVo = new FscOrderPayItemPO();
        queryVo.setFscOrderId(reqBO.getFscOrderId());
        List poList = this.fscOrderPayItemMapper.getListWithShouldPay(queryVo);
        ArrayList<FscPushFinancePaySettleBO> settleList = new ArrayList<FscPushFinancePaySettleBO>();
        ArrayList<Long> contractIds = new ArrayList<Long>();
        for (FscOrderPayItemPO payItemPO : poList) {
            if (payItemPO.getContractId() == null || !"2".equals(payItemPO.getContractType())) continue;
            contractIds.add(payItemPO.getContractId());
        }
        HashMap<Long, BigDecimal> contractMap = new HashMap<Long, BigDecimal>();
        if (!CollectionUtils.isEmpty(contractIds)) {
            FscFinanceSelectContractAmountReqBO amountReqBO = new FscFinanceSelectContractAmountReqBO();
            amountReqBO.setContractIds(contractIds);
            FscFinanceSelectContractAmountRspBo amountRspBo = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(amountReqBO);
            if (!CollectionUtils.isEmpty((Collection)amountRspBo.getRows())) {
                for (FscFinanceSelectContractAmountRspBoList row : amountRspBo.getRows()) {
                    if (row.getContractAmount() == null) continue;
                    contractMap.put(row.getContractId(), row.getContractAmount().divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP));
                }
            }
        }
        for (FscOrderPayItemPO po : poList) {
            FscPushFinancePaySettleBO bo = new FscPushFinancePaySettleBO();
            bo.setGuid(po.getOrderPayItemId() + "");
            bo.setSettleBillGuid(po.getFscBillOrderId());
            bo.setSettleBillCode(po.getFscBillOrderNo());
            bo.setContractCode(po.getContractNo());
            bo.setContractName(po.getContractName());
            if (po.getContractId() != null) {
                bo.setContractAmt((BigDecimal)contractMap.get(po.getContractId()));
            }
            bo.setPayStageCode(financePayBO.getPayStageCode());
            bo.setPayStageName(financePayBO.getPayStageName());
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(Long.valueOf(po.getFscBillOrderId()));
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            bo.setSettleAmt(fscOrderPO.getTotalCharge());
            bo.setSettlePayedAmt(null);
            bo.setSettleUnpayedAmt(null);
            bo.setIsCarryover(po.getIsReduce() + "");
            bo.setContractPayedAmt(null);
            bo.setContractUnpayedAmt(null);
            bo.setPayAmt(po.getPayAmount());
            bo.setContractPayedLocalAmt(null);
            bo.setContractUnpayedLocalAmt(null);
            bo.setPayLocalAmt(po.getPayAmountLocal());
            bo.setCashItemCode(po.getCashItemCode());
            bo.setCashItemName(po.getCashItemName());
            bo.setCashDetailName(po.getCashDetailName());
            bo.setCashDetailCode(po.getCashDetailCode());
            bo.setPayLocalAmt(po.getPayAmountLocal());
            bo.setExchangeRate(invoiceMap.get(Long.valueOf(po.getFscBillOrderId())));
            settleList.add(bo);
        }
        return settleList;
    }

    private List<FscPushFinancePayItemBO> buildPayItemInfo(List<FscFinancePayItemPO> poList, FscOrderPO orderPO) {
        ArrayList<FscPushFinancePayItemBO> itemList = new ArrayList<FscPushFinancePayItemBO>(poList.size());
        Map paymethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAY_METHOD");
        for (FscFinancePayItemPO po : poList) {
            FscPushFinancePayItemBO itemBO = new FscPushFinancePayItemBO();
            itemBO.setGuid(po.getFinancePayItemId() + "");
            itemBO.setReceiverAccountCode(po.getRecvBankAccountCode());
            itemBO.setReceiverBankAccountNum(po.getRecvBankAccount());
            itemBO.setReceiverAccountName(po.getRecvBankAccountName());
            itemBO.setReceiverLinkbankCode(po.getRecvBankLinkCode());
            itemBO.setReceiverBankName(po.getRecvBankName());
            itemBO.setReceiverBankCode(po.getRecvBankCode());
            itemBO.setReceiverName(orderPO.getPayeeName());
            itemBO.setPayMethodCode(po.getFinancePayMethod());
            itemBO.setPayMethodName((String)paymethodMap.get(po.getFinancePayMethod()));
            itemBO.setPayerAccountCode(po.getPayerAccountCode());
            itemBO.setPayerAccountName(po.getPayerAccountName());
            itemBO.setPayerBankCode(po.getPayerBankCode());
            itemBO.setPayerBankName(po.getPayerBankName());
            itemBO.setPayerLinkbankCode(po.getPayerLinkBankCode());
            itemBO.setPayerBankAccountNum(po.getPayerBankAccountNum());
            itemBO.setPayOriginAmt(po.getPayAmount());
            itemBO.setPayLocalAmt(po.getPayAmountLocal());
            itemBO.setAcceptBillTypeCode(po.getAcceptBillTypeCode());
            itemBO.setAcceptBillTypeName(po.getAcceptBillTypeName());
            itemBO.setAcceptBillOpenCode(po.getAcceptBillOpenCode());
            itemBO.setAcceptBillOpenName(po.getAcceptBillOpenName());
            itemBO.setAcceptBillPledgeCode(po.getPledgeNo());
            itemBO.setAcceptBillCode(null);
            itemBO.setAcceptBillResidueAmt(null);
            itemBO.setSupplyChainFinancePlatformCode(po.getFinancePlatformCode());
            itemBO.setSupplyChainFinancePlatformName(po.getFinancePlatformName());
            itemBO.setBankNote(po.getBankRemark());
            itemBO.setIsBuyExchange(po.getIsBuyExchange());
            itemBO.setBillFlowGuid(null);
            itemList.add(itemBO);
        }
        return itemList;
    }

    private List<FscPushFinancePayDraftBO> buildDraftInfo(FscFinancePushPayBillAbilityReqBO reqBO) {
        FscFinanceDraftInfoPO queryVo = new FscFinanceDraftInfoPO();
        queryVo.setFscOrderId(reqBO.getFscOrderId());
        List poList = this.fscFinanceDraftInfoMapper.getListWithPay(queryVo);
        if (CollectionUtils.isEmpty((Collection)poList)) {
            return new ArrayList<FscPushFinancePayDraftBO>();
        }
        ArrayList<FscPushFinancePayDraftBO> draftList = new ArrayList<FscPushFinancePayDraftBO>();
        for (FscFinanceDraftInfoPO po : poList) {
            FscPushFinancePayDraftBO draftBO = new FscPushFinancePayDraftBO();
            draftBO.setGuid(po.getDraftId() + "");
            draftBO.setCmRpGuid(po.getFinancePayItemId() + "");
            draftBO.setCmRpCode(po.getPayItemNo());
            draftBO.setAcceptBillTypeCode(po.getBillType());
            draftBO.setAcceptBillTypeName(po.getBillTypeName());
            draftBO.setTicketCode(po.getBillNo());
            draftBO.setAcceptBillResidueAmt(po.getRemainingAmount());
            draftBO.setCurrentPayAmt(po.getOccAmt());
            draftBO.setCurrentPayLocalAmt(po.getOccAmtLocal());
            draftBO.setHolderName(po.getHolderName());
            draftBO.setHolderNameCode(po.getHolderNameCode());
            draftBO.setHolderBranchBankName(po.getHolderBranchBankName());
            draftBO.setHolderAccountNo(po.getHolderAccountNo());
            draftBO.setHldrCnapsNo(po.getHolderCnapsNo());
            draftBO.setPlatformCode(po.getFinancePlatformCode());
            draftBO.setPlatformName(po.getFinancePlatformName());
            draftBO.setBizBlAmt(po.getBillAmount());
            draftBO.setBillFlowGuid(po.getGuid());
            draftList.add(draftBO);
        }
        return draftList;
    }

    private List<FscPushFinancePayCapitalBO> buildCaptialInfo(FscFinancePushPayBillAbilityReqBO reqBO) {
        FscFinanceCapitalPlanPO queryVo = new FscFinanceCapitalPlanPO();
        queryVo.setFscOrderId(reqBO.getFscOrderId());
        List poList = this.fscFinanceCapitalPlanMapper.getListWithPay(queryVo);
        if (CollectionUtils.isEmpty((Collection)poList)) {
            return new ArrayList<FscPushFinancePayCapitalBO>();
        }
        ArrayList<FscPushFinancePayCapitalBO> capitalList = new ArrayList<FscPushFinancePayCapitalBO>(poList.size());
        for (FscFinanceCapitalPlanPO po : poList) {
            FscPushFinancePayCapitalBO capitalBO = new FscPushFinancePayCapitalBO();
            capitalBO.setGuid(po.getCaptialId() + "");
            if (po.getStatementId() == null) {
                capitalBO.setDetailGuid(po.getFinancePayItemId() + "");
                capitalBO.setDetailCode(po.getPayItemNo());
            } else {
                capitalBO.setDetailGuid(po.getStatementId() + "");
                capitalBO.setDetailCode(po.getPayItemNo());
            }
            capitalBO.setFundPlanPeriod(po.getPeriod().replace("-", ""));
            capitalBO.setFundBudgetItemCode(po.getFundBudgetItemCode());
            capitalBO.setFundBudgetItemName(po.getFundBudgetItemName());
            capitalBO.setFundPlanItemCode(po.getPlanItemCode());
            capitalBO.setFundPlanItemName(po.getPlanItemName());
            capitalBO.setCapitalPayItemCode(po.getCapitalPayItemCode());
            capitalBO.setCapitalPayItemName(po.getCapitalPayItemName());
            capitalBO.setFundPlanAmt(po.getBalAmount());
            capitalBO.setFundUseAmt(po.getOccAmount());
            capitalBO.setPayMethodCode(po.getPayMethodCode());
            capitalBO.setPayMethodName(po.getPayMethodName());
            capitalList.add(capitalBO);
        }
        return capitalList;
    }

    private List<FscPushFinanceBankBO> buildBankInfo(FscFinancePushPayBillAbilityReqBO reqBO) {
        FscFinanceBankStatementPO queryVo = new FscFinanceBankStatementPO();
        queryVo.setFscOrderId(reqBO.getFscOrderId());
        List bankPoList = this.fscFinanceBankStatementMapper.getList(queryVo);
        if (CollectionUtils.isEmpty((Collection)bankPoList)) {
            return new ArrayList<FscPushFinanceBankBO>();
        }
        ArrayList<FscPushFinanceBankBO> bankList = new ArrayList<FscPushFinanceBankBO>(bankPoList.size());
        for (FscFinanceBankStatementPO po : bankPoList) {
            FscPushFinanceBankBO bankBO = new FscPushFinanceBankBO();
            bankBO.setGuid(po.getStatementId() + "");
            bankBO.setFlowNo(po.getBankFlowNum());
            bankBO.setFlowDate(DateUtil.dateToStrYYYYMMdd((Date)po.getBankFlowDate()));
            bankBO.setSummary(po.getExt1());
            bankBO.setCurrencyCode(po.getCurrencyCode());
            bankBO.setCurrencyName(po.getCurrencyName());
            bankBO.setOurAccountName(po.getOursidAccName());
            bankBO.setOurAccountNum(po.getOursidBankAcc());
            bankBO.setOurBankName(po.getOursidAccOpebnkName());
            bankBO.setOurOpeningBank(po.getOursidAccOpebnk());
            bankBO.setCounterpartyAccountNum(po.getOppsidBankAcc());
            bankBO.setCounterpartyAccountName(po.getOppsidAccName());
            bankBO.setCounterpartyOpeningBank(po.getOppsidAccOpebnk());
            bankBO.setCounterpartyBankName(po.getOppsidAccOpebnkName());
            bankBO.setBankFlowDirectionCode(po.getFlowDirFlag());
            bankBO.setBankFlowDirectionName(po.getFlowDirFlagName());
            bankBO.setTransactionAmt(po.getAmount());
            bankBO.setClaimableAmt(po.getAmountUnclaimed());
            bankBO.setClaimableLocalAmt(po.getAmountUnclaimedLocal());
            bankBO.setCurrentClaimOriginalAmt(po.getOccAmt());
            bankBO.setCurrentClaimOriginalLocalAmt(po.getOccAmtLocal());
            bankBO.setIsAgent(po.getIsAgent() + "");
            bankBO.setBankFlowGuid(po.getGuid());
            bankBO.setFinancialDetailGuid(po.getExtId());
            bankList.add(bankBO);
        }
        return bankList;
    }

    private List<FscPushFinanceAttachmentBO> buildAttachmentInfo(FscFinancePushPayBillAbilityReqBO reqBO, FscOrderFinancePO financePO) {
        FscAttachmentPO queryVo = new FscAttachmentPO();
        queryVo.setObjId(reqBO.getFscOrderId());
        List attachmentPOList = this.fscAttachmentMapper.getList(queryVo);
        if (CollectionUtils.isEmpty((Collection)attachmentPOList)) {
            return new ArrayList<FscPushFinanceAttachmentBO>();
        }
        List boList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)attachmentPOList), AttachmentBO.class);
        FscFinanceFileUploadAbilityReqBO abilityReqBO = new FscFinanceFileUploadAbilityReqBO();
        abilityReqBO.setFileList(boList);
        FscFinanceFileUploadAbilityRspBO abilityRspBO = this.fscFinanceFileUploadAbilityService.dealFinanceUpload(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + abilityRspBO.getRespDesc());
        }
        ArrayList<FscPushFinanceAttachmentBO> fileList = new ArrayList<FscPushFinanceAttachmentBO>(abilityRspBO.getFileList().size());
        for (FscFinanceAttachmentBO bo : abilityRspBO.getFileList()) {
            FscPushFinanceAttachmentBO pushBo = new FscPushFinanceAttachmentBO();
            pushBo.setFileId(bo.getFileId());
            pushBo.setFileName(bo.getFileName());
            pushBo.setFileSize(bo.getFileSize());
            pushBo.setCreateUserName(financePO.getFinanceUserName());
            pushBo.setCreateUser(financePO.getFinanceUserId());
            fileList.add(pushBo);
        }
        return fileList;
    }

    private List<FscPushFinanceReduceBO> buildReduceInfo(FscFinancePushPayBillAbilityReqBO reqBO) {
        FscFinancePayReducePO queryVo = new FscFinancePayReducePO();
        queryVo.setFscOrderId(reqBO.getFscOrderId());
        List reducePOList = this.fscFinancePayReduceMapper.getListWithPay(queryVo);
        if (CollectionUtils.isEmpty((Collection)reducePOList)) {
            return new ArrayList<FscPushFinanceReduceBO>();
        }
        ArrayList<FscPushFinanceReduceBO> reduceList = new ArrayList<FscPushFinanceReduceBO>(reducePOList.size());
        for (FscFinancePayReducePO po : reducePOList) {
            FscPushFinanceReduceBO reduceBO = new FscPushFinanceReduceBO();
            reduceBO.setGuid(po.getReduceId() + "");
            reduceBO.setSettleBillGuid(po.getSettleId() + "");
            reduceBO.setSettleBillCode(po.getSettleNo());
            reduceBO.setBizTypeCode(po.getReduceItemCode());
            reduceBO.setBizTypeName(po.getReduceItemName());
            reduceBO.setBizItemCode(po.getReduceDetailCode());
            reduceBO.setBizItemName(po.getReduceDetailName());
            reduceBO.setCarryoverAmt(po.getReduceAmt());
            reduceBO.setCarryoverLocalAmt(po.getReduceAmtLocal());
            reduceBO.setContractCode(po.getContractNo());
            reduceBO.setContractName(po.getContractName());
            reduceList.add(reduceBO);
        }
        return reduceList;
    }

    private FscPushFinancePayBO buildPayInfo(FscOrderFinancePO financePO, FscOrderPO orderPO) {
        FscPushFinancePayBO payBO = new FscPushFinancePayBO();
        payBO.setSrcSys("EB");
        payBO.setSrcBillId(orderPO.getFscOrderId() + "");
        payBO.setSrcBillCode(orderPO.getOrderNo());
        payBO.setCreateUser(financePO.getFinanceUserId());
        payBO.setCreateUserName(financePO.getFinanceUserName());
        payBO.setCreateDate(DateUtil.dateToStrLong((Date)orderPO.getCreateTime()));
        payBO.setDeptCode(financePO.getFinanceDeptId());
        payBO.setDeptName(financePO.getFinanceDeptName());
        payBO.setOrgId(financePO.getFinanceOrgId());
        payBO.setOrgName(financePO.getFinanceOrgName());
        payBO.setBillDate(DateUtil.dateToStrYYYYMMdd((Date)orderPO.getCreateTime()));
        payBO.setBizDeptCode(financePO.getBizDeptCode());
        payBO.setBizDeptName(financePO.getBizDeptName());
        payBO.setBizTypeCode(financePO.getBizTypeCode());
        payBO.setBizTypeName(financePO.getBizTypeName());
        payBO.setBizItemCode(financePO.getBusinessItemCode());
        payBO.setBizItemName(financePO.getBusinessItemName());
        payBO.setNote(financePO.getNote());
        payBO.setSegmentCode(financePO.getSegmentCode());
        payBO.setSegmentName(financePO.getSegmentName());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(orderPO.getCreateTime());
        payBO.setBillYear(calendar.get(1) + "");
        payBO.setBillTypeCode(FscFundsclaimBillTypeEnum.PAY_BILL_TYPE_USED_CONTRACT.getName());
        payBO.setBillTypeName(FscFundsclaimBillTypeEnum.PAY_BILL_TYPE_USED_CONTRACT.getDescription());
        payBO.setSegCompanyCode(financePO.getCompanySegmentCode());
        payBO.setSegCompanyName(financePO.getCompanySegmentName());
        payBO.setSegProjectCode(financePO.getProjectSegmentCode());
        payBO.setSegProjectName(financePO.getProjectSegmentName());
        payBO.setSegContractCode(financePO.getContractSegmentCode());
        payBO.setSegContractName(financePO.getContractSegmentName());
        payBO.setSegProductCode(null);
        payBO.setSegProductName(null);
        payBO.setSegMainSubjectName(null);
        payBO.setSegMainSubjectCode(null);
        payBO.setSegSubSubjectCode(null);
        payBO.setSegSubSubjectName(null);
        payBO.setSegCorrespondentCode(null);
        payBO.setSegCorrespondentName(null);
        payBO.setSegCalcCostCode(null);
        payBO.setSegCalcCostName(null);
        payBO.setSegProduceStageCode(null);
        payBO.setSegProduceStageName(null);
        payBO.setSegBakCode(null);
        payBO.setSegBakName(null);
        Map paymentPhaseMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_FINANCE_PAYMENT_PHASE");
        payBO.setPayStageCode(financePO.getPaymentPhase());
        payBO.setPayStageName((String)paymentPhaseMap.get(financePO.getPaymentPhase()));
        payBO.setSupplierCode(financePO.getExt1());
        payBO.setSupplierName(orderPO.getPayeeName());
        payBO.setSupplierAreaCode(financePO.getVendorSiteId() + "");
        payBO.setSupplierAreaName(financePO.getVendorSiteName());
        Map currencTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_MONEY_UNIT");
        payBO.setCurrencyCode(financePO.getCurrency());
        payBO.setCurrencyName((String)currencTypeMap.get(financePO.getCurrency()));
        payBO.setRate(financePO.getExchangeRate());
        payBO.setPayAmt(orderPO.getTotalCharge());
        payBO.setPayType(financePO.getPaymentType() + "");
        payBO.setIsAgent(financePO.getIsAgent() + "");
        payBO.setAgentCompanyCode(financePO.getAgentCompanyCode());
        payBO.setAgentCompanyName(financePO.getAgentCompanyName());
        payBO.setCashUnitCode(financePO.getCashUnitCode());
        payBO.setCashUnitName(financePO.getCashUnitName());
        payBO.setPayDate(DateUtil.dateToStrYYYYMMdd((Date)financePO.getPayDate()));
        payBO.setBizAccountant(financePO.getFinanceAuditAccount());
        payBO.setBizAccountantName(financePO.getFinanceAuditName());
        return payBO;
    }

    private FscFinancePushPayBillAbilityRspBO dealBuildFail(FscOrderPO orderPO, Exception e) {
        log.debug("\u6784\u5efa\u63a8\u9001\u5171\u4eab\u4ed8\u6b3e\u5355\u53c2\u6570\u5f02\u5e38\uff1a{}", (Throwable)e);
        FscFinancePushPayBillBusiReqBO busiReqBO = new FscFinancePushPayBillBusiReqBO();
        busiReqBO.setFscOrderId(orderPO.getFscOrderId());
        busiReqBO.setOrderNo(orderPO.getOrderNo());
        busiReqBO.setFailRemark(e.getMessage());
        this.fscFinancePushPayBillBusiService.updateFailLog(busiReqBO);
        FscFinancePushPayBillAbilityRspBO rspBO = new FscFinancePushPayBillAbilityRspBO();
        rspBO.setRespCode("198888");
        rspBO.setRespDesc("\u6784\u5efa\u63a8\u9001\u5171\u4eab\u4ed8\u6b3e\u5355\u53c2\u6570\u5f02\u5e38\uff1a" + e.getMessage());
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        return rspBO;
    }

    private String getToken() {
        FscFinanceShareTokenRspBO shareToken = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        if (StringUtils.isEmpty((Object)shareToken.getToken())) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u8d22\u52a1\u5171\u4eabtoken\u4fe1\u606f\u5931\u8d25\uff1a" + shareToken.getRespDesc());
        }
        return shareToken.getToken();
    }

    @PostMapping(value={"dealPushFinancePayBatch"})
    public FscFinancePushPayBillAbilityRspBO dealPushFinancePayBatch(@RequestBody FscFinancePushPayBillAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuffer sb = new StringBuffer();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscFinancePushPayBillAbilityReqBO abilityReqBO = new FscFinancePushPayBillAbilityReqBO();
            abilityReqBO.setFscOrderId(fscOrderId);
            FscFinancePushPayBillAbilityRspBO abilityRspBO = this.pushFinancePayBill(abilityReqBO);
            if ("0000".equals(abilityRspBO.getRespCode())) continue;
            sb.append("\u5355\u636e[").append(fscOrderId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(abilityRspBO.getRespDesc());
        }
        FscFinancePushPayBillAbilityRspBO rspBO = new FscFinancePushPayBillAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }
}

