/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.pay.ability.api.finance.FscPayEngineeringQryStageAmountAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayEngineeringQryStageAmountAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayEngineeringQryStageAmountAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.finance.FscPayEngineeringQryStageAmountBO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscPayEngineeringQryStageAmountAbilityService"})
public class FscPayEngineeringQryStageAmountAbilityServiceImpl
implements FscPayEngineeringQryStageAmountAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayEngineeringQryStageAmountAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;

    @PostMapping(value={"getFscPayEngineeringQryStageAmount"})
    public FscPayEngineeringQryStageAmountAbilityRspBO getFscPayEngineeringQryStageAmount(@RequestBody FscPayEngineeringQryStageAmountAbilityReqBO reqBO) {
        if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscPayEngineeringQryStageAmountAbilityRspBO rspBO = new FscPayEngineeringQryStageAmountAbilityRspBO();
        FscOrderRelationPO qryOrderRelationPO = new FscOrderRelationPO();
        qryOrderRelationPO.setFscOrderIds(reqBO.getFscOrderIds());
        qryOrderRelationPO.setContractId(reqBO.getContractId());
        List fscPayEngineeringQryStageAmount = this.fscOrderRelationMapper.getFscPayEngineeringQryStageAmount(qryOrderRelationPO);
        log.debug("\u67e5\u8be2\u5de5\u7a0b\u670d\u52a1\u4ed8\u6b3e\u5e94\u4ed8\u67e5\u8be2\u9636\u6bb5\u91d1\u989d\uff1a{}", (Object)JSON.toJSONString((Object)fscPayEngineeringQryStageAmount));
        List<FscPayEngineeringQryStageAmountBO> fscPayEngineeringQryStageAmountBOList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)fscPayEngineeringQryStageAmount)) {
            fscPayEngineeringQryStageAmountBOList = JSON.parseArray((String)JSON.toJSONString((Object)fscPayEngineeringQryStageAmount), FscPayEngineeringQryStageAmountBO.class);
        }
        Map<Object, Object> fscOrderFinanceMap = new HashMap();
        Map<Object, Object> fscOrderMap = new HashMap();
        FscOrderFinancePO qryOrderFinancePO = new FscOrderFinancePO();
        qryOrderFinancePO.setFscOrderIds(reqBO.getFscOrderIds());
        List fscOrderFinancePOList = this.fscOrderFinanceMapper.getList(qryOrderFinancePO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderFinancePOList)) {
            fscOrderFinanceMap = fscOrderFinancePOList.stream().collect(Collectors.groupingBy(FscOrderFinancePO::getFscOrderId));
        }
        FscOrderPO qryOrderPO = new FscOrderPO();
        qryOrderPO.setFscOrderIds(reqBO.getFscOrderIds());
        List list = this.fscOrderMapper.getList(qryOrderPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            fscOrderMap = list.stream().collect(Collectors.groupingBy(FscOrderPO::getFscOrderId));
        }
        if (!CollectionUtils.isEmpty(fscPayEngineeringQryStageAmountBOList)) {
            for (FscPayEngineeringQryStageAmountBO bo2 : fscPayEngineeringQryStageAmountBOList) {
                if (bo2.getShouldPayAmount() == null) {
                    bo2.setShouldPayAmount(bo2.getSettleAmt());
                }
                if (bo2.getPaidAmount() == null) {
                    bo2.setPaidAmount(new BigDecimal(BigInteger.ZERO));
                }
                if (bo2.getToPayAmount() == null) {
                    bo2.setToPayAmount(bo2.getSettleAmt());
                }
                if (bo2.getPayingAmount() == null) {
                    bo2.setPayingAmount(new BigDecimal(BigInteger.ZERO));
                }
                if (fscOrderFinanceMap.containsKey(bo2.getFscOrderId())) {
                    bo2.setSettleAmtLocal(((FscOrderFinancePO)((List)fscOrderFinanceMap.get(bo2.getFscOrderId())).get(0)).getExchangeRate().multiply(bo2.getSettleAmt()).setScale(2, RoundingMode.HALF_UP));
                    bo2.setPaidAmountLocal(((FscOrderFinancePO)((List)fscOrderFinanceMap.get(bo2.getFscOrderId())).get(0)).getExchangeRate().multiply(bo2.getPaidAmount()).setScale(2, RoundingMode.HALF_UP));
                    bo2.setPayingAmountLocal(((FscOrderFinancePO)((List)fscOrderFinanceMap.get(bo2.getFscOrderId())).get(0)).getExchangeRate().multiply(bo2.getPayingAmount()).setScale(2, RoundingMode.HALF_UP));
                    bo2.setToPayAmountLocal(((FscOrderFinancePO)((List)fscOrderFinanceMap.get(bo2.getFscOrderId())).get(0)).getExchangeRate().multiply(bo2.getToPayAmount()).setScale(2, RoundingMode.HALF_UP));
                }
                if (!fscOrderMap.containsKey(bo2.getFscOrderId())) continue;
                bo2.setFscOrderNo(((FscOrderPO)((List)fscOrderMap.get(bo2.getFscOrderId())).get(0)).getOrderNo());
            }
            fscPayEngineeringQryStageAmountBOList.removeIf(bo -> bo.getPaidAmount().equals(bo.getSettleAmt()) && bo.getPayingAmount().compareTo(BigDecimal.ZERO) == 0 && bo.getToPayAmount().compareTo(BigDecimal.ZERO) == 0);
        }
        rspBO.setFscPayEngineeringQryStageAmountBOList(fscPayEngineeringQryStageAmountBOList);
        return rspBO;
    }
}

