/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementAbilityReqBO;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementAbilityRspBO;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementItemBO;
import com.tydic.contract.ability.enums.ContractObjectTypeEnum;
import com.tydic.contract.ability.finance.ContractSyncSettlementAbilityService;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.FscShouldPayRspBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscContractSettlementDetailMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscFinanceEngineeringPayBillCreateReqBO;
import com.tydic.fsc.pay.ability.bo.FscFinanceEngineeringPayBillCreateRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinanceEngineeringPayBillCreateBusiService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscContractSettlementDetailPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinanceEngineeringPayBillCreateBusiServiceImpl
implements FscFinanceEngineeringPayBillCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceEngineeringPayBillCreateBusiServiceImpl.class);
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscFinanceCapitalInfoAtomService fscFinanceCapitalInfoAtomService;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Autowired
    private FscContractSettlementDetailMapper fscContractSettlementDetailMapper;
    @Autowired
    private ContractSyncSettlementAbilityService contractSyncSettlementAbilityService;

    @Override
    public FscFinanceEngineeringPayBillCreateRspBO dealFinanceEngineeringPayBillCreate(FscFinanceEngineeringPayBillCreateReqBO reqBO) {
        FscFinanceEngineeringPayBillCreateRspBO createRspBO = new FscFinanceEngineeringPayBillCreateRspBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        String operationNo = String.valueOf(reqBO.getOrgId());
        if ("0".equals(reqBO.getIsprofess())) {
            String[] org;
            for (String pro : org = this.proOrg.split(",")) {
                if (!reqBO.getOrgPath().contains(pro)) continue;
                operationNo = pro;
            }
        }
        this.updateShouldPay(reqBO, fscOrderId);
        this.insertOrder(reqBO, fscOrderId, operationNo);
        this.insertAttachment(reqBO.getAttachmentList(), fscOrderId);
        this.insertFinanceInfo(reqBO, fscOrderId);
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            this.invokeUacNoTask(reqBO, fscOrderId);
        }
        this.insertCapitalInfo(reqBO, fscOrderId);
        if (!"1".equals(reqBO.getSaveOrSubmit()) && reqBO.getPayType() == 0) {
            this.syncContractInfo(fscOrderId, reqBO);
        }
        createRspBO.setFscOrderId(fscOrderId);
        createRspBO.setRespCode("0000");
        createRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return createRspBO;
    }

    private void insertCapitalInfo(FscFinanceEngineeringPayBillCreateReqBO reqBO, Long fscOrderId) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(fscOrderId);
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscFinanceCapitalInfoAtomReqBO atomReqBO = (FscFinanceCapitalInfoAtomReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscFinanceCapitalInfoAtomReqBO.class);
        atomReqBO.setObjId(fscOrderId);
        atomReqBO.setObjNo(orderPO.getOrderNo());
        atomReqBO.setObjType(Integer.valueOf(1));
        atomReqBO.setFscOrderPayItemBOS(reqBO.getFscOrderPayItemBOS());
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            atomReqBO.setOperationType(Integer.valueOf(1));
        } else {
            atomReqBO.setOperationType(Integer.valueOf(0));
        }
        FscFinanceCapitalInfoAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealFinanceCapitalInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u5b58\u50a8\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
    }

    private void insertOrder(FscFinanceEngineeringPayBillCreateReqBO createReqBO, Long fscOrderId, String operationNo) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.ENGINEERING_SERVICE_PAY);
        if (!StringUtils.isEmpty((Object)createReqBO.getOrderNo())) {
            fscOrderPO.setOrderNo(createReqBO.getOrderNo());
        } else {
            CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
            encodedSerialGetServiceReqBO.setCenter("FSC");
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
            encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
            encodedSerialGetServiceReqBO.setOrgType("-1");
            CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
            fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
            createReqBO.setOrderNo(fscOrderPO.getOrderNo());
        }
        fscOrderPO.setOrderName(createReqBO.getOrderName());
        fscOrderPO.setPayerId(createReqBO.getPayerId());
        fscOrderPO.setPayerName(createReqBO.getPayerName());
        fscOrderPO.setPayeeId(createReqBO.getPayeeId());
        fscOrderPO.setPayeeName(createReqBO.getPayeeName());
        fscOrderPO.setPayeeAccountName(createReqBO.getPayeeAccountName());
        fscOrderPO.setPayeeBankAccount(createReqBO.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName(createReqBO.getPayeeBankName());
        if (StringUtils.isEmpty((Object)fscOrderPO.getPayeeAccountName()) || StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankAccount()) || StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankName())) {
            FscMerchantPayeePO fscMerchantPayeePO = new FscMerchantPayeePO();
            fscMerchantPayeePO.setSupplierId(createReqBO.getPayeeId());
            List fscMerchantPayeePOList = this.fscMerchantPayeeMapper.getList(fscMerchantPayeePO);
            if (!CollectionUtils.isEmpty((Collection)fscMerchantPayeePOList)) {
                fscMerchantPayeePO = (FscMerchantPayeePO)fscMerchantPayeePOList.get(0);
                fscOrderPO.setPayeeAccountName(fscMerchantPayeePO.getPayeeAccountName());
                fscOrderPO.setPayeeBankAccount(fscMerchantPayeePO.getPayeeBankAccount());
                fscOrderPO.setPayeeBankName(fscMerchantPayeePO.getPayeeBankName());
            } else {
                throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u672a\u914d\u7f6e\u6536\u6b3e\u8d26\u6237");
            }
        }
        fscOrderPO.setPayMethod(createReqBO.getPayMethod());
        fscOrderPO.setPayType(createReqBO.getPayType());
        fscOrderPO.setShouldPayType(createReqBO.getShouldPayType());
        fscOrderPO.setPayChannel(createReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(createReqBO.getUserId());
        fscOrderPO.setCreateOperName(createReqBO.getName());
        fscOrderPO.setCreateOperNo(createReqBO.getUserName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(createReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(createReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(createReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(createReqBO.getOrgName());
        fscOrderPO.setTotalCharge(createReqBO.getTotalAmount());
        fscOrderPO.setContractNo(createReqBO.getContractNo());
        fscOrderPO.setContractId(createReqBO.getContractId());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        fscOrderPO.setPaidAmount(BigDecimal.ZERO);
        fscOrderPO.setPayingAmount(BigDecimal.ZERO);
        fscOrderPO.setBuynerNo(createReqBO.getBuynerNo());
        fscOrderPO.setBuynerName(createReqBO.getBuynerName());
        fscOrderPO.setOrderType(createReqBO.getOrderType());
        fscOrderPO.setOrderSource(createReqBO.getOrderSource());
        fscOrderPO.setTradeMode(FscConstants.FscTradeMode.MATCHMAKING_MODE);
        fscOrderPO.setRemark(createReqBO.getRemark());
        fscOrderPO.setPaymentMethod(createReqBO.getPaymentMethod());
        fscOrderPO.setSettleType(createReqBO.getSettleType());
        if ("0".equals(createReqBO.getIsprofess())) {
            fscOrderPO.setOperatorId(createReqBO.getUserId());
            fscOrderPO.setOperatorName(createReqBO.getName());
            fscOrderPO.setOperationNo(operationNo);
            fscOrderPO.setOperationName(createReqBO.getCompanyName());
        }
        if ("3".equals(createReqBO.getPayChannel())) {
            if (null != createReqBO.getUserId()) {
                fscOrderPO.setPayOperId(createReqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(createReqBO.getName());
        }
        fscOrderPO.setSettlePlatform(Integer.valueOf(3));
        if ("1".equals(createReqBO.getSaveOrSubmit())) {
            fscOrderPO.setOrderState(FscConstants.FscPayOrderState.CANCEL);
        }
        String procKey = FscOrderFlowProcKeyEnum.ENGINEERING_PAY.getDescr();
        fscOrderPO.setOrderFlowKey(procKey);
        this.fscOrderMapper.insert(fscOrderPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(fscOrderId);
        List invoicePOList = this.fscInvoiceMapper.getInvoiceByShouldPay(fscInvoicePO);
        if (CollectionUtils.isEmpty((Collection)invoicePOList)) {
            invoicePOList = this.fscInvoiceMapper.getInvoiceByAdvance(fscInvoicePO);
        }
        StringBuilder invoiceNo = new StringBuilder();
        StringBuilder invoiceCode = new StringBuilder();
        log.debug("invoicePoList:{}", (Object)JSONObject.toJSONString((Object)invoicePOList));
        if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
            boolean flag = false;
            for (FscInvoicePO po : invoicePOList) {
                if (po == null) continue;
                flag = true;
                invoiceNo.append(po.getInvoiceNo()).append(",");
                invoiceCode.append(po.getInvoiceCode()).append(",");
            }
            if (flag) {
                fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderId);
                fscOrderPO.setInvoiceNo(invoiceNo.toString());
                fscOrderPO.setInvoiceCode(invoiceCode.toString());
                this.fscOrderMapper.updateById(fscOrderPO);
            }
        }
    }

    private void updateShouldPay(FscFinanceEngineeringPayBillCreateReqBO busiReqBO, Long fscOrderId) {
        ArrayList<FscShouldPayBO> fscShouldPayBOList = new ArrayList<FscShouldPayBO>();
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        ArrayList<Object> fscContractSettlementDetailPOS = new ArrayList<Object>();
        ArrayList<Long> qryShouldPayIds = new ArrayList<Long>();
        HashMap<String, Long> shouldItemPayRelationMap = new HashMap<String, Long>();
        BigDecimal totalAmount = new BigDecimal(0);
        if (busiReqBO.getPayType() == 0) {
            Map contractSettlementDetailPOMap = new HashMap();
            FscContractSettlementDetailPO contractSettlementDetailQry = new FscContractSettlementDetailPO();
            contractSettlementDetailQry.setDetailIds(busiReqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getObjectId).collect(Collectors.toList()));
            List fscContractSettlementDetailPOList = this.fscContractSettlementDetailMapper.getList(contractSettlementDetailQry);
            if (!CollectionUtils.isEmpty((Collection)fscContractSettlementDetailPOList)) {
                contractSettlementDetailPOMap = fscContractSettlementDetailPOList.stream().collect(Collectors.toMap(FscContractSettlementDetailPO::getDetailId, Function.identity()));
                ArrayList updateDetailPOList = new ArrayList();
                Map fscOrderPayItemBOMap = busiReqBO.getFscOrderPayItemBOS().stream().collect(Collectors.toMap(FscOrderPayItemBO::getObjectId, Function.identity()));
                for (FscOrderPayItemPO po : fscContractSettlementDetailPOList) {
                    if (po.getShouldPayId() != null) {
                        qryShouldPayIds.add(po.getShouldPayId());
                    }
                    FscContractSettlementDetailPO updatePO = new FscContractSettlementDetailPO();
                    updatePO.setDetailId(po.getDetailId());
                    if (StringUtils.isEmpty((Object)((FscOrderPayItemBO)fscOrderPayItemBOMap.get(po.getDetailId())).getPaymentType())) {
                        if (busiReqBO.getPayType() == 0) {
                            updatePO.setPaymentType("YUFK");
                        } else if (busiReqBO.getPayType() == 2) {
                            updatePO.setPaymentType("YINGFK");
                        } else if (busiReqBO.getPayType() == 1) {
                            updatePO.setPaymentType("ZBJ");
                        }
                    } else {
                        updatePO.setPaymentType(((FscOrderPayItemBO)fscOrderPayItemBOMap.get(po.getDetailId())).getPaymentType());
                    }
                    updateDetailPOList.add(updatePO);
                }
                if (!CollectionUtils.isEmpty((Collection)updateDetailPOList)) {
                    this.fscContractSettlementDetailMapper.updateByDetailIdBatch((List)updateDetailPOList);
                }
            }
            for (FscOrderPayItemBO fscOrderPayItemBO : busiReqBO.getFscOrderPayItemBOS()) {
                FscShouldPayBO fscShouldPayBO;
                Object fscContractSettlementDetailPO;
                if (contractSettlementDetailPOMap.containsKey(fscOrderPayItemBO.getObjectId())) {
                    fscContractSettlementDetailPO = (FscContractSettlementDetailPO)contractSettlementDetailPOMap.get(fscOrderPayItemBO.getObjectId());
                    if (fscContractSettlementDetailPO.getShouldPayId() != null) {
                        int count1;
                        BigDecimal currentPayAmt = fscOrderPayItemBO.getPayAmount();
                        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                        fscShouldPayPO.setShouldPayId(fscContractSettlementDetailPO.getShouldPayId());
                        fscShouldPayPO.setPayAmount(currentPayAmt);
                        if (fscOrderPayItemBO.getReduceAmt() != null) {
                            fscShouldPayPO.setPayAmount(fscShouldPayPO.getPayAmount().add(fscOrderPayItemBO.getReduceAmt()));
                        }
                        if ((count1 = this.fscShouldPayMapper.updateAmount(fscShouldPayPO)) != 1) {
                            throw new FscBusinessException("193204", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
                        }
                        shouldItemPayRelationMap.put(fscOrderPayItemBO.getObjectId().toString(), fscContractSettlementDetailPO.getShouldPayId());
                        continue;
                    }
                    fscShouldPayBO = this.assemableShouldPayPO(fscOrderPayItemBO, busiReqBO);
                    fscShouldPayBOList.add(fscShouldPayBO);
                    continue;
                }
                fscContractSettlementDetailPO = new FscContractSettlementDetailPO();
                fscContractSettlementDetailPO.setDetailId(fscOrderPayItemBO.getObjectId());
                fscContractSettlementDetailPO.setContractId(busiReqBO.getContractId());
                fscContractSettlementDetailPO.setPayType(busiReqBO.getPayType());
                fscContractSettlementDetailPO.setPanelPointCode(fscOrderPayItemBO.getPanelPointCode());
                fscContractSettlementDetailPO.setPanelPointName(fscOrderPayItemBO.getPanelPointName());
                fscContractSettlementDetailPO.setDays(fscOrderPayItemBO.getDays());
                fscContractSettlementDetailPO.setPayPercent(fscOrderPayItemBO.getPayPercent());
                fscContractSettlementDetailPO.setPlanAmount(fscOrderPayItemBO.getPlanAmount());
                if (StringUtils.isEmpty((Object)fscOrderPayItemBO.getPaymentType())) {
                    if (busiReqBO.getPayType() == 0) {
                        fscContractSettlementDetailPO.setPaymentType("YUFK");
                    } else if (busiReqBO.getPayType() == 2) {
                        fscContractSettlementDetailPO.setPaymentType("YINGFK");
                    } else if (busiReqBO.getPayType() == 1) {
                        fscContractSettlementDetailPO.setPaymentType("ZBJ");
                    }
                } else {
                    fscContractSettlementDetailPO.setPaymentType(fscOrderPayItemBO.getPaymentType());
                }
                fscContractSettlementDetailPOS.add(fscContractSettlementDetailPO);
                fscShouldPayBO = this.assemableShouldPayPO(fscOrderPayItemBO, busiReqBO);
                fscShouldPayBOList.add(fscShouldPayBO);
            }
            if (!CollectionUtils.isEmpty(fscShouldPayBOList)) {
                FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
                fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOList);
                fscPayShouldPayCreateAtomReqBO.setUserId(busiReqBO.getUserId());
                fscPayShouldPayCreateAtomReqBO.setName(busiReqBO.getName());
                fscPayShouldPayCreateAtomReqBO.setUserName(busiReqBO.getUserName());
                fscPayShouldPayCreateAtomReqBO.setCompanyId(busiReqBO.getCompanyId());
                fscPayShouldPayCreateAtomReqBO.setCompanyName(busiReqBO.getCompanyName());
                fscPayShouldPayCreateAtomReqBO.setOrgId(busiReqBO.getOrgId());
                fscPayShouldPayCreateAtomReqBO.setOrgName(busiReqBO.getOrgName());
                FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.saveShouldPayInfo(fscPayShouldPayCreateAtomReqBO);
                if (!CollectionUtils.isEmpty((Collection)fscPayShouldPayCreateAtomRspBO.getFscShouldPayRspBOs())) {
                    shouldItemPayRelationMap.putAll(fscPayShouldPayCreateAtomRspBO.getFscShouldPayRspBOs().stream().collect(Collectors.toMap(item -> String.valueOf(item.getObjectId()), FscShouldPayRspBO::getShouldPayId)));
                }
                for (FscContractSettlementDetailPO settlementDetailPO : fscContractSettlementDetailPOList) {
                    if (settlementDetailPO.getShouldPayId() != null) continue;
                    FscContractSettlementDetailPO record = new FscContractSettlementDetailPO();
                    record.setShouldPayId((Long)shouldItemPayRelationMap.get(settlementDetailPO.getDetailId().toString()));
                    record.setDetailId(settlementDetailPO.getDetailId());
                    this.fscContractSettlementDetailMapper.updateShouldPayIdByDetailId(record);
                }
            }
            if (!CollectionUtils.isEmpty(fscContractSettlementDetailPOS)) {
                fscContractSettlementDetailPOS.forEach(o -> o.setShouldPayId((Long)shouldItemPayRelationMap.get(o.getDetailId().toString())));
                this.fscContractSettlementDetailMapper.insertBatch(fscContractSettlementDetailPOS);
            }
        } else {
            for (FscOrderPayItemBO fscOrderPayItemBO : busiReqBO.getFscOrderPayItemBOS()) {
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setObjectId(fscOrderPayItemBO.getObjectId());
                fscShouldPayPO.setOrderId(fscOrderPayItemBO.getOrderId());
                FscShouldPayPO fscShouldPayPOResult = this.fscShouldPayMapper.getModelBy(fscShouldPayPO);
                if (fscShouldPayPOResult != null) {
                    int count1;
                    FscShouldPayPO fscShouldPayUpdPO = new FscShouldPayPO();
                    fscShouldPayUpdPO.setShouldPayId(fscShouldPayPOResult.getShouldPayId());
                    fscShouldPayUpdPO.setPayAmount(fscOrderPayItemBO.getPayAmount());
                    if (fscOrderPayItemBO.getReduceAmt() != null) {
                        fscShouldPayUpdPO.setPayAmount(fscShouldPayUpdPO.getPayAmount().add(fscOrderPayItemBO.getReduceAmt()));
                    }
                    if ((count1 = this.fscShouldPayMapper.updateAmount(fscShouldPayUpdPO)) != 1) {
                        throw new FscBusinessException("193204", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
                    }
                    shouldItemPayRelationMap.put(fscShouldPayPOResult.getObjectId() + "-" + fscShouldPayPOResult.getOrderId(), fscShouldPayPOResult.getShouldPayId());
                    continue;
                }
                FscShouldPayBO fscShouldPayBO = this.assemableShouldPayPO(fscOrderPayItemBO, busiReqBO);
                fscShouldPayBOList.add(fscShouldPayBO);
            }
            if (!CollectionUtils.isEmpty(fscShouldPayBOList)) {
                FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
                fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOList);
                fscPayShouldPayCreateAtomReqBO.setUserId(busiReqBO.getUserId());
                fscPayShouldPayCreateAtomReqBO.setName(busiReqBO.getName());
                fscPayShouldPayCreateAtomReqBO.setUserName(busiReqBO.getUserName());
                fscPayShouldPayCreateAtomReqBO.setCompanyId(busiReqBO.getCompanyId());
                fscPayShouldPayCreateAtomReqBO.setCompanyName(busiReqBO.getCompanyName());
                fscPayShouldPayCreateAtomReqBO.setOrgId(busiReqBO.getOrgId());
                fscPayShouldPayCreateAtomReqBO.setOrgName(busiReqBO.getOrgName());
                FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.saveShouldPayInfo(fscPayShouldPayCreateAtomReqBO);
                if (!CollectionUtils.isEmpty((Collection)fscPayShouldPayCreateAtomRspBO.getFscShouldPayRspBOs())) {
                    shouldItemPayRelationMap.putAll(fscPayShouldPayCreateAtomRspBO.getFscShouldPayRspBOs().stream().collect(Collectors.toMap(item -> item.getObjectId() + "-" + item.getOrderId(), FscShouldPayRspBO::getShouldPayId)));
                }
            }
        }
        List shouldPayIds = shouldItemPayRelationMap.values().stream().distinct().collect(Collectors.toList());
        FscShouldPayPO qryShouldPO = new FscShouldPayPO();
        qryShouldPO.setShouldPayIds(shouldPayIds);
        List fscShouldPayPOList = this.fscShouldPayMapper.getList(qryShouldPO);
        Map shouldPayMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, Function.identity()));
        for (FscOrderPayItemBO fscOrderPayItemBO : busiReqBO.getFscOrderPayItemBOS()) {
            FscOrderPayItemPO po;
            po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setItemNo(fscOrderPayItemBO.getItemNo());
            po.setIsReduce(fscOrderPayItemBO.getIsReduce());
            if (po.getIsReduce() == null) {
                po.setIsReduce(FscConstants.NO);
            }
            po.setPaymentPhase(fscOrderPayItemBO.getPaymentPhase());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            if (busiReqBO.getPayType() == 0) {
                po.setShouldPayId((Long)shouldItemPayRelationMap.get(fscOrderPayItemBO.getObjectId().toString()));
            } else {
                po.setShouldPayId((Long)shouldItemPayRelationMap.get(fscOrderPayItemBO.getObjectId() + "-" + fscOrderPayItemBO.getOrderId()));
            }
            po.setPayAmount(fscOrderPayItemBO.getPayAmount());
            po.setPayAmountLocal(fscOrderPayItemBO.getPayAmountLocal());
            po.setExt3(fscOrderPayItemBO.getExt3());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            if (po.getReduceAmt() == null) {
                po.setReduceAmt(BigDecimal.ZERO);
            }
            po.setExpType(fscOrderPayItemBO.getExpLineType());
            po.setExpTypeId(fscOrderPayItemBO.getExpTypeCode());
            if (StringUtils.isEmpty((Object)fscOrderPayItemBO.getShouldPayItemNo())) {
                po.setShouldPayItemNo(((FscShouldPayPO)shouldPayMap.get(po.getShouldPayId())).getShouldPayNo() + "-01");
            } else {
                po.setShouldPayItemNo(fscOrderPayItemBO.getShouldPayItemNo());
            }
            po.setShouldPayMethod(busiReqBO.getShouldPayMethod());
            po.setFscBillOrderId(fscOrderPayItemBO.getFscBillOrderId());
            po.setFscBillOrderNo(fscOrderPayItemBO.getFscBillOrderNo());
            po.setRemark(fscOrderPayItemBO.getRemark());
            fscOrderPayItemBO.setOrderPayItemId(po.getOrderPayItemId());
            fscOrderPayItemBO.setShouldPayItemNo(po.getShouldPayItemNo());
            fscOrderPayItemBO.setShouldPayId(po.getShouldPayId());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO.getPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
    }

    private void invokeUacNoTask(FscFinanceEngineeringPayBillCreateReqBO busiReqBO, Long fscOrderId) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO), FscOrderStatusStartAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("M003041");
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ENGINEERING_PAY_APPLY_ORDER);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(fscOrderId);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(fscOrderId.toString());
        approvalObjBO.setObjName("\u5de5\u7a0b\u670d\u52a1\u4ed8\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ENGINEERING_PAY_APPLY_ORDER);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        BigDecimal payAmount = BigDecimal.ZERO;
        for (FscOrderPayItemBO payItem : busiReqBO.getFscOrderPayItemBOS()) {
            payAmount = payAmount.add(payItem.getPayAmount());
        }
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("payAmount", payAmount);
        variables.put("payType", 1);
        uacNoTaskAuditCreateReqBO.setVariables(variables);
        this.checkExistProcess(fscOrderId);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u4ed8\u6b3e\u5ba1\u6279\u6d41\uff01");
        }
        if (uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.ENGINEERING_SERVICE_PAY);
        fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserName());
        fscOrderStatusStartAtomReqBO.setIndividually(busiReqBO.getIndividually());
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194203", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private void insertFinanceInfo(FscFinanceEngineeringPayBillCreateReqBO reqBO, Long fscOrderId) {
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)financePO);
        financePO.setFscOrderId(fscOrderId);
        financePO.setCreateTime(new Date());
        financePO.setCreateUserId(reqBO.getUserName());
        financePO.setCreateUserName(reqBO.getName());
        financePO.setFinanceUserId(reqBO.getUserName());
        financePO.setFinanceUserName(reqBO.getName());
        financePO.setExt1(reqBO.getSupplierErpNo());
        financePO.setPaymentPhase("FKJD001");
        int count = this.fscOrderFinanceMapper.insert(financePO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        int count;
        if (CollectionUtils.isEmpty(attachmentBOList)) {
            return;
        }
        FscAttachmentPO deletePo = new FscAttachmentPO();
        deletePo.setFscOrderId(fscOrderId);
        deletePo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
        ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletePo);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS) && (count = this.fscAttachmentMapper.deleteBy(deletePo)) != fscAttachmentPOS.size()) {
            throw new FscBusinessException("198888", "\u5220\u9664\u4ed8\u6b3e\u5355\u9644\u4ef6\u5931\u8d25\uff01");
        }
        fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
        for (AttachmentBO attachmentBO : attachmentBOList) {
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPo);
            fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAYMENT);
            if (attachmentBO.getObjId() == null) {
                fscAttachmentPo.setObjId(fscOrderId);
            }
            fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
            fscAttachmentPo.setFscOrderId(fscOrderId);
            fscAttachmentPOS.add(fscAttachmentPo);
        }
        count = this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        if (count != fscAttachmentPOS.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u5355\u9644\u4ef6\u5931\u8d25\uff01");
        }
    }

    private void checkExistProcess(Long fscOrderId) {
        int count = this.fscOrderMapper.selectStepIdCount(fscOrderId, FscConstants.AuditObjType.PAY_APPLY_ORDER);
        if (count > 0) {
            throw new FscBusinessException("191019", "\u8be5\u5355\u636e\u5df2\u63d0\u4ea4\u5ba1\u6279");
        }
    }

    private FscShouldPayBO assemableShouldPayPO(FscOrderPayItemBO fscOrderPayItemBO, FscFinanceEngineeringPayBillCreateReqBO reqBO) {
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setShouldPayType(reqBO.getShouldPayType());
        fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.CONTRACT);
        fscShouldPayBO.setObjectId(fscOrderPayItemBO.getObjectId());
        fscShouldPayBO.setObjectNo(fscOrderPayItemBO.getObjectNo());
        fscShouldPayBO.setOrderId(fscOrderPayItemBO.getOrderId());
        fscShouldPayBO.setPayType(reqBO.getPayType());
        fscShouldPayBO.setShouldPayAmount(fscOrderPayItemBO.getShouldPayAmount());
        fscShouldPayBO.setPayingAmount(fscOrderPayItemBO.getPayAmount());
        fscShouldPayBO.setToPayAmount(fscShouldPayBO.getShouldPayAmount().subtract(Optional.ofNullable(fscShouldPayBO.getPayingAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(fscShouldPayBO.getPaidAmount()).orElse(BigDecimal.ZERO)));
        fscShouldPayBO.setPayeeId(reqBO.getPayeeId());
        fscShouldPayBO.setPayeeName(reqBO.getPayeeName());
        fscShouldPayBO.setPayerId(reqBO.getPayerId());
        fscShouldPayBO.setPayerName(reqBO.getPayerName());
        if (reqBO.getPayType() == 2) {
            fscShouldPayBO.setContractId(fscOrderPayItemBO.getContractId());
            fscShouldPayBO.setContractNo(fscOrderPayItemBO.getContractNo());
            fscShouldPayBO.setContractName(fscOrderPayItemBO.getContractName());
        } else {
            fscShouldPayBO.setContractId(reqBO.getContractId());
            fscShouldPayBO.setContractNo(reqBO.getContractNo());
            fscShouldPayBO.setContractName(reqBO.getContractName());
        }
        fscShouldPayBO.setBuyerNo(reqBO.getBuynerNo());
        fscShouldPayBO.setBuyerName(reqBO.getBuynerName());
        fscShouldPayBO.setShouldPayMethod(reqBO.getShouldPayMethod());
        fscShouldPayBO.setSettlePlatform(FscConstants.SettlePlatform.FINANCE);
        fscShouldPayBO.setContractType(reqBO.getContractType());
        fscShouldPayBO.setBusinessType(reqBO.getBusinessType());
        return fscShouldPayBO;
    }

    private FscPayShouldPayCreateAtomRspBO saveShouldPayInfo(FscPayShouldPayCreateAtomReqBO atomReqBO) {
        ArrayList<FscShouldPayRspBO> fscShouldPayRspBOs = new ArrayList<FscShouldPayRspBO>();
        List fscShouldPayPOS = JSON.parseArray((String)JSON.toJSONString((Object)atomReqBO.getFscShouldPayBOS()), FscShouldPayPO.class);
        List serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()) == null) {
            throw new FscBusinessException("194311", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()).getDescr());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(fscShouldPayPOS.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        for (int i = 0; i < fscShouldPayPOS.size(); ++i) {
            Long shouldPayId = Sequence.getInstance().nextId();
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayPOS.get(i);
            fscShouldPayPO.setShouldPayId(shouldPayId);
            fscShouldPayPO.setCreateId(atomReqBO.getUserId());
            fscShouldPayPO.setCreateName(atomReqBO.getName());
            fscShouldPayPO.setCreateAccount(atomReqBO.getUserName());
            fscShouldPayPO.setCreateTime(new Date());
            fscShouldPayPO.setCreateCompanyId(atomReqBO.getCompanyId());
            fscShouldPayPO.setCreateCompanyName(atomReqBO.getCompanyName());
            fscShouldPayPO.setCreateOrgId(atomReqBO.getOrgId());
            fscShouldPayPO.setCreateOrgName(atomReqBO.getOrgName());
            fscShouldPayPO.setPenalty(new BigDecimal(0));
            fscShouldPayPO.setOriginalAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
            fscShouldPayPO.setToPayAmount(fscShouldPayPO.getToPayAmount());
            fscShouldPayPO.setPaidAmount(new BigDecimal(0));
            fscShouldPayPO.setPayingAmount(fscShouldPayPO.getPayingAmount());
            fscShouldPayPO.setShouldPayNo((String)serialNoList.get(i));
            fscShouldPayPO.setPayMethod(fscShouldPayPO.getShouldPayMethod());
            FscShouldPayRspBO bo = new FscShouldPayRspBO();
            bo.setShouldPayId(shouldPayId);
            bo.setObjectId(fscShouldPayPO.getObjectId());
            bo.setOrderId(fscShouldPayPO.getOrderId());
            fscShouldPayRspBOs.add(bo);
        }
        this.fscShouldPayMapper.insertBatch(fscShouldPayPOS);
        FscPayShouldPayCreateAtomRspBO atomRspBO = new FscPayShouldPayCreateAtomRspBO();
        atomRspBO.setFscShouldPayRspBOs(fscShouldPayRspBOs);
        return atomRspBO;
    }

    private void syncContractInfo(Long fscOrderId, FscFinanceEngineeringPayBillCreateReqBO reqBO) {
        ContractSyncSettlementAbilityReqBO contractSyncSettlementAbilityReqBO = new ContractSyncSettlementAbilityReqBO();
        contractSyncSettlementAbilityReqBO.setObjectId(fscOrderId);
        contractSyncSettlementAbilityReqBO.setObjectType(ContractObjectTypeEnum.PRE_PAY.getCode());
        contractSyncSettlementAbilityReqBO.setUserId(reqBO.getUserId());
        ArrayList contractList = new ArrayList();
        reqBO.getFscOrderPayItemBOS().forEach(e -> {
            ContractSyncSettlementItemBO syncSettlementItemBO = new ContractSyncSettlementItemBO();
            syncSettlementItemBO.setPayDetailId(e.getObjectId());
            syncSettlementItemBO.setAmt(e.getPayAmount());
            if (reqBO.getPayType() == 2) {
                syncSettlementItemBO.setContractId(e.getContractId());
            } else {
                syncSettlementItemBO.setContractId(reqBO.getContractId());
            }
            contractList.add(syncSettlementItemBO);
        });
        contractSyncSettlementAbilityReqBO.setAddList(contractList);
        log.info("\u5de5\u7a0b\u670d\u52a1\u4ed8\u6b3e\u8c03\u7528\u5408\u540c\u540c\u6b65\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)contractSyncSettlementAbilityReqBO));
        ContractSyncSettlementAbilityRspBO contractSyncSettlementAbilityRspBO = this.contractSyncSettlementAbilityService.modifySettlement(contractSyncSettlementAbilityReqBO);
        log.info("\u5de5\u7a0b\u670d\u52a1\u4ed8\u6b3e\u8c03\u7528\u5408\u540c\u540c\u6b65\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)contractSyncSettlementAbilityRspBO));
        if (Objects.nonNull(contractSyncSettlementAbilityRspBO) && !"0000".equals(contractSyncSettlementAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("8888", "\u540c\u6b65\u5408\u540c\u6a21\u5757\u7ed3\u7b97\u4fe1\u606f\u5931\u8d25\uff1a" + contractSyncSettlementAbilityRspBO.getRespDesc());
        }
    }
}

