/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.task.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.fsc.bo.UocApprovalLogBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.UocApprovalLogMapper;
import com.tydic.fsc.pay.atom.api.FscDealWaitParamsAtomService;
import com.tydic.fsc.pay.atom.api.WaitDoneLogAtomService;
import com.tydic.fsc.pay.atom.bo.TodoWaitAbilityAtomRspBO;
import com.tydic.fsc.pay.busi.api.WaitDoneLogBusiService;
import com.tydic.fsc.pay.busi.bo.WaitDoneLogReqBO;
import com.tydic.fsc.pay.task.bo.TodoAddAlreadyDoneAbilityReqBO;
import com.tydic.fsc.pay.task.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.fsc.pay.task.bo.TodoFscWaitAbilityReqBO;
import com.tydic.fsc.pay.task.bo.TodoWaitAbilityAssembleReqBO;
import com.tydic.fsc.pay.task.bo.TodoWaitAbilityReqBO;
import com.tydic.fsc.pay.task.enums.TaskWaitDoneEnum;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.pay.task.utils.DycFscTodoWaitDoneProvider;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.todo.ability.api.TodoMqRetryRecordAbilityService;
import com.tydic.todo.ability.api.TodoWaitDoneWriteAbilityService;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityRspBO;
import com.tydic.umc.daiban.UmcAddTaskAbilityService;
import com.tydic.umc.daiban.bo.UmcTaskReqBO;
import com.tydic.umc.daiban.bo.UmcTaskRspBO;
import com.tydic.umc.general.ability.bo.MemberAbilityBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TaskTodoWaitServiceImpl
implements TaskTodoWaitService {
    private static final Logger log = LoggerFactory.getLogger(TaskTodoWaitServiceImpl.class);
    @Autowired
    private UocApprovalLogMapper uocApprovalLogMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private UmcAddTaskAbilityService umcAddTaskAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private DycFscTodoWaitDoneProvider dycFscTodoWaitDoneProviderService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private TodoMqRetryRecordAbilityService todoMqRetryRecordAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private WaitDoneLogBusiService waitDoneLogBusiService;
    @Autowired
    private WaitDoneLogAtomService waitDoneLogAtomService;
    @Value(value="${dyc.fsc.add.todo.wait.done.topic:TODO_ADD_WAIT_DONE_TOPIC}")
    private String addWaitTodoTopic;
    @Value(value="${dyc.fsc.cancel.todo.wait.done.topic:TODO_CANCEL_WAIT_DONE_TOPIC}")
    private String cancelWaitTodoTopic;
    @Value(value="${dyc.fsc.done.todo.wait.done.topic:TODO_ADD_ALREADY_DONE_TOPIC}")
    private String DoneWaitTodoTopic;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscDealWaitParamsAtomService fscDealWaitParamsAtomService;
    @Autowired
    private TodoWaitDoneWriteAbilityService todoWaitDoneWriteAbilityService;

    @Override
    public void handler(TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        log.info("TaskTodoWaitService todoFscWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoFscWaitAbilityReqBO));
        this.assertParam(todoFscWaitAbilityReqBO);
        try {
            Thread.sleep(3000L);
            UocApprovalLogPO uocApprovalLogPO = this.listApproval(todoFscWaitAbilityReqBO.getObjId());
            log.info("TaskTodoWaitService uocApprovalLogPO:{}", (Object)JSON.toJSONString((Object)uocApprovalLogPO));
            switch (todoFscWaitAbilityReqBO.getOperatorType()) {
                case "0": {
                    TodoWaitAbilityReqBO todoSubmitWaitAbilityReqBO = this.operatorSubmit(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    this.addTodoWait(todoSubmitWaitAbilityReqBO);
                    break;
                }
                case "1": {
                    TodoWaitAbilityReqBO todoDonePassWaitAbilityReqBO = this.operatorDoneApproval(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    this.doneTodoWait(todoDonePassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoCancelPassWaitAbilityReqBO = this.operatorCancelApproval(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    todoCancelPassWaitAbilityReqBO.setWaitPushStatus(todoDonePassWaitAbilityReqBO.getWaitPushStatus());
                    this.cancelTodoWait(todoCancelPassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoAddPassWaitAbilityReqBO = this.operatorAddApproval(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    todoAddPassWaitAbilityReqBO.setWaitPushStatus(todoCancelPassWaitAbilityReqBO.getWaitPushStatus());
                    this.addTodoWait(todoAddPassWaitAbilityReqBO);
                    break;
                }
                case "2": {
                    TodoWaitAbilityReqBO todoReturnWaitAbilityReqBO = this.operatorReturn(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    this.cancelTodoWait(todoReturnWaitAbilityReqBO);
                }
            }
        }
        catch (Exception e) {
            log.error("TaskTodoWaitService error:{}", (Throwable)e);
        }
    }

    @Override
    public void saleRefundHandler(TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        log.info("TaskTodoWaitService todoFscWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoFscWaitAbilityReqBO));
        this.assertParam(todoFscWaitAbilityReqBO);
        try {
            Thread.sleep(3000L);
            UocApprovalLogPO uocApprovalLogPO = this.listApproval(todoFscWaitAbilityReqBO.getObjId());
            log.info("TaskTodoWaitService uocApprovalLogPO:{}", (Object)JSON.toJSONString((Object)uocApprovalLogPO));
            switch (todoFscWaitAbilityReqBO.getOperatorType()) {
                case "0": {
                    TodoWaitAbilityReqBO todoSubmitWaitAbilityReqBO = this.saleRefundOperatorSubmit(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    this.addTodoWait(todoSubmitWaitAbilityReqBO);
                    break;
                }
                case "1": {
                    TodoWaitAbilityReqBO todoDonePassWaitAbilityReqBO = this.saleRefundOperatorDoneApproval(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    this.doneTodoWait(todoDonePassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoCancelPassWaitAbilityReqBO = this.operatorCancelApproval(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    todoCancelPassWaitAbilityReqBO.setWaitPushStatus(todoDonePassWaitAbilityReqBO.getWaitPushStatus());
                    this.cancelTodoWait(todoCancelPassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoAddPassWaitAbilityReqBO = this.saleRefundOperatorAddApproval(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    todoAddPassWaitAbilityReqBO.setWaitPushStatus(todoCancelPassWaitAbilityReqBO.getWaitPushStatus());
                    this.addTodoWait(todoAddPassWaitAbilityReqBO);
                    break;
                }
                case "2": {
                    TodoWaitAbilityReqBO todoReturnWaitAbilityReqBO = this.operatorReturn(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    this.cancelTodoWait(todoReturnWaitAbilityReqBO);
                }
            }
        }
        catch (Exception e) {
            log.error("TaskTodoWaitService error:{}", (Throwable)e);
        }
    }

    @Override
    public void syncNotifyPayBillWaitDone(Long fscOrderId) {
        log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u5f85\u529e\u63a8\u9001===========>obj_id:{}", (Object)fscOrderId);
        TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
        todoFscWaitAbilityReqBO.setObjId(fscOrderId);
        todoFscWaitAbilityReqBO.setOperatorType("0");
        todoFscWaitAbilityReqBO.setBusiCode("1012");
        todoFscWaitAbilityReqBO.setBusiName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
        todoFscWaitAbilityReqBO.setCenterCode("settle");
        this.handler(todoFscWaitAbilityReqBO);
    }

    @Override
    public void syncNotifySignApplyWaitDone(Long fscOrderId) {
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u5f85\u529e\u63a8\u9001===========>obj_id:{}", (Object)fscOrderId);
        TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
        todoFscWaitAbilityReqBO.setObjId(fscOrderId);
        todoFscWaitAbilityReqBO.setOperatorType("0");
        todoFscWaitAbilityReqBO.setBusiCode("1031");
        todoFscWaitAbilityReqBO.setBusiName("\u91c7\u8d2d\u7ed3\u7b97\u5355");
        todoFscWaitAbilityReqBO.setCenterCode("settle");
        this.handler(todoFscWaitAbilityReqBO);
    }

    @Override
    public void syncNotifyContractSignApplyWaitDone(Long fscOrderId) {
        log.info("\u804c\u80fd\u5408\u540c-\u91c7\u8d2d\u7533\u8bf7\u5355\u5f85\u529e\u63a8\u9001===========>obj_id:{}", (Object)fscOrderId);
        TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
        todoFscWaitAbilityReqBO.setObjId(fscOrderId);
        todoFscWaitAbilityReqBO.setOperatorType("0");
        todoFscWaitAbilityReqBO.setBusiCode("1036");
        todoFscWaitAbilityReqBO.setBusiName("\u804c\u80fd\u7ed3\u7b97\u4ed8\u6b3e");
        todoFscWaitAbilityReqBO.setCenterCode("settle");
        this.handler(todoFscWaitAbilityReqBO);
    }

    @Override
    public void syncNotifyAccountWaitDone(Long fscOrderId) {
        log.info("\u9500\u552e\u7ed3\u7b97\u5355\u5f85\u529e\u63a8\u9001===========>obj_id:{}", (Object)fscOrderId);
        TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
        todoFscWaitAbilityReqBO.setObjId(fscOrderId);
        todoFscWaitAbilityReqBO.setOperatorType("0");
        todoFscWaitAbilityReqBO.setBusiCode("1032");
        todoFscWaitAbilityReqBO.setBusiName("\u9500\u552e\u7ed3\u7b97\u5355");
        todoFscWaitAbilityReqBO.setCenterCode("settle");
        this.handler(todoFscWaitAbilityReqBO);
    }

    @Override
    public void syncNotifyPrepareWaitDone(Long fscOrderId) {
        log.info("\u9884\u5b58\u6b3e\u5145\u503c\u5f85\u529e\u63a8\u9001===========>obj_id:{}", (Object)fscOrderId);
        TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
        todoFscWaitAbilityReqBO.setObjId(fscOrderId);
        todoFscWaitAbilityReqBO.setOperatorType("0");
        todoFscWaitAbilityReqBO.setBusiCode("1050");
        todoFscWaitAbilityReqBO.setBusiName("\u9884\u5b58\u6b3e\u5145\u503c");
        todoFscWaitAbilityReqBO.setCenterCode("settle");
        this.handler(todoFscWaitAbilityReqBO);
    }

    @Override
    public void syncNotifySaleRefundWaitDone(Long refundId) {
        log.info("\u9500\u552e\u9000\u7968\u5f85\u529e\u63a8\u9001===========>obj_id:{}", (Object)refundId);
        TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
        todoFscWaitAbilityReqBO.setObjId(refundId);
        todoFscWaitAbilityReqBO.setOperatorType("0");
        todoFscWaitAbilityReqBO.setBusiCode("1052");
        todoFscWaitAbilityReqBO.setBusiName("\u9500\u552e\u9000\u7968\u5355");
        todoFscWaitAbilityReqBO.setCenterCode("settle");
        this.saleRefundHandler(todoFscWaitAbilityReqBO);
    }

    @Override
    public void syncNotifyTrafficInvoiceWaitDone(Long fscOrderId) {
        log.info("\u5e73\u53f0\u6d41\u91cf\u8d39\u7ed3\u7b97\u5355\u5f85\u529e\u63a8\u9001===========>obj_id:{}", (Object)fscOrderId);
        TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
        todoFscWaitAbilityReqBO.setObjId(fscOrderId);
        todoFscWaitAbilityReqBO.setOperatorType("0");
        todoFscWaitAbilityReqBO.setBusiCode("1100");
        todoFscWaitAbilityReqBO.setBusiName("\u5e73\u53f0\u6d41\u91cf\u8d39\u7ed3\u7b97\u5355");
        todoFscWaitAbilityReqBO.setCenterCode("settle");
        this.handler(todoFscWaitAbilityReqBO);
    }

    @Override
    public UocApprovalLogPO listApprovalForSub(Long objId) {
        UocApprovalLogBO uocApprovalLogBO = new UocApprovalLogBO();
        uocApprovalLogBO.setOrderId(objId);
        List approvalListForSub = this.uocApprovalLogMapper.getApprovalListForSub(uocApprovalLogBO);
        if (!CollectionUtils.isEmpty((Collection)approvalListForSub)) {
            return (UocApprovalLogPO)approvalListForSub.get(0);
        }
        log.error("\u67e5\u8be2\u63d0\u4ea4\u4eba\u5931\u8d25:" + objId);
        return null;
    }

    @Override
    public void syncNotifySalePurchaseRefundWaitDone(Long refundId) {
        log.info("\u91c7\u8d2d\u9000\u7968\u5f85\u529e\u63a8\u9001===========>obj_id:{}", (Object)refundId);
        TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO = new TodoFscWaitAbilityReqBO();
        todoFscWaitAbilityReqBO.setObjId(refundId);
        todoFscWaitAbilityReqBO.setOperatorType("0");
        todoFscWaitAbilityReqBO.setBusiCode("1053");
        todoFscWaitAbilityReqBO.setBusiName("\u91c7\u8d2d\u9000\u7968\u5355");
        todoFscWaitAbilityReqBO.setCenterCode("settle");
        this.salePurchaseRefundHandler(todoFscWaitAbilityReqBO);
    }

    @Override
    public void salePurchaseRefundHandler(TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        log.info("TaskTodoWaitService todoFscWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoFscWaitAbilityReqBO));
        this.assertParam(todoFscWaitAbilityReqBO);
        try {
            Thread.sleep(3000L);
            UocApprovalLogPO uocApprovalLogPO = this.listApproval(todoFscWaitAbilityReqBO.getObjId());
            log.info("TaskTodoWaitService uocApprovalLogPO:{}", (Object)JSON.toJSONString((Object)uocApprovalLogPO));
            switch (todoFscWaitAbilityReqBO.getOperatorType()) {
                case "0": {
                    TodoWaitAbilityReqBO todoSubmitWaitAbilityReqBO = this.saleRefundOperatorSubmit(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    this.addTodoWait(todoSubmitWaitAbilityReqBO);
                    break;
                }
                case "1": {
                    TodoWaitAbilityReqBO todoDonePassWaitAbilityReqBO = this.saleRefundOperatorDoneApproval(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    this.doneTodoWait(todoDonePassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoCancelPassWaitAbilityReqBO = this.operatorCancelApproval(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    todoCancelPassWaitAbilityReqBO.setWaitPushStatus(todoDonePassWaitAbilityReqBO.getWaitPushStatus());
                    this.cancelTodoWait(todoCancelPassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoAddPassWaitAbilityReqBO = this.saleRefundOperatorAddApproval(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    todoAddPassWaitAbilityReqBO.setWaitPushStatus(todoCancelPassWaitAbilityReqBO.getWaitPushStatus());
                    this.addTodoWait(todoAddPassWaitAbilityReqBO);
                    break;
                }
                case "2": {
                    TodoWaitAbilityReqBO todoReturnWaitAbilityReqBO = this.operatorReturn(uocApprovalLogPO, todoFscWaitAbilityReqBO);
                    this.cancelTodoWait(todoReturnWaitAbilityReqBO);
                }
            }
        }
        catch (Exception e) {
            log.error("TaskTodoWaitService error:{}", (Throwable)e);
        }
    }

    @Override
    public UocApprovalLogPO listApproval(Long objId) {
        log.info("TaskTodoWaitServiceImpl listApproval objId:{}", (Object)objId);
        UocApprovalLogBO uocApprovalLogBO = new UocApprovalLogBO();
        uocApprovalLogBO.setOrderId(objId);
        return this.uocApprovalLogMapper.listByParam(uocApprovalLogBO).stream().filter($ -> Objects.nonNull($)).max(Comparator.comparing(UocApprovalLogPO::getDealTime)).orElse(null);
    }

    private TodoWaitAbilityReqBO operatorReturn(UocApprovalLogPO uocApprovalLogPO, TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        String stationId = todoFscWaitAbilityReqBO.getStationId();
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.listUser(stationId);
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
            todoPassWaitAbilityReqBO.setCenterCode(todoFscWaitAbilityReqBO.getCenterCode());
            todoPassWaitAbilityReqBO.setBusiCode(todoFscWaitAbilityReqBO.getBusiCode());
            todoPassWaitAbilityReqBO.setCancelList(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(user -> {
                com.tydic.fsc.pay.task.bo.TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = new com.tydic.fsc.pay.task.bo.TodoCancelWaitDoneAbilityReqBO();
                todoCancelWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoCancelWaitDoneAbilityReqBO.setObjId(uocApprovalLogPO.getOrderId().toString());
                return todoCancelWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorDoneApproval(UocApprovalLogPO uocApprovalLogPO, TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorDoneApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoFscWaitAbilityReqBO.getObjId());
        String regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : "";
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        if ("1050".equals(todoFscWaitAbilityReqBO.getBusiCode())) {
            FscAccountChargePO chargePO = new FscAccountChargePO();
            chargePO.setChargeId(todoFscWaitAbilityReqBO.getObjId());
            chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
            if (chargePO == null) {
                log.error("\u5145\u503c\u5ba1\u6279\u5f85\u529e\u672a\u67e5\u8be2\u5230\u5145\u503c\u5355\u4fe1\u606f\uff1a{}", (Object)todoFscWaitAbilityReqBO.getObjId());
                return null;
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(chargePO.getUserId());
            List<MemberAbilityBO> userCode1 = this.getUserCode(ids);
            todoPassWaitAbilityReqBO.setCreateId(userCode1.get(0).getRegAccount());
            todoPassWaitAbilityReqBO.setCreateName(chargePO.getUserName());
        } else {
            List<MemberAbilityBO> userCode1;
            ArrayList<Long> ids;
            FscOrderPO fscOrderPO = this.fscOrderMapper.qryByFscOrderId(todoFscWaitAbilityReqBO.getObjId());
            Integer orderFlow = fscOrderPO.getOrderFlow();
            if (Objects.nonNull(orderFlow)) {
                switch (orderFlow) {
                    case 0: {
                        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
                        fscOrderRelationPo.setFscOrderId(fscOrderPO.getFscOrderId());
                        List list = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
                        if (!CollectionUtils.isEmpty((Collection)list)) {
                            todoPassWaitAbilityReqBO.setExt2(((FscOrderRelationPO)list.get(0)).getInspExecution());
                        }
                        String code = fscOrderPO.getTradeMode() + "" + fscOrderPO.getReceiveType() + fscOrderPO.getOrderSource() + fscOrderPO.getOrderType() + fscOrderPO.getSettleType();
                        Map itemCodeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_WAIT_DONE_ITEM_TYPE");
                        todoPassWaitAbilityReqBO.setExtendCode((String)itemCodeMap.get(code));
                        break;
                    }
                    case 1: {
                        Integer tradeMode = fscOrderPO.getTradeMode();
                        Integer settlePlatform = fscOrderPO.getSettlePlatform();
                        if (!Objects.nonNull(tradeMode) || !Objects.nonNull(settlePlatform) || !tradeMode.equals(2) || !settlePlatform.equals(2)) break;
                        todoPassWaitAbilityReqBO.setExt2("2");
                        break;
                    }
                    case 20: {
                        todoPassWaitAbilityReqBO.setExt2("3");
                        break;
                    }
                    default: {
                        log.error("fscOrderPO orderFlow error objId:{}", (Object)fscOrderPO.getFscOrderId());
                    }
                }
            }
            if (todoFscWaitAbilityReqBO.getBusiCode().equals("1032") && Objects.nonNull(fscOrderPO.getOperatorId())) {
                ids = new ArrayList();
                ids.add(fscOrderPO.getOperatorId());
                userCode1 = this.getUserCode(ids);
                if (!CollectionUtils.isEmpty(userCode1)) {
                    todoPassWaitAbilityReqBO.setCreateId(userCode1.get(0).getRegAccount());
                    todoPassWaitAbilityReqBO.setCreateName(fscOrderPO.getOperatorName());
                }
            } else {
                ids = new ArrayList<Long>();
                ids.add(fscOrderPO.getCreateOperId());
                userCode1 = this.getUserCode(ids);
                if (!CollectionUtils.isEmpty(userCode1)) {
                    todoPassWaitAbilityReqBO.setCreateId(userCode1.get(0).getRegAccount());
                    todoPassWaitAbilityReqBO.setCreateName(fscOrderPO.getCreateOperName());
                }
            }
        }
        todoPassWaitAbilityReqBO.setCenterCode(todoFscWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoFscWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoFscWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
        todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = new TodoAddAlreadyDoneAbilityReqBO();
        todoAddAlreadyDoneAbilityReqBO.setObjId(todoFscWaitAbilityReqBO.getObjId().toString());
        todoAddAlreadyDoneAbilityReqBO.setAuditStatus(uocApprovalLogPO.getAuditResult() == 0 ? Boolean.TRUE : Boolean.FALSE);
        todoAddAlreadyDoneAbilityReqBO.setFinishYn(uocApprovalLogPO.getFinish() == 0 ? Boolean.FALSE : Boolean.TRUE);
        todoAddAlreadyDoneAbilityReqBO.setFinishTime(new Date());
        todoAddAlreadyDoneAbilityReqBO.setAuditTime(new Date());
        todoAddAlreadyDoneAbilityReqBO.setStepId(uocApprovalLogPO.getStepId());
        todoPassWaitAbilityReqBO.setDoneList(Collections.singletonList(todoAddAlreadyDoneAbilityReqBO));
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO saleRefundOperatorDoneApproval(UocApprovalLogPO uocApprovalLogPO, TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorDoneApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoFscWaitAbilityReqBO.getObjId());
        String regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : "";
        FscOrderRefundPO fscOrderRefundPO = this.fscOrderRefundMapper.queryById(todoFscWaitAbilityReqBO.getObjId());
        if (Objects.isNull(fscOrderRefundPO)) {
            log.info("fscOrderPO is null objId:{}", (Object)fscOrderRefundPO);
            return null;
        }
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        String code = fscOrderRefundPO.getTradeMode() + "" + fscOrderRefundPO.getReceiveType() + fscOrderRefundPO.getOrderSource() + fscOrderRefundPO.getOrderType() + fscOrderRefundPO.getSettleType();
        Map itemCodeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_WAIT_DONE_ITEM_TYPE");
        todoPassWaitAbilityReqBO.setExtendCode((String)itemCodeMap.get(code));
        todoPassWaitAbilityReqBO.setExt2(fscOrderRefundPO.getFscOrderId() + "");
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(fscOrderRefundPO.getCreateUserId());
        List<MemberAbilityBO> userCode1 = this.getUserCode(ids);
        if (!CollectionUtils.isEmpty(userCode1)) {
            todoPassWaitAbilityReqBO.setCreateId(userCode1.get(0).getRegAccount());
            todoPassWaitAbilityReqBO.setCreateName(fscOrderRefundPO.getCreateUserName());
        }
        todoPassWaitAbilityReqBO.setCenterCode(todoFscWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoFscWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoFscWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
        todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = new TodoAddAlreadyDoneAbilityReqBO();
        todoAddAlreadyDoneAbilityReqBO.setObjId(todoFscWaitAbilityReqBO.getObjId().toString());
        todoAddAlreadyDoneAbilityReqBO.setAuditStatus(uocApprovalLogPO.getAuditResult() == 0 ? Boolean.TRUE : Boolean.FALSE);
        todoAddAlreadyDoneAbilityReqBO.setFinishYn(uocApprovalLogPO.getFinish() == 0 ? Boolean.FALSE : Boolean.TRUE);
        todoAddAlreadyDoneAbilityReqBO.setFinishTime(new Date());
        todoAddAlreadyDoneAbilityReqBO.setFinishTime(new Date());
        todoAddAlreadyDoneAbilityReqBO.setStepId(uocApprovalLogPO.getStepId());
        todoPassWaitAbilityReqBO.setDoneList(Collections.singletonList(todoAddAlreadyDoneAbilityReqBO));
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorCancelApproval(UocApprovalLogPO uocApprovalLogPO, TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoFscWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoFscWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoFscWaitAbilityReqBO.getBusiName());
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorCancelApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoFscWaitAbilityReqBO.getObjId());
        String regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : "";
        todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        String stationId = todoFscWaitAbilityReqBO.getStationId();
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.listUser(stationId);
        if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO.getUserList();
            List collect = userList.stream().filter($ -> !$.getLoginName().equals(regAccount)).collect(Collectors.toList());
            log.info("operatorCancelApproval cancel userCode:{},ObjId:{}", (Object)JSON.toJSONString(collect), (Object)uocApprovalLogPO.getOrderId());
            todoPassWaitAbilityReqBO.setCancelList(collect.stream().map(user -> {
                com.tydic.fsc.pay.task.bo.TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = new com.tydic.fsc.pay.task.bo.TodoCancelWaitDoneAbilityReqBO();
                if (uocApprovalLogPO.getFinish() == 0) {
                    todoCancelWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                } else {
                    todoCancelWaitDoneAbilityReqBO.setHandleUserNo(null);
                }
                todoCancelWaitDoneAbilityReqBO.setObjId(uocApprovalLogPO.getOrderId().toString());
                todoCancelWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getStepId());
                return todoCancelWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorAddApproval(UocApprovalLogPO uocApprovalLogPO, TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoFscWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoFscWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoFscWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorAddApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoFscWaitAbilityReqBO.getObjId());
        String regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : "";
        todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
        todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        todoPassWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long auditOrderId = uocApprovalLogPO.getAuditOrderId();
        Long id = uocApprovalLogPO.getId();
        String nextStepName = uocApprovalLogPO.getNextStepName();
        if (!StringUtils.isEmpty((Object)nextStationId)) {
            UocApprovalLogPO subApprovalLogPO = this.listApprovalForSub(uocApprovalLogPO.getOrderId());
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(Long.parseLong(subApprovalLogPO.getOperid()));
            List<MemberAbilityBO> userCode1 = this.getUserCode(ids);
            todoPassWaitAbilityReqBO.setCreateId(userCode1.get(0).getRegAccount());
            todoPassWaitAbilityReqBO.setCreateName(subApprovalLogPO.getOperName());
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO1 = this.listUser(nextStationId);
            if (dycStationOrgSelectUserNameRspBO1 != null && dycStationOrgSelectUserNameRspBO1.getUserList() != null && dycStationOrgSelectUserNameRspBO1.getUserList().size() > 0) {
                List userList = dycStationOrgSelectUserNameRspBO1.getUserList();
                log.info("operatorAddApproval add userCode:{},objId:{}", (Object)JSON.toJSONString((Object)userList), (Object)uocApprovalLogPO.getOrderId());
                if ("1050".equals(todoFscWaitAbilityReqBO.getBusiCode())) {
                    FscAccountChargePO chargePO = new FscAccountChargePO();
                    chargePO.setChargeId(todoFscWaitAbilityReqBO.getObjId());
                    chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
                    if (chargePO == null) {
                        log.error("\u5145\u503c\u5ba1\u6279\u5f85\u529e\u672a\u67e5\u8be2\u5230\u5145\u503c\u5355\u4fe1\u606f\uff1a{}", (Object)todoFscWaitAbilityReqBO.getObjId());
                        return null;
                    }
                    todoPassWaitAbilityReqBO.setExt1(chargePO.getAdvanceDepositNo());
                } else {
                    FscOrderPO fscOrderPO = this.fscOrderMapper.qryByFscOrderId(uocApprovalLogPO.getOrderId());
                    Integer orderFlow = fscOrderPO.getOrderFlow();
                    if (Objects.nonNull(orderFlow)) {
                        switch (orderFlow) {
                            case 0: {
                                FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
                                fscOrderRelationPo.setFscOrderId(fscOrderPO.getFscOrderId());
                                List list = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
                                if (!CollectionUtils.isEmpty((Collection)list)) {
                                    todoPassWaitAbilityReqBO.setExt2(((FscOrderRelationPO)list.get(0)).getInspExecution());
                                }
                                String code = fscOrderPO.getTradeMode() + "" + fscOrderPO.getReceiveType() + fscOrderPO.getOrderSource() + fscOrderPO.getOrderType() + fscOrderPO.getSettleType();
                                Map itemCodeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_WAIT_DONE_ITEM_TYPE");
                                todoPassWaitAbilityReqBO.setExtendCode((String)itemCodeMap.get(code));
                                break;
                            }
                            case 1: {
                                Integer tradeMode = fscOrderPO.getTradeMode();
                                Integer settlePlatform = fscOrderPO.getSettlePlatform();
                                if (!Objects.nonNull(tradeMode) || !Objects.nonNull(settlePlatform) || !tradeMode.equals(2) || !settlePlatform.equals(2)) break;
                                todoPassWaitAbilityReqBO.setExt2("2");
                                break;
                            }
                            case 20: {
                                todoPassWaitAbilityReqBO.setExt2("3");
                                break;
                            }
                            default: {
                                log.error("fscOrderPO orderFlow error objId:{}", (Object)fscOrderPO.getFscOrderId());
                            }
                        }
                    }
                    todoPassWaitAbilityReqBO.setExt1(fscOrderPO.getOrderNo());
                }
                todoPassWaitAbilityReqBO.setExt7(auditOrderId + "");
                todoPassWaitAbilityReqBO.setExt8(id + "");
                todoPassWaitAbilityReqBO.setRemark(nextStepName);
                todoPassWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                    todoAddWaitDoneAbilityReqBO.setObjId(uocApprovalLogPO.getOrderId().toString());
                    todoAddWaitDoneAbilityReqBO.setObjNo(todoPassWaitAbilityReqBO.getExt1());
                    todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                    todoAddWaitDoneAbilityReqBO.setIsFirstAddWait("0");
                    todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                    return todoAddWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO saleRefundOperatorAddApproval(UocApprovalLogPO uocApprovalLogPO, TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO1;
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoFscWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoFscWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoFscWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorAddApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoFscWaitAbilityReqBO.getObjId());
        String regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : "";
        todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
        todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        todoPassWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long auditOrderId = uocApprovalLogPO.getAuditOrderId();
        Long id = uocApprovalLogPO.getId();
        String nextStepName = uocApprovalLogPO.getNextStepName();
        if (!StringUtils.isEmpty((Object)nextStationId) && (dycStationOrgSelectUserNameRspBO1 = this.listUser(nextStationId)) != null && dycStationOrgSelectUserNameRspBO1.getUserList() != null && dycStationOrgSelectUserNameRspBO1.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO1.getUserList();
            log.info("operatorAddApproval add userCode:{},objId:{}", (Object)JSON.toJSONString((Object)userList), (Object)uocApprovalLogPO.getOrderId());
            FscOrderRefundPO fscOrderRefundPO = this.fscOrderRefundMapper.queryById(uocApprovalLogPO.getOrderId());
            String code = fscOrderRefundPO.getTradeMode() + "" + fscOrderRefundPO.getReceiveType() + fscOrderRefundPO.getOrderSource() + fscOrderRefundPO.getOrderType() + fscOrderRefundPO.getSettleType();
            Map itemCodeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_WAIT_DONE_ITEM_TYPE");
            todoPassWaitAbilityReqBO.setExtendCode((String)itemCodeMap.get(code));
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(fscOrderRefundPO.getCreateUserId());
            List<MemberAbilityBO> userCode1 = this.getUserCode(ids);
            if (!CollectionUtils.isEmpty(userCode1)) {
                todoPassWaitAbilityReqBO.setCreateId(userCode1.get(0).getRegAccount());
                todoPassWaitAbilityReqBO.setCreateName(fscOrderRefundPO.getCreateUserName());
            }
            todoPassWaitAbilityReqBO.setExt7(auditOrderId + "");
            todoPassWaitAbilityReqBO.setExt8(id + "");
            todoPassWaitAbilityReqBO.setRemark(nextStepName);
            todoPassWaitAbilityReqBO.setExt1(fscOrderRefundPO.getRefundNo());
            todoPassWaitAbilityReqBO.setExt2(fscOrderRefundPO.getFscOrderId() + "");
            todoPassWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                todoAddWaitDoneAbilityReqBO.setObjId(uocApprovalLogPO.getOrderId().toString());
                todoAddWaitDoneAbilityReqBO.setObjNo(fscOrderRefundPO.getRefundNo());
                todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                return todoAddWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorSubmit(UocApprovalLogPO uocApprovalLogPO, TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        if (Objects.isNull(uocApprovalLogPO)) {
            log.info("uocApprovalLogPO is null objId:{}", (Object)todoFscWaitAbilityReqBO.getObjId());
            return null;
        }
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long orderId = uocApprovalLogPO.getOrderId();
        Long auditOrderId = uocApprovalLogPO.getAuditOrderId();
        Long id = uocApprovalLogPO.getId();
        String nextStepName = uocApprovalLogPO.getNextStepName();
        TodoWaitAbilityReqBO todoWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoWaitAbilityReqBO.setExt7(auditOrderId + "");
        todoWaitAbilityReqBO.setExt8(id + "");
        todoWaitAbilityReqBO.setRemark(nextStepName);
        if (!StringUtils.isEmpty((Object)nextStationId)) {
            UocApprovalLogPO subApprovalLogPO = this.listApprovalForSub(orderId);
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(Long.parseLong(subApprovalLogPO.getOperid()));
            List<MemberAbilityBO> userCode1 = this.getUserCode(ids);
            todoWaitAbilityReqBO.setCreateId(userCode1.get(0).getRegAccount());
            todoWaitAbilityReqBO.setCreateName(subApprovalLogPO.getOperName());
            if ("1050".equals(todoFscWaitAbilityReqBO.getBusiCode())) {
                FscAccountChargePO chargePO = new FscAccountChargePO();
                chargePO.setChargeId(todoFscWaitAbilityReqBO.getObjId());
                chargePO = this.fscAccountChargeMapper.getModelBy(chargePO);
                if (chargePO == null) {
                    log.error("\u5145\u503c\u5ba1\u6279\u5f85\u529e\u672a\u67e5\u8be2\u5230\u5145\u503c\u5355\u4fe1\u606f\uff1a{}", (Object)todoFscWaitAbilityReqBO.getObjId());
                    return null;
                }
                todoWaitAbilityReqBO.setExt1(chargePO.getAdvanceDepositNo());
            } else {
                FscOrderPO fscOrderPO = this.fscOrderMapper.qryByFscOrderId(orderId);
                if (Objects.isNull(fscOrderPO)) {
                    log.info("fscOrderPO is null objId:{}", (Object)orderId);
                    return null;
                }
                Integer orderFlow = fscOrderPO.getOrderFlow();
                if (Objects.nonNull(orderFlow)) {
                    switch (orderFlow) {
                        case 0: {
                            FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
                            fscOrderRelationPo.setFscOrderId(fscOrderPO.getFscOrderId());
                            List list = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
                            if (!CollectionUtils.isEmpty((Collection)list)) {
                                todoWaitAbilityReqBO.setExt2(((FscOrderRelationPO)list.get(0)).getInspExecution());
                            }
                            String code = fscOrderPO.getTradeMode() + "" + fscOrderPO.getReceiveType() + fscOrderPO.getOrderSource() + fscOrderPO.getOrderType() + fscOrderPO.getSettleType();
                            Map itemCodeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_WAIT_DONE_ITEM_TYPE");
                            todoWaitAbilityReqBO.setExtendCode((String)itemCodeMap.get(code));
                            break;
                        }
                        case 1: {
                            Integer tradeMode = fscOrderPO.getTradeMode();
                            Integer settlePlatform = fscOrderPO.getSettlePlatform();
                            if (!Objects.nonNull(tradeMode) || !Objects.nonNull(settlePlatform) || !tradeMode.equals(2) || !settlePlatform.equals(2)) break;
                            todoWaitAbilityReqBO.setExt2("2");
                            break;
                        }
                        case 20: {
                            todoWaitAbilityReqBO.setExt2("3");
                            break;
                        }
                        default: {
                            log.error("fscOrderPO orderFlow error objId:{}", (Object)orderId);
                        }
                    }
                }
                todoWaitAbilityReqBO.setExt1(fscOrderPO.getOrderNo());
            }
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.listUser(nextStationId);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                List userList = dycStationOrgSelectUserNameRspBO.getUserList();
                log.info("dycStationOrgSelectUserNameRspBO userList:{}", (Object)JSON.toJSONString((Object)userList));
                todoWaitAbilityReqBO.setBusiCode(todoFscWaitAbilityReqBO.getBusiCode());
                todoWaitAbilityReqBO.setBusiName(todoFscWaitAbilityReqBO.getBusiName());
                todoWaitAbilityReqBO.setCenterCode(todoFscWaitAbilityReqBO.getCenterCode());
                if (Objects.nonNull(uocApprovalLogPO.getOperid())) {
                    List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
                    List<MemberAbilityBO> userCode = this.getUserCode(strings);
                    String regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : "";
                    todoWaitAbilityReqBO.setOperatorId(regAccount);
                    todoWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
                }
                todoWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
                todoWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                    todoAddWaitDoneAbilityReqBO.setObjId(uocApprovalLogPO.getOrderId().toString());
                    todoAddWaitDoneAbilityReqBO.setObjNo(todoWaitAbilityReqBO.getExt1());
                    todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                    todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                    return todoAddWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO saleRefundOperatorSubmit(UocApprovalLogPO uocApprovalLogPO, TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        if (Objects.isNull(uocApprovalLogPO)) {
            log.info("uocApprovalLogPO is null objId:{}", (Object)todoFscWaitAbilityReqBO.getObjId());
            return null;
        }
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long orderId = uocApprovalLogPO.getOrderId();
        Long auditOrderId = uocApprovalLogPO.getAuditOrderId();
        Long id = uocApprovalLogPO.getId();
        String nextStepName = uocApprovalLogPO.getNextStepName();
        TodoWaitAbilityReqBO todoWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoWaitAbilityReqBO.setExt7(auditOrderId + "");
        todoWaitAbilityReqBO.setExt8(id + "");
        todoWaitAbilityReqBO.setRemark(nextStepName);
        if (!StringUtils.isEmpty((Object)nextStationId)) {
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO;
            FscOrderRefundPO fscOrderRefundPO = this.fscOrderRefundMapper.queryById(orderId);
            if (Objects.isNull(fscOrderRefundPO)) {
                log.info("fscOrderPO is null objId:{}", (Object)orderId);
                return null;
            }
            String code = fscOrderRefundPO.getTradeMode() + "" + fscOrderRefundPO.getReceiveType() + fscOrderRefundPO.getOrderSource() + fscOrderRefundPO.getOrderType() + fscOrderRefundPO.getSettleType();
            Map itemCodeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_WAIT_DONE_ITEM_TYPE");
            todoWaitAbilityReqBO.setExtendCode((String)itemCodeMap.get(code));
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(fscOrderRefundPO.getCreateUserId());
            List<MemberAbilityBO> userCode1 = this.getUserCode(ids);
            if (!CollectionUtils.isEmpty(userCode1)) {
                todoWaitAbilityReqBO.setCreateId(userCode1.get(0).getRegAccount());
                todoWaitAbilityReqBO.setCreateName(fscOrderRefundPO.getCreateUserName());
            }
            if ((dycStationOrgSelectUserNameRspBO = this.listUser(nextStationId)) != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                List userList = dycStationOrgSelectUserNameRspBO.getUserList();
                log.info("dycStationOrgSelectUserNameRspBO userList:{}", (Object)JSON.toJSONString((Object)userList));
                todoWaitAbilityReqBO.setBusiCode(todoFscWaitAbilityReqBO.getBusiCode());
                todoWaitAbilityReqBO.setBusiName(todoFscWaitAbilityReqBO.getBusiName());
                todoWaitAbilityReqBO.setCenterCode(todoFscWaitAbilityReqBO.getCenterCode());
                todoWaitAbilityReqBO.setExt1(fscOrderRefundPO.getRefundNo());
                todoWaitAbilityReqBO.setExt2(fscOrderRefundPO.getFscOrderId() + "");
                if (Objects.nonNull(uocApprovalLogPO.getOperid())) {
                    List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
                    List<MemberAbilityBO> userCode = this.getUserCode(strings);
                    String regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : "";
                    todoWaitAbilityReqBO.setOperatorId(regAccount);
                    todoWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
                }
                todoWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
                todoWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                    todoAddWaitDoneAbilityReqBO.setObjId(uocApprovalLogPO.getOrderId().toString());
                    todoAddWaitDoneAbilityReqBO.setObjNo(fscOrderRefundPO.getRefundNo());
                    todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                    todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                    return todoAddWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoWaitAbilityReqBO;
    }

    private DycStationOrgSelectUserNameRspBO listUser(String nextStationId) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nextStationId)) {
            return null;
        }
        String[] stationIds = nextStationId.split(",");
        if (stationIds.length == 0) {
            return null;
        }
        ArrayList<Long> nextStationIds = new ArrayList<Long>();
        for (String stationId : stationIds) {
            nextStationIds.add(Long.parseLong(stationId));
        }
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationIds(nextStationIds);
        return this.dycStationOrgSelectUserNameService.selectUserNameList(dycStationOrgSelectUserNameReqBO);
    }

    private List<MemberAbilityBO> getUserCode(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return null;
        }
        UmcTaskReqBO umcTaskReqBO = new UmcTaskReqBO();
        umcTaskReqBO.setMemIds(userIds);
        UmcTaskRspBO user = this.umcAddTaskAbilityService.qryTaskUser(umcTaskReqBO);
        if (Objects.isNull(user) || CollectionUtils.isEmpty((Collection)user.getList())) {
            return null;
        }
        return user.getList();
    }

    public void addTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getWaitDoneList())) {
            log.info("addTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            TodoWaitAbilityAssembleReqBO todoWaitAbilityAssembleReqBO = new TodoWaitAbilityAssembleReqBO();
            BeanUtils.copyProperties((Object)todoWaitAbilityReqBO, (Object)todoWaitAbilityAssembleReqBO);
            TodoWaitAbilityAtomRspBO todoWaitAbilityAtomRspBO = this.fscDealWaitParamsAtomService.fscDealTodoAddWaitParams(todoWaitAbilityAssembleReqBO);
            log.error("\u5f53\u524d\u8fd4\u56de\u5f97todoWaitAbilityAtomRspBO\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)((Object)todoWaitAbilityAtomRspBO)));
            if (todoWaitAbilityAtomRspBO.getRespCode().equals("0000") && todoWaitAbilityAtomRspBO.getTodoWaitAbilityAssembleRspBO() != null) {
                TodoWaitAbilityReqBO abilityReqBO = new TodoWaitAbilityReqBO();
                BeanUtils.copyProperties((Object)todoWaitAbilityAtomRspBO.getTodoWaitAbilityAssembleRspBO(), (Object)abilityReqBO);
                abilityReqBO.setStepId(todoWaitAbilityReqBO.getStepId());
                abilityReqBO.setNextStepId(todoWaitAbilityReqBO.getNextStepId());
                todoWaitAbilityReqBO = abilityReqBO;
            }
            try {
                if (!todoWaitAbilityReqBO.getWaitPushStatus().booleanValue()) {
                    throw new ZTBusinessException("\u4e0a\u4e00\u6b65\u53d6\u6d88\u5f85\u529e\u63a8\u9001\u5931\u8d25");
                }
                com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = (com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoWaitAbilityReqBO), (TypeReference)new TypeReference<com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO>(){}, (Feature[])new Feature[0]);
                TodoAddWaitDoneAbilityRspBO doneAbilityRspBO = this.todoWaitDoneWriteAbilityService.addWaitDone(todoAddWaitDoneAbilityReqBO);
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                if ("0000".equals(doneAbilityRspBO.getRespCode())) {
                    waitDoneLogReqBO.setWaitDoneStatus(1);
                } else {
                    waitDoneLogReqBO.setWaitDoneStatus(2);
                    waitDoneLogReqBO.setFailNum(0);
                    waitDoneLogReqBO.setExt1(doneAbilityRspBO.getRespDesc().length() > 200 ? doneAbilityRspBO.getRespDesc().substring(0, 200) : doneAbilityRspBO.getRespDesc());
                    todoWaitAbilityReqBO.setWaitPushStatus(false);
                }
                waitDoneLogReqBO.setWaitDoneType(1);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getWaitDoneList())) {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getWaitDoneList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5f85\u529e\u63a8\u9001\u9519\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)e));
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                waitDoneLogReqBO.setWaitDoneStatus(2);
                waitDoneLogReqBO.setFailNum(0);
                waitDoneLogReqBO.setExt1(e.getMessage().length() > 200 ? e.getMessage().substring(0, 200) : e.getMessage());
                waitDoneLogReqBO.setWaitDoneType(1);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getWaitDoneList())) {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getWaitDoneList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
                todoWaitAbilityReqBO.setWaitPushStatus(false);
            }
        }
    }

    public void cancelTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getCancelList())) {
            log.info("cancelTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            try {
                if (!todoWaitAbilityReqBO.getWaitPushStatus().booleanValue()) {
                    throw new ZTBusinessException("\u4e0a\u4e00\u6b65\u65b0\u589e\u5df2\u529e\u63a8\u9001\u5931\u8d25");
                }
                TodoCancelWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = (TodoCancelWaitDoneAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoWaitAbilityReqBO), (TypeReference)new TypeReference<TodoCancelWaitDoneAbilityReqBO>(){}, (Feature[])new Feature[0]);
                TodoCancelWaitDoneAbilityRspBO doneAbilityRspBO = this.todoWaitDoneWriteAbilityService.cancelWaitDone(todoAddWaitDoneAbilityReqBO);
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                if ("0000".equals(doneAbilityRspBO.getRespCode())) {
                    waitDoneLogReqBO.setWaitDoneStatus(1);
                } else {
                    waitDoneLogReqBO.setWaitDoneStatus(2);
                    waitDoneLogReqBO.setFailNum(0);
                    waitDoneLogReqBO.setExt1(doneAbilityRspBO.getRespDesc().length() > 200 ? doneAbilityRspBO.getRespDesc().substring(0, 200) : doneAbilityRspBO.getRespDesc());
                    todoWaitAbilityReqBO.setWaitPushStatus(false);
                }
                waitDoneLogReqBO.setWaitDoneType(2);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getCancelList())) {
                    com.tydic.fsc.pay.task.bo.TodoCancelWaitDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getCancelList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
            }
            catch (Exception e) {
                log.error("\u53d6\u6d88\u5f85\u529e\u63a8\u9001\u9519\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)e));
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                waitDoneLogReqBO.setWaitDoneStatus(2);
                waitDoneLogReqBO.setFailNum(0);
                waitDoneLogReqBO.setExt1(e.getMessage().length() > 200 ? e.getMessage().substring(0, 200) : e.getMessage());
                waitDoneLogReqBO.setWaitDoneType(2);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getCancelList())) {
                    com.tydic.fsc.pay.task.bo.TodoCancelWaitDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getCancelList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
                todoWaitAbilityReqBO.setWaitPushStatus(false);
            }
        }
    }

    public void doneTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getDoneList())) {
            log.info("doneTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            try {
                com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = (com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoWaitAbilityReqBO), (TypeReference)new TypeReference<com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO>(){}, (Feature[])new Feature[0]);
                TodoAddAlreadyDoneAbilityRspBO doneAbilityRspBO = this.todoWaitDoneWriteAbilityService.AddAlreadyDone(todoAddWaitDoneAbilityReqBO);
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                if ("0000".equals(doneAbilityRspBO.getRespCode())) {
                    waitDoneLogReqBO.setWaitDoneStatus(1);
                } else {
                    todoWaitAbilityReqBO.setWaitPushStatus(false);
                    waitDoneLogReqBO.setWaitDoneStatus(2);
                    waitDoneLogReqBO.setFailNum(0);
                    waitDoneLogReqBO.setExt1(doneAbilityRspBO.getRespDesc().length() > 200 ? doneAbilityRspBO.getRespDesc().substring(0, 200) : doneAbilityRspBO.getRespDesc());
                }
                waitDoneLogReqBO.setWaitDoneType(3);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getDoneList())) {
                    TodoAddAlreadyDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getDoneList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5df2\u529e\u63a8\u9001\u9519\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)e));
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                waitDoneLogReqBO.setWaitDoneStatus(2);
                waitDoneLogReqBO.setFailNum(0);
                waitDoneLogReqBO.setExt1(e.getMessage().length() > 200 ? e.getMessage().substring(0, 200) : e.getMessage());
                waitDoneLogReqBO.setWaitDoneType(3);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getDoneList())) {
                    TodoAddAlreadyDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getDoneList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
                todoWaitAbilityReqBO.setWaitPushStatus(false);
            }
        }
    }

    private void assertParam(TodoFscWaitAbilityReqBO todoFscWaitAbilityReqBO) {
        Assert.notNull((Object)todoFscWaitAbilityReqBO, (String)"PARAM_IS_NULL");
        Assert.notNull((Object)todoFscWaitAbilityReqBO.getObjId(), (String)"OBJID_IS_NULL");
        Assert.notNull((Object)todoFscWaitAbilityReqBO.getOperatorType(), (String)"OPERATOR_IS_NULL");
    }

    private void addWaitDoneLog(TodoWaitAbilityReqBO todoWaitAbilityReqBO, String addWaitTodoTopic, String addWaitTodoTag) {
        WaitDoneLogReqBO contractWaitDoneLogReqBO = new WaitDoneLogReqBO();
        List<TodoAddWaitDoneAbilityReqBO> waitDoneList = todoWaitAbilityReqBO.getWaitDoneList();
        if (!CollectionUtils.isEmpty(waitDoneList)) {
            TodoAddWaitDoneAbilityReqBO todoAddWaitDone = waitDoneList.get(0);
            contractWaitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
            contractWaitDoneLogReqBO.setTitle(todoAddWaitDone.getTitle());
        }
        contractWaitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
        contractWaitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
        contractWaitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
        contractWaitDoneLogReqBO.setWaitDoneStatus(1);
        contractWaitDoneLogReqBO.setWaitDoneType(1);
        contractWaitDoneLogReqBO.setMqTopic(addWaitTodoTopic);
        contractWaitDoneLogReqBO.setMqTag(addWaitTodoTag);
        this.waitDoneLogBusiService.addWaitDoneLog(contractWaitDoneLogReqBO);
    }

    private void addCancelWaitDoneLog(TodoWaitAbilityReqBO todoWaitAbilityReqBO, String cancelWaitTodoTopic, String addWaitTodoTag) {
        WaitDoneLogReqBO contractWaitDoneLogReqBO = new WaitDoneLogReqBO();
        List<com.tydic.fsc.pay.task.bo.TodoCancelWaitDoneAbilityReqBO> cancelList = todoWaitAbilityReqBO.getCancelList();
        if (!CollectionUtils.isEmpty(cancelList)) {
            com.tydic.fsc.pay.task.bo.TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = cancelList.get(0);
            contractWaitDoneLogReqBO.setObjId(Long.valueOf(todoCancelWaitDoneAbilityReqBO.getObjId()));
        }
        contractWaitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
        contractWaitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
        contractWaitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
        contractWaitDoneLogReqBO.setWaitDoneStatus(1);
        contractWaitDoneLogReqBO.setWaitDoneType(2);
        contractWaitDoneLogReqBO.setMqTopic(this.addWaitTodoTopic);
        contractWaitDoneLogReqBO.setMqTag(addWaitTodoTag);
        this.waitDoneLogBusiService.addWaitDoneLog(contractWaitDoneLogReqBO);
    }

    private void addDoneWaitDoneLog(TodoWaitAbilityReqBO todoWaitAbilityReqBO, String doneWaitTodoTopic, String addWaitTodoTag) {
        WaitDoneLogReqBO contractWaitDoneLogReqBO = new WaitDoneLogReqBO();
        List<TodoAddAlreadyDoneAbilityReqBO> doneList = todoWaitAbilityReqBO.getDoneList();
        if (!CollectionUtils.isEmpty(doneList)) {
            TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = doneList.get(0);
            contractWaitDoneLogReqBO.setObjId(Long.valueOf(todoAddAlreadyDoneAbilityReqBO.getObjId()));
        }
        contractWaitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
        contractWaitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
        contractWaitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
        contractWaitDoneLogReqBO.setWaitDoneStatus(1);
        contractWaitDoneLogReqBO.setWaitDoneType(3);
        contractWaitDoneLogReqBO.setMqTopic(doneWaitTodoTopic);
        contractWaitDoneLogReqBO.setMqTag(addWaitTodoTag);
        this.waitDoneLogBusiService.addWaitDoneLog(contractWaitDoneLogReqBO);
    }
}

