/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.google.common.base.Joiner;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.authority.busi.api.DycStationSelectService;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscAdvPayManagerPrintService;
import com.tydic.fsc.pay.ability.api.FscPayQueryShouldPayListAbilityService;
import com.tydic.fsc.pay.ability.bo.FscAdvPayManagerPrintReqBO;
import com.tydic.fsc.pay.ability.bo.FscAdvPayManagerPrintRspBO;
import com.tydic.fsc.pay.ability.bo.FscPayQueryShouldPayListAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayQueryShouldPayListAbilityRspBO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscStringUtils;
import com.tydic.fsc.util.PdfUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscAdvPayManagerPrintService"})
public class FscAdvPayManagerPrintAbilityServiceImpl
implements FscAdvPayManagerPrintService {
    private static final Logger log = LoggerFactory.getLogger(FscAdvPayManagerPrintAbilityServiceImpl.class);
    private FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService;
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    private FscPayQueryShouldPayListAbilityService fscPayQueryShouldPayListAbilityService;
    private DycStationSelectService dycStationSelectService;
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    private static final String PATH = "fsc/pdf";
    private static final String FILE_TYPE_OSS = "OSS";
    private static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;

    @PostMapping(value={"fscAdvPayManagerPrint"})
    public FscAdvPayManagerPrintRspBO fscAdvPayManagerPrint(@RequestBody FscAdvPayManagerPrintReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2OrderId\u4e3a\u7a7a");
        }
        FscComOrderDetailQueryAbilityReqBO fscComOrderDetailQueryAbilityReqBO = (FscComOrderDetailQueryAbilityReqBO)BeanUtil.copyProperties((Object)reqBO, FscComOrderDetailQueryAbilityReqBO.class);
        FscComOrderDetailQueryAbilityRspBO fscComOrderDetailQueryAbilityRspBO = this.fscComOrderDetailQueryAbilityService.qryOrderDetail(fscComOrderDetailQueryAbilityReqBO);
        FscPayQueryShouldPayListAbilityReqBO fscPayQueryShouldPayListAbilityReqBO = (FscPayQueryShouldPayListAbilityReqBO)BeanUtil.copyProperties((Object)reqBO, FscPayQueryShouldPayListAbilityReqBO.class);
        fscPayQueryShouldPayListAbilityReqBO.setFscOrderIds(Stream.of(reqBO.getOrderId()).collect(Collectors.toList()));
        ArrayList<FscShouldPayBO> shouldPayBOList = new ArrayList();
        FscPayQueryShouldPayListAbilityRspBO fscPayQueryShouldPayListAbilityRspBO = this.fscPayQueryShouldPayListAbilityService.qryShouldPayList(fscPayQueryShouldPayListAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscPayQueryShouldPayListAbilityRspBO.getRows())) {
            shouldPayBOList = fscPayQueryShouldPayListAbilityRspBO.getRows();
        }
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = (FscComApprovalprocessListQryAbilityReqBO)BeanUtil.copyProperties((Object)reqBO, FscComApprovalprocessListQryAbilityReqBO.class);
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(1));
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
            this.dealStationInfo(approvalList);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.createAdvPayManagerPrintByParams(fscComOrderDetailQueryAbilityRspBO, approvalList, shouldPayBOList, byteArrayOutputStream, reqBO);
        if (reqBO.getMergerFlag().booleanValue()) {
            FscAdvPayManagerPrintRspBO rspBO = new FscAdvPayManagerPrintRspBO();
            rspBO.setByteArrayOutputStream(byteArrayOutputStream);
            return rspBO;
        }
        String pdfUrl = this.uploadFile("\u91c7\u8d2d\u9884\u4ed8\u5355", byteArrayOutputStream);
        return new FscAdvPayManagerPrintRspBO(pdfUrl, fscComOrderDetailQueryAbilityRspBO.getOrderNo(), null);
    }

    public List<FscApprovalprocessListBO> dealStationInfo(List<FscApprovalprocessListBO> approvalList) {
        approvalList.get(0).setStationName("\u63d0\u4ea4\u4eba");
        for (int i = 1; i < approvalList.size(); ++i) {
            approvalList.get(i).setStationName(approvalList.get(i).getStepName());
        }
        log.info("\u4e8c\u6b21\u5904\u7406\u4fe1\u606f\u4eba\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014:" + approvalList.toString());
        return approvalList;
    }

    private void createAdvPayManagerPrintByParams(FscComOrderDetailQueryAbilityRspBO fscComOrderDetailQueryAbilityRspBO, List<FscApprovalprocessListBO> auditList, List<FscShouldPayBO> shouldPayList, ByteArrayOutputStream byteArrayOutputStream, FscAdvPayManagerPrintReqBO reqBO) {
        Document document = PdfUtils.newDefaultDocument();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        this.addHeadTable(tableList, fscComOrderDetailQueryAbilityRspBO, "\u91c7\u8d2d\u9884\u4ed8\u5355", reqBO);
        this.addMiddleTable(tableList, fscComOrderDetailQueryAbilityRspBO, shouldPayList);
        PdfUtils.addAuditTable(tableList, auditList);
        PdfUtils.addTableListToDoc((Document)document, tableList);
        document.close();
    }

    public void addHeadTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO fscComOrderDetailQueryAbilityRspBO, String typeStr, FscAdvPayManagerPrintReqBO reqBO) {
        boolean settlePlatFlag;
        String orgName = "\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8";
        String deptName = fscComOrderDetailQueryAbilityRspBO.getCreateOrgName();
        boolean bl = settlePlatFlag = Objects.nonNull(fscComOrderDetailQueryAbilityRspBO.getSettlePlatform()) && fscComOrderDetailQueryAbilityRspBO.getSettlePlatform() == 2;
        if (settlePlatFlag) {
            FscOrderExtPO extPO = new FscOrderExtPO();
            extPO.setFscOrderId(fscComOrderDetailQueryAbilityRspBO.getFscOrderId());
            FscOrderExtPO modelBy = this.fscOrderExtMapper.getModelBy(extPO);
            if (Objects.nonNull(modelBy.getUnifyOrgName())) {
                orgName = modelBy.getUnifyOrgName();
            }
            if (Objects.nonNull(modelBy.getUnifyDeptName())) {
                deptName = orgName + " - " + modelBy.getUnifyDeptName();
            }
        }
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)fscComOrderDetailQueryAbilityRspBO.getPayerName(), (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)22, null);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u7ed3\u7b97\u5e26\u4ed8\u6b3e\u81ea\u52a8\u751f\u6210", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
        tableList.add(titleTable1);
        tableList.add(this.dealColor(fscComOrderDetailQueryAbilityRspBO, typeStr, fscComOrderDetailQueryAbilityRspBO, reqBO));
        PdfPTable pageTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u90e8\u95e8\u540d\u79f0\uff1a", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)deptName, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u4eba\uff1a", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)fscComOrderDetailQueryAbilityRspBO.getCreateOperName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)6, null);
        tableList.add(pageTable3);
    }

    private void addMiddleTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO fscComOrderDetailQueryAbilityRspBO, List<FscShouldPayBO> shouldPayList) {
        PdfPTable pageTable4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u9884\u4ed8\u6b3e\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)fscComOrderDetailQueryAbilityRspBO.getOrderNo(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u9884\u4ed8\u6b3e\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u4e1a\u52a1\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        StringBuilder orderTypeStr = new StringBuilder();
        ArrayList<String> shouldPayOrderTypeList = new ArrayList<String>();
        for (FscShouldPayBO shouldPayBO : shouldPayList) {
            shouldPayOrderTypeList.add(this.dealOrderTypeEnum(shouldPayBO.getOrderType()));
        }
        if (Objects.nonNull(fscComOrderDetailQueryAbilityRspBO.getSettlePlatform()) && fscComOrderDetailQueryAbilityRspBO.getSettlePlatform() == 2) {
            orderTypeStr.append("\u81ea\u9700\u91c7\u8d2d");
        } else {
            orderTypeStr.append(Joiner.on((String)"\u3001").join(shouldPayOrderTypeList));
        }
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)orderTypeStr.toString(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable4);
        PdfPTable pageTable5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u8ba2\u5355\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        String orderNo = null;
        List payOrderCode = shouldPayList.stream().filter(s -> s.getOrderCodeStr() != null).map(FscShouldPayBO::getOrderCodeStr).collect(Collectors.toList());
        if (!StringUtils.isEmpty(payOrderCode)) {
            orderNo = String.join((CharSequence)",", payOrderCode);
        }
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)orderNo, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u5b9e\u9645\u6536\u6b3e\u5355\u4f4d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)fscComOrderDetailQueryAbilityRspBO.getPayeeAccountName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u7533\u8bf7\u65e5\u671f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)DateUtil.dateToStr((Date)fscComOrderDetailQueryAbilityRspBO.getCreateTime()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable5);
        PdfPTable pageTable6 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u5907\u6ce8", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)fscComOrderDetailQueryAbilityRspBO.getOrderDesc(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(pageTable6);
        PdfPTable pageTable7 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u5408\u540c\u6807\u7b7e", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)0, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        tableList.add(pageTable7);
        PdfPTable pageTable8 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u4ed8\u6b3e\u65b9\u5f0f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u6536\u6b3e\u65b9", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u5f00\u6237\u94f6\u884c", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u94f6\u884c\u8d26\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable8);
        PdfPTable pageTable9 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)"1 ", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)fscComOrderDetailQueryAbilityRspBO.getPayChannelStr(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)fscComOrderDetailQueryAbilityRspBO.getPayeeName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)fscComOrderDetailQueryAbilityRspBO.getPayeeBankName(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable9, (Object)fscComOrderDetailQueryAbilityRspBO.getPayeeBankAccount(), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTable9);
        PdfPTable titleTable12 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable12, (Object)"\u9884\u4ed8\u91d1\u989d\u5408\u8ba1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)8, null);
        PdfPTable nestedTable = new PdfPTable(2);
        PdfPTable nestedTable1 = new PdfPTable(4);
        PdfUtils.addCellToTable((PdfPTable)nestedTable1, (Object)"\u5927\u5199", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)1, null);
        PdfUtils.addCellToTable((PdfPTable)nestedTable1, (Object)AmountUtils.upper((BigDecimal)fscComOrderDetailQueryAbilityRspBO.getTotalCharge()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)3, null);
        PdfPTable nestedTable2 = new PdfPTable(4);
        PdfUtils.addCellToTable((PdfPTable)nestedTable2, (Object)"\u5c0f\u5199", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)1, null);
        PdfUtils.addCellToTable((PdfPTable)nestedTable2, (Object)("\uffe5" + FscStringUtils.convertValue((Object)fscComOrderDetailQueryAbilityRspBO.getTotalCharge())), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)nestedTable, (Object)nestedTable1, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)nestedTable, (Object)nestedTable2, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)titleTable12, (Object)nestedTable, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(25.0f), (Integer)16, null);
        tableList.add(titleTable12);
    }

    public String uploadFile(String name, ByteArrayOutputStream byteArrayOutputStream) {
        String exportUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = name + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return exportUrl;
    }

    private String dealOrderTypeEnum(Integer code) {
        FscOrderTypeEnum instance = FscOrderTypeEnum.getInstance((Integer)code);
        if (instance != null) {
            return instance.getCodeDesc();
        }
        return code.toString();
    }

    private PdfPTable dealColor(FscComOrderDetailQueryAbilityRspBO abilityRspBO, String typeStr, FscComOrderDetailQueryAbilityRspBO fscComOrderDetailQueryAbilityRspBO, FscAdvPayManagerPrintReqBO reqBO) {
        log.info("\u662f\u5426\u5bf9\u63a5\u65b0\u4e1a\u8d22:" + abilityRspBO.getSettlePlatform());
        PdfPTable pageTable2 = PdfUtils.newPdfTable();
        Integer pushResult = 0;
        if (abilityRspBO.getSettlePlatform() != null && abilityRspBO.getSettlePlatform() == 2) {
            FscPurchasePushLogPo po = new FscPurchasePushLogPo();
            po.setObjectId(abilityRspBO.getFscOrderId());
            po.setType(FscConstants.OrderFlow.PAY);
            po.setOrderBy("create_time desc");
            po.setPushStatus(Integer.valueOf(1));
            List modelBy = this.fscPurchasePushLogMapper.getList(po);
            if (!CollectionUtils.isEmpty((Collection)modelBy) && ((FscPurchasePushLogPo)modelBy.get(0)).getPushStatus() != null) {
                pushResult = ((FscPurchasePushLogPo)modelBy.get(0)).getPushStatus();
            }
        } else {
            FscPushLogPO pushLogPO = new FscPushLogPO();
            pushLogPO.setObjectId(abilityRspBO.getFscOrderId());
            pushLogPO.setType(FscConstants.OrderFlow.PAY);
            pushLogPO.setStatus(Integer.valueOf(1));
            FscPushLogPO lastPushLog = this.fscPushLogMapper.getLastPushLog(pushLogPO);
            if (lastPushLog != null && lastPushLog.getStatus() != null) {
                pushResult = lastPushLog.getStatus();
            }
        }
        if (pushResult == 1 || !StringUtils.isEmpty((Object)reqBO.getIsprofess()) && !"0".equals(reqBO.getIsprofess())) {
            PdfUtils.addCellToTable((PdfPTable)pageTable2, (Object)typeStr, (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)22, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable2, (Object)("\u9644\u4ef6" + (fscComOrderDetailQueryAbilityRspBO.getAttachmentList() == null ? 0 : fscComOrderDetailQueryAbilityRspBO.getAttachmentList().size()) + "\u5f20"), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
        } else {
            PdfPCell cell1 = new PdfPCell();
            Paragraph paragraph = new Paragraph();
            paragraph.add((Element)new Chunk(typeStr, PdfUtils.DEFAULT_TITLE_FONT));
            paragraph.add((Element)new Chunk("(\u6d41\u7a0b\u672a\u7ed3\u675f\uff0c\u4ec5\u4f9b\u9884\u89c8\u4f7f\u7528)", PdfUtils.DEFAULT_TITLE_FONT_RED));
            paragraph.setAlignment(1);
            cell1.addElement((Element)paragraph);
            cell1.setColspan(22);
            cell1.setFixedHeight(40.0f);
            cell1.setVerticalAlignment(5);
            pageTable2.addCell(cell1);
            PdfPCell cell2 = new PdfPCell((Phrase)new Paragraph("\u9644\u4ef6" + (fscComOrderDetailQueryAbilityRspBO.getAttachmentList() == null ? 0 : fscComOrderDetailQueryAbilityRspBO.getAttachmentList().size()) + "\u5f20", PdfUtils.DEFAULT_SECOND_TITLE_FONT));
            cell2.setColspan(2);
            cell2.setFixedHeight(30.0f);
            cell2.setVerticalAlignment(5);
            cell2.setHorizontalAlignment(5);
            pageTable2.addCell(cell2);
        }
        return pageTable2;
    }

    @Autowired
    public void setFscComOrderDetailQueryAbilityService(FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService) {
        this.fscComOrderDetailQueryAbilityService = fscComOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setFscComApprovalprocessListQryAbilityService(FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService) {
        this.fscComApprovalprocessListQryAbilityService = fscComApprovalprocessListQryAbilityService;
    }

    @Autowired
    public void setFscPayQueryShouldPayListAbilityService(FscPayQueryShouldPayListAbilityService fscPayQueryShouldPayListAbilityService) {
        this.fscPayQueryShouldPayListAbilityService = fscPayQueryShouldPayListAbilityService;
    }

    @Autowired
    public void setDycStationSelectService(DycStationSelectService dycStationSelectService) {
        this.dycStationSelectService = dycStationSelectService;
    }

    @Autowired
    public void setFileClient(FileClient fileClient) {
        this.fileClient = fileClient;
    }
}

