/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscPayShouldRefundBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscShouldPayDealOrderCancelAbilityService;
import com.tydic.fsc.pay.ability.bo.FscShouldPayDealOrderCancelAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscShouldPayDealOrderCancelAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscShouldPayDealOrderCancelBusiService;
import com.tydic.fsc.pay.busi.bo.FscShouldPayDealOrderCancelBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscShouldPayDealOrderCancelBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uoc.common.ability.api.PebExtSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUpperOrderAbilityBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscShouldPayDealOrderCancelAbilityService"})
public class FscShouldPayDealOrderCancelAbilityServiceImpl
implements FscShouldPayDealOrderCancelAbilityService {
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayDealOrderCancelBusiService fscShouldPayDealOrderCancelBusiService;
    @Autowired
    private PebExtSalesSingleDetailsListQueryAbilityService pebExtSalesSingleDetailsListQueryAbilityService;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @PostMapping(value={"dealOrderCancel"})
    public FscShouldPayDealOrderCancelAbilityRspBO dealOrderCancel(@RequestBody FscShouldPayDealOrderCancelAbilityReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u8ba2\u5355id[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscShouldPayPO shouldPayPO = new FscShouldPayPO();
        shouldPayPO.setOrderId(reqBO.getOrderId());
        List list = this.fscShouldPayMapper.getList(shouldPayPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new FscShouldPayDealOrderCancelAbilityRspBO();
        }
        ArrayList<FscPayShouldRefundBO> refundPOList = new ArrayList<FscPayShouldRefundBO>(list.size());
        HashMap<Long, Object> orderPaidMap = new HashMap<Long, Object>();
        HashMap<Long, FscShouldPayPO> shouldPayMap = new HashMap<Long, FscShouldPayPO>();
        for (FscShouldPayPO fscShouldPayPO : list) {
            if (orderPaidMap.get(fscShouldPayPO.getPayerId()) == null) {
                orderPaidMap.put(fscShouldPayPO.getPayerId(), fscShouldPayPO.getPaidAmount());
            } else {
                Object paidAmt = (BigDecimal)orderPaidMap.get(fscShouldPayPO.getPayerId());
                paidAmt = ((BigDecimal)paidAmt).add(fscShouldPayPO.getPaidAmount());
                orderPaidMap.put(fscShouldPayPO.getPayerId(), paidAmt);
            }
            shouldPayMap.put(fscShouldPayPO.getPayerId(), fscShouldPayPO);
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        List orderPOList = this.fscOrderMapper.getPrePayInfo(orderPO);
        if (!CollectionUtils.isEmpty((Collection)orderPOList)) {
            for (FscOrderPO fscOrderPO : orderPOList) {
                if (fscOrderPO.getPaidAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                FscPayShouldRefundBO shouldRefundBO = new FscPayShouldRefundBO();
                shouldPayPO = (FscShouldPayPO)shouldPayMap.get(fscOrderPO.getPayerId());
                if (shouldPayPO == null) {
                    throw new FscBusinessException("198888", "\u672a\u83b7\u53d6\u5230\u5e94\u4ed8\u5355\u4fe1\u606f\uff01");
                }
                BeanUtils.copyProperties((Object)shouldPayPO, (Object)shouldRefundBO);
                shouldRefundBO.setRefundShouldPayById(reqBO.getOrderId());
                shouldRefundBO.setPayingAmount(BigDecimal.ZERO);
                shouldRefundBO.setPaidAmount(BigDecimal.ZERO);
                shouldRefundBO.setTotalPaidAmount((BigDecimal)orderPaidMap.get(shouldPayPO.getPayerId()));
                shouldRefundBO.setGenerateType(FscConstants.FscRefundGenerateType.AUTO);
                shouldRefundBO.setRefundPayStatus(FscConstants.RefundPayStatus.DRAFT);
                if (shouldPayPO.getTradeMode().equals(FscConstants.FscTradeMode.MATCHMAKING_MODE)) {
                    shouldRefundBO.setUserType(Integer.valueOf(1));
                    shouldRefundBO.setBuynerNo(shouldPayPO.getBuyerNo());
                    shouldRefundBO.setBuynerName(shouldPayPO.getBuyerName());
                } else if (shouldPayPO.getPayerId().equals(this.operationOrgId)) {
                    shouldRefundBO.setUserType(Integer.valueOf(2));
                } else {
                    shouldRefundBO.setUserType(Integer.valueOf(1));
                    shouldRefundBO.setBuynerNo(shouldPayPO.getBuyerNo());
                    shouldRefundBO.setBuynerName(shouldPayPO.getBuyerName());
                }
                shouldRefundBO.setRefundType(FscConstants.RefundType.INSPECTION);
                shouldRefundBO.setOperatorId(shouldPayPO.getOperatorId());
                shouldRefundBO.setOperatorName(shouldPayPO.getOperatorName());
                if (!StringUtils.isEmpty((Object)shouldPayPO.getOperationNo())) {
                    shouldRefundBO.setOperatorDeptId(Long.valueOf(shouldPayPO.getOperationNo()));
                }
                shouldRefundBO.setOperatorDeptName(shouldPayPO.getOperationName());
                shouldRefundBO.setRefundAmount(fscOrderPO.getPaidAmount());
                shouldRefundBO.setCreateTime(new Date());
                shouldRefundBO.setCreateUserId(reqBO.getUserId());
                shouldRefundBO.setCreateUserName(reqBO.getName());
                shouldRefundBO.setCreateOrgId(reqBO.getOrgId());
                shouldRefundBO.setCreateOrgName(reqBO.getOrgName());
                shouldRefundBO.setRefundShouldPayNo(shouldPayPO.getObjectNo());
                shouldRefundBO.setOrderCode(shouldPayPO.getObjectNo());
                shouldRefundBO.setPayOrderId(fscOrderPO.getFscOrderId());
                shouldRefundBO.setPayOrderNo(fscOrderPO.getOrderNo());
                shouldRefundBO.setRefundPayStatus(FscConstants.RefundPayStatus.DRAFT);
                shouldRefundBO.setIsPushUnify(fscOrderPO.getSettlePlatform());
                if (shouldRefundBO.getIsPushUnify() == null) {
                    shouldRefundBO.setIsPushUnify(Integer.valueOf(0));
                }
                PebExtSalesSingleDetailsListQueryReqBO detailsListQueryReqBO = new PebExtSalesSingleDetailsListQueryReqBO();
                detailsListQueryReqBO.setOrderId(reqBO.getOrderId());
                detailsListQueryReqBO.setTabId(Integer.valueOf(30001));
                PebExtSalesSingleDetailsListQueryRspBO detailsListQueryRspBO = this.pebExtSalesSingleDetailsListQueryAbilityService.getPebExtSalesSingleDetailsListQuery(detailsListQueryReqBO);
                if (!detailsListQueryRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + detailsListQueryRspBO.getRespDesc());
                }
                if (CollectionUtils.isEmpty((Collection)detailsListQueryRspBO.getRows())) {
                    throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
                shouldRefundBO.setSupplierId(Long.valueOf(((PebExtUpperOrderAbilityBO)detailsListQueryRspBO.getRows().get(0)).getSupNo()));
                shouldRefundBO.setSupplierName(((PebExtUpperOrderAbilityBO)detailsListQueryRspBO.getRows().get(0)).getSupName());
                refundPOList.add(shouldRefundBO);
            }
        }
        FscShouldPayDealOrderCancelBusiReqBO busiReqBO = new FscShouldPayDealOrderCancelBusiReqBO();
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setRefundBOList(refundPOList);
        FscShouldPayDealOrderCancelBusiRspBO busiRspBO = this.fscShouldPayDealOrderCancelBusiService.dealOrderCancel(busiReqBO);
        return (FscShouldPayDealOrderCancelAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscShouldPayDealOrderCancelAbilityRspBO.class);
    }
}

