/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bo.FscFinanceBankSerialBO;
import com.tydic.fsc.bo.FscFinanceDraftInfoBO;
import com.tydic.fsc.bo.FscFinancePayItemBO;
import com.tydic.fsc.bo.FscFinancePayReduceBO;
import com.tydic.fsc.bo.FscFinancePlanItemBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinancePayTempQryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceReleasePayInfoAbilityService;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceReleasePayInfoReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.enums.FscFundsclaimBillTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscFinanceDealPayAuditAbilityService;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceDealPayAuditReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceDealPayAuditRspBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePushPayBillAbilityReqBO;
import com.tydic.fsc.pay.atom.api.FscFinancePayCheckUtil;
import com.tydic.fsc.pay.busi.api.finance.FscFinanceDealPayAuditBusiService;
import com.tydic.fsc.pay.busi.bo.finance.FscFinanceDealPayAuditBusiReqBO;
import com.tydic.fsc.pay.busi.bo.finance.FscFinanceDealPayAuditBusiRspBO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinancePayReducePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscFinanceDealPayAuditAbilityService"})
public class FscFinanceDealPayAuditAbilityServiceImpl
implements FscFinanceDealPayAuditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceDealPayAuditAbilityServiceImpl.class);
    @Autowired
    private FscFinanceDealPayAuditBusiService fscFinanceDealPayAuditBusiService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscFinanceReleasePayInfoAbilityService fscFinanceReleasePayInfoAbilityService;
    @Resource(name="fscPushFinancePayListMqServiceProvider")
    private ProxyMessageProducer fscPushFinancePayListMqServiceProvider;
    @Autowired
    private FscFinancePayTempQryAtomService fscFinancePayTempQryAtomService;
    @Value(value="${es.FSC_PUSH_FINANCE_PAY_TOPIC:FSC_PUSH_FINANCE_PAY_TOPIC}")
    private String fscPushFinancePayTopic;
    @Value(value="${es.FSC_PUSH_FINANCE_PAY_TAG:FSC_PUSH_FINANCE_PAY_TAG}")
    private String fscPushFinancePayTag;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealFinancePayAudit"})
    public FscFinanceDealPayAuditRspBO dealFinancePayAudit(@RequestBody FscFinanceDealPayAuditReqBO reqBO) {
        if (reqBO.getTempId() != null) {
            this.qryTemp(reqBO);
        }
        this.valid(reqBO);
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (!FscBillStatus.TO_BE_APPROVAL.getCode().equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("191124", "\u5f53\u524d\u4ed8\u6b3e\u5355\u4e0d\u4e3a\u5f85\u5ba1\u6279\u72b6\u6001");
        }
        Integer count = this.fscOrderMapper.getOrderAuditCount(reqBO.getOrderId(), reqBO.getStationsList());
        if (count == 0) {
            this.sendMq(reqBO);
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        FscFinanceDealPayAuditBusiReqBO busiReqBO = new FscFinanceDealPayAuditBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        busiReqBO.setOrderFlow(fscOrder.getOrderFlow());
        busiReqBO.setOrderState(fscOrder.getOrderState());
        busiReqBO.setActualAmount(fscOrder.getActualAmount());
        busiReqBO.setTotalCharge(fscOrder.getTotalCharge());
        busiReqBO.setOrderNo(fscOrder.getOrderNo());
        this.dealFinanceInfo(reqBO, busiReqBO);
        FscFinanceDealPayAuditBusiRspBO busiRspBO = this.fscFinanceDealPayAuditBusiService.dealFinancePayAudit(busiReqBO);
        this.sendMq(reqBO);
        if ("0000".equals(busiRspBO.getRespCode()) && busiRspBO.getFinish().booleanValue()) {
            if (reqBO.getAuditResult() == 1) {
                FscFinanceReleasePayInfoReqBO releaseReqBO = new FscFinanceReleasePayInfoReqBO();
                releaseReqBO.setFscOrderId(reqBO.getOrderId());
                this.fscFinanceReleasePayInfoAbilityService.dealReleasePayInfo(releaseReqBO);
            } else {
                FscFinancePushPayBillAbilityReqBO abilityReqBO = new FscFinancePushPayBillAbilityReqBO();
                abilityReqBO.setFscOrderId(reqBO.getOrderId());
                this.fscPushFinancePayListMqServiceProvider.send(new ProxyMessage(this.fscPushFinancePayTopic, this.fscPushFinancePayTag, JSON.toJSONString((Object)abilityReqBO)));
            }
        }
        return (FscFinanceDealPayAuditRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscFinanceDealPayAuditRspBO.class);
    }

    private void valid(FscFinanceDealPayAuditReqBO reqBO) {
        if (reqBO.getOrderId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getAuditResult() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[auditResult]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void sendMq(FscFinanceDealPayAuditReqBO reqBO) {
        FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
        syncReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
    }

    private void dealFinanceInfo(FscFinanceDealPayAuditReqBO reqBO, FscFinanceDealPayAuditBusiReqBO busiReqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderPayItemBOS())) {
            FscOrderPayItemPO payItemPO;
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getOrderId());
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            FscOrderFinancePO financePO = new FscOrderFinancePO();
            financePO.setFscOrderId(reqBO.getOrderId());
            financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
            if (financePO.getPaymentType() == null) {
                financePO.setPaymentType(FscConstants.FinancePaymentType.INITIATIVE);
            }
            if (reqBO.getPaymentType() == null) {
                reqBO.setPaymentType(FscConstants.FinancePaymentType.INITIATIVE);
            }
            if (!financePO.getPaymentType().equals(reqBO.getPaymentType())) {
                this.dealPaymentChange(reqBO, busiReqBO);
            }
            FscOrderPayItemPO payItemQueryVo = new FscOrderPayItemPO();
            payItemQueryVo.setFscOrderId(reqBO.getOrderId());
            List itemPoList = this.fscOrderPayItemMapper.getList(payItemQueryVo);
            Map<Long, FscOrderPayItemPO> payItemMap = itemPoList.stream().collect(Collectors.toMap(FscOrderPayItemPO::getOrderPayItemId, e -> e));
            ArrayList<FscOrderPayItemPO> updOrderPayItemPOS = new ArrayList<FscOrderPayItemPO>();
            ArrayList<FscOrderPayItemPO> updatePayingAmtList = new ArrayList<FscOrderPayItemPO>();
            BigDecimal totalCharge = BigDecimal.ZERO;
            for (FscOrderPayItemBO payItemBO : reqBO.getFscOrderPayItemBOS()) {
                if (payItemBO.getOrderPayItemId() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderPayItemBOS.orderPayItemId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                FscOrderPayItemPO fscOrderPayItemPO = payItemMap.get(payItemBO.getOrderPayItemId());
                if (fscOrderPayItemPO == null) {
                    throw new FscBusinessException("198888", payItemBO.getOrderPayItemId() + "\u4ed8\u6b3e\u660e\u7ec6\u884c\u4e0d\u5b58\u5728\uff01");
                }
                totalCharge = totalCharge.add(payItemBO.getPayAmount());
                if (payItemBO.getReduceAmt() != null && payItemBO.getReduceAmt().compareTo(BigDecimal.ZERO) > 0) {
                    totalCharge = totalCharge.add(payItemBO.getReduceAmt());
                }
                payItemMap.remove(payItemBO.getOrderPayItemId());
                if (payItemBO.getReduceAmt() == null) {
                    payItemBO.setReduceAmt(BigDecimal.ZERO);
                }
                if (fscOrderPayItemPO.getReduceAmt() == null) {
                    fscOrderPayItemPO.setReduceAmt(BigDecimal.ZERO);
                }
                if (payItemBO.getPayAmount().compareTo(fscOrderPayItemPO.getPayAmount()) == 0 && payItemBO.getReduceAmt().compareTo(fscOrderPayItemPO.getReduceAmt()) == 0 && (payItemBO.getIsReduce() == null || payItemBO.getIsReduce().equals(fscOrderPayItemPO.getIsReduce()))) continue;
                payItemPO = new FscOrderPayItemPO();
                BeanUtils.copyProperties((Object)payItemBO, (Object)payItemPO);
                updOrderPayItemPOS.add(payItemPO);
                FscOrderPayItemPO updatePayingPO = new FscOrderPayItemPO();
                BeanUtils.copyProperties((Object)payItemBO, (Object)updatePayingPO);
                updatePayingPO.setPayAmount(payItemBO.getPayAmount().add(payItemBO.getReduceAmt()).subtract(fscOrderPayItemPO.getPayAmount()).subtract(payItemBO.getReduceAmt()));
                updatePayingPO.setPayAmountLocal(payItemBO.getPayAmountLocal().subtract(fscOrderPayItemPO.getPayAmountLocal()));
                updatePayingAmtList.add(updatePayingPO);
                payItemPO.setOrderPayItemId(payItemBO.getOrderPayItemId());
            }
            busiReqBO.setUpdOrderPayItemPOS(updOrderPayItemPOS);
            busiReqBO.setTotalCharge(totalCharge);
            busiReqBO.setActualAmount(totalCharge);
            if (!CollectionUtils.isEmpty(payItemMap)) {
                Set<Long> orderItemIds = payItemMap.keySet();
                busiReqBO.setOrderPayItemIds(orderItemIds);
                for (Long key : payItemMap.keySet()) {
                    payItemPO = payItemMap.get(key);
                    payItemPO.setPayAmount(payItemPO.getPayAmount().negate());
                    updatePayingAmtList.add(payItemPO);
                }
            }
            busiReqBO.setUpdatePayingAmtList(updatePayingAmtList);
            if (financePO.getPaymentType().equals(reqBO.getPaymentType())) {
                this.dealPayItemInfo(busiReqBO, itemPoList);
            }
        }
    }

    private void dealPayItemInfo(FscFinanceDealPayAuditBusiReqBO busiReqBO, List<FscOrderPayItemPO> poList) {
        log.info("dealPayItemInfo:{}", (Object)JSON.toJSONString((Object)((Object)busiReqBO)));
        String billtypeName = null;
        String extBizBilltype = null;
        if (FscConstants.PaymentMethod.PRE_PAY.equals(poList.get(0).getShouldPayMethod())) {
            billtypeName = FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getDescription();
            extBizBilltype = FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getName();
        } else {
            billtypeName = FscFundsclaimBillTypeEnum.PAY_BILL_TYPE_USED_CONTRACT.getDescription();
            extBizBilltype = FscFundsclaimBillTypeEnum.PAY_BILL_TYPE_USED_CONTRACT.getName();
        }
        FscFinancePayReducePO reduceQueryVo = new FscFinancePayReducePO();
        reduceQueryVo.setFscOrderId(busiReqBO.getOrderId());
        List reducePOList = this.fscFinancePayReduceMapper.getList(reduceQueryVo);
        Map<Long, FscFinancePayReducePO> reduceMap = reducePOList.stream().collect(Collectors.toMap(FscFinancePayReducePO::getReduceId, e -> e));
        ArrayList<FscFinancePayReducePO> reduceUpdList = new ArrayList<FscFinancePayReducePO>();
        ArrayList<FscFinancePayReducePO> reduceAddList = new ArrayList<FscFinancePayReducePO>();
        ArrayList<Long> delReduceIds = new ArrayList<Long>();
        FscFinanceBankStatementPO statementQueryVo = new FscFinanceBankStatementPO();
        statementQueryVo.setFscOrderId(busiReqBO.getOrderId());
        List statementPOList = this.fscFinanceBankStatementMapper.getList(statementQueryVo);
        Map<Long, FscFinanceBankStatementPO> bankMap = statementPOList.stream().collect(Collectors.toMap(FscFinanceBankStatementPO::getStatementId, e -> e));
        ArrayList<FscFinanceBankStatementPO> bankUpdList = new ArrayList<FscFinanceBankStatementPO>();
        ArrayList<FscFinanceBankStatementPO> bankAddList = new ArrayList<FscFinanceBankStatementPO>();
        ArrayList<String> bankExtIds = new ArrayList<String>();
        ArrayList<Long> delBankIds = new ArrayList<Long>();
        FscFinanceDraftInfoPO draftInfoQueryVo = new FscFinanceDraftInfoPO();
        draftInfoQueryVo.setFscOrderId(busiReqBO.getOrderId());
        List draftPOList = this.fscFinanceDraftInfoMapper.getList(draftInfoQueryVo);
        Map<Long, FscFinanceDraftInfoPO> draftMap = draftPOList.stream().collect(Collectors.toMap(FscFinanceDraftInfoPO::getDraftId, e -> e));
        ArrayList<FscFinanceDraftInfoPO> draftUpdList = new ArrayList<FscFinanceDraftInfoPO>();
        ArrayList<FscFinanceDraftInfoPO> draftAddList = new ArrayList<FscFinanceDraftInfoPO>();
        HashSet<String> draftExtIds = new HashSet<String>();
        HashSet<String> supplyExtIds = new HashSet<String>();
        ArrayList<Long> delDraftIds = new ArrayList<Long>();
        FscFinanceCapitalPlanPO capitalPlanQueryVo = new FscFinanceCapitalPlanPO();
        capitalPlanQueryVo.setFscOrderId(busiReqBO.getOrderId());
        List planList = this.fscFinanceCapitalPlanMapper.getList(capitalPlanQueryVo);
        Map<Long, FscFinanceCapitalPlanPO> planMap = planList.stream().collect(Collectors.toMap(FscFinanceCapitalPlanPO::getCaptialId, e -> e));
        ArrayList<FscFinanceCapitalPlanPO> planUpdList = new ArrayList<FscFinanceCapitalPlanPO>();
        ArrayList<FscFinanceCapitalPlanPO> planAddList = new ArrayList<FscFinanceCapitalPlanPO>();
        ArrayList<FscFinanceCapitalPlanPO> releasePlanList = new ArrayList<FscFinanceCapitalPlanPO>();
        ArrayList<Long> delPlanIds = new ArrayList<Long>();
        FscFinancePayItemPO payItemPO = new FscFinancePayItemPO();
        payItemPO.setFscOrderId(busiReqBO.getOrderId());
        List financeItemList = this.fscFinancePayItemMapper.getList(payItemPO);
        Map<Object, Object> financeMap = Maps.newHashMap();
        if (financeItemList != null && !financeItemList.isEmpty()) {
            financeMap = financeItemList.stream().collect(Collectors.toMap(FscFinancePayItemPO::getFinancePayItemId, e -> e));
        }
        ArrayList<FscFinancePayItemPO> financeUpdList = new ArrayList<FscFinancePayItemPO>();
        ArrayList<FscFinancePayItemPO> financeAddList = new ArrayList<FscFinancePayItemPO>();
        if (busiReqBO.getFscOrderPayItemBOS() == null || busiReqBO.getFscOrderPayItemBOS().isEmpty()) {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (FscOrderPayItemBO payItemBO : busiReqBO.getFscOrderPayItemBOS()) {
            FscFinanceCapitalPlanPO planPO;
            FscFinancePayCheckUtil.checkLocalAmount(payItemBO, busiReqBO.getExchangeRate(), busiReqBO.getCurrency());
            if (!CollectionUtils.isEmpty((Collection)payItemBO.getReduceList())) {
                for (FscFinancePayReduceBO reduceBO : payItemBO.getReduceList()) {
                    FscFinancePayReducePO reducePO;
                    if (reduceBO.getReduceId() == null) {
                        reducePO = new FscFinancePayReducePO();
                        BeanUtils.copyProperties((Object)reduceBO, (Object)reducePO);
                        reducePO.setReduceId(Long.valueOf(Sequence.getInstance().nextId()));
                        reducePO.setFscOrderId(busiReqBO.getOrderId());
                        reducePO.setShouldPayId(payItemBO.getShouldPayId());
                        reducePO.setOrderPayItemId(payItemBO.getOrderPayItemId());
                        reducePO.setCreateTime(new Date());
                        reduceAddList.add(reducePO);
                        continue;
                    }
                    reducePO = reduceMap.get(reduceBO.getReduceId());
                    reduceMap.remove(reduceBO.getReduceId());
                    if (reducePO == null) {
                        throw new FscBusinessException("198888", reduceBO.getReduceId() + "\u672a\u67e5\u8be2\u5230\u6838\u51cf\u4fe1\u606f");
                    }
                    if (reduceBO.getReduceAmt().compareTo(reducePO.getReduceAmt()) == 0) continue;
                    FscFinancePayReducePO updatePo = new FscFinancePayReducePO();
                    updatePo.setReduceId(reduceBO.getReduceId());
                    updatePo.setReduceAmt(reduceBO.getReduceAmt());
                    updatePo.setReduceChgAmt(reduceBO.getReduceAmt().subtract(reducePO.getReduceAmt()));
                    reduceUpdList.add(updatePo);
                }
                busiReqBO.setReduceUpdList(reduceUpdList);
                busiReqBO.setReduceAddList(reduceAddList);
            }
            if (!CollectionUtils.isEmpty((Collection)payItemBO.getSerialList())) {
                for (FscFinanceBankSerialBO bankSerialBO : payItemBO.getSerialList()) {
                    Object bankPO;
                    if (bankSerialBO.getStatementId() == null || !bankSerialBO.getOrderPayItemId().equals(bankMap.get(bankSerialBO.getStatementId()).getOrderPayItemId())) {
                        bankPO = new FscFinanceBankStatementPO();
                        BeanUtils.copyProperties((Object)bankSerialBO, (Object)bankPO);
                        bankPO.setStatementId(Long.valueOf(Sequence.getInstance().nextId()));
                        bankPO.setFscOrderId(busiReqBO.getOrderId());
                        bankPO.setCreateTime(new Date());
                        bankPO.setBilltypeName(billtypeName);
                        bankPO.setExtBizBilltype(extBizBilltype);
                        bankPO.setOrderPayItemId(payItemBO.getOrderPayItemId());
                        bankSerialBO.setStatementId(bankPO.getStatementId());
                        bankAddList.add((FscFinanceBankStatementPO)bankPO);
                    } else {
                        bankPO = bankMap.get(bankSerialBO.getStatementId());
                        bankMap.remove(bankSerialBO.getStatementId());
                        if (bankPO == null) {
                            throw new FscBusinessException("198888", bankSerialBO.getStatementId() + "\u672a\u67e5\u8be2\u5230\u6d41\u6c34\u4fe1\u606f\uff01");
                        }
                        if (bankPO.getOccAmt().compareTo(bankSerialBO.getOccAmt()) != 0) {
                            bankPO.setOccAmt(bankSerialBO.getOccAmt());
                            bankPO.setBilltypeName(billtypeName);
                            bankPO.setExtBizBilltype(extBizBilltype);
                            bankUpdList.add((FscFinanceBankStatementPO)bankPO);
                            if (!StringUtils.isEmpty((Object)bankPO.getExtId())) {
                                bankExtIds.add(bankPO.getExtId());
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)bankSerialBO.getPlanList())) continue;
                    for (FscFinancePlanItemBO planItemBO : bankSerialBO.getPlanList()) {
                        if (!(planItemBO.getCaptialId() != null && planItemBO.getPlanItemCode().equals(planMap.get(planItemBO.getCaptialId()).getPlanItemCode()) && planItemBO.getPayItemNo().equals(planMap.get(planItemBO.getCaptialId()).getPayItemNo()) && planItemBO.getPayMethodCode().equals(planMap.get(planItemBO.getCaptialId()).getPayMethodCode()))) {
                            planPO = new FscFinanceCapitalPlanPO();
                            BeanUtils.copyProperties((Object)planItemBO, (Object)planPO);
                            planPO.setCaptialId(Long.valueOf(Sequence.getInstance().nextId()));
                            planPO.setFscOrderId(busiReqBO.getOrderId());
                            planPO.setStatementId(bankSerialBO.getStatementId());
                            planPO.setShouldPayId(payItemBO.getShouldPayId());
                            planAddList.add(planPO);
                            continue;
                        }
                        planPO = planMap.get(planItemBO.getCaptialId());
                        planMap.remove(planItemBO.getCaptialId());
                        if (planPO == null) {
                            throw new FscBusinessException("198888", planItemBO.getCaptialId() + "\u672a\u67e5\u8be2\u5230\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\uff01");
                        }
                        if (planPO.getOccAmount().compareTo(planItemBO.getOccAmount()) == 0) continue;
                        planPO.setOccAmount(planItemBO.getOccAmount());
                        planUpdList.add(planPO);
                        releasePlanList.add(planPO);
                    }
                    busiReqBO.setPlanAddList(planAddList);
                    busiReqBO.setPlanUpdList(planUpdList);
                }
                busiReqBO.setBankUpdList(bankUpdList);
                busiReqBO.setBankAddList(bankAddList);
            }
            if (CollectionUtils.isEmpty((Collection)payItemBO.getFinanceItemList())) continue;
            for (FscFinancePayItemBO financePayItemBO : payItemBO.getFinanceItemList()) {
                FscFinancePayItemPO financePayItemPO;
                if (financePayItemBO.getFinancePayItemId() == null || !financePayItemBO.getOrderPayItemId().equals(((FscFinancePayItemPO)financeMap.get(financePayItemBO.getFinancePayItemId())).getOrderPayItemId())) {
                    financePayItemPO = new FscFinancePayItemPO();
                    BeanUtils.copyProperties((Object)financePayItemBO, (Object)financePayItemPO);
                    financePayItemPO.setFinancePayItemId(Long.valueOf(Sequence.getInstance().nextId()));
                    financePayItemPO.setShouldPayId(payItemBO.getShouldPayId());
                    financePayItemPO.setOrderPayItemId(payItemBO.getOrderPayItemId());
                    financePayItemPO.setFscOrderId(busiReqBO.getOrderId());
                    financePayItemBO.setFinancePayItemId(financePayItemPO.getFinancePayItemId());
                    financeAddList.add(financePayItemPO);
                } else {
                    financePayItemPO = (FscFinancePayItemPO)financeMap.get(financePayItemBO.getFinancePayItemId());
                    financeMap.remove(financePayItemBO.getFinancePayItemId());
                    if (financePayItemPO == null) {
                        throw new FscBusinessException("198888", financePayItemBO.getFinancePayItemId() + "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u4fe1\u606f\u6570\u636e");
                    }
                    FscFinancePayItemPO updatePO = new FscFinancePayItemPO();
                    BeanUtils.copyProperties((Object)financePayItemBO, (Object)updatePO);
                    updatePO.setFinancePayItemId(financePayItemBO.getFinancePayItemId());
                    financeUpdList.add(updatePO);
                }
                if (!CollectionUtils.isEmpty((Collection)financePayItemBO.getDraftList())) {
                    for (FscFinanceDraftInfoBO draftInfoBO : financePayItemBO.getDraftList()) {
                        FscFinanceDraftInfoPO draftInfoPO;
                        if (draftInfoBO.getDraftId() == null || !draftInfoBO.getFinancePayItemId().equals(draftMap.get(draftInfoBO.getDraftId()).getFinancePayItemId())) {
                            draftInfoPO = new FscFinanceDraftInfoPO();
                            BeanUtils.copyProperties((Object)draftInfoBO, (Object)draftInfoPO);
                            draftInfoPO.setDraftId(Long.valueOf(Sequence.getInstance().nextId()));
                            draftInfoPO.setFinancePayItemId(financePayItemBO.getFinancePayItemId());
                            draftInfoPO.setFscOrderId(busiReqBO.getOrderId());
                            draftInfoPO.setCreateTime(new Date());
                            draftInfoPO.setExtbilltypeName(billtypeName);
                            draftInfoPO.setExtBizBilltype(extBizBilltype);
                            draftAddList.add(draftInfoPO);
                            continue;
                        }
                        draftInfoPO = draftMap.get(draftInfoBO.getDraftId());
                        if (draftInfoPO == null) {
                            throw new FscBusinessException("198888", draftInfoBO.getDraftId() + "\u672a\u83b7\u53d6\u5230\u7968\u636e\u4fe1\u606f\uff01");
                        }
                        draftMap.remove(draftInfoPO.getDraftId());
                        if (draftInfoPO.getOccAmt().compareTo(draftInfoBO.getOccAmt()) == 0) continue;
                        draftInfoPO.setOccAmt(draftInfoBO.getOccAmt());
                        draftInfoPO.setOccAmtLocal(draftInfoBO.getOccAmtLocal());
                        draftInfoPO.setExtbilltypeName(billtypeName);
                        draftInfoPO.setExtBizBilltype(extBizBilltype);
                        draftUpdList.add(draftInfoPO);
                        if (!StringUtils.isEmpty((Object)draftInfoPO.getExtId()) && FscConstants.FinanceDraftType.RECEIVABLE_DRAFT.equals(draftInfoPO.getDraftType())) {
                            draftExtIds.add(draftInfoPO.getExtId());
                            continue;
                        }
                        if (StringUtils.isEmpty((Object)draftInfoPO.getExtId()) || !FscConstants.FinanceDraftType.RECEIVABLE_SUPPLY.equals(draftInfoPO.getDraftType())) continue;
                        supplyExtIds.add(draftInfoPO.getExtId());
                    }
                    busiReqBO.setDraftUpdList(draftUpdList);
                    busiReqBO.setDraftAddList(draftAddList);
                }
                if (CollectionUtils.isEmpty((Collection)financePayItemBO.getPlanList())) continue;
                for (FscFinancePlanItemBO planItemBO : financePayItemBO.getPlanList()) {
                    if (!(planItemBO.getCaptialId() != null && planItemBO.getPlanItemCode().equals(planMap.get(planItemBO.getCaptialId()).getPlanItemCode()) && planItemBO.getPayItemNo().equals(planMap.get(planItemBO.getCaptialId()).getPayItemNo()) && planItemBO.getPayMethodCode().equals(planMap.get(planItemBO.getCaptialId()).getPayMethodCode()))) {
                        planPO = new FscFinanceCapitalPlanPO();
                        BeanUtils.copyProperties((Object)planItemBO, (Object)planPO);
                        planPO.setCaptialId(Long.valueOf(Sequence.getInstance().nextId()));
                        planPO.setFscOrderId(busiReqBO.getOrderId());
                        planPO.setShouldPayId(payItemBO.getShouldPayId());
                        planPO.setFinancePayItemId(financePayItemBO.getFinancePayItemId());
                        planAddList.add(planPO);
                        continue;
                    }
                    planPO = planMap.get(planItemBO.getCaptialId());
                    planMap.remove(planItemBO.getCaptialId());
                    if (planPO == null) {
                        throw new FscBusinessException("198888", planItemBO.getCaptialId() + "\u672a\u67e5\u8be2\u5230\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\uff01");
                    }
                    if (planPO.getOccAmount().compareTo(planItemBO.getOccAmount()) == 0) continue;
                    planPO.setOccAmount(planItemBO.getOccAmount());
                    planUpdList.add(planPO);
                    releasePlanList.add(planPO);
                }
                busiReqBO.setPlanAddList(planAddList);
                busiReqBO.setPlanUpdList(planUpdList);
            }
            busiReqBO.setFinanceAddList(financeAddList);
            busiReqBO.setFinanceUpdList(financeUpdList);
        }
        if (!CollectionUtils.isEmpty(planMap)) {
            for (Long planId : planMap.keySet()) {
                FscFinanceCapitalPlanPO planPO = planMap.get(planId);
                releasePlanList.add(planPO);
                delPlanIds.add(planPO.getCaptialId());
            }
        }
        if (!CollectionUtils.isEmpty(draftMap)) {
            for (Long draftId : draftMap.keySet()) {
                FscFinanceDraftInfoPO draftInfoPO = draftMap.get(draftId);
                if (!StringUtils.isEmpty((Object)draftInfoPO.getExtId())) {
                    if (FscConstants.FinanceDraftType.RECEIVABLE_DRAFT.equals(draftInfoPO.getDraftType())) {
                        draftExtIds.add(draftInfoPO.getExtId());
                    } else {
                        supplyExtIds.add(draftInfoPO.getExtId());
                    }
                }
                delDraftIds.add(draftId);
            }
        }
        if (!CollectionUtils.isEmpty((Map)financeMap)) {
            Set<Object> delFinanceItemIds = financeMap.keySet();
            busiReqBO.setDelFinanceItemIds(delFinanceItemIds);
        }
        if (!CollectionUtils.isEmpty(bankMap)) {
            for (Long bankId : bankMap.keySet()) {
                FscFinanceBankStatementPO statementPO = bankMap.get(bankId);
                if (!StringUtils.isEmpty((Object)statementPO.getExtId())) {
                    bankExtIds.add(statementPO.getExtId());
                }
                delBankIds.add(bankId);
            }
        }
        busiReqBO.setBankExtIds(bankExtIds);
        busiReqBO.setDraftExtIds(draftExtIds);
        busiReqBO.setReleasePlanList(releasePlanList);
        busiReqBO.setDelDraftIds(delDraftIds);
        busiReqBO.setDelPlanIds(delPlanIds);
        busiReqBO.setDelBankIds(delBankIds);
        busiReqBO.setDelReduceIds(delReduceIds);
        busiReqBO.setFscOrderPayItemBOS(null);
    }

    private void dealPaymentChange(FscFinanceDealPayAuditReqBO reqBO, FscFinanceDealPayAuditBusiReqBO busiReqBO) {
        FscFinanceCapitalPlanPO planQueryVo = new FscFinanceCapitalPlanPO();
        planQueryVo.setFscOrderId(reqBO.getOrderId());
        List releasePlanList = this.fscFinanceCapitalPlanMapper.getList(planQueryVo);
        if (reqBO.getPaymentType().equals(FscConstants.FinancePaymentType.INITIATIVE)) {
            FscFinanceBankStatementPO bankQueryVo = new FscFinanceBankStatementPO();
            bankQueryVo.setFscOrderId(reqBO.getOrderId());
            List bankExtIds = this.fscFinanceBankStatementMapper.getDistinctExtIds(bankQueryVo);
            busiReqBO.setBankExtIds(bankExtIds);
        } else {
            FscFinanceDraftInfoPO draftInfoQueryVo = new FscFinanceDraftInfoPO();
            draftInfoQueryVo.setFscOrderId(reqBO.getOrderId());
            List draftList = this.fscFinanceDraftInfoMapper.getDistinctExtIdList(draftInfoQueryVo);
            HashSet<String> draftExtIds = new HashSet<String>();
            HashSet<String> supplyExtIds = new HashSet<String>();
            for (FscFinanceDraftInfoPO draftInfoPO : draftList) {
                if (FscConstants.FinanceDraftType.RECEIVABLE_DRAFT.equals(draftInfoPO.getDraftType())) {
                    draftExtIds.add(draftInfoPO.getExtId());
                    continue;
                }
                supplyExtIds.add(draftInfoPO.getExtId());
            }
            busiReqBO.setDraftExtIds(draftExtIds);
            busiReqBO.setSupplyExtIds(supplyExtIds);
        }
        busiReqBO.setReleasePlanList(releasePlanList);
        busiReqBO.setIsChange(true);
    }

    private void qryTemp(FscFinanceDealPayAuditReqBO reqBO) {
        FscFinancePayTempQryAtomReqBO atomReqBO = new FscFinancePayTempQryAtomReqBO();
        atomReqBO.setTempId(reqBO.getTempId());
        atomReqBO.setFscOrderId(reqBO.getOrderId());
        atomReqBO.setPaymentType(reqBO.getPaymentType());
        FscFinancePayTempQryAtomRspBO atomRspBO = this.fscFinancePayTempQryAtomService.qryPayTemp(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u67e5\u8be2\u4ed8\u6b3e\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
        atomRspBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
            fscOrderPayItemBO.setObjectId(fscOrderPayItemBO.getOrderId());
            fscOrderPayItemBO.setPanelPointCode(fscOrderPayItemBO.getExt4());
            fscOrderPayItemBO.setPanelPointName(fscOrderPayItemBO.getExt5());
        });
        reqBO.setFscOrderPayItemBOS(atomRspBO.getFscOrderPayItemBOS());
    }
}

