/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyRefundPrePayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushUnifyRefundPrePayBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushUnifyRefundPrePayBillService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPushUnifyRefundPayBusiService;
import com.tydic.fsc.pay.busi.bo.FscPushUnifyRefundPayBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPushUnifyRefundPayBusiRspBO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.uoc.common.ability.api.PebExtUnifySettleEncryptionAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleDecryptionAbilityRspBO;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPushUnifyRefundPayBusiServiceImpl
implements FscPushUnifyRefundPayBusiService {
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPushUnifyRefundPrePayBillService fscPushUnifyRefundPrePayBillService;
    @Autowired
    private PebExtUnifySettleEncryptionAbilityService pebExtUnifySettleEncryptionAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u9000\u6b3e\u63a8\u9001\u7edf\u4e00\u7ed3\u7b97";

    @Override
    public FscPushUnifyRefundPayBusiRspBO dealPushUnifyRefundPay(FscPushUnifyRefundPayBusiReqBO reqBO) {
        FscPushUnifyRefundPayBusiRspBO rspBO = new FscPushUnifyRefundPayBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO.getPushUnifyStatus() != null && refundPO.getPushUnifyStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001!");
        }
        FscPurchasePushLogPo pushLogPo = this.buildPushLog(reqBO);
        FscPushUnifyRefundPrePayBillReqBO prePayBillReqBO = new FscPushUnifyRefundPrePayBillReqBO();
        prePayBillReqBO.setData(reqBO.getData());
        prePayBillReqBO.setToken(reqBO.getToken());
        FscPushUnifyRefundPrePayBillRspBO prePayBillRspBO = new FscPushUnifyRefundPrePayBillRspBO();
        prePayBillRspBO = FscConstants.FscPurchasePushType.REFUND_PRE_PAY.equals(reqBO.getPushType()) ? this.fscPushUnifyRefundPrePayBillService.pushRefundPrePay(prePayBillReqBO) : this.fscPushUnifyRefundPrePayBillService.pushRefundSelPay(prePayBillReqBO);
        pushLogPo.setRespParseData(prePayBillRspBO.getRspData());
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        if (prePayBillRspBO.getRespCode().equals("0000")) {
            updatePo.setPushUnifyStatus(FscConstants.FscPushStatus.SUCCESS);
            pushLogPo.setPushStatus(FscConstants.FscPushStatus.SUCCESS);
            PebExtUnifySettleDecryptionAbilityReqBO decryptionAbilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
            decryptionAbilityReqBO.setData(prePayBillRspBO.getData());
            PebExtUnifySettleDecryptionAbilityRspBO decryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(decryptionAbilityReqBO);
            if (decryptionAbilityRspBO.getRespCode().equals("0000")) {
                pushLogPo.setRespData(decryptionAbilityRspBO.getData());
                JSONObject object = JSONObject.parseObject((String)decryptionAbilityRspBO.getData());
                if (object.get((Object)"INST_ID") != null) {
                    updatePo.setInstanceId(object.get((Object)"INST_ID").toString());
                }
            }
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
            fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
            fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("startFlag", 2);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
            }
        } else {
            updatePo.setPushUnifyStatus(FscConstants.FscPushStatus.FAIL);
            updatePo.setUnifyFailReason(prePayBillRspBO.getMsg());
            PebExtUnifySettleDecryptionAbilityReqBO decryptionAbilityReqBO = new PebExtUnifySettleDecryptionAbilityReqBO();
            decryptionAbilityReqBO.setData(prePayBillRspBO.getMsg());
            PebExtUnifySettleDecryptionAbilityRspBO decryptionAbilityRspBO = this.pebExtUnifySettleEncryptionAbilityService.dealParamDecryption(decryptionAbilityReqBO);
            if (decryptionAbilityRspBO.getRespCode().equals("0000")) {
                pushLogPo.setRespData(decryptionAbilityRspBO.getData());
                pushLogPo.setPushStatus(FscConstants.FscPushStatus.FAIL);
                updatePo.setUnifyFailReason(decryptionAbilityRspBO.getData());
            }
        }
        this.fscPurchasePushLogMapper.insert(pushLogPo);
        this.fscOrderRefundMapper.updateById(updatePo);
        return rspBO;
    }

    private FscPurchasePushLogPo buildPushLog(FscPushUnifyRefundPayBusiReqBO reqBO) {
        FscPurchasePushLogPo pushLogPo = new FscPurchasePushLogPo();
        pushLogPo.setObjectId(reqBO.getRefundId());
        pushLogPo.setObjectNo(reqBO.getRefundNo());
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setType(reqBO.getPushType());
        if (!CollectionUtils.isEmpty(reqBO.getPrePayList())) {
            pushLogPo.setPushData(JSONObject.toJSONString(reqBO.getPrePayList()));
        } else if (!CollectionUtils.isEmpty(reqBO.getSelPayList())) {
            pushLogPo.setPushData(JSONObject.toJSONString(reqBO.getSelPayList()));
        }
        pushLogPo.setPushParseData(reqBO.getData());
        pushLogPo.setCreateTime(new Date());
        return pushLogPo;
    }
}

