/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinancePushPayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinancePushPayBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinancePushPayBillService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePushPayBillBusiService;
import com.tydic.fsc.pay.busi.bo.finance.FscFinancePushPayBillBusiReqBO;
import com.tydic.fsc.pay.busi.bo.finance.FscFinancePushPayBillBusiRspBO;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinancePushPayBillBusiServiceImpl
implements FscFinancePushPayBillBusiService {
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscFinancePushPayBillService fscFinancePushPayBillService;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;

    @Override
    public FscFinancePushPayBillBusiRspBO dealPushPayBill(FscFinancePushPayBillBusiReqBO reqBO) {
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (FscConstants.FscPushStatus.SUCCESS.equals(financePO.getPushFinanceStatus())) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        FscFinancePushPayBillReqBO payBillReqBO = new FscFinancePushPayBillReqBO();
        payBillReqBO.setReqData(reqBO.getReqData());
        payBillReqBO.setToken(reqBO.getToken());
        payBillReqBO.setShouldPayMethod(reqBO.getShouldPayMethod());
        FscFinancePushPayBillRspBO payBillRspBO = this.fscFinancePushPayBillService.dealPushPayBill(payBillReqBO);
        FscFinancePushPayBillBusiRspBO rspBO = new FscFinancePushPayBillBusiRspBO();
        FscOrderFinancePO updatePo = new FscOrderFinancePO();
        updatePo.setFscOrderId(reqBO.getFscOrderId());
        updatePo.setExtBillId(payBillRspBO.getExtBillId());
        updatePo.setExtBillNo(payBillRspBO.getExtBillNo());
        if ("0000".equals(payBillRspBO.getRespCode())) {
            this.fscOrderMapper.updateOrderStatusByFscOrderId(reqBO.getFscOrderId(), FscConstants.FscPayOrderState.PAYING);
            this.fscFinancePayItemMapper.updatePayStatusByFscOrderId(reqBO.getFscOrderId(), FscConstants.FscPayOrderState.PAYING);
            this.updateAccountChargeStatus(reqBO.getFscOrderId());
            updatePo.setPushFinanceStatus(FscConstants.FscPushStatus.SUCCESS);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            this.fscOrderMapper.updateOrderStatusByFscOrderId(reqBO.getFscOrderId(), FscConstants.FscPayOrderState.PUSH_FAIL);
            updatePo.setPushFinanceStatus(FscConstants.FscPushStatus.FAIL);
            updatePo.setPushFinanceRemark(payBillRspBO.getRespDesc());
            if (updatePo.getPushFinanceRemark().length() > 500) {
                updatePo.setPushFinanceRemark(updatePo.getPushFinanceRemark().substring(0, 500));
            }
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(payBillRspBO.getRespDesc());
        }
        FscBillDealPushLogAbilityReqBO abilityReqBO = new FscBillDealPushLogAbilityReqBO();
        abilityReqBO.setCreateTime(new Date());
        abilityReqBO.setType(FscConstants.FscPurchasePushType.PAY);
        abilityReqBO.setObjectId(reqBO.getFscOrderId());
        abilityReqBO.setObjectNo(reqBO.getOrderNo());
        abilityReqBO.setPushData(reqBO.getReqData().toJSONString());
        abilityReqBO.setPushStatus(updatePo.getPushFinanceStatus());
        abilityReqBO.setRespData(payBillRspBO.getRespStr());
        this.fscBillAddPushLogAbilityService.savePurchasePushLog(abilityReqBO);
        this.fscOrderFinanceMapper.updateById(updatePo);
        return rspBO;
    }

    @Override
    public FscFinancePushPayBillBusiRspBO updateFailLog(FscFinancePushPayBillBusiReqBO reqBO) {
        if (!StringUtils.isEmpty((String)reqBO.getFailRemark()) && reqBO.getFailRemark().length() > 500) {
            reqBO.setFailRemark(reqBO.getFailRemark().substring(0, 500));
        }
        this.fscOrderMapper.updateOrderStatusByFscOrderId(reqBO.getFscOrderId(), FscConstants.FscPayOrderState.PUSH_FAIL);
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        financePO.setPushFinanceStatus(FscConstants.FscPushStatus.FAIL);
        financePO.setUpdateTime(new Date());
        financePO.setPushFinanceRemark(reqBO.getFailRemark());
        this.fscOrderFinanceMapper.updateById(financePO);
        FscFinancePushPayBillBusiRspBO rspBO = new FscFinancePushPayBillBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateAccountChargeStatus(Long chargeId) {
        FscAccountChargePO updateFscAccountCharge = new FscAccountChargePO();
        updateFscAccountCharge.setChargeId(chargeId);
        updateFscAccountCharge.setAuditStatus(FscConstants.AuditStatus.PAY_IN);
        this.fscAccountChargeMapper.update(updateFscAccountCharge);
    }
}

