/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.config;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class OrderDelayTask
implements Delayed {
    private Long fscOrderId;
    private long delayTime;

    public OrderDelayTask(Long fscOrderId, long delayTime) {
        this.fscOrderId = fscOrderId;
        this.delayTime = System.currentTimeMillis() + delayTime;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.delayTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        return Long.compare(this.delayTime, ((OrderDelayTask)o).delayTime);
    }

    public Long getFscOrderId() {
        return this.fscOrderId;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public void setFscOrderId(Long fscOrderId) {
        this.fscOrderId = fscOrderId;
    }

    public void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderDelayTask)) {
            return false;
        }
        OrderDelayTask other = (OrderDelayTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$fscOrderId = this.getFscOrderId();
        Long other$fscOrderId = other.getFscOrderId();
        if (this$fscOrderId == null ? other$fscOrderId != null : !((Object)this$fscOrderId).equals(other$fscOrderId)) {
            return false;
        }
        return this.getDelayTime() == other.getDelayTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderDelayTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $fscOrderId = this.getFscOrderId();
        result = result * 59 + ($fscOrderId == null ? 43 : ((Object)$fscOrderId).hashCode());
        long $delayTime = this.getDelayTime();
        result = result * 59 + (int)($delayTime >>> 32 ^ $delayTime);
        return result;
    }

    public String toString() {
        return "OrderDelayTask(fscOrderId=" + this.getFscOrderId() + ", delayTime=" + this.getDelayTime() + ")";
    }
}

