/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemTempMapper;
import com.tydic.fsc.dao.FscFinancePayReduceTempMapper;
import com.tydic.fsc.dao.FscOrderPayItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscFinancePayItemTempAllCheckQryAbilityService;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceBankStatementTempDetailBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceCapitalPlanTempDetailBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceDraftInfoTempDetailBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllCheckQryReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempAllCheckQryRspBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayItemTempDetailBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayReduceTempDetailBO;
import com.tydic.fsc.pay.ability.bo.finance.FscOrderPayItemTempDetailBO;
import com.tydic.fsc.pay.ability.bo.finance.FscPayItemTempDetailBO;
import com.tydic.fsc.po.FscFinanceBankStatementTempPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanTempPO;
import com.tydic.fsc.po.FscFinanceDraftInfoTempPO;
import com.tydic.fsc.po.FscFinancePayItemTempPO;
import com.tydic.fsc.po.FscFinancePayReduceTempPO;
import com.tydic.fsc.po.FscOrderPayItemTempPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscFinancePayItemTempAllCheckQryAbilityService"})
public class FscFinancePayItemTempAllCheckQryAbilityServiceImpl
implements FscFinancePayItemTempAllCheckQryAbilityService {
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;
    @Autowired
    private FscFinancePayReduceTempMapper fscFinancePayReduceTempMapper;
    @Autowired
    private FscFinancePayItemTempMapper fscFinancePayItemTempMapper;
    @Autowired
    private FscOrderPayItemTempMapper fscOrderPayItemTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;

    @PostMapping(value={"qryFinancePayTempAllDetailCheck"})
    public FscFinancePayItemTempAllCheckQryRspBO qryFinancePayTempAllDetailCheck(@RequestBody FscFinancePayItemTempAllCheckQryReqBO reqBO) {
        this.valid(reqBO);
        FscFinancePayItemTempAllCheckQryRspBO rspBO = new FscFinancePayItemTempAllCheckQryRspBO();
        List<FscPayItemTempDetailBO> detailBOList = this.qryFinancePayTempAllDetail(reqBO);
        this.validData(reqBO, detailBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validData(FscFinancePayItemTempAllCheckQryReqBO reqBO, List<FscPayItemTempDetailBO> detailBOList) {
        if (CollectionUtils.isEmpty(detailBOList)) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u6570\u636e\u96c6\u5408[detailBOList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscPayItemTempDetailBO detailBO : detailBOList) {
            if (CollectionUtils.isEmpty((Collection)detailBO.getOrderPayItemList())) {
                throw new FscBusinessException("191000", "\u4ed8\u6b3e\u660e\u7ec6\u96c6\u5408[orderPayItemTempList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(detailBO.getTempId())) {
                throw new FscBusinessException("191000", "\u4e34\u65f6ID[tempId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (Objects.isNull(detailBO.getContractId())) {
                throw new FscBusinessException("191000", "\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            for (FscOrderPayItemTempDetailBO item : detailBO.getOrderPayItemList()) {
                if (!StringUtils.isEmpty((Object)item.getItemNo())) continue;
                throw new FscBusinessException("191000", "\u4ed8\u6b3e\u660e\u7ec6\u7684\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getFinancePayItemList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getFinancePayItemList()) {
                    FscFinanceDraftInfoTempDetailBO draftInfoTemp;
                    if (StringUtils.isEmpty((Object)item.getItemNo())) {
                        throw new FscBusinessException("191000", "\u4ed8\u6b3e\u884c\u53f7[itemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (Objects.nonNull(reqBO.getIsAudit()) && reqBO.getIsAudit() == 1 && Objects.equals(item.getFinancePayMethod(), "FKFS0001")) {
                        if (StringUtils.isEmpty((Object)item.getPayerAccountName())) {
                            throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u4ed8\u6b3e\u65b9\u8d26\u6237\u540d\u79f0\u672a\u586b\u5199\u5b8c\u6210\uff01");
                        }
                        if (StringUtils.isEmpty((Object)item.getPayerBankAccountNum())) {
                            throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u4ed8\u6b3e\u65b9\u94f6\u884c\u8d26\u53f7\u672a\u586b\u5199\u5b8c\u6210\uff01");
                        }
                    }
                    if (Objects.nonNull(reqBO.getIsAudit()) && reqBO.getIsAudit() == 1 && Objects.equals(item.getFinancePayMethod(), "FKFS0002")) {
                        if (CollectionUtils.isEmpty((Collection)detailBO.getFinanceDraftInfoList())) {
                            throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4e2d\u7684\u7968\u636e\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6210\uff01");
                        }
                        draftInfoTemp = detailBO.getFinanceDraftInfoList().stream().filter(arg_0 -> FscFinancePayItemTempAllCheckQryAbilityServiceImpl.lambda$validData$0((FscFinancePayItemTempDetailBO)item, arg_0)).findFirst().orElse(new FscFinanceDraftInfoTempDetailBO());
                        if (Objects.isNull(draftInfoTemp)) {
                            throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u7968\u636e\u660e\u7ec6\u672a\u586b\u5199\u5b8c\u6210\uff01");
                        }
                        if (StringUtils.isEmpty((Object)draftInfoTemp.getBillType())) {
                            throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u7968\u636e\u7c7b\u522b\u672a\u586b\u5199\u5b8c\u6210\uff01");
                        }
                    }
                    if (Objects.nonNull(reqBO.getIsAudit()) && reqBO.getIsAudit() == 1 && Objects.equals(item.getFinancePayMethod(), "FKFS0003")) {
                        if (StringUtils.isEmpty((Object)item.getPayerAccountName())) {
                            throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u4ed8\u6b3e\u65b9\u8d26\u6237\u540d\u79f0\u672a\u586b\u5199\u5b8c\u6210\uff01");
                        }
                        if (StringUtils.isEmpty((Object)item.getPayerBankAccountNum())) {
                            throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u4ed8\u6b3e\u65b9\u94f6\u884c\u8d26\u53f7\u672a\u586b\u5199\u5b8c\u6210\uff01");
                        }
                        if (StringUtils.isEmpty((Object)item.getAcceptBillTypeName())) {
                            throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u7968\u636e\u7c7b\u578b\u672a\u586b\u5199\u5b8c\u6210\uff01");
                        }
                        if (StringUtils.isEmpty((Object)item.getAcceptBillOpenName())) {
                            throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u7968\u636e\u5f00\u7acb\u65b9\u5f0f\u672a\u586b\u5199\u5b8c\u6210\uff01");
                        }
                        if (StringUtils.isEmpty((Object)item.getPledgeNo())) {
                            throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u8d28\u62bc\u7968\u53f7\u672a\u586b\u5199\u5b8c\u6210\uff01");
                        }
                    }
                    if (Objects.nonNull(reqBO.getIsAudit()) && reqBO.getIsAudit() == 1 && Objects.equals(item.getFinancePayMethod(), "FKFS0004") && StringUtils.isEmpty((Object)item.getFinancePlatformCode())) {
                        throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u4f9b\u5e94\u94fe\u91d1\u878d\u5e73\u53f0\u672a\u586b\u5199\u5b8c\u6210\uff01");
                    }
                    if (!Objects.nonNull(reqBO.getIsAudit()) || reqBO.getIsAudit() != 1 || !Objects.equals(item.getFinancePayMethod(), "FKFS0005")) continue;
                    if (CollectionUtils.isEmpty((Collection)detailBO.getFinanceDraftInfoList())) {
                        throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4e2d\u7684\u7968\u636e\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u6210\uff01");
                    }
                    draftInfoTemp = detailBO.getFinanceDraftInfoList().stream().filter(arg_0 -> FscFinancePayItemTempAllCheckQryAbilityServiceImpl.lambda$validData$1((FscFinancePayItemTempDetailBO)item, arg_0)).findFirst().orElse(new FscFinanceDraftInfoTempDetailBO());
                    if (!StringUtils.isEmpty((Object)draftInfoTemp.getPlatformCode())) continue;
                    throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u4ed8\u6b3e\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c[" + item.getItemNo() + "]\u7684\u4f9b\u5e94\u94fe\u91d1\u878d\u5e73\u53f0\u672a\u586b\u5199\u5b8c\u6210\uff01");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getPayReduceTempList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getPayReduceTempList()) {
                    if (!StringUtils.isEmpty((Object)item.getItemNo())) continue;
                    throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u6838\u51cf\u4fe1\u606f\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c\u672a\u586b\u5199\u5b8c\u6210\uff01");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getCapitalPlanTempList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getCapitalPlanTempList()) {
                }
            }
            if (!CollectionUtils.isEmpty((Collection)detailBO.getFinanceBankStatementList())) {
                for (FscOrderPayItemTempDetailBO item : detailBO.getFinanceBankStatementList()) {
                    if (!Objects.isNull(item.getItemNo())) continue;
                    throw new FscBusinessException("191000", "\u5408\u540c\u7f16\u53f7\u4e3a[" + detailBO.getContractNo() + "]\u94f6\u884c\u6d41\u6c34\u4e2d\u4ed8\u6b3e\u660e\u7ec6\u884c\u672a\u586b\u5199\u5b8c\u6210\uff01");
                }
            }
            if (CollectionUtils.isEmpty((Collection)detailBO.getFinanceDraftInfoList())) continue;
            for (FscOrderPayItemTempDetailBO item : detailBO.getFinanceDraftInfoList()) {
                if (!Objects.isNull(item.getPayItemNo())) continue;
                throw new FscBusinessException("191000", "\u5165\u53c2\u4ed8\u6b3e\u660e\u7ec6\u884c\u53f7[payItemNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    private List<FscPayItemTempDetailBO> qryFinancePayTempAllDetail(FscFinancePayItemTempAllCheckQryReqBO reqBO) {
        ArrayList<FscPayItemTempDetailBO> resultList = new ArrayList<FscPayItemTempDetailBO>();
        Long tempId = reqBO.getTempId();
        List contractIds = reqBO.getContractIds();
        FscFinanceBankStatementTempPO fscFinanceBankStatementTempPO = new FscFinanceBankStatementTempPO();
        fscFinanceBankStatementTempPO.setTempId(tempId);
        fscFinanceBankStatementTempPO.setContractIds(contractIds);
        fscFinanceBankStatementTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List bankStatementTempList = this.fscFinanceBankStatementTempMapper.getList(fscFinanceBankStatementTempPO);
        List financeBankStatementList = JSON.parseArray((String)JSON.toJSONString((Object)bankStatementTempList), FscFinanceBankStatementTempDetailBO.class);
        FscOrderPayItemTempPO fscOrderPayItemTempPO = new FscOrderPayItemTempPO();
        fscOrderPayItemTempPO.setTempId(tempId);
        fscOrderPayItemTempPO.setContractIds(contractIds);
        fscOrderPayItemTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List orderPayItemTempList = this.fscOrderPayItemTempMapper.getList(fscOrderPayItemTempPO);
        List orderPayItemList = JSON.parseArray((String)JSON.toJSONString((Object)orderPayItemTempList), FscOrderPayItemTempDetailBO.class);
        FscFinancePayItemTempPO fscFinancePayItemTempPO = new FscFinancePayItemTempPO();
        fscFinancePayItemTempPO.setTempId(tempId);
        fscFinancePayItemTempPO.setContractIds(contractIds);
        fscFinancePayItemTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List payItemTempList = this.fscFinancePayItemTempMapper.getList(fscFinancePayItemTempPO);
        List financePayItemList = JSON.parseArray((String)JSON.toJSONString((Object)payItemTempList), FscFinancePayItemTempDetailBO.class);
        FscFinancePayReduceTempPO fscFinancePayReduceTempPO = new FscFinancePayReduceTempPO();
        fscFinancePayReduceTempPO.setTempId(tempId);
        fscFinancePayReduceTempPO.setContractIds(contractIds);
        fscFinancePayReduceTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List payReduceTempPOList = this.fscFinancePayReduceTempMapper.getList(fscFinancePayReduceTempPO);
        List payReduceTempList = JSON.parseArray((String)JSON.toJSONString((Object)payReduceTempPOList), FscFinancePayReduceTempDetailBO.class);
        FscFinanceCapitalPlanTempPO fscFinanceCapitalPlanTempPO = new FscFinanceCapitalPlanTempPO();
        fscFinanceCapitalPlanTempPO.setTempId(tempId);
        fscFinanceCapitalPlanTempPO.setContractIds(contractIds);
        fscFinanceCapitalPlanTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List capitalPlanTempPOList = this.fscFinanceCapitalPlanTempMapper.getList(fscFinanceCapitalPlanTempPO);
        List capitalPlanTempList = JSON.parseArray((String)JSON.toJSONString((Object)capitalPlanTempPOList), FscFinanceCapitalPlanTempDetailBO.class);
        FscFinanceDraftInfoTempPO fscFinanceDraftInfoTempPO = new FscFinanceDraftInfoTempPO();
        fscFinanceDraftInfoTempPO.setTempId(tempId);
        fscFinanceDraftInfoTempPO.setContractIds(contractIds);
        fscFinanceDraftInfoTempPO.setDelFlag(FscConstants.DicDelFlag.NO);
        List draftInfoTempPOList = this.fscFinanceDraftInfoTempMapper.getList(fscFinanceDraftInfoTempPO);
        List financeDraftInfoList = JSON.parseArray((String)JSON.toJSONString((Object)draftInfoTempPOList), FscFinanceDraftInfoTempDetailBO.class);
        for (Long contractId : reqBO.getContractIds()) {
            FscPayItemTempDetailBO detailBO = new FscPayItemTempDetailBO();
            detailBO.setTempId(tempId);
            detailBO.setContractId(contractId);
            if (!CollectionUtils.isEmpty((Collection)financeBankStatementList)) {
                List bankStatementTempDetailBOList = financeBankStatementList.stream().filter(bankStatement -> Objects.equals(bankStatement.getContractId(), contractId)).collect(Collectors.toList());
                detailBO.setFinanceBankStatementList(bankStatementTempDetailBOList);
            }
            if (!CollectionUtils.isEmpty((Collection)orderPayItemList)) {
                List orderPayItemTempDetailBOList = orderPayItemList.stream().filter(orderPayItem -> Objects.equals(orderPayItem.getContractId(), contractId)).collect(Collectors.toList());
                detailBO.setOrderPayItemList(orderPayItemTempDetailBOList);
            }
            if (!CollectionUtils.isEmpty((Collection)financePayItemList)) {
                List financePayItemTempDetailBOList = financePayItemList.stream().filter(financePayItem -> Objects.equals(financePayItem.getContractId(), contractId)).collect(Collectors.toList());
                detailBO.setFinancePayItemList(financePayItemTempDetailBOList);
            }
            if (!CollectionUtils.isEmpty((Collection)payReduceTempList)) {
                List payReduceTempDetailBOList = payReduceTempList.stream().filter(payReduce -> Objects.equals(payReduce.getContractId(), contractId)).collect(Collectors.toList());
                detailBO.setPayReduceTempList(payReduceTempDetailBOList);
            }
            if (!CollectionUtils.isEmpty((Collection)capitalPlanTempList)) {
                List capitalPlanTempDetailBOList = capitalPlanTempList.stream().filter(capitalPlan -> Objects.equals(capitalPlan.getContractId(), contractId)).collect(Collectors.toList());
                detailBO.setCapitalPlanTempList(capitalPlanTempDetailBOList);
            }
            if (!CollectionUtils.isEmpty((Collection)financeDraftInfoList)) {
                List financeDraftInfoTempDetailBOList = financeDraftInfoList.stream().filter(draftInfo -> Objects.equals(draftInfo.getContractId(), contractId)).collect(Collectors.toList());
                detailBO.setFinanceDraftInfoList(financeDraftInfoTempDetailBOList);
            }
            resultList.add(detailBO);
        }
        return resultList;
    }

    private void valid(FscFinancePayItemTempAllCheckQryReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getContractIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID\u96c6\u5408[contractIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTempId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6\u6570\u636e\u8be6\u60c5\u4e34\u65f6\u7f16\u53f7[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private static /* synthetic */ boolean lambda$validData$1(FscFinancePayItemTempDetailBO item, FscFinanceDraftInfoTempDetailBO d) {
        return Objects.equals(item.getPayItemNo(), d.getPayItemNo());
    }

    private static /* synthetic */ boolean lambda$validData$0(FscFinancePayItemTempDetailBO item, FscFinanceDraftInfoTempDetailBO d) {
        return Objects.equals(item.getPayItemNo(), d.getPayItemNo());
    }
}

