/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOverduePayItemMapper;
import com.tydic.fsc.dao.FscOverduePenaltyMapper;
import com.tydic.fsc.dao.FscPenaltyOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscPenaltyOrderStatusEnum;
import com.tydic.fsc.enums.FscReliefOverPenaltyAuditResultEnum;
import com.tydic.fsc.enums.FscReliefOverPenaltyStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscCancelOverduePenaltyAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscCancelOverduePenaltyAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscAuditOverduePenaltyBusiService;
import com.tydic.fsc.pay.busi.bo.FscAuditOverduePenaltyBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscAuditOverduePenaltyBusiRspBO;
import com.tydic.fsc.po.FscOverduePayItemPO;
import com.tydic.fsc.po.FscOverduePenaltyPO;
import com.tydic.fsc.po.FscPenaltyOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAuditOverduePenaltyBusiServiceImpl
implements FscAuditOverduePenaltyBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAuditOverduePenaltyBusiServiceImpl.class);
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOverduePenaltyMapper fscOverduePenaltyMapper;
    @Autowired
    private FscPenaltyOrderMapper fscPenaltyOrderMapper;
    @Autowired
    private FscOverduePayItemMapper fscOverduePayItemMapper;

    @Override
    public FscAuditOverduePenaltyBusiRspBO dealAuditOverduePenalty(FscAuditOverduePenaltyBusiReqBO reqBO) {
        log.info("\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u5ba1\u6838busi\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)((Object)reqBO)));
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getOverduePenaltyIdList())) {
            throw new FscBusinessException("191000", "\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscAuditOverduePenaltyBusiRspBO rspBO = new FscAuditOverduePenaltyBusiRspBO();
        Integer auditResult = reqBO.getAuditResult();
        List<Long> overduePenaltyIdList = reqBO.getOverduePenaltyIdList();
        FscOverduePenaltyPO po = new FscOverduePenaltyPO();
        po.setOverduePenaltyIds(overduePenaltyIdList);
        po.setStatus(FscReliefOverPenaltyStatusEnum.AUDITED.getCode());
        if (FscReliefOverPenaltyAuditResultEnum.YES.getCode().equals(auditResult)) {
            po.setAuditResult(FscReliefOverPenaltyAuditResultEnum.YES.getCode());
        } else {
            po.setAuditResult(FscReliefOverPenaltyAuditResultEnum.NO.getCode());
        }
        po.setAuditMsg(reqBO.getAuditMsg());
        po.setAuditTime(new Date());
        po.setAuditUserId(reqBO.getUserId());
        po.setAuditUserName(reqBO.getName());
        this.fscOverduePenaltyMapper.updateByCondition(po);
        List fscShouldPayPOS = this.fscShouldPayMapper.getListByOverduePenaltyId(overduePenaltyIdList);
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOS)) {
            throw new FscBusinessException("198888", "\u5e94\u4ed8\u5355\u4e3a\u7a7a\uff0c\u5ba1\u6838\u5931\u8d25");
        }
        ArrayList shouldPayIds = new ArrayList();
        fscShouldPayPOS.forEach(fscShouldPayPO -> {
            if (!FscConstants.ShouldPayType.OVERDUE_PENALTY_PAY.equals(fscShouldPayPO.getShouldPayType())) {
                throw new FscBusinessException("198888", "\u5e94\u4ed8\u7c7b\u578b\u4e0d\u4e3a\u903e\u671f\u5e94\u4ed8\uff0c\u8bf7\u786e\u8ba4\u540e\u63d0\u4ea4");
            }
            if (!FscConstants.ShouldPayStatus.TO_RELIEF.equals(fscShouldPayPO.getShouldPayStatus())) {
                throw new FscBusinessException("198888", "\u5e94\u4ed8\u72b6\u6001\u4e0d\u4e3a\u5f85\u51cf\u514d\uff0c\u8bf7\u786e\u8ba4\u540e\u63d0\u4ea4");
            }
            shouldPayIds.add(fscShouldPayPO.getShouldPayId());
        });
        FscShouldPayPO fscShouldPayPO2 = new FscShouldPayPO();
        fscShouldPayPO2.setShouldPayIds(shouldPayIds);
        if (FscReliefOverPenaltyAuditResultEnum.YES.getCode().equals(auditResult)) {
            fscShouldPayPO2.setShouldPayStatus(FscConstants.ShouldPayStatus.PAY_TERMINAL);
        } else {
            fscShouldPayPO2.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
        }
        this.fscShouldPayMapper.updateById(fscShouldPayPO2);
        List fscPenaltyOrderList = this.fscPenaltyOrderMapper.getListByOverduePenaltyId(overduePenaltyIdList);
        if (CollectionUtils.isEmpty((Collection)fscPenaltyOrderList)) {
            throw new FscBusinessException("198888", "\u903e\u671f\u8fdd\u7ea6\u91d1\u5355\u636e\u4e3a\u7a7a\uff0c\u5ba1\u6838\u5931\u8d25");
        }
        ArrayList penaltyOrderIds = new ArrayList();
        fscPenaltyOrderList.forEach(fscPenaltyOrder -> {
            if (!FscPenaltyOrderStatusEnum.TO_RELIEF.getCode().equals(fscPenaltyOrder.getStatus())) {
                throw new FscBusinessException("198888", "\u903e\u671f\u8fdd\u7ea6\u91d1\u5355\u636e\u72b6\u6001\u9519\u8bef");
            }
            penaltyOrderIds.add(fscPenaltyOrder.getFscPenaltyOrderId());
        });
        FscPenaltyOrderPO penaltyOrderPO = new FscPenaltyOrderPO();
        penaltyOrderPO.setFscPenaltyOrderIds(penaltyOrderIds);
        if (FscReliefOverPenaltyAuditResultEnum.YES.getCode().equals(auditResult)) {
            penaltyOrderPO.setStatus(FscPenaltyOrderStatusEnum.RELIEFED.getCode());
        } else {
            penaltyOrderPO.setStatus(FscPenaltyOrderStatusEnum.TO_PAY.getCode());
        }
        this.fscPenaltyOrderMapper.updateByContion(penaltyOrderPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public FscCancelOverduePenaltyAbilityRspBO dealCancelOverduePenalty(FscCancelOverduePenaltyAbilityReqBO reqBO) {
        log.info("\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u53d6\u6d88busi\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOverduePenaltyIdList())) {
            throw new FscBusinessException("191000", "\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscCancelOverduePenaltyAbilityRspBO rspBO = new FscCancelOverduePenaltyAbilityRspBO();
        List overduePenaltyIdList = reqBO.getOverduePenaltyIdList();
        FscOverduePenaltyPO po = new FscOverduePenaltyPO();
        po.setOverduePenaltyIds(overduePenaltyIdList);
        po.setStatus(FscReliefOverPenaltyStatusEnum.CANCEL.getCode());
        this.fscOverduePenaltyMapper.updateByCondition(po);
        FscOverduePayItemPO payItemPO = new FscOverduePayItemPO();
        payItemPO.setOverduePenatlyIds(overduePenaltyIdList);
        payItemPO.setItemStatus(Integer.valueOf(1));
        List payItems = this.fscOverduePayItemMapper.getListByCondition(payItemPO);
        if (CollectionUtils.isEmpty((Collection)payItems)) {
            throw new FscBusinessException("191000", "\u7533\u8bf7\u5355\u5173\u7cfb\u8868\u4e3a\u7a7a");
        }
        ArrayList shouldPayIds = new ArrayList();
        payItems.forEach(fscOverduePayItem -> shouldPayIds.add(fscOverduePayItem.getShouldPayId()));
        FscOverduePayItemPO itemPO = new FscOverduePayItemPO();
        itemPO.setOverduePenatlyIds(overduePenaltyIdList);
        itemPO.setItemStatus(Integer.valueOf(0));
        this.fscOverduePayItemMapper.updateByCondition(itemPO);
        FscShouldPayPO shouldPayPO = new FscShouldPayPO();
        shouldPayPO.setShouldPayIds(shouldPayIds);
        shouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
        this.fscShouldPayMapper.updateById(shouldPayPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

