/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscPayBillReqReturnReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillReqReturnRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillReturnBusiService;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscPayRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscPayBillReturnBusiServiceImpl
implements FscPayBillReturnBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillReturnBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;

    @Override
    public FscPayBillReqReturnRspBO dealPayBillCreateAndPay(FscPayBillReqReturnReqBO abilityReqBO) {
        FscPayBillReqReturnRspBO rspBO = new FscPayBillReqReturnRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setShouldPayId(abilityReqBO.getShouldPayId());
        fscShouldPayPO = this.fscShouldPayMapper.getModelBy(fscShouldPayPO);
        if (fscShouldPayPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5e94\u4ed8\u5355");
        }
        FscOrderPayItemPO payItemPO = new FscOrderPayItemPO();
        payItemPO.setShouldPayId(abilityReqBO.getShouldPayId());
        payItemPO = this.fscOrderPayItemMapper.getModelBy(payItemPO);
        if (payItemPO == null) {
            FscShouldPayPO update = new FscShouldPayPO();
            update.setShouldPayId(abilityReqBO.getShouldPayId());
            update.setShouldPayStatus(FscConstants.ShouldPayStatus.PAY_TERMINAL);
            this.fscShouldPayMapper.updateById(update);
            return rspBO;
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(payItemPO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            return rspBO;
        }
        if (orderPO.getOrderState().equals(FscConstants.FscPayOrderState.PAIED_TO_COMFIR)) {
            throw new FscBusinessException("198888", "\u652f\u4ed8\u786e\u8ba4\u4e2d\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u5904\u7406\u540e\u518d\u9000\u6b3e");
        }
        if (orderPO.getOrderState().equals(FscConstants.FscPayOrderState.PAIED)) {
            if (fscShouldPayPO.getPaidAmount().subtract(fscShouldPayPO.getReturnAmount()).compareTo(abilityReqBO.getFee()) < 0) {
                throw new FscBusinessException("198888", "\u652f\u4ed8\u91d1\u989d" + fscShouldPayPO.getPaidAmount() + "\u5c0f\u4e8e\u4ed8\u6b3e\u91d1\u989d" + fscShouldPayPO.getReturnAmount().add(abilityReqBO.getFee()));
            }
            Long fscOrderId = Sequence.getInstance().nextId();
            rspBO.setFscOrderId(fscOrderId);
            this.saveFsc(fscOrderId, orderPO, fscShouldPayPO, abilityReqBO);
            FscShouldPayPO update = new FscShouldPayPO();
            update.setShouldPayId(abilityReqBO.getShouldPayId());
            update.setReturnAmount(abilityReqBO.getFee());
            this.fscShouldPayMapper.updateReturnAmount(update);
            FscOrderPO updateOrder = new FscOrderPO();
            updateOrder.setFscOrderId(payItemPO.getFscOrderId());
            updateOrder.setReturnAmount(abilityReqBO.getFee());
            this.fscOrderMapper.updateReturnAmount(updateOrder);
            this.returnPay(orderPO, abilityReqBO, fscOrderId);
        } else {
            FscShouldPayPO update = new FscShouldPayPO();
            update.setShouldPayId(abilityReqBO.getShouldPayId());
            update.setShouldPayStatus(FscConstants.ShouldPayStatus.PAY_TERMINAL);
            this.fscShouldPayMapper.updateById(update);
            FscOrderPO updateOrder = new FscOrderPO();
            updateOrder.setFscOrderId(payItemPO.getFscOrderId());
            updateOrder.setOrderState(FscConstants.FscPayOrderState.CANCEL);
            this.fscOrderMapper.updateById(updateOrder);
        }
        return rspBO;
    }

    private void returnPay(FscOrderPO orderPO, FscPayBillReqReturnReqBO reqBO, Long fscOrderId) {
        if ("3".equals(orderPO.getPayChannel())) {
            return;
        }
        FscPayRelationPO relationPO = new FscPayRelationPO();
        relationPO.setFscOrderId(orderPO.getFscOrderId());
        relationPO = this.fscPayRelationMapper.getModelBy(relationPO);
        if (relationPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u7684\u5916\u90e8\u6d41\u6c34\u53f7");
        }
        PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
        payProRefundAbilityReqBo.setRefundOutOrderId(fscOrderId.toString());
        payProRefundAbilityReqBo.setOriOutOrderId(relationPO.getPayOrderId().toString());
        payProRefundAbilityReqBo.setBusiCode(this.payBusiCode);
        BigDecimal refundAmtB = reqBO.getFee().multiply(new BigDecimal(100));
        payProRefundAbilityReqBo.setRefundFee(refundAmtB.setScale(0, 5).abs().toString());
        payProRefundAbilityReqBo.setCreateOperId(String.valueOf(reqBO.getCreateId()));
        payProRefundAbilityReqBo.setCreateOperIdName(reqBO.getCreateName());
        payProRefundAbilityReqBo.setOrderType("06");
        log.error("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
        if (!"0000".equals(payProRefundAbilityRspBo.getRespCode())) {
            throw new FscBusinessException("198888", "\u9000\u6b3e\u652f\u4ed8\u4e2d\u5fc3\u62a5\u9519\uff1a" + payProRefundAbilityRspBo.getResultMsg() + payProRefundAbilityRspBo.getRespDesc());
        }
        log.error("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    private void saveFsc(Long fscOrderId, FscOrderPO orderPO, FscShouldPayPO fscShouldPayPO, FscPayBillReqReturnReqBO reqBO) {
        FscShouldPayPO payPO = new FscShouldPayPO();
        BeanUtils.copyProperties((Object)fscShouldPayPO, (Object)payPO);
        payPO.setPaidAmount(reqBO.getFee().negate());
        payPO.setShouldPayId(Long.valueOf(Sequence.getInstance().nextId()));
        payPO.setShouldPayAmount(reqBO.getFee().negate());
        payPO.setPayAmount(BigDecimal.ZERO);
        payPO.setPayingAmount(BigDecimal.ZERO);
        payPO.setReturnAmount(BigDecimal.ZERO);
        payPO.setToPayAmount(BigDecimal.ZERO);
        payPO.setCreateAccount(reqBO.getCreateAccount());
        payPO.setCreateCompanyId(reqBO.getCreateCompanyId());
        payPO.setCreateCompanyName(reqBO.getCreateCompanyName());
        payPO.setCreateId(reqBO.getCreateId());
        payPO.setCreateName(reqBO.getCreateName());
        payPO.setCreateOrgId(reqBO.getCreateOrgId());
        payPO.setCreateTime(new Date());
        payPO.setShouldPayStatus(FscConstants.ShouldPayStatus.PAYED);
        FscOrderPO po = new FscOrderPO();
        BeanUtils.copyProperties((Object)orderPO, (Object)po);
        po.setFscOrderId(fscOrderId);
        po.setOrderState(FscConstants.FscPayOrderState.PAIED);
        po.setBusiCategory(Integer.valueOf(1));
        po.setActualAmount(reqBO.getFee().negate());
        po.setClaimAmount(BigDecimal.ZERO);
        po.setCreditAmount(BigDecimal.ZERO);
        po.setPaidAmount(reqBO.getFee().negate());
        po.setPayingAmount(BigDecimal.ZERO);
        po.setReturnAmount(BigDecimal.ZERO);
        po.setToPayAmount(BigDecimal.ZERO);
        po.setWriteOffAmount(BigDecimal.ZERO);
        po.setCreateCompanyId(reqBO.getCreateCompanyId());
        po.setCreateCompanyName(reqBO.getCreateCompanyName());
        po.setCreateOperId(reqBO.getCreateId());
        po.setCreateOperName(reqBO.getCreateName());
        po.setCreateOrgId(reqBO.getCreateOrgId());
        po.setCreateTime(new Date());
        this.fscOrderMapper.insert(po);
        this.fscShouldPayMapper.insert(payPO);
        FscOrderPayItemPO payItemPO = new FscOrderPayItemPO();
        payItemPO.setShouldPayId(payPO.getShouldPayId());
        payItemPO.setFscOrderId(po.getFscOrderId());
        payItemPO.setPayAmount(reqBO.getFee().negate());
        payItemPO.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
        this.fscOrderPayItemMapper.insert(payItemPO);
    }
}

