/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillOrderSettleCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSettleCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSettleCheckAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscShouldPayAccordingToOrderBusiService;
import com.tydic.fsc.pay.busi.bo.FscShouldPayAccordingToOrderBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscShouldPayAccordingToOrderBusiRspBO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uoc.common.ability.api.PebExtOrderForFscPayChangeAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderForFscPayChangeAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderForFscPayChangeAbilityRspBO;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscShouldPayAccordingToOrderBusiServiceImpl
implements FscShouldPayAccordingToOrderBusiService {
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscBillOrderSettleCheckAbilityService fscBillOrderSettleCheckAbilityService;
    @Autowired
    private PebExtOrderForFscPayChangeAbilityService pebExtOrderForFscPayChangeAbilityService;

    @Override
    public FscShouldPayAccordingToOrderBusiRspBO dealShouldPayAccordingToOrder(FscShouldPayAccordingToOrderBusiReqBO reqBO) {
        if (reqBO.getShouldPayId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[shouldPayId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscShouldPayPO shouldPayPo = new FscShouldPayPO();
        shouldPayPo.setShouldPayId(reqBO.getShouldPayId());
        shouldPayPo = this.fscShouldPayMapper.getModelBy(shouldPayPo);
        if (shouldPayPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (!shouldPayPo.getShouldPayStatus().equals(FscConstants.ShouldPayStatus.TO_PAY) || shouldPayPo.getPayingAmount().compareTo(BigDecimal.ZERO) != 0) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5e94\u4ed8\u5355\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001\uff01");
        }
        Integer userType = -1;
        userType = shouldPayPo.getPayeeId().equals(this.operationOrgId) ? Integer.valueOf(1) : Integer.valueOf(2);
        if (shouldPayPo.getTradeMode() != null && shouldPayPo.getTradeMode().equals(FscConstants.FscTradeMode.MATCHMAKING_MODE)) {
            userType = 1;
        }
        FscBillOrderSettleCheckAbilityReqBO abilityReqBO = new FscBillOrderSettleCheckAbilityReqBO();
        abilityReqBO.setOrderIds(Collections.singletonList(shouldPayPo.getOrderId()));
        abilityReqBO.setSettleType(FscConstants.SettleType.ORDER);
        abilityReqBO.setUserType(userType);
        FscBillOrderSettleCheckAbilityRspBO abilityRspBO = this.fscBillOrderSettleCheckAbilityService.dealOrderSettleCheck(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
        FscShouldPayPO updatePayPo = new FscShouldPayPO();
        updatePayPo.setShouldPayStatus(FscConstants.ShouldPayStatus.DEL);
        updatePayPo.setPayeeId(shouldPayPo.getPayeeId());
        updatePayPo.setOrderId(shouldPayPo.getOrderId());
        updatePayPo.setShouldPayTypeNot(FscConstants.ShouldPayType.PAYMENT_GRADING_PAY);
        this.fscShouldPayMapper.updateOrderPayStatus(updatePayPo);
        PebExtOrderForFscPayChangeAbilityReqBO pebExtOrderForFscPayChangeAbilityReqBO = new PebExtOrderForFscPayChangeAbilityReqBO();
        pebExtOrderForFscPayChangeAbilityReqBO.setOrderId(shouldPayPo.getOrderId());
        pebExtOrderForFscPayChangeAbilityReqBO.setUserType(userType);
        pebExtOrderForFscPayChangeAbilityReqBO.setPayType(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE);
        PebExtOrderForFscPayChangeAbilityRspBO pebExtOrderForFscPayChangeAbilityRspBO = this.pebExtOrderForFscPayChangeAbilityService.dealFscPrePayChange(pebExtOrderForFscPayChangeAbilityReqBO);
        if (!pebExtOrderForFscPayChangeAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(pebExtOrderForFscPayChangeAbilityRspBO.getRespCode(), "\u4fee\u6539\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f\u5931\u8d25\uff1a" + pebExtOrderForFscPayChangeAbilityRspBO.getRespDesc());
        }
        return new FscShouldPayAccordingToOrderBusiRspBO();
    }

    private void dealShouldPayCreate(FscShouldPayPO shouldPayPo, BigDecimal orderAmt) {
        shouldPayPo.setShouldPayId(Long.valueOf(Sequence.getInstance().nextId()));
        shouldPayPo.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_GRADING_PAY);
        shouldPayPo.setShouldPayAmount(orderAmt);
        List serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)shouldPayPo.getShouldPayType()) == null) {
            throw new FscBusinessException("194311", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)shouldPayPo.getShouldPayType()).getDescr());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        shouldPayPo.setToPayAmount(orderAmt);
        shouldPayPo.setOriginalAmount(orderAmt);
        shouldPayPo.setShouldPayNo((String)serialNoList.get(0));
        this.fscShouldPayMapper.insert(shouldPayPo);
    }
}

