/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.tydic.fsc.dao.FscAttachmentTempMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementTempMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanTempMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoTempMapper;
import com.tydic.fsc.dao.FscFinancePayItemTempMapper;
import com.tydic.fsc.dao.FscFinancePayReduceTempMapper;
import com.tydic.fsc.dao.FscOrderPayItemTempMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayTempDeleteReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePayTempDeleteRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePayTempDeleteBusiService;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinancePayTempDeleteBusiServiceImpl
implements FscFinancePayTempDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayTempDeleteBusiServiceImpl.class);
    @Autowired
    private FscOrderPayItemTempMapper fscOrderPayItemTempMapper;
    @Autowired
    private FscFinancePayItemTempMapper fscFinancePayItemTempMapper;
    @Autowired
    private FscFinancePayReduceTempMapper fscFinancePayReduceTempMapper;
    @Autowired
    private FscFinanceCapitalPlanTempMapper fscFinanceCapitalPlanTempMapper;
    @Autowired
    private FscFinanceBankStatementTempMapper fscFinanceBankStatementTempMapper;
    @Autowired
    private FscFinanceDraftInfoTempMapper fscFinanceDraftInfoTempMapper;
    @Autowired
    private FscAttachmentTempMapper fscAttachmentTempMapper;

    @Override
    public FscFinancePayTempDeleteRspBO dealFinancePayTempDelete(FscFinancePayTempDeleteReqBO reqBo) {
        this.valid(reqBo);
        FscFinancePayTempDeleteRspBO rspBO = new FscFinancePayTempDeleteRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        int orderPayResult = this.fscOrderPayItemTempMapper.deleteBatchByTempId(reqBo.getTempIdList(), reqBo.getContractId());
        if (orderPayResult != reqBo.getTempIdList().size() || orderPayResult < 1) {
            return rspBO;
        }
        this.fscFinancePayItemTempMapper.deleteBatchByTempId(reqBo.getTempIdList(), reqBo.getContractId());
        this.fscFinancePayReduceTempMapper.deleteBatchByTempId(reqBo.getTempIdList(), reqBo.getContractId());
        this.fscFinanceCapitalPlanTempMapper.deleteBatchByTempId(reqBo.getTempIdList(), reqBo.getContractId());
        this.fscFinanceBankStatementTempMapper.deleteBatchByTempId(reqBo.getTempIdList(), reqBo.getContractId());
        this.fscFinanceDraftInfoTempMapper.deleteBatchByTempId(reqBo.getTempIdList(), reqBo.getContractId());
        this.fscAttachmentTempMapper.deleteBatchByTempId(reqBo.getTempIdList(), reqBo.getContractId());
        return rspBO;
    }

    private void valid(FscFinancePayTempDeleteReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getTempIdList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e34\u65f6ID\u96c6\u5408[tempIdList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getContractId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5408\u540cID[contractId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

