/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscPayCallbackContentBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscRecvClaimConfirmAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMemPayInfoMapper;
import com.tydic.fsc.dao.FscPayIntfLogMapper;
import com.tydic.fsc.pay.ability.api.FscPayBillCallbackAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillCallbackAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillCallbackAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCallbackBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiRspBO;
import com.tydic.fsc.po.FscMemPayInfoPO;
import com.tydic.fsc.po.FscPayIntfLogPO;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import com.tydic.umc.general.ability.api.UmcMemberFeePushAbilityService;
import com.tydic.umc.general.ability.bo.UmcMemberFeePushAbilityRspBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillCallbackAbilityService"})
public class FscPayBillCallbackAbilityServiceImpl
implements FscPayBillCallbackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCallbackAbilityServiceImpl.class);
    @Value(value="${payPublicKey}")
    private String payPublicKey;
    @Autowired
    private FscPayBillCallbackBusiService fscPayBillCallbackBusiService;
    @Autowired
    private FscPayIntfLogMapper fscPayIntfLogMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Value(value="${payCallBackFail:}")
    private String payCallBackFailFlag;
    @Autowired
    private FscRecvClaimConfirmAbilityService fscRecvClaimConfirmAbilityService;
    @Autowired
    private FscMemPayInfoMapper fscMemPayInfoMapper;
    @Autowired
    private UmcMemberFeePushAbilityService umcMemberFeePushAbilityService;

    @PostMapping(value={"dealPayBillCallback"})
    public FscPayBillCallbackAbilityRspBO dealPayBillCallback(@RequestBody FscPayBillCallbackAbilityReqBO abilityReqBO) {
        FscPayCallbackContentBO fscPayCallbackContentBO = new FscPayCallbackContentBO();
        if (abilityReqBO.getOutOrderId() != null) {
            fscPayCallbackContentBO = new FscPayCallbackContentBO();
            fscPayCallbackContentBO.setOutOrderId(abilityReqBO.getOutOrderId().toString());
        } else if (abilityReqBO.getFscPayCallbackContentBO() == null) {
            String content = PayCenterUtils.deCode((String)abilityReqBO.getContent(), (String)this.payPublicKey);
            log.info("\u652f\u4ed8\u56de\u8c03\u52a0\u5bc6\u4e32\u89e3\u7801\u540estring\uff1a" + content);
            fscPayCallbackContentBO = (FscPayCallbackContentBO)JSON.parseObject((String)content, FscPayCallbackContentBO.class);
            if ("payCallBackFailFlag".equals(this.payCallBackFailFlag)) {
                fscPayCallbackContentBO.setResultCode("FAIL");
                log.debug("\u6d4b\u8bd5\u5931\u8d25\u573a\u666f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscPayCallbackContentBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
        }
        if (abilityReqBO.getFscPayCallbackContentBO() != null) {
            fscPayCallbackContentBO = abilityReqBO.getFscPayCallbackContentBO();
        }
        FscPayBillCallbackBusiReqBO fscPayBillCallbackBusiReqBO = new FscPayBillCallbackBusiReqBO();
        fscPayBillCallbackBusiReqBO.setFscPayCallbackContentBO(fscPayCallbackContentBO);
        FscPayBillCallbackBusiRspBO busiRspBO = this.fscPayBillCallbackBusiService.dealPayBillCallback(fscPayBillCallbackBusiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            busiRspBO.getResultFscOrderIds().forEach(fscOrderId -> {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            });
        }
        if (busiRspBO.getUmcMemberFeePushAbilityReqBO() != null && !CollectionUtils.isEmpty(busiRspBO.getTypes()) && busiRspBO.getMemPayInfoPo() != null) {
            try {
                FscMemPayInfoPO payInfo = new FscMemPayInfoPO();
                payInfo.setFscOrderId(busiRspBO.getMemPayInfoPo().getFscOrderId());
                payInfo.setMemId(busiRspBO.getMemPayInfoPo().getMemId());
                if (busiRspBO.getTypes().contains(2)) {
                    log.info("\u8c03\u7528\u4f1a\u5458\u63a8\u9001\u62db\u6807\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)busiRspBO.getUmcMemberFeePushAbilityReqBO()));
                    UmcMemberFeePushAbilityRspBO zbRspBO = this.umcMemberFeePushAbilityService.dealPushZbMemFee(busiRspBO.getUmcMemberFeePushAbilityReqBO());
                    log.info("\u8c03\u7528\u4f1a\u5458\u63a8\u9001\u62db\u6807\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)zbRspBO));
                    payInfo.setIsPushZb(FscConstants.pushState.SUCCESS);
                    if (!zbRspBO.getRespCode().equals("0000")) {
                        payInfo.setIsPushZb(FscConstants.pushState.FAILED);
                        payInfo.setPushZbFailedReason(zbRspBO.getRespDesc().length() > 255 ? zbRspBO.getRespDesc().substring(0, 254) : zbRspBO.getRespDesc());
                    }
                }
                if (busiRspBO.getTypes().contains(1)) {
                    log.info("\u8c03\u7528\u4f1a\u5458\u63a8\u9001\u975e\u62db\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)busiRspBO.getUmcMemberFeePushAbilityReqBO()));
                    UmcMemberFeePushAbilityRspBO fzRspBO = this.umcMemberFeePushAbilityService.dealPushFzMemFee(busiRspBO.getUmcMemberFeePushAbilityReqBO());
                    log.info("\u8c03\u7528\u4f1a\u5458\u63a8\u9001\u975e\u62db\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)fzRspBO));
                    payInfo.setIsPushFz(FscConstants.pushState.SUCCESS);
                    if (!fzRspBO.getRespCode().equals("0000")) {
                        payInfo.setIsPushFz(FscConstants.pushState.FAILED);
                        payInfo.setPushFzFailedReason(fzRspBO.getRespDesc().length() > 255 ? fzRspBO.getRespDesc().substring(0, 254) : fzRspBO.getRespDesc());
                    }
                }
                this.fscMemPayInfoMapper.update(payInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u4f1a\u5458\u8d39\u63a8\u9001\u62db\u6807/\u975e\u62db\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            }
        }
        FscPayBillCallbackAbilityRspBO abilityRspBO = (FscPayBillCallbackAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscPayBillCallbackAbilityRspBO.class);
        FscPayIntfLogPO fscPayIntfLogPO = new FscPayIntfLogPO();
        fscPayIntfLogPO.setCreateTime(new Date());
        fscPayIntfLogPO.setReqJson(JSON.toJSONString((Object)abilityReqBO));
        fscPayIntfLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPayIntfLogPO.setIntfResult(FscConstants.InfcProcessResult.SUCCESS);
        fscPayIntfLogPO.setSerialNo(fscPayCallbackContentBO.getOutOrderId());
        if ("0000".equals(busiRspBO.getRespCode())) {
            fscPayIntfLogPO.setBusiResult(FscConstants.InfcProcessResult.SUCCESS);
        } else {
            fscPayIntfLogPO.setBusiResult(FscConstants.InfcProcessResult.FAIL);
            fscPayIntfLogPO.setRspJson(JSON.toJSONString((Object)((Object)busiRspBO)));
        }
        fscPayIntfLogPO.setServiceCode("FscPayBillCallbackAbilityService");
        this.fscPayIntfLogMapper.insert(fscPayIntfLogPO);
        return abilityRspBO;
    }
}

