/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOverduePenaltyMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscReliefOverduePenaltyAbilityService;
import com.tydic.fsc.pay.ability.bo.FscAuditOverduePenaltyAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscAuditOverduePenaltyAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscCancelOverduePenaltyAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscCancelOverduePenaltyAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscReliefOverduePenaltyAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscReliefOverduePenaltyAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscAuditOverduePenaltyBusiService;
import com.tydic.fsc.pay.busi.api.FscReliefOverduePenaltyBusiService;
import com.tydic.fsc.pay.busi.bo.FscAuditOverduePenaltyBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscAuditOverduePenaltyBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscReliefOverduePenaltyBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscReliefOverduePenaltyBusiRspBO;
import com.tydic.fsc.po.FscOverduePenaltyPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscReliefOverduePenaltyAbilityService"})
public class FscReliefOverduePenaltyAbilityServiceImpl
implements FscReliefOverduePenaltyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscReliefOverduePenaltyAbilityServiceImpl.class);
    @Autowired
    private FscReliefOverduePenaltyBusiService fscReliefOverduePenaltyBusiService;
    @Autowired
    private FscAuditOverduePenaltyBusiService fscAuditOverduePenaltyBusiService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOverduePenaltyMapper fscOverduePenaltyMapper;

    @PostMapping(value={"dealReliefOverduePenalty"})
    public FscReliefOverduePenaltyAbilityRspBO dealReliefOverduePenalty(@RequestBody FscReliefOverduePenaltyAbilityReqBO reqBO) {
        log.info("\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u63d0\u4ea4\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        this.checkParam(reqBO);
        FscReliefOverduePenaltyAbilityRspBO rspBO = new FscReliefOverduePenaltyAbilityRspBO();
        List shouldPayIdList = reqBO.getShouldPayIdList();
        FscShouldPayPO po = new FscShouldPayPO();
        po.setShouldPayIds(shouldPayIdList);
        List shouldPayPOS = this.fscShouldPayMapper.getList(po);
        if (CollectionUtils.isEmpty((Collection)shouldPayPOS)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u65e0\u5e94\u4ed8\u5355");
        }
        if (shouldPayIdList.size() != shouldPayPOS.size()) {
            throw new FscBusinessException("198888", "\u5e94\u4ed8\u5355\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        for (FscShouldPayPO shouldPayPO : shouldPayPOS) {
            if (!FscConstants.ShouldPayStatus.TO_PAY.equals(shouldPayPO.getShouldPayStatus())) {
                throw new FscBusinessException("198888", shouldPayPO.getShouldPayNo() + "\u5e94\u4ed8\u5355\u4ed8\u6b3e\u72b6\u6001\u9519\u8bef\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u6b21\u63d0\u4ea4");
            }
            if (FscConstants.ShouldPayType.OVERDUE_PENALTY_PAY.equals(shouldPayPO.getShouldPayType())) continue;
            throw new FscBusinessException("198888", shouldPayPO.getShouldPayNo() + "\u5e94\u4ed8\u5355\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u6b21\u63d0\u4ea4");
        }
        FscReliefOverduePenaltyBusiReqBO busiReqBO = new FscReliefOverduePenaltyBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        busiReqBO.setFscShouldPayPOList(shouldPayPOS);
        FscReliefOverduePenaltyBusiRspBO busiRspBO = this.fscReliefOverduePenaltyBusiService.dealReliefOverduePenalty(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("198888", busiRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"dealAuditOverduePenalty"})
    public FscAuditOverduePenaltyAbilityRspBO dealAuditOverduePenalty(@RequestBody FscAuditOverduePenaltyAbilityReqBO reqBO) {
        this.val(reqBO);
        List idList = reqBO.getOverduePenaltyIdList();
        FscOverduePenaltyPO po = new FscOverduePenaltyPO();
        po.setOverduePenaltyIds(idList);
        List fscOverduePenaltyList = this.fscOverduePenaltyMapper.selectByCondition(po);
        fscOverduePenaltyList.forEach(fscOverduePenalty -> {
            if (!FscConstants.ReliefOverDuePenaltyStatus.TO_AUDIT.equals(fscOverduePenalty.getStatus())) {
                throw new FscBusinessException("198888", "\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u5355\u72b6\u6001\u9519\u8bef\uff01");
            }
            if (null != fscOverduePenalty.getAuditResult()) {
                throw new FscBusinessException("198888", "\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u5355\u5ba1\u6279\u72b6\u6001\u9519\u8bef\uff01");
            }
        });
        FscAuditOverduePenaltyAbilityRspBO rspBO = new FscAuditOverduePenaltyAbilityRspBO();
        FscAuditOverduePenaltyBusiReqBO busiReqBO = new FscAuditOverduePenaltyBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        FscAuditOverduePenaltyBusiRspBO busiRspBO = this.fscAuditOverduePenaltyBusiService.dealAuditOverduePenalty(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("198888", busiRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"dealCancelOverduePenalty"})
    public FscCancelOverduePenaltyAbilityRspBO dealCancelOverduePenalty(@RequestBody FscCancelOverduePenaltyAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOverduePenaltyIdList())) {
            throw new FscBusinessException("191000", "\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List idList = reqBO.getOverduePenaltyIdList();
        FscOverduePenaltyPO po = new FscOverduePenaltyPO();
        po.setOverduePenaltyIds(idList);
        List fscOverduePenaltyList = this.fscOverduePenaltyMapper.selectByCondition(po);
        fscOverduePenaltyList.forEach(fscOverduePenalty -> {
            if (!FscConstants.ReliefOverDuePenaltyStatus.TO_AUDIT.equals(fscOverduePenalty.getStatus())) {
                throw new FscBusinessException("198888", "\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u5355\u72b6\u6001\u9519\u8bef\uff01");
            }
            if (null != fscOverduePenalty.getAuditResult()) {
                throw new FscBusinessException("198888", "\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u5355\u5ba1\u6279\u72b6\u6001\u9519\u8bef\uff01");
            }
        });
        return this.fscAuditOverduePenaltyBusiService.dealCancelOverduePenalty(reqBO);
    }

    private void val(FscAuditOverduePenaltyAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOverduePenaltyIdList())) {
            throw new FscBusinessException("191000", "\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAuditResult()) {
            throw new FscBusinessException("191000", "\u5ba1\u6838\u5904\u7406\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkParam(FscReliefOverduePenaltyAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getShouldPayIdList())) {
            throw new FscBusinessException("191000", "\u5e94\u4ed8\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

