/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl.finance;

import com.tydic.fsc.busibase.atom.api.FscFinancePayTempQryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinancePayTempQryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.finance.FscFinanceEngineeringPayBillUpdateAbilityService;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceEngineeringPayBillUpdateReqBO;
import com.tydic.fsc.pay.ability.bo.finance.FscFinanceEngineeringPayBillUpdateRspBO;
import com.tydic.fsc.pay.atom.api.FscFinancePayCheckUtil;
import com.tydic.fsc.pay.busi.api.finance.FscFinanceEngineeringPayBillUpdateBusiService;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.finance.FscFinanceEngineeringPayBillUpdateAbilityService"})
public class FscFinanceEngineeringPayBillUpdateAbilityServiceImpl
implements FscFinanceEngineeringPayBillUpdateAbilityService {
    @Autowired
    private FscFinanceEngineeringPayBillUpdateBusiService fscFinanceEngineeringPayBillUpdateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscFinancePayTempQryAtomService fscFinancePayTempQryAtomService;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealFinanceEngineeringPayBillUpdate"})
    public FscFinanceEngineeringPayBillUpdateRspBO dealFinanceEngineeringPayBillUpdate(@RequestBody FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        FscFinanceEngineeringPayBillUpdateRspBO rspBO;
        if (reqBO.getTempId() != null) {
            this.qryTemp(reqBO);
        }
        this.valid(reqBO);
        if (reqBO.getPayType() != 0 && !"1".equals(reqBO.getSaveOrSubmit())) {
            this.checkIfUnfinishRefund(reqBO);
        }
        if ((rspBO = this.fscFinanceEngineeringPayBillUpdateBusiService.dealFinanceEngineeringPayBillUpdate(reqBO)).getFscOrderId() != null) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        return rspBO;
    }

    private void qryTemp(FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        FscFinancePayTempQryAtomReqBO atomReqBO = new FscFinancePayTempQryAtomReqBO();
        atomReqBO.setTempId(reqBO.getTempId());
        atomReqBO.setFscOrderId(reqBO.getFscOrderId());
        atomReqBO.setPaymentType(reqBO.getPaymentType());
        FscFinancePayTempQryAtomRspBO atomRspBO = this.fscFinancePayTempQryAtomService.qryPayTemp(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u67e5\u8be2\u4ed8\u6b3e\u4e34\u65f6\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
        atomRspBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
            fscOrderPayItemBO.setOrderId(fscOrderPayItemBO.getObjectId());
            fscOrderPayItemBO.setObjectId(Long.valueOf(Long.parseLong(fscOrderPayItemBO.getFscBillOrderId())));
            fscOrderPayItemBO.setObjectNo(fscOrderPayItemBO.getFscBillOrderNo());
            fscOrderPayItemBO.setPanelPointCode(fscOrderPayItemBO.getExt4());
            fscOrderPayItemBO.setPanelPointName(fscOrderPayItemBO.getExt5());
        });
        reqBO.setFscOrderPayItemBOS(atomRspBO.getFscOrderPayItemBOS());
        reqBO.setAttachmentList(atomRspBO.getAttachmentList());
    }

    private void valid(FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderPayItemBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderPayItemBOS]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            FscFinancePayCheckUtil.checkLocalAmountApply(reqBO.getFscOrderPayItemBOS(), reqBO.getExchangeRate(), reqBO.getCurrency());
        }
    }

    private void checkIfUnfinishRefund(FscFinanceEngineeringPayBillUpdateReqBO reqBO) {
        List fscOrderIds = reqBO.getFscOrderPayItemBOS().stream().map(e -> Long.parseLong(e.getFscBillOrderId())).collect(Collectors.toList());
        Integer count = this.fscOrderRefundMapper.checkRefundStatusByFscOrderIds(fscOrderIds);
        if (count > 0) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u5728\u9014\u7684\u9000\u7968\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u4ed8\u6b3e\u6d41\u7a0b\uff01");
        }
    }
}

