/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscPayShouldRefundBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRefundPayRelationMapper;
import com.tydic.fsc.dao.FscOrderShouldAmountMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscPurOrderRefundAmtMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.enums.FscRefundShouldPayFlowEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscRefundShouldPayCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscRefundShouldPayCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscRefundShouldPayCreateBusiRspBO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRefundPayRelationPo;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscPurOrderRefundAmtPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uoc.common.ability.api.PebExtMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.api.PebExtSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.api.PebExtSalesSingleDetailsQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtOrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.PebOrdAgreementRspBO;
import com.tydic.uoc.common.ability.bo.PebOrdStakeholderRspBO;
import com.tydic.uoc.common.ability.bo.PebOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdZmInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscRefundShouldPayCreateBusiServiceImpl
implements FscRefundShouldPayCreateBusiService {
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderRefundPayRelationMapper fscOrderRefundPayRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long operationSupId;
    @Autowired
    private PebExtSalesSingleDetailsListQueryAbilityService pebExtSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService;
    @Autowired
    private PebExtSalesSingleDetailsQueryAbilityService pebExtSalesSingleDetailsQueryAbilityService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscPurOrderRefundAmtMapper fscPurOrderRefundAmtMapper;
    @Autowired
    private FscOrderShouldAmountMapper fscOrderShouldAmountMapper;

    @Override
    public FscRefundShouldPayCreateBusiRspBO dealRefundShouldPayCreate(FscRefundShouldPayCreateBusiReqBO reqBO) {
        if (FscConstants.FscTradeMode.TRADE_MODEL.equals(reqBO.getTradeMode())) {
            this.refundShouldCreateByPay(reqBO, reqBO.getOrderPurchaseAmt(), this.operationOrgId, null);
            if (reqBO.getSettlePlatform() != null && FscConstants.SettlePlatform.FINANCE.equals(reqBO.getSettlePlatform())) {
                this.refundShouldCreateByPay(reqBO, reqBO.getOrderSaleAmt(), null, this.operationOrgId);
            } else {
                this.refundShouldCreateByClaim(reqBO, reqBO.getOrderSaleAmt(), FscConstants.IsSup.ORG);
            }
        } else if (this.operationSupId.equals(reqBO.getSupNo())) {
            this.refundShouldCreateByClaim(reqBO, reqBO.getOrderAmt(), FscConstants.IsSup.SUP);
        } else {
            this.refundShouldCreateByPay(reqBO, reqBO.getOrderAmt(), null, null);
        }
        if (reqBO.getOrderAmt() != null && reqBO.getOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
            this.cancelShouldPay(reqBO);
        } else if (reqBO.getOrderSaleAmt() != null && reqBO.getOrderSaleAmt().compareTo(BigDecimal.ZERO) == 0) {
            this.cancelShouldPay(reqBO);
        }
        FscRefundShouldPayCreateBusiRspBO rspBO = new FscRefundShouldPayCreateBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void cancelShouldPay(FscRefundShouldPayCreateBusiReqBO reqBO) {
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setOrderId(reqBO.getOrderId());
        fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.DEL);
        this.fscShouldPayMapper.updateStatusByOrderId(fscShouldPayPO);
    }

    private void refundShouldCreateByPay(FscRefundShouldPayCreateBusiReqBO reqBO, BigDecimal orderAmt, Long payerId, Long payeeId) {
        BigDecimal shouldRefundAmt;
        BigDecimal purWriteOffAmt;
        this.dealNoPayRefundAmount(reqBO, orderAmt, payerId);
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setOrderId(reqBO.getOrderId());
        orderPO.setPayerId(payerId);
        orderPO.setPayeeId(payeeId);
        List orderList = this.fscOrderMapper.getPrePayInfo(orderPO);
        BigDecimal writeAmount = this.fscOrderShouldAmountMapper.getWriteAmountByOrder(reqBO.getOrderId());
        BigDecimal totalPaidAmt = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        for (FscOrderPO fscOrderPO : orderList) {
            totalPaidAmt = totalPaidAmt.add(fscOrderPO.getPaidAmount());
        }
        if (FscConstants.FscTradeMode.MATCHMAKING_MODE.equals(reqBO.getTradeMode()) && (purWriteOffAmt = this.fscOrderPayItemMapper.getPurWriteOffAmt(reqBO.getOrderId())) != null) {
            totalPaidAmt = totalPaidAmt.subtract(purWriteOffAmt);
        }
        if ((shouldRefundAmt = totalPaidAmt.subtract(writeAmount).subtract(orderAmt)).compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        ArrayList<FscShouldPayPO> shouldPayList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscOrderPayItemPO> payItemList = new ArrayList<FscOrderPayItemPO>();
        ArrayList<FscPayShouldRefundBO> refundPOList = new ArrayList<FscPayShouldRefundBO>(orderList.size());
        HashMap<Long, FscOrderPO> fscOrderMap = new HashMap<Long, FscOrderPO>();
        for (FscOrderPO fscOrderPO : orderList) {
            FscOrderPO refund;
            FscShouldPayPO shouldPayPO = new FscShouldPayPO();
            FscOrderPayItemPO payItemPO = new FscOrderPayItemPO();
            if (shouldRefundAmt.compareTo(fscOrderPO.getPaidAmount()) <= 0) {
                if (fscOrderMap.get(fscOrderPO.getFscOrderId()) == null) {
                    fscOrderPO.setRefundAmt(shouldRefundAmt);
                    fscOrderMap.put(fscOrderPO.getFscOrderId(), fscOrderPO);
                } else {
                    refund = (FscOrderPO)fscOrderMap.get(fscOrderPO.getFscOrderId());
                    refund.setRefundAmt(refund.getRefundAmt().add(shouldRefundAmt));
                    fscOrderMap.put(fscOrderPO.getFscOrderId(), refund);
                }
                shouldPayPO.setShouldPayId(fscOrderPO.getShouldPayId());
                shouldPayPO.setRefundAmt(shouldRefundAmt);
                shouldPayList.add(shouldPayPO);
                payItemPO.setRefundAmt(shouldRefundAmt);
                payItemPO.setOrderPayItemId(fscOrderPO.getOrderPayItemId());
                payItemList.add(payItemPO);
                break;
            }
            if (fscOrderMap.get(fscOrderPO.getFscOrderId()) == null) {
                fscOrderPO.setRefundAmt(fscOrderPO.getPaidAmount());
                fscOrderMap.put(fscOrderPO.getFscOrderId(), fscOrderPO);
            } else {
                refund = (FscOrderPO)fscOrderMap.get(fscOrderPO.getFscOrderId());
                refund.setRefundAmt(refund.getRefundAmt().add(fscOrderPO.getPaidAmount()));
                fscOrderMap.put(fscOrderPO.getFscOrderId(), refund);
            }
            shouldPayPO.setShouldPayId(fscOrderPO.getShouldPayId());
            shouldPayPO.setRefundAmt(fscOrderPO.getPaidAmount());
            shouldPayList.add(shouldPayPO);
            payItemPO.setRefundAmt(fscOrderPO.getPaidAmount());
            payItemPO.setOrderPayItemId(fscOrderPO.getOrderPayItemId());
            payItemList.add(payItemPO);
            shouldRefundAmt = shouldRefundAmt.subtract(fscOrderPO.getPaidAmount());
        }
        PebExtSalesSingleDetailsListQueryReqBO detailsListQueryReqBO = new PebExtSalesSingleDetailsListQueryReqBO();
        detailsListQueryReqBO.setOrderId(reqBO.getOrderId());
        detailsListQueryReqBO.setTabId(Integer.valueOf(30001));
        PebExtSalesSingleDetailsListQueryRspBO detailsListQueryRspBO = this.pebExtSalesSingleDetailsListQueryAbilityService.getPebExtSalesSingleDetailsListQuery(detailsListQueryReqBO);
        if (!detailsListQueryRspBO.getRespCode().equals("0000")) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)detailsListQueryRspBO.getRows())) {
            return;
        }
        for (Long fscOrderId : fscOrderMap.keySet()) {
            FscOrderPO po = (FscOrderPO)fscOrderMap.get(fscOrderId);
            FscPayShouldRefundBO shouldRefundBO = new FscPayShouldRefundBO();
            BeanUtils.copyProperties((Object)po, (Object)shouldRefundBO);
            shouldRefundBO.setRefundShouldPayById(reqBO.getOrderId());
            shouldRefundBO.setPayingAmount(BigDecimal.ZERO);
            shouldRefundBO.setPaidAmount(BigDecimal.ZERO);
            shouldRefundBO.setTotalPaidAmount(po.getActualAmount());
            shouldRefundBO.setGenerateType(FscConstants.FscRefundGenerateType.AUTO);
            shouldRefundBO.setRefundPayStatus(FscConstants.RefundPayStatus.DRAFT);
            if (payerId != null) {
                shouldRefundBO.setUserType(FscConstants.RefundUserType.OPERATION);
            } else {
                shouldRefundBO.setUserType(FscConstants.RefundUserType.PURCHASE);
            }
            shouldRefundBO.setBuynerNo(po.getBuynerNo());
            shouldRefundBO.setBuynerName(po.getBuynerName());
            shouldRefundBO.setRefundType(reqBO.getRefundType());
            shouldRefundBO.setOperatorId(po.getOperatorId());
            shouldRefundBO.setOperatorName(po.getOperatorName());
            if (!StringUtils.isEmpty((Object)po.getOperationNo())) {
                shouldRefundBO.setOperatorDeptId(Long.valueOf(po.getOperationNo()));
            }
            shouldRefundBO.setOperatorDeptName(po.getOperationName());
            shouldRefundBO.setRefundAmount(po.getRefundAmt());
            shouldRefundBO.setCreateTime(new Date());
            shouldRefundBO.setCreateUserId(reqBO.getUserId());
            shouldRefundBO.setCreateUserName(reqBO.getName());
            shouldRefundBO.setCreateOrgId(reqBO.getOrgId());
            shouldRefundBO.setCreateOrgName(reqBO.getOrgName());
            shouldRefundBO.setRefundShouldPayNo(po.getObjectNo());
            shouldRefundBO.setOrderCode(po.getObjectNo());
            shouldRefundBO.setPayOrderId(po.getFscOrderId());
            shouldRefundBO.setPayOrderNo(po.getOrderNo());
            shouldRefundBO.setRefundPayStatus(FscConstants.RefundPayStatus.DRAFT);
            shouldRefundBO.setIsPushUnify(po.getSettlePlatform());
            if (shouldRefundBO.getIsPushUnify() == null) {
                shouldRefundBO.setIsPushUnify(Integer.valueOf(0));
            }
            shouldRefundBO.setSupplierId(Long.valueOf(((PebExtUpperOrderAbilityBO)detailsListQueryRspBO.getRows().get(0)).getSupNo()));
            shouldRefundBO.setSupplierName(((PebExtUpperOrderAbilityBO)detailsListQueryRspBO.getRows().get(0)).getSupName());
            shouldRefundBO.setOrderAmount(orderAmt);
            shouldRefundBO.setRefundMethod(FscPayTypeEnum.ADVANCE_PAY.getCode() + "");
            shouldRefundBO.setExt1(FscRefundShouldPayFlowEnum.MATERIAL.getCode());
            refundPOList.add(shouldRefundBO);
        }
        this.dealShouldRefundCreate(refundPOList, payItemList, shouldPayList);
    }

    private void dealShouldRefundCreate(List<FscPayShouldRefundBO> fscPayShouldRefundBOS, List<FscOrderPayItemPO> payItemList, List<FscShouldPayPO> shouldPayList) {
        ArrayList<FscOrderRefundPayRelationPo> relationPoList = new ArrayList<FscOrderRefundPayRelationPo>();
        ArrayList<FscPayShouldRefundPO> fscPayShouldRefundPOS = new ArrayList<FscPayShouldRefundPO>(fscPayShouldRefundBOS.size());
        for (FscPayShouldRefundBO fscPayShouldRefundBO : fscPayShouldRefundBOS) {
            FscPayShouldRefundPO fscPayShouldRefundPO = (FscPayShouldRefundPO)JSON.parseObject((String)JSON.toJSONString((Object)fscPayShouldRefundBO), FscPayShouldRefundPO.class);
            fscPayShouldRefundPO.setRefundShouldPayId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayShouldRefundPOS.add(fscPayShouldRefundPO);
            FscOrderRefundPayRelationPo refundPayRelationPo = new FscOrderRefundPayRelationPo();
            refundPayRelationPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundPayRelationPo.setRefundShouldPayId(fscPayShouldRefundPO.getRefundShouldPayId());
            refundPayRelationPo.setOrderId(fscPayShouldRefundPO.getOrderId());
            refundPayRelationPo.setOrderNo(fscPayShouldRefundPO.getOrderCode());
            refundPayRelationPo.setPayAmount(fscPayShouldRefundPO.getTotalPaidAmount());
            refundPayRelationPo.setRefundAmount(fscPayShouldRefundPO.getRefundAmount());
            refundPayRelationPo.setPayOrderId(fscPayShouldRefundPO.getPayOrderId());
            refundPayRelationPo.setPayOrderNo(fscPayShouldRefundPO.getPayOrderNo());
            refundPayRelationPo.setPayingAmount(BigDecimal.ZERO);
            refundPayRelationPo.setRefundedAmount(BigDecimal.ZERO);
            refundPayRelationPo.setCreateId(fscPayShouldRefundPO.getCreateUserId());
            refundPayRelationPo.setCreateName(fscPayShouldRefundPO.getCreateUserName());
            refundPayRelationPo.setCreateTime(new Date());
            refundPayRelationPo.setClaimAmt(BigDecimal.ZERO);
            relationPoList.add(refundPayRelationPo);
        }
        int count = this.fscPayShouldRefundMapper.insertBatch(fscPayShouldRefundPOS);
        if (count != fscPayShouldRefundPOS.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u5355\u6570\u636e\u5931\u8d25\uff01");
        }
        count = this.fscOrderRefundPayRelationMapper.insertBatch(relationPoList);
        if (count != relationPoList.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u5355\u660e\u7ec6\u6570\u636e\u5931\u8d25\uff01");
        }
        int shouldPaySize = (int)shouldPayList.stream().map(FscShouldPayPO::getShouldPayId).distinct().count();
        count = this.fscShouldPayMapper.updateRefundAmtBatch(shouldPayList);
        if (count != shouldPaySize) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u6570\u636e\u5931\u8d25,\u66f4\u65b0\u5e94\u4ed8\u6570\u636e\u5931\u8d25\uff01");
        }
        count = this.fscOrderPayItemMapper.updateRefundAmtBatch(payItemList);
        if (count != payItemList.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u6570\u636e\u5931\u8d25,\u66f4\u65b0\u5e94\u4ed8\u5173\u8054\u6570\u636e\u5931\u8d25\uff01");
        }
    }

    private void refundShouldCreateByClaim(FscRefundShouldPayCreateBusiReqBO reqBO, BigDecimal orderAmt, Integer isSup) {
        this.dealNoClaimRefundAmount(reqBO, orderAmt);
        FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
        fscClaimDetailPO.setOrderId(reqBO.getOrderId());
        fscClaimDetailPO.setIsSup(isSup);
        List claimDetailList = this.fscClaimDetailMapper.getClaimedByOrderId(fscClaimDetailPO);
        if (CollectionUtils.isEmpty((Collection)claimDetailList)) {
            return;
        }
        BigDecimal totalPaidAmt = claimDetailList.stream().map(FscClaimDetailPO::getAmount).reduce(BigDecimal::add).get();
        if (totalPaidAmt.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        BigDecimal refundAmt = this.fscPurOrderRefundAmtMapper.getRefundAmtByOrderId(reqBO.getOrderId());
        BigDecimal shouldRefundAmt = totalPaidAmt.subtract(refundAmt).subtract(orderAmt);
        if (shouldRefundAmt.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        PebExtSalesSingleDetailsQueryReqBO pebExtSalesSingleDetailsQueryReqBO = new PebExtSalesSingleDetailsQueryReqBO();
        pebExtSalesSingleDetailsQueryReqBO.setOrderId(reqBO.getOrderId());
        PebExtSalesSingleDetailsQueryRspBO pebExtSalesSingleDetailsQueryRspBO = this.pebExtSalesSingleDetailsQueryAbilityService.getSalesSingleDetailsQuery(pebExtSalesSingleDetailsQueryReqBO);
        if (!"0000".equals(pebExtSalesSingleDetailsQueryRspBO.getRespCode())) {
            return;
        }
        PebExtOrdSaleRspBO orderBO = pebExtSalesSingleDetailsQueryRspBO.getOrdSaleRspBO();
        PebExtMainOrderDetailQueryReqBO pebExtMainOrderDetailQueryReqBO = new PebExtMainOrderDetailQueryReqBO();
        pebExtMainOrderDetailQueryReqBO.setOrderId(reqBO.getOrderId());
        PebExtMainOrderDetailQueryRspBO pebExtMainOrderDetailQuery = this.pebExtMainOrderDetailQueryAbilityService.getPebExtMainOrderDetailQuery(pebExtMainOrderDetailQueryReqBO);
        if (!"0000".equals(pebExtMainOrderDetailQuery.getRespCode())) {
            return;
        }
        PebOrderRspBO orderRspBO = pebExtMainOrderDetailQuery.getOrderRspBO();
        UocOrdZmInfoBO uocOrdZmInfoBO = pebExtMainOrderDetailQuery.getOrderZmInfo();
        PebOrdStakeholderRspBO stakeholderPO = pebExtMainOrderDetailQuery.getOrdStakeholderRspBO();
        PebOrdAgreementRspBO agreementRspBO = pebExtMainOrderDetailQuery.getOrdAgreementRspBO();
        fscClaimDetailPO = (FscClaimDetailPO)claimDetailList.get(0);
        FscPayShouldRefundPO fscPayShouldRefundPO = new FscPayShouldRefundPO();
        fscPayShouldRefundPO.setRefundShouldPayId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPayShouldRefundPO.setRefundShouldPayNo(fscClaimDetailPO.getOrderCode());
        fscPayShouldRefundPO.setPayerId(Long.valueOf(uocOrdZmInfoBO.getExt3()));
        fscPayShouldRefundPO.setPayerName(uocOrdZmInfoBO.getBuynerName());
        fscPayShouldRefundPO.setPayeeId(FscConstants.IsSup.ORG.equals(isSup) ? Long.valueOf(stakeholderPO.getProNo()) : Long.valueOf(stakeholderPO.getSupNo()));
        fscPayShouldRefundPO.setPayeeName(FscConstants.IsSup.ORG.equals(isSup) ? stakeholderPO.getProName() : stakeholderPO.getSupName());
        fscPayShouldRefundPO.setSupplierId(Long.valueOf(stakeholderPO.getSupNo()));
        fscPayShouldRefundPO.setSupplierName(stakeholderPO.getSupName());
        fscPayShouldRefundPO.setOrderSource(Integer.valueOf(orderBO.getOrderSource()));
        fscPayShouldRefundPO.setOrderType(orderBO.getOrderType());
        fscPayShouldRefundPO.setRefundType(reqBO.getRefundType());
        fscPayShouldRefundPO.setGenerateType(FscConstants.FscRefundGenerateType.AUTO);
        fscPayShouldRefundPO.setTotalPaidAmount(totalPaidAmt);
        fscPayShouldRefundPO.setRefundAmount(shouldRefundAmt);
        fscPayShouldRefundPO.setPayingAmount(BigDecimal.ZERO);
        fscPayShouldRefundPO.setPaidAmount(BigDecimal.ZERO);
        fscPayShouldRefundPO.setUserType(FscConstants.RefundUserType.PURCHASE);
        fscPayShouldRefundPO.setRefundPayStatus(FscConstants.RefundPayStatus.DRAFT);
        fscPayShouldRefundPO.setClaimAmt(BigDecimal.ZERO);
        fscPayShouldRefundPO.setOrderId(orderBO.getOrderId());
        fscPayShouldRefundPO.setOrderCode(orderBO.getSaleVoucherNo());
        fscPayShouldRefundPO.setRefundShouldPayById(orderBO.getOrderId());
        fscPayShouldRefundPO.setBuynerNo(uocOrdZmInfoBO.getBuynerNo());
        fscPayShouldRefundPO.setBuynerName(uocOrdZmInfoBO.getBuynerName());
        if (!StringUtils.isEmpty((Object)orderRspBO.getExt2())) {
            fscPayShouldRefundPO.setOperatorId(Long.valueOf(orderRspBO.getExt2()));
        }
        fscPayShouldRefundPO.setOperatorName(orderRspBO.getExt3());
        if (!StringUtils.isEmpty((Object)orderRspBO.getExt6())) {
            fscPayShouldRefundPO.setOperatorDeptId(Long.valueOf(orderRspBO.getExt6()));
        }
        fscPayShouldRefundPO.setOperatorDeptName(orderRspBO.getExt8());
        fscPayShouldRefundPO.setCreateTime(new Date());
        fscPayShouldRefundPO.setCreateUserId(reqBO.getUserId());
        fscPayShouldRefundPO.setCreateUserName(reqBO.getName());
        fscPayShouldRefundPO.setCreateOrgId(reqBO.getOrgId());
        fscPayShouldRefundPO.setCreateOrgName(reqBO.getOrgName());
        fscPayShouldRefundPO.setIsPushUnify(Integer.valueOf(0));
        fscPayShouldRefundPO.setTradeMode(FscConstants.IsSup.ORG.equals(isSup) ? FscConstants.FscTradeMode.TRADE_MODEL : FscConstants.FscTradeMode.MATCHMAKING_MODE);
        if (agreementRspBO != null && !StringUtils.isEmpty((Object)agreementRspBO.getAgreementId())) {
            fscPayShouldRefundPO.setContractId(Long.valueOf(agreementRspBO.getAgreementId()));
            fscPayShouldRefundPO.setContractNo(agreementRspBO.getEntAgreementCode());
        }
        fscPayShouldRefundPO.setOrderAmount(orderAmt);
        ArrayList<FscPayShouldRefundPO> fscPayShouldRefundPOS = new ArrayList<FscPayShouldRefundPO>(1);
        fscPayShouldRefundPOS.add(fscPayShouldRefundPO);
        ArrayList<FscOrderRefundPayRelationPo> relationPoList = new ArrayList<FscOrderRefundPayRelationPo>();
        FscOrderRefundPayRelationPo refundPayRelationPo = new FscOrderRefundPayRelationPo();
        refundPayRelationPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        refundPayRelationPo.setRefundShouldPayId(fscPayShouldRefundPO.getRefundShouldPayId());
        refundPayRelationPo.setOrderId(fscPayShouldRefundPO.getOrderId());
        refundPayRelationPo.setOrderNo(fscPayShouldRefundPO.getOrderCode());
        refundPayRelationPo.setPayAmount(fscPayShouldRefundPO.getTotalPaidAmount());
        refundPayRelationPo.setRefundAmount(fscPayShouldRefundPO.getRefundAmount());
        refundPayRelationPo.setPayOrderId(fscPayShouldRefundPO.getPayOrderId());
        refundPayRelationPo.setPayOrderNo(fscPayShouldRefundPO.getPayOrderNo());
        refundPayRelationPo.setPayingAmount(BigDecimal.ZERO);
        refundPayRelationPo.setRefundedAmount(BigDecimal.ZERO);
        refundPayRelationPo.setCreateId(fscPayShouldRefundPO.getCreateUserId());
        refundPayRelationPo.setCreateName(fscPayShouldRefundPO.getCreateUserName());
        refundPayRelationPo.setCreateTime(new Date());
        refundPayRelationPo.setClaimAmt(BigDecimal.ZERO);
        relationPoList.add(refundPayRelationPo);
        int count = this.fscPayShouldRefundMapper.insertBatch(fscPayShouldRefundPOS);
        if (count != fscPayShouldRefundPOS.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u5355\u6570\u636e\u5931\u8d25\uff01");
        }
        count = this.fscOrderRefundPayRelationMapper.insertBatch(relationPoList);
        if (count != relationPoList.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u5355\u660e\u7ec6\u6570\u636e\u5931\u8d25\uff01");
        }
        FscPurOrderRefundAmtPO fscPurOrderRefundAmtPO = new FscPurOrderRefundAmtPO();
        fscPurOrderRefundAmtPO.setOrderId(reqBO.getOrderId());
        fscPurOrderRefundAmtPO.setRefundShouldPayId(fscPayShouldRefundPO.getRefundShouldPayId());
        fscPurOrderRefundAmtPO.setRefundAmt(shouldRefundAmt);
        count = this.fscPurOrderRefundAmtMapper.insertBatch(Collections.singletonList(fscPurOrderRefundAmtPO));
        if (count != 1) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u8ba2\u5355\u9000\u6b3e\u8bb0\u5f55\u6570\u636e\u5931\u8d25\uff01");
        }
        Set orderIds = claimDetailList.stream().map(FscClaimDetailPO::getOrderId).collect(Collectors.toSet());
        fscClaimDetailPO.setOrderIds(orderIds);
        fscClaimDetailPO.setRefundLock(FscConstants.RefundLock.YES);
        this.fscClaimDetailMapper.updateRefundLock(fscClaimDetailPO);
    }

    private void dealNoPayRefundAmount(FscRefundShouldPayCreateBusiReqBO reqBO, BigDecimal orderAmt, Long payerId) {
        int count;
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setOrderId(reqBO.getOrderId());
        ArrayList<Integer> shouldPayTypes = new ArrayList<Integer>();
        shouldPayTypes.add(FscConstants.ShouldPayType.ADVANCE_PAY);
        shouldPayTypes.add(FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY);
        shouldPayTypes.add(FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY);
        shouldPayTypes.add(FscConstants.ShouldPayType.PAYMENT_PRE_PAY);
        fscShouldPayPO.setShouldPayTypes(shouldPayTypes);
        fscShouldPayPO.setPayerId(payerId);
        fscShouldPayPO.setOrderBy("create_time asc");
        List shouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
        if (CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            return;
        }
        BigDecimal nodePayRatio = shouldPayPOList.stream().map(FscShouldPayPO::getNodePayRatio).reduce(BigDecimal::add).get().multiply(new BigDecimal("0.01"));
        BigDecimal orderPreAmt = orderAmt.multiply(nodePayRatio);
        BigDecimal shouldPayAmount = shouldPayPOList.stream().map(FscShouldPayPO::getShouldPayAmount).reduce(BigDecimal::add).get();
        BigDecimal refundAmount = shouldPayPOList.stream().filter(e -> e.getRefundAmount() != null).map(FscShouldPayPO::getRefundAmount).reduce(BigDecimal::add).get();
        BigDecimal changeAmount = shouldPayAmount.subtract(refundAmount).subtract(orderPreAmt);
        ArrayList<FscShouldPayPO> updateShouldList = new ArrayList<FscShouldPayPO>();
        if (changeAmount.compareTo(BigDecimal.ZERO) > 0) {
            for (FscShouldPayPO po : shouldPayPOList) {
                if (changeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal noPayAmount = po.getToPayAmount().subtract(po.getRefundAmount());
                if (noPayAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                FscShouldPayPO shouldPayPO = new FscShouldPayPO();
                shouldPayPO.setShouldPayId(po.getShouldPayId());
                if (noPayAmount.compareTo(changeAmount) > 0) {
                    shouldPayPO.setRefundAmount(changeAmount);
                    changeAmount = BigDecimal.ZERO;
                } else {
                    shouldPayPO.setRefundAmount(noPayAmount);
                    changeAmount = changeAmount.subtract(noPayAmount);
                }
                updateShouldList.add(shouldPayPO);
            }
        }
        if (!CollectionUtils.isEmpty(updateShouldList) && (count = this.fscShouldPayMapper.updateRefundAmountBatch(updateShouldList)) != updateShouldList.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u6570\u636e\u5931\u8d25,\u66f4\u65b0\u5e94\u4ed8\u672a\u4ed8\u6b3e\u5360\u7528\u6570\u636e\u5931\u8d25\uff01");
        }
    }

    private void dealNoClaimRefundAmount(FscRefundShouldPayCreateBusiReqBO reqBO, BigDecimal orderAmt) {
        int count;
        FscOrderPayItemPO fscOrderPayItemPO;
        BigDecimal noClaimAmount;
        List payingOrderList;
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setOrderId(reqBO.getOrderId());
        ArrayList<Integer> shouldPayTypes = new ArrayList<Integer>();
        shouldPayTypes.add(FscConstants.ShouldPayType.ADVANCE_PAY);
        shouldPayTypes.add(FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY);
        shouldPayTypes.add(FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY);
        shouldPayTypes.add(FscConstants.ShouldPayType.PAYMENT_PRE_PAY);
        fscShouldPayPO.setShouldPayTypes(shouldPayTypes);
        ArrayList<Long> payeeIds = new ArrayList<Long>();
        payeeIds.add(this.operationOrgId);
        payeeIds.add(this.operationSupId);
        fscShouldPayPO.setPayeeIds(payeeIds);
        fscShouldPayPO.setOrderBy("create_time asc");
        List shouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
        if (CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            return;
        }
        BigDecimal nodePayRatio = shouldPayPOList.stream().map(FscShouldPayPO::getNodePayRatio).reduce(BigDecimal::add).get().multiply(new BigDecimal("0.01"));
        BigDecimal orderPreAmt = orderAmt.multiply(nodePayRatio);
        BigDecimal shouldPayAmount = shouldPayPOList.stream().map(FscShouldPayPO::getShouldPayAmount).reduce(BigDecimal::add).get();
        BigDecimal refundAmount = shouldPayPOList.stream().filter(e -> e.getRefundAmount() != null).map(FscShouldPayPO::getRefundAmount).reduce(BigDecimal::add).get();
        BigDecimal changeAmount = shouldPayAmount.subtract(refundAmount).subtract(orderPreAmt);
        ArrayList<FscShouldPayPO> updateShouldList = new ArrayList<FscShouldPayPO>();
        if (changeAmount.compareTo(BigDecimal.ZERO) > 0) {
            for (FscShouldPayPO po : shouldPayPOList) {
                if (changeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal noClaimAmount2 = po.getToPayAmount().subtract(po.getRefundAmount());
                if (noClaimAmount2.compareTo(BigDecimal.ZERO) <= 0) continue;
                FscShouldPayPO shouldPayPO = new FscShouldPayPO();
                shouldPayPO.setShouldPayId(po.getShouldPayId());
                if (noClaimAmount2.compareTo(changeAmount) > 0) {
                    shouldPayPO.setRefundAmount(changeAmount);
                    changeAmount = BigDecimal.ZERO;
                } else {
                    shouldPayPO.setRefundAmount(noClaimAmount2);
                    changeAmount = changeAmount.subtract(noClaimAmount2);
                }
                updateShouldList.add(shouldPayPO);
            }
        }
        ArrayList<FscOrderPayItemPO> updateList = new ArrayList<FscOrderPayItemPO>();
        FscOrderPayItemPO payItemQueryPO = new FscOrderPayItemPO();
        payItemQueryPO.setOrderId(reqBO.getOrderId());
        payItemQueryPO.setPayeeIds(payeeIds);
        if (changeAmount.compareTo(BigDecimal.ZERO) > 0 && !CollectionUtils.isEmpty((Collection)(payingOrderList = this.fscOrderPayItemMapper.getPayingOrderByOrderId(payItemQueryPO)))) {
            for (FscOrderPayItemPO po : payingOrderList) {
                if (changeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                noClaimAmount = po.getPayAmount().subtract(po.getRefundAmount());
                if (noClaimAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                fscOrderPayItemPO = new FscOrderPayItemPO();
                fscOrderPayItemPO.setOrderPayItemId(po.getOrderPayItemId());
                if (noClaimAmount.compareTo(changeAmount) > 0) {
                    fscOrderPayItemPO.setRefundAmount(changeAmount);
                    changeAmount = BigDecimal.ZERO;
                } else {
                    fscOrderPayItemPO.setRefundAmount(noClaimAmount);
                    changeAmount = changeAmount.subtract(noClaimAmount);
                }
                updateList.add(fscOrderPayItemPO);
            }
        }
        if (changeAmount.compareTo(BigDecimal.ZERO) > 0 && !CollectionUtils.isEmpty((Collection)(payingOrderList = this.fscOrderPayItemMapper.getPaidOrderByOrderId(payItemQueryPO)))) {
            for (FscOrderPayItemPO po : payingOrderList) {
                if (changeAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                noClaimAmount = po.getPayAmount().subtract(po.getClaimAmount()).subtract(po.getRefundAmount());
                if (noClaimAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                fscOrderPayItemPO = new FscOrderPayItemPO();
                fscOrderPayItemPO.setOrderPayItemId(po.getOrderPayItemId());
                if (noClaimAmount.compareTo(changeAmount) > 0) {
                    fscOrderPayItemPO.setRefundAmount(changeAmount);
                    changeAmount = BigDecimal.ZERO;
                } else {
                    fscOrderPayItemPO.setRefundAmount(noClaimAmount);
                    changeAmount = changeAmount.subtract(noClaimAmount);
                }
                updateList.add(fscOrderPayItemPO);
            }
        }
        if (!CollectionUtils.isEmpty(updateShouldList) && (count = this.fscShouldPayMapper.updateRefundAmountBatch(updateShouldList)) != updateShouldList.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u6570\u636e\u5931\u8d25,\u66f4\u65b0\u5e94\u4ed8\u672a\u8ba4\u9886\u5360\u7528\u6570\u636e\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(updateList) && (count = this.fscOrderPayItemMapper.updateRefundAmountBatch(updateList)) != updateList.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u4ed8\u6b3e\u6570\u636e\u5931\u8d25,\u66f4\u65b0\u4ed8\u6b3e\u672a\u8ba4\u9886\u5360\u7528\u6570\u636e\u5931\u8d25\uff01");
        }
    }
}

