/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscContractPlanItemBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleFundingPlanRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscGetContractCapitalPlanListAbilityService;
import com.tydic.fsc.common.ability.api.FscUnifySettleTokenAbilityService;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscGetContractCapitalPlanListBo;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityReqBO;
import com.tydic.fsc.common.ability.bo.QryUnifySettleTokenAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscContractCapitalPlanMapper;
import com.tydic.fsc.dao.FscDraftInfoMapper;
import com.tydic.fsc.dao.FscOperateCapitalPlanMapper;
import com.tydic.fsc.dao.FscOrderExtMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPlanPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillDetailAssemblyAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillDetailAssemblyAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillDetailAssemblyAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscUnifySettlePayBillUpdateBusiService;
import com.tydic.fsc.pay.busi.bo.FscUnifySettlePayBillUpdateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscUnifySettlePayBillUpdateBusiRspBO;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscContractCapitalPlanPo;
import com.tydic.fsc.po.FscOperateCapitalPlanPO;
import com.tydic.fsc.po.FscOrderExtPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPlanPayItemPo;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettlePersonQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscUnifySettlePayBillUpdateBusiServiceImpl
implements FscUnifySettlePayBillUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscUnifySettlePayBillUpdateBusiServiceImpl.class);
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Resource
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscContractCapitalPlanMapper fscContractCapitalPlanMapper;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscGetContractCapitalPlanListAbilityService fscGetContractCapitalPlanListAbilityService;
    @Autowired
    private FscOrderExtMapper fscOrderExtMapper;
    @Autowired
    private FscPlanPayItemMapper fscPlanPayItemMapper;
    @Autowired
    private FscDraftInfoMapper fscDraftInfoMapper;
    @Autowired
    private FscOperateCapitalPlanMapper fscOperateCapitalPlanMapper;
    @Autowired
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private FscUnifySettleTokenAbilityService fscUnifySettleTokenAbilityService;
    public static final String BUSI_NAME = "\u652f\u4ed8\u5355\u5220\u9664";
    public static final String BUSI_CODE = "1199";
    @Autowired
    private FscPayBillDetailAssemblyAtomService fscPayBillDetailAssemblyAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;

    @Override
    public FscUnifySettlePayBillUpdateBusiRspBO dealUnifySettlePayBillUpdate(FscUnifySettlePayBillUpdateBusiReqBO busiReqBO) {
        this.vail(busiReqBO);
        FscOrderPO set = new FscOrderPO();
        if (!CollectionUtils.isEmpty(busiReqBO.getFscOrderPayItemBOS())) {
            BigDecimal totalAmount = this.updateShouldPay(busiReqBO);
            set.setTotalCharge(totalAmount);
            set.setToPayAmount(totalAmount);
        }
        set.setPayMethod(busiReqBO.getPayMethod());
        set.setPayChannel(busiReqBO.getPayChannel());
        set.setUpdateOperId(busiReqBO.getUserName());
        set.setUpdateOperName(busiReqBO.getName());
        set.setUpdateTime(new Date());
        set.setRemark(busiReqBO.getRemark());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(busiReqBO.getFscOrderId());
        if (busiReqBO.getDockPaySettlePlatFormYn() != null && busiReqBO.getDockPaySettlePlatFormYn() == 1) {
            where.setOrderStates(Arrays.asList(1203, 1204));
        } else {
            where.setOrderStates(Arrays.asList(1099, 1));
        }
        if (where.getFscOrderId() == null) {
            throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        }
        int count = this.fscOrderMapper.updateBy(set, where);
        if (count != 1) {
            throw new FscBusinessException("193204", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u662f\u8349\u7a3f\u72b6\u6001");
        }
        this.insertAttachment(busiReqBO.getAttachmentList(), busiReqBO.getFscOrderId());
        this.updateExt(busiReqBO);
        FscUnifySettlePayBillUpdateBusiRspBO busiRspBO = new FscUnifySettlePayBillUpdateBusiRspBO();
        if (!"1".equals(busiReqBO.getSaveOrSubmit())) {
            if (Objects.isNull(busiReqBO.getPaySource()) || !"1".equals(busiReqBO.getPaySource())) {
                if (busiReqBO.getDockPaySettlePlatFormYn() != null && busiReqBO.getDockPaySettlePlatFormYn() == 2 && !CollectionUtils.isEmpty(busiReqBO.getFscOrderPayItemBOS())) {
                    this.updateContractPlanItem(busiReqBO, 2);
                }
                this.occupyFundsPlan(busiReqBO, busiReqBO.getFscOrderId());
                this.invokeFscOrderStatusFlow(busiReqBO);
            } else {
                this.occupyFundsPlan(busiReqBO, busiReqBO.getFscOrderId());
            }
        } else if (!(!Objects.isNull(busiReqBO.getPaySource()) && "1".equals(busiReqBO.getPaySource()) || busiReqBO.getDockPaySettlePlatFormYn() == null || busiReqBO.getDockPaySettlePlatFormYn() != 2 || CollectionUtils.isEmpty(busiReqBO.getFscOrderPayItemBOS()))) {
            this.updateContractPlanItem(busiReqBO, 2);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        return busiRspBO;
    }

    private void updateContractPlanItem(FscUnifySettlePayBillUpdateBusiReqBO busiReqBO, int type) {
        FscPlanPayItemPo planPayItemPo = new FscPlanPayItemPo();
        planPayItemPo.setFscOrderId(busiReqBO.getFscOrderId());
        this.fscPlanPayItemMapper.deleteByFscOrderId(planPayItemPo);
        ArrayList<FscPlanPayItemPo> insertList = new ArrayList<FscPlanPayItemPo>();
        for (FscOrderPayItemBO itemBO : busiReqBO.getFscOrderPayItemBOS()) {
            for (FscContractPlanItemBO planItemBO : itemBO.getPlanItemBOs()) {
                FscPlanPayItemPo fscPlanPayItemPo = new FscPlanPayItemPo();
                fscPlanPayItemPo.setFscOrderId(busiReqBO.getFscOrderId());
                fscPlanPayItemPo.setShouldPayId(itemBO.getShouldPayId());
                fscPlanPayItemPo.setContractCapitalPlanId(planItemBO.getContractCapitalPlanId());
                fscPlanPayItemPo.setContractNum(planItemBO.getContractNum());
                fscPlanPayItemPo.setOccAmount(planItemBO.getOccAmount());
                fscPlanPayItemPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                if (type == 2) {
                    fscPlanPayItemPo.setType(Integer.valueOf(type));
                }
                insertList.add(fscPlanPayItemPo);
            }
        }
        int i = this.fscPlanPayItemMapper.insertBatch(insertList);
        if (i < 1) {
            throw new BusinessException("8888", "\u63d2\u5165\u8d44\u91d1\u8ba1\u5212\u5173\u8054\u8868\u5931\u8d25");
        }
    }

    private void updateExt(FscUnifySettlePayBillUpdateBusiReqBO atomReqBO) {
        FscOrderExtPO fscOrderExtPo = new FscOrderExtPO();
        if (!(atomReqBO.getDockPaySettlePlatFormYn() == null || atomReqBO.getDockPaySettlePlatFormYn() != 1 && atomReqBO.getDockPaySettlePlatFormYn() != 2 || CollectionUtils.isEmpty(atomReqBO.getFscOrderPayItemBOS()))) {
            if (atomReqBO.getUnifyOrgId() == null) {
                PebExtUnifySettleTokenQryAbilityReqBO pebExtUnifySettleTokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
                pebExtUnifySettleTokenQryAbilityReqBO.setUserId(atomReqBO.getAgentAccount());
                log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6token\u5165\u53c2:" + JSONObject.toJSONString((Object)pebExtUnifySettleTokenQryAbilityReqBO));
                PebExtUnifySettleTokenQryAbilityRspBO pebExtUnifySettleTokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(pebExtUnifySettleTokenQryAbilityReqBO);
                log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6token\u51fa\u53c2:" + JSONObject.toJSONString((Object)pebExtUnifySettleTokenQryAbilityRspBO));
                if (pebExtUnifySettleTokenQryAbilityRspBO == null || StringUtils.isEmpty((Object)pebExtUnifySettleTokenQryAbilityRspBO.getData())) {
                    throw new BusinessException("8888", "\u83b7\u53d6token\u5931\u8d25");
                }
                PebExtUnifySettlePersonQryAbilityReqBO settlePersonQryAbilityReqBO = new PebExtUnifySettlePersonQryAbilityReqBO();
                settlePersonQryAbilityReqBO.setToken(pebExtUnifySettleTokenQryAbilityRspBO.getData());
                settlePersonQryAbilityReqBO.setUSER_NAME(atomReqBO.getAgentAccount());
                log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u4fe1\u606f\u5165\u53c2:" + JSONObject.toJSONString((Object)settlePersonQryAbilityReqBO));
                PebExtUnifySettlePersonQryAbilityRspBO pebExtUnifySettlePersonQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonInfo(settlePersonQryAbilityReqBO);
                log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u4fe1\u606f\u51fa\u53c2:" + JSONObject.toJSONString((Object)settlePersonQryAbilityReqBO));
                if (!"0000".equals(pebExtUnifySettleTokenQryAbilityRspBO.getRespCode())) {
                    throw new BusinessException("8888", pebExtUnifySettlePersonQryAbilityRspBO.getRespDesc());
                }
                if (CollectionUtils.isEmpty((Collection)pebExtUnifySettlePersonQryAbilityRspBO.getRows())) {
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u4fe1\u606f");
                }
                if (((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getSUB_ORG_ID() == null) {
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7edf\u4e00\u7ed3\u7b97\u4eba\u5458\u673a\u6784ID\u4fe1\u606f");
                }
                fscOrderExtPo.setUnifyOrgId(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getSUB_ORG_ID());
                fscOrderExtPo.setUnifyOrgName(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getSUB_ORG_NAME());
                fscOrderExtPo.setUnifyComCode(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getCOM_CODE());
                fscOrderExtPo.setUnifyDeptId(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getDEPT_ID());
                fscOrderExtPo.setUnifyDeptName(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getDEPT_NAME());
                fscOrderExtPo.setUnifyUserId(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getPERSON_ID());
                fscOrderExtPo.setUnifyUserName(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getPERSON_NAME());
                if (((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getUSER_ID() != null) {
                    fscOrderExtPo.setExt1(String.valueOf(((PebExtUnifySettlePersonBO)pebExtUnifySettlePersonQryAbilityRspBO.getRows().get(0)).getUSER_ID()));
                }
                fscOrderExtPo.setExt2(atomReqBO.getUnifyBusinessNature());
            } else {
                fscOrderExtPo.setUnifyOrgId(atomReqBO.getUnifyOrgId());
                fscOrderExtPo.setUnifyOrgName(atomReqBO.getUnifyOrgName());
                fscOrderExtPo.setUnifyComCode(atomReqBO.getUnifyComCode());
                fscOrderExtPo.setUnifyDeptId(atomReqBO.getUnifyDeptId());
                fscOrderExtPo.setUnifyDeptName(atomReqBO.getUnifyDeptName());
                fscOrderExtPo.setUnifyUserId(atomReqBO.getUnifyUserId());
                fscOrderExtPo.setUnifyUserName(atomReqBO.getUnifyUserName());
                fscOrderExtPo.setExt1(atomReqBO.getHandlerUserId());
                fscOrderExtPo.setExt2(atomReqBO.getUnifyBusinessNature());
                fscOrderExtPo.setExt3(atomReqBO.getColmunCode());
                fscOrderExtPo.setExt4(atomReqBO.getColmunName());
                fscOrderExtPo.setFuncAccountId(atomReqBO.getFuncAccountId());
                fscOrderExtPo.setFuncAccountName(atomReqBO.getFuncAccountName());
                fscOrderExtPo.setPaySource("1");
            }
            fscOrderExtPo.setAgentAccount(atomReqBO.getAgentAccount());
        }
        if (atomReqBO.getPayDate() != null || atomReqBO.getIsEquipPurchase() != null) {
            fscOrderExtPo.setFscOrderId(atomReqBO.getFscOrderId());
            fscOrderExtPo.setPayDate(atomReqBO.getPayDate());
            fscOrderExtPo.setIsEquipPurchase(atomReqBO.getIsEquipPurchase());
            int insert = this.fscOrderExtMapper.updateByFscOrderId(fscOrderExtPo);
            if (insert < 1) {
                throw new BusinessException("8888", "\u4fee\u6539\u4fe1\u606f\u6269\u5c55\u8868\u5931\u8d25");
            }
        }
    }

    private void vail(FscUnifySettlePayBillUpdateBusiReqBO busiReqBO) {
        Boolean IsDock = false;
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = new UmcEnterpriseOrgQryDetailAbilityRspBO();
        if ("1".equals(busiReqBO.getIsprofess())) {
            UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(busiReqBO.getOrgId());
            umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
            if (!"0000".equals(umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode()) || umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
                throw new FscBusinessException("191000", "\u7528\u6237\u673a\u6784\u67e5\u8be2\u5931\u8d25");
            }
            if (umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn() != null && umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getDockPaySettlePlatFormYn() == 1) {
                IsDock = true;
                busiReqBO.setDockPaySettlePlatFormYn(1);
            }
        }
        Boolean finalIsDock = IsDock;
        busiReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
            if (finalIsDock.booleanValue()) {
                if (CollectionUtils.isEmpty((Collection)fscOrderPayItemBO.getPlanItemBOs())) {
                    throw new FscBusinessException("191000", "\u8d44\u91d1\u8ba1\u5212\u4e3a\u7a7a");
                }
                for (FscContractPlanItemBO itemBO : fscOrderPayItemBO.getPlanItemBOs()) {
                    if (itemBO.getContractCapitalPlanId() == null) {
                        throw new FscBusinessException("191000", "\u8d44\u91d1\u8ba1\u5212ID\u4e3a\u7a7a");
                    }
                    if (itemBO.getOccAmount() != null) continue;
                    throw new FscBusinessException("191000", "\u8d44\u91d1\u8ba1\u5212\u5360\u7528\u91d1\u989d\u4e3a\u7a7a");
                }
            }
        });
        if (finalIsDock.booleanValue()) {
            ArrayList contractCapitalPlanIds = new ArrayList();
            for (FscOrderPayItemBO itemBO : busiReqBO.getFscOrderPayItemBOS()) {
                List planIds = itemBO.getPlanItemBOs().stream().map(e -> e.getContractCapitalPlanId()).collect(Collectors.toList());
                contractCapitalPlanIds.addAll(planIds);
            }
            FscContractCapitalPlanPo contractCapitalPlanQryPo = new FscContractCapitalPlanPo();
            contractCapitalPlanQryPo.setIds(contractCapitalPlanIds);
            List contractCapitalPlanPos = this.fscContractCapitalPlanMapper.getList(contractCapitalPlanQryPo);
            if (CollectionUtils.isEmpty((Collection)contractCapitalPlanPos)) {
                throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u8d44\u91d1\u8ba1\u5212");
            }
            FscGetContractCapitalPlanListAbilityReqBO fscGetContractCapitalPlanListAbilityReqBO = new FscGetContractCapitalPlanListAbilityReqBO();
            fscGetContractCapitalPlanListAbilityReqBO.setContractCapitalPlanIds(contractCapitalPlanIds);
            fscGetContractCapitalPlanListAbilityReqBO.setAgentAccount(busiReqBO.getAgentAccount());
            FscGetContractCapitalPlanListAbilityRspBO contractCapitalPlanList = this.fscGetContractCapitalPlanListAbilityService.getContractCapitalPlanList(fscGetContractCapitalPlanListAbilityReqBO);
            if (CollectionUtils.isEmpty((Collection)contractCapitalPlanList.getRows())) {
                throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u8d44\u91d1\u8ba1\u5212");
            }
            Map capitalPlanPoMap = contractCapitalPlanList.getRows().stream().collect(Collectors.toMap(e -> e.getId(), Function.identity()));
            HashMap<Long, BigDecimal> planOccMap = new HashMap<Long, BigDecimal>();
            for (FscOrderPayItemBO itemBO : busiReqBO.getFscOrderPayItemBOS()) {
                for (FscContractPlanItemBO planItemBO : itemBO.getPlanItemBOs()) {
                    if (!capitalPlanPoMap.containsKey(planItemBO.getContractCapitalPlanId())) {
                        throw new FscBusinessException("191000", "\u672a\u67e5\u8be2\u5230\u8d44\u91d1\u8ba1\u5212");
                    }
                    planItemBO.setContractNum(((FscGetContractCapitalPlanListBo)capitalPlanPoMap.get(planItemBO.getContractCapitalPlanId())).getContractNum());
                    if (planOccMap.containsKey(planItemBO.getContractCapitalPlanId())) {
                        BigDecimal occAmt = (BigDecimal)planOccMap.get(planItemBO.getContractCapitalPlanId());
                        occAmt = occAmt.add(planItemBO.getOccAmount());
                        planOccMap.put(planItemBO.getContractCapitalPlanId(), occAmt);
                        continue;
                    }
                    planOccMap.put(planItemBO.getContractCapitalPlanId(), planItemBO.getOccAmount());
                }
            }
            for (FscGetContractCapitalPlanListBo capitalPlanPo : contractCapitalPlanList.getRows()) {
                if (!planOccMap.containsKey(capitalPlanPo.getId()) || ((BigDecimal)planOccMap.get(capitalPlanPo.getId())).compareTo(capitalPlanPo.getAmount()) <= 0) continue;
                throw new FscBusinessException("191000", "\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u8db3");
            }
        }
    }

    private BigDecimal updateShouldPay(FscUnifySettlePayBillUpdateBusiReqBO busiReqBO) {
        try {
            FscPayBillDetailAssemblyAtomReqBO assemblyAtomReqBO = (FscPayBillDetailAssemblyAtomReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)busiReqBO)), FscPayBillDetailAssemblyAtomReqBO.class));
            assemblyAtomReqBO.setPayOrderId(busiReqBO.getFscOrderId());
            FscPayBillDetailAssemblyAtomRspBO fscPayBillDetailAssemblyAtomRspBO = this.fscPayBillDetailAssemblyAtomService.dealPayBillDetailAssembly(assemblyAtomReqBO);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        BigDecimal totalAmount = new BigDecimal(0);
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        FscOrderPayItemPO orderPayItemPO = new FscOrderPayItemPO();
        orderPayItemPO.setFscOrderId(busiReqBO.getFscOrderId());
        List list = this.fscOrderPayItemMapper.getListWithShouldPay(orderPayItemPO);
        Map<Long, FscOrderPayItemPO> map = list.stream().collect(Collectors.toMap(FscOrderPayItemPO::getShouldPayId, fscOrderPayItemPO -> fscOrderPayItemPO));
        for (FscOrderPayItemBO fscOrderPayItemBO : busiReqBO.getFscOrderPayItemBOS()) {
            FscOrderPayDetailPO fscOrderPayDetailPO;
            BigDecimal currentPayAmount = fscOrderPayItemBO.getPayAmount();
            totalAmount = totalAmount.add(fscOrderPayItemBO.getPayAmount());
            FscOrderPayItemPO fscOrderPayItemPO2 = map.get(fscOrderPayItemBO.getShouldPayId());
            BigDecimal payAmt = fscOrderPayItemPO2.getPayAmount();
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            fscShouldPayPO.setObjectId(fscOrderPayItemPO2.getObjectId());
            fscShouldPayPO.setObjectType(fscOrderPayItemPO2.getObjectType());
            if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemBO.getFscBillOrderIdList())) {
                fscShouldPayPO.setObjectId(null);
                fscShouldPayPO.setSettleId((Long)fscOrderPayItemBO.getFscBillOrderIdList().get(0));
            }
            if (busiReqBO.getShouldPayMethod() == 2 && !CollectionUtils.isEmpty((Collection)fscOrderPayItemBO.getFscBillOrderIdList()) && !"2".equals(fscOrderPayItemPO2.getInspExecution())) {
                fscShouldPayPO.setObjectType(Integer.valueOf(8));
            } else if (busiReqBO.getShouldPayMethod() == 2 && fscOrderPayItemPO2.getShouldPayType() != null && fscOrderPayItemPO2.getShouldPayType() == 16) {
                Long fscOrderPO = this.fscOrderMapper.getOrderIdByNo(busiReqBO.getOrderNo());
                fscShouldPayPO.setSettleId(fscOrderPO != null ? fscOrderPO : fscShouldPayPO.getSettleId());
            }
            if (Objects.nonNull(payAmt)) {
                fscShouldPayPO.setPayAmount(fscOrderPayItemBO.getPayAmount().subtract(payAmt));
            } else {
                fscShouldPayPO.setPayAmount(fscOrderPayItemBO.getPayAmount());
            }
            int count1 = this.fscShouldPayMapper.updateAmount(fscShouldPayPO);
            if (count1 != 1) {
                throw new FscBusinessException("193204", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemBO.getFscBillOrderIdList())) {
                fscOrderPayDetailPO = new FscOrderPayDetailPO();
                fscOrderPayDetailPO.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
                fscOrderPayDetailPO.setFscOrderId(busiReqBO.getFscOrderId());
                fscOrderPayDetailPO.setSettleType(FscConstants.SettleType.ORDER);
                List fscOrderPayDetailPOList = this.fscOrderPayDetailMapper.queryListWithSettleId(fscOrderPayDetailPO);
                if (!CollectionUtils.isEmpty((Collection)fscOrderPayDetailPOList)) {
                    fscOrderPayDetailPOList.stream().filter(e -> Objects.nonNull(e.getSettleId())).forEach(e -> {
                        FscOrderPO req = new FscOrderPO();
                        req.setFscOrderId(e.getSettleId());
                        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(req);
                        if (Objects.nonNull(fscOrderPO)) {
                            fscOrderPO.setToPayAmount(fscOrderPO.getToPayAmount().add(e.getPayAmount()));
                            fscOrderPO.setPayingAmount(fscOrderPO.getPayingAmount().subtract(e.getPayAmount()));
                            this.fscOrderMapper.updateById(fscOrderPO);
                        }
                    });
                }
            }
            fscOrderPayDetailPO = new FscOrderPayDetailPO();
            fscOrderPayDetailPO.setFscOrderId(busiReqBO.getFscOrderId());
            fscOrderPayDetailPO.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            this.fscOrderPayDetailMapper.deleteByFscOrderId(fscOrderPayDetailPO);
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            this.handlePayDetail(fscShouldPayPO, busiReqBO, fscOrderPayItemBO, po);
            po.setFscOrderId(busiReqBO.getFscOrderId());
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            po.setPayAmount(currentPayAmount);
            po.setShouldPayMethod(busiReqBO.getShouldPayMethod());
            po.setShouldPayItemNo(fscOrderPayItemBO.getShouldPayItemNo());
            if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemBO.getFscBillOrderIdList())) {
                po.setSettleId((Long)fscOrderPayItemBO.getFscBillOrderIdList().get(0));
            }
            fscOrderPayItemPOs.add(po);
        }
        FscOrderPayItemPO fscOrderPayItemPO3 = new FscOrderPayItemPO();
        fscOrderPayItemPO3.setFscOrderId(busiReqBO.getFscOrderId());
        this.fscOrderPayItemMapper.deleteBy(fscOrderPayItemPO3);
        if (!CollectionUtils.isEmpty(fscOrderPayItemPOs)) {
            this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        }
        return totalAmount;
    }

    public void handlePayDetail(FscShouldPayPO fscShouldPayPO, FscUnifySettlePayBillUpdateBusiReqBO busiReqBO, FscOrderPayItemBO fscOrderPayItemBO, FscOrderPayItemPO po) {
        int count;
        ArrayList fscOrderPayDetailPOList = new ArrayList();
        FscShouldPayPO shouldPay = this.fscShouldPayMapper.getModelBy(fscShouldPayPO);
        if (Objects.isNull(shouldPay.getOrderId())) {
            log.error("\u5f53\u524d\u5e94\u4ed8\u5355\u65e0\u8ba2\u5355\u53f7\u4fe1\u606f");
        }
        if (FscConstants.SettleType.ORDER.equals(busiReqBO.getSettleType()) && FscPayTypeEnum.ADVANCE_PAY.getCode().equals(busiReqBO.getShouldPayMethod())) {
            FscOrderRelationPO fscOrderRelationPO = this.fscOrderRelationMapper.getByOrderId(shouldPay.getOrderId());
            if (shouldPay.getToPayAmount().subtract(fscOrderRelationPO.getSettleAmt()).compareTo(fscOrderPayItemBO.getPayAmount()) < 0) {
                throw new FscBusinessException("194203", shouldPay.getOrderNo() + "\u8ba2\u5355\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\uff0c\u5f53\u524d\u9009\u62e9\u9884\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\uff08\u8ba2\u5355\u5e94\u4ed8\u91d1\u989d-\u5df2\u5f00\u7968\u91d1\u989d\uff09");
            }
        }
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setPageSize(1000);
        saleDetailsReqBO.setOrderId(shouldPay.getOrderId());
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setIndividually("1");
        log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)saleDetailsReqBO));
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        FscOrderPayDetailPO fscOrderPayDetailPOReq = new FscOrderPayDetailPO();
        fscOrderPayDetailPOReq.setOrderId(shouldPay.getOrderId());
        fscOrderPayDetailPOReq.setRelType("0".equals(busiReqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
        List payDetailPOList = this.fscOrderPayDetailMapper.queryList(fscOrderPayDetailPOReq);
        Map<Object, Object> payDetailMap = !CollectionUtils.isEmpty((Collection)payDetailPOList) ? payDetailPOList.stream().collect(Collectors.groupingBy(FscOrderPayDetailPO::getOrderId, Collectors.mapping(FscOrderPayDetailPO::getPayAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))) : new HashMap();
        shouldPay.setPayAmount(fscOrderPayItemBO.getPayAmount());
        saleDetailsRspBO.getRows().forEach(e -> ((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderItemList().forEach(item -> {
            if (shouldPay.getPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
                return;
            }
            BigDecimal orderAmount = Objects.nonNull(busiReqBO.getIsprofess()) && "0".equals(busiReqBO.getIsprofess()) ? new BigDecimal(item.getPurchaseFeeMoney()) : new BigDecimal(item.getSaleFeeMoney());
            BigDecimal initOrderAmt = orderAmount;
            BigDecimal payOrderAmount = BigDecimal.ZERO;
            if (Objects.nonNull(payDetailMap.get(Long.valueOf(item.getOrderItemId())))) {
                payOrderAmount = (BigDecimal)payDetailMap.get(Long.valueOf(item.getOrderItemId()));
            }
            if (BigDecimal.ZERO.compareTo(orderAmount = orderAmount.subtract(payOrderAmount)) == 0) {
                return;
            }
            FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
            fscOrderPayDetailPO.setPayDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderPayDetailPO.setSettleType(busiReqBO.getSettleType());
            fscOrderPayDetailPO.setOrderId(Objects.isNull(e.getOrderId()) ? null : Long.valueOf(e.getOrderId()));
            fscOrderPayDetailPO.setOrderItemId(Objects.isNull(item.getOrderItemId()) ? null : Long.valueOf(item.getOrderItemId()));
            fscOrderPayDetailPO.setSaleVoucherId(Objects.isNull(e.getSaleVoucherId()) ? null : Long.valueOf(e.getSaleVoucherId()));
            fscOrderPayDetailPO.setFscOrderId(busiReqBO.getFscOrderId());
            fscOrderPayDetailPO.setShouldPayId(fscShouldPayPO.getShouldPayId());
            fscOrderPayDetailPO.setOrderAmount(initOrderAmt);
            fscOrderPayDetailPO.setBeforeLeaveAmount(orderAmount);
            fscOrderPayDetailPO.setRelType("0".equals(busiReqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
            fscOrderPayDetailPO.setCreateId(Objects.nonNull(busiReqBO.getUserId()) ? busiReqBO.getUserId().toString() : "");
            fscOrderPayDetailPO.setCreateTime(new Date());
            fscOrderPayDetailPO.setUpdateId(Objects.nonNull(busiReqBO.getUserId()) ? busiReqBO.getUserId().toString() : "");
            fscOrderPayDetailPO.setUpdateTime(new Date());
            if (fscShouldPayPO.getObjectType().equals(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER)) {
                fscOrderPayDetailPO.setSettleId(fscShouldPayPO.getObjectId());
            } else {
                fscOrderPayDetailPO.setSettleId(fscShouldPayPO.getSettleId());
            }
            if (fscOrderPayItemBO.getPayAmount().compareTo(orderAmount) > 0) {
                fscOrderPayDetailPO.setPayAmount(orderAmount);
                fscOrderPayItemBO.setPayAmount(fscOrderPayItemBO.getPayAmount().subtract(orderAmount));
            } else {
                fscOrderPayDetailPO.setPayAmount(fscOrderPayItemBO.getPayAmount());
                fscOrderPayItemBO.setPayAmount(BigDecimal.ZERO);
            }
            fscOrderPayDetailPOList.add(fscOrderPayDetailPO);
        }));
        if (!CollectionUtils.isEmpty(fscOrderPayDetailPOList) && (count = this.fscOrderPayDetailMapper.insertBatch(fscOrderPayDetailPOList)) == 0) {
            throw new FscBusinessException("194203", "\u63d2\u5165\u8ba2\u5355\u652f\u4ed8\u660e\u7ec6\u5f02\u5e38");
        }
    }

    private void invokeFscOrderStatusFlow(FscUnifySettlePayBillUpdateBusiReqBO busiReqBO) {
        HashMap<String, Integer> paramMap;
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("fscPayApplyOrder");
        if (busiReqBO.getDockPaySettlePlatFormYn() != null && busiReqBO.getDockPaySettlePlatFormYn() == 2) {
            uacNoTaskAuditCreateReqBO.setMenuId(null);
            if (busiReqBO.getBusiCode() != null) {
                uacNoTaskAuditCreateReqBO.setProcDefKey(busiReqBO.getBusiCode());
            } else {
                uacNoTaskAuditCreateReqBO.setMenuId("M001013");
            }
        }
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(busiReqBO.getFscOrderId());
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(busiReqBO.getFscOrderId().toString());
        approvalObjBO.setObjName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        BigDecimal payAmount = BigDecimal.ZERO;
        for (FscOrderPayItemBO payItem : busiReqBO.getFscOrderPayItemBOS()) {
            payAmount = payAmount.add(payItem.getPayAmount());
        }
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("payAmount", payAmount);
        Long shouldPayId = busiReqBO.getFscOrderPayItemBOS().get(0).getShouldPayId();
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setShouldPayId(shouldPayId);
        FscShouldPayPO model = this.fscShouldPayMapper.getModelBy(fscShouldPayPo);
        if (model.getShouldPayType().equals(FscConstants.ShouldPayType.ADVANCE_PAY) || model.getShouldPayType().equals(FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY) || model.getShouldPayType().equals(FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY) || model.getShouldPayType().equals(FscConstants.ShouldPayType.PAYMENT_PRE_PAY)) {
            variables.put("payType", 1);
        } else {
            variables.put("payType", 2);
        }
        uacNoTaskAuditCreateReqBO.setVariables(variables);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("193204", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        if (!uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            paramMap = new HashMap<String, Integer>();
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        }
        if (!uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            paramMap = new HashMap();
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        }
        fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.CANCEL);
        fscOrderStatusFlowAtomReqBO.setOrderId(busiReqBO.getFscOrderId());
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193204", atomRspBO.getRespDesc());
        }
        try {
            this.taskTodoWaitService.syncNotifyPayBillWaitDone(busiReqBO.getFscOrderId());
        }
        catch (Exception e) {
            log.error("dealPayBillCreate -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
        }
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        if (!CollectionUtils.isEmpty(attachmentBOList)) {
            FscAttachmentPO deletPo = new FscAttachmentPO();
            deletPo.setFscOrderId(fscOrderId);
            deletPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
            ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletPo);
            if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
                this.fscAttachmentMapper.deleteBy(deletPo);
            }
            fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : attachmentBOList) {
                FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPo.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                fscAttachmentPo.setAttachmentName(attachmentBO.getAttachmentName());
                fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAYMENT);
                fscAttachmentPo.setObjId(fscOrderId);
                fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
                fscAttachmentPo.setFscOrderId(fscOrderId);
                fscAttachmentPOS.add(fscAttachmentPo);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        }
    }

    private void occupyFundsPlan(FscUnifySettlePayBillUpdateBusiReqBO atomReqBO, Long fscOrderId) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPO);
        atomReqBO.setTradeMode(fscOrder.getTradeMode());
        if (!CollectionUtils.isEmpty(atomReqBO.getFscOrderPayItemBOS()) && atomReqBO.getDockPaySettlePlatFormYn() != null && atomReqBO.getDockPaySettlePlatFormYn() == 2 && atomReqBO.getTradeMode() != null && atomReqBO.getTradeMode() == 2) {
            List list = this.fscOperateCapitalPlanMapper.getListByFscOrderId(fscOrderId);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            FscBillDealPushLogAbilityReqBO logReqBO = new FscBillDealPushLogAbilityReqBO();
            logReqBO.setPushStatus(Integer.valueOf(0));
            logReqBO.setObjectId(fscOrderId);
            logReqBO.setCreateTime(new Date());
            logReqBO.setType(FscConstants.FscPushType.FSC_NEW_OCCUPY_PLAN);
            FscOrderExtPO orderExtPO = new FscOrderExtPO();
            orderExtPO.setFscOrderId(fscOrderId);
            orderExtPO = this.fscOrderExtMapper.getModelBy(orderExtPO);
            try {
                QryUnifySettleTokenAbilityReqBO qryUnifySettleTokenReqBO = new QryUnifySettleTokenAbilityReqBO();
                qryUnifySettleTokenReqBO.setUserId(atomReqBO.getAgentAccount());
                QryUnifySettleTokenAbilityRspBO qryUnifySettleTokenAbilityRspBO = this.fscUnifySettleTokenAbilityService.qryToken(qryUnifySettleTokenReqBO);
                if (!qryUnifySettleTokenAbilityRspBO.getRespCode().equals("0000")) {
                    throw new FscBusinessException(qryUnifySettleTokenAbilityRspBO.getRespCode(), "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7528\u6237token\u4fe1\u606f\u5931\u8d25\uff1a" + qryUnifySettleTokenAbilityRspBO.getMsg());
                }
                logReqBO.setObjectNo(fscOrder.getOrderNo());
                FscUnifySettleFundingPlanReqBO planReqBO = new FscUnifySettleFundingPlanReqBO();
                JSONObject jsonObject = new JSONObject();
                JSONArray jsonArray = new JSONArray();
                for (FscOperateCapitalPlanPO x : list) {
                    JSONObject bo = new JSONObject();
                    bo.put("period", (Object)x.getPeriod());
                    bo.put("itemId", (Object)x.getItemId());
                    bo.put("itemName", (Object)x.getItemName());
                    bo.put("controlMode", (Object)x.getControlMode());
                    bo.put("exeType", (Object)"ZY");
                    bo.put("planAmount", (Object)x.getPlanAmount());
                    bo.put("amount", (Object)x.getUseAmount());
                    bo.put("fromSource", (Object)"EBAY");
                    bo.put("contractNum", (Object)x.getContractNum());
                    if ("BILL".equals(x.getControlMode())) {
                        bo.put("billId", (Object)fscOrderId);
                        bo.put("billNum", (Object)fscOrder.getOrderNo());
                    }
                    bo.put("recOrgName", (Object)fscOrder.getPayeeName());
                    bo.put("fromBillId", (Object)(fscOrderId + ""));
                    bo.put("fromBillLineId", (Object)x.getId());
                    bo.put("deptId", (Object)x.getDeptId());
                    bo.put("deptName", (Object)x.getDeptName());
                    bo.put("orgId", x.getOrgId() != null ? x.getOrgId() : orderExtPO.getUnifyOrgId());
                    bo.put("billType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "HTJS"));
                    bo.put("fromBillType", (Object)("YFK".equals(x.getBillType()) ? "YFK" : "FK"));
                    jsonArray.add((Object)bo);
                }
                jsonObject.put("head", (Object)jsonArray);
                JSONArray jsonArray1 = new JSONArray();
                jsonArray1.add((Object)jsonObject);
                logReqBO.setPushData(jsonArray1.toJSONString());
                planReqBO.setJsonObject(jsonArray1);
                planReqBO.setToken(qryUnifySettleTokenAbilityRspBO.getData());
                FscUnifySettleFundingPlanRspBO fundingPlanRspBO = this.fscUnifySettleRelatedInterfacesAtomService.occupyFundsEabyUpdateState(planReqBO);
                logReqBO.setPushParseData(fundingPlanRspBO.getPushParseData());
                logReqBO.setRespData(fundingPlanRspBO.getRespData());
                logReqBO.setRespParseData(fundingPlanRspBO.getRespParseData());
                if (!"0000".equals(fundingPlanRspBO.getRespCode())) {
                    throw new FscBusinessException("190000", "\u5360\u7528/\u91ca\u653e\u8d44\u91d1\u8ba1\u5212\u5931\u8d25\uff1a" + fundingPlanRspBO.getRespData());
                }
                logReqBO.setPushStatus(Integer.valueOf(1));
            }
            catch (Exception e) {
                this.fscBillAddPushLogAbilityService.savePurchasePushLog(logReqBO);
                throw new FscBusinessException("190000", e.getMessage());
            }
            this.fscBillAddPushLogAbilityService.savePurchasePushLog(logReqBO);
        }
    }
}

