/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPayItemSerialMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.FscFinancePayBillCreateReqBO;
import com.tydic.fsc.pay.ability.bo.FscFinancePayBillCreateRspBO;
import com.tydic.fsc.pay.busi.api.finance.FscFinancePayBillCreateBusiService;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscPayItemSerialPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderItemAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinancePayBillCreateBusiServiceImpl
implements FscFinancePayBillCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePayBillCreateBusiServiceImpl.class);
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscPayItemSerialMapper fscPayItemSerialMapper;
    @Autowired
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private PebExtOrderSettleTypeUpdateAbilityService pebExtOrderSettleTypeUpdateAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscFinanceCapitalInfoAtomService fscFinanceCapitalInfoAtomService;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;

    @Override
    public FscFinancePayBillCreateRspBO dealFinancePayBillCreate(FscFinancePayBillCreateReqBO reqBO) {
        FscFinancePayBillCreateRspBO createRspBO = new FscFinancePayBillCreateRspBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        String operationNo = String.valueOf(reqBO.getOrgId());
        if ("0".equals(reqBO.getIsprofess())) {
            String[] org;
            for (String pro : org = this.proOrg.split(",")) {
                if (!reqBO.getOrgPath().contains(pro)) continue;
                operationNo = pro;
            }
        }
        FscShouldPayPO querVo = new FscShouldPayPO();
        ArrayList<Long> shouldPayIds = new ArrayList<Long>();
        reqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> shouldPayIds.add(fscOrderPayItemBO.getShouldPayId()));
        querVo.setShouldPayIds(shouldPayIds);
        List poResult = this.fscShouldPayMapper.getList(querVo);
        if (CollectionUtils.isEmpty((Collection)poResult)) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        this.updateShouldPay(reqBO, fscOrderId, poResult, shouldPayIds);
        this.insertOrder(reqBO, fscOrderId, operationNo);
        this.insertAttachment(reqBO.getAttachmentList(), fscOrderId);
        this.insertFinanceInfo(reqBO, fscOrderId);
        List orderIdList = poResult.stream().map(FscShouldPayPO::getOrderId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(orderIdList)) {
            PebExtOrderSettleTypeUpdateAbilityReqBO settleReqBO = new PebExtOrderSettleTypeUpdateAbilityReqBO();
            settleReqBO.setUserType(UocCoreConstant.UserType.PUR);
            settleReqBO.setSettleType(FscConstants.SettleType.INSPECTION);
            settleReqBO.setOrderIds(orderIdList);
            PebExtOrderSettleTypeUpdateAbilityRspBO orderUpdateRspBO = this.pebExtOrderSettleTypeUpdateAbilityService.dealOrderSettleType(settleReqBO);
            if (!"0000".equals(orderUpdateRspBO.getRespCode())) {
                log.error("\u540c\u6b65\u8ba2\u5355\u7ed3\u7b97\u7c7b\u578b\u5931\u8d25\uff1a{}", (Object)orderUpdateRspBO.getRespDesc());
            }
        }
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            this.invokeUacNoTask(reqBO, fscOrderId);
        }
        this.insertCapitalInfo(reqBO, fscOrderId);
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            try {
                FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
                taskPo.setFscOrderId(fscOrderId);
                List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
                if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                    DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
                    dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
                    DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
                    if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
                        String orderTypeStr = (String)orderTypeMap.get(reqBO.getOrderType() + "");
                        FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                        fscSendNotificationExtAtomReqBO.setTitel(reqBO.getOrderNo() + "\u4ed8\u6b3e\u7533\u8bf7\u5355_" + orderTypeStr + "_" + reqBO.getTotalAmount().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                        fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355" + reqBO.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                        fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                        fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                        this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
                    }
                }
                this.taskTodoWaitService.syncNotifyPayBillWaitDone(fscOrderId);
            }
            catch (Exception e) {
                log.error("dealPayBillCreate -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
            }
        }
        createRspBO.setFscOrderId(fscOrderId);
        createRspBO.setRespCode("0000");
        createRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return createRspBO;
    }

    private void insertCapitalInfo(FscFinancePayBillCreateReqBO reqBO, Long fscOrderId) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(fscOrderId);
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscFinanceCapitalInfoAtomReqBO atomReqBO = (FscFinanceCapitalInfoAtomReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscFinanceCapitalInfoAtomReqBO.class);
        atomReqBO.setObjId(fscOrderId);
        atomReqBO.setObjNo(orderPO.getOrderNo());
        atomReqBO.setObjType(Integer.valueOf(1));
        atomReqBO.setFscOrderPayItemBOS(reqBO.getFscOrderPayItemBOS());
        if (!"1".equals(reqBO.getSaveOrSubmit())) {
            atomReqBO.setOperationType(Integer.valueOf(1));
        } else {
            atomReqBO.setOperationType(Integer.valueOf(0));
        }
        FscFinanceCapitalInfoAtomRspBO atomRspBO = this.fscFinanceCapitalInfoAtomService.dealFinanceCapitalInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), "\u5b58\u50a8\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
    }

    private void insertOrder(FscFinancePayBillCreateReqBO createReqBO, Long fscOrderId, String operationNo) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        if (!StringUtils.isEmpty((Object)createReqBO.getOrderNo())) {
            fscOrderPO.setOrderNo(createReqBO.getOrderNo());
        } else {
            CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
            encodedSerialGetServiceReqBO.setCenter("FSC");
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
            encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
            encodedSerialGetServiceReqBO.setOrgType("-1");
            CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
            fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
            createReqBO.setOrderNo(fscOrderPO.getOrderNo());
        }
        fscOrderPO.setOrderName(createReqBO.getOrderName());
        fscOrderPO.setPayerId(createReqBO.getPayerId());
        fscOrderPO.setPayerName(createReqBO.getPayerName());
        fscOrderPO.setPayeeId(createReqBO.getPayeeId());
        fscOrderPO.setPayeeName(createReqBO.getPayeeName());
        fscOrderPO.setPayeeAccountName(createReqBO.getPayeeAccountName());
        fscOrderPO.setPayeeBankAccount(createReqBO.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName(createReqBO.getPayeeBankName());
        if (StringUtils.isEmpty((Object)fscOrderPO.getPayeeAccountName()) || StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankAccount()) || StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankName())) {
            FscMerchantPayeePO fscMerchantPayeePO = new FscMerchantPayeePO();
            fscMerchantPayeePO.setSupplierId(createReqBO.getPayeeId());
            List fscMerchantPayeePOList = this.fscMerchantPayeeMapper.getList(fscMerchantPayeePO);
            if (!CollectionUtils.isEmpty((Collection)fscMerchantPayeePOList)) {
                fscMerchantPayeePO = (FscMerchantPayeePO)fscMerchantPayeePOList.get(0);
                fscOrderPO.setPayeeAccountName(fscMerchantPayeePO.getPayeeAccountName());
                fscOrderPO.setPayeeBankAccount(fscMerchantPayeePO.getPayeeBankAccount());
                fscOrderPO.setPayeeBankName(fscMerchantPayeePO.getPayeeBankName());
            } else {
                throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u672a\u914d\u7f6e\u6536\u6b3e\u8d26\u6237");
            }
        }
        fscOrderPO.setPayMethod(createReqBO.getPayMethod());
        fscOrderPO.setPayType(createReqBO.getPayType());
        fscOrderPO.setShouldPayType(createReqBO.getShouldPayType());
        fscOrderPO.setPayChannel(createReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(createReqBO.getUserId());
        fscOrderPO.setCreateOperName(createReqBO.getName());
        fscOrderPO.setCreateOperNo(createReqBO.getUserName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(createReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(createReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(createReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(createReqBO.getOrgName());
        fscOrderPO.setTotalCharge(createReqBO.getTotalAmount());
        fscOrderPO.setContractNo(createReqBO.getContractNo());
        fscOrderPO.setContractId(createReqBO.getContractId());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        fscOrderPO.setPaidAmount(BigDecimal.ZERO);
        fscOrderPO.setPayingAmount(BigDecimal.ZERO);
        fscOrderPO.setBuynerNo(createReqBO.getBuynerNo());
        fscOrderPO.setBuynerName(createReqBO.getBuynerName());
        fscOrderPO.setOrderType(createReqBO.getOrderType());
        fscOrderPO.setOrderSource(createReqBO.getOrderSource());
        fscOrderPO.setTradeMode(createReqBO.getTradeMode());
        fscOrderPO.setRemark(createReqBO.getRemark());
        fscOrderPO.setPaymentMethod(createReqBO.getPaymentMethod());
        fscOrderPO.setSettleType(createReqBO.getSettleType());
        if ("0".equals(createReqBO.getIsprofess())) {
            fscOrderPO.setOperatorId(createReqBO.getUserId());
            fscOrderPO.setOperatorName(createReqBO.getName());
            fscOrderPO.setOperationNo(operationNo);
            fscOrderPO.setOperationName(createReqBO.getCompanyName());
        }
        if ("3".equals(createReqBO.getPayChannel())) {
            if (null != createReqBO.getUserId()) {
                fscOrderPO.setPayOperId(createReqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(createReqBO.getName());
        }
        fscOrderPO.setSettlePlatform(Integer.valueOf(3));
        if ("1".equals(createReqBO.getSaveOrSubmit())) {
            fscOrderPO.setOrderState(FscConstants.FscPayOrderState.CANCEL);
        }
        String procKey = FscOrderFlowProcKeyEnum.DOWN_PAY.getDescr();
        fscOrderPO.setOrderFlowKey(procKey);
        this.fscOrderMapper.insert(fscOrderPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(fscOrderId);
        List invoicePOList = this.fscInvoiceMapper.getInvoiceByShouldPay(fscInvoicePO);
        if (CollectionUtils.isEmpty((Collection)invoicePOList)) {
            invoicePOList = this.fscInvoiceMapper.getInvoiceByAdvance(fscInvoicePO);
        }
        StringBuilder invoiceNo = new StringBuilder();
        StringBuilder invoiceCode = new StringBuilder();
        log.debug("invoicePoList:{}", (Object)JSONObject.toJSONString((Object)invoicePOList));
        if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
            boolean flag = false;
            for (FscInvoicePO po : invoicePOList) {
                if (po == null) continue;
                flag = true;
                invoiceNo.append(po.getInvoiceNo()).append(",");
                invoiceCode.append(po.getInvoiceCode()).append(",");
            }
            if (flag) {
                fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderId);
                fscOrderPO.setInvoiceNo(invoiceNo.toString());
                fscOrderPO.setInvoiceCode(invoiceCode.toString());
                this.fscOrderMapper.updateById(fscOrderPO);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateShouldPay(FscFinancePayBillCreateReqBO busiReqBO, Long fscOrderId, List<FscShouldPayPO> poResult, List<Long> shouldPayIds) {
        List orderIdList;
        HashSet shouldPayType = new HashSet();
        HashSet payerIds = new HashSet();
        HashSet payeeIds = new HashSet();
        HashSet contractNos = new HashSet();
        HashSet payType = new HashSet();
        poResult.forEach(fscShouldPayPO -> {
            if (null != fscShouldPayPO.getShouldPayType()) {
                shouldPayType.add(fscShouldPayPO.getShouldPayType());
                busiReqBO.setShouldPayType(fscShouldPayPO.getShouldPayType());
            }
            if (null != fscShouldPayPO.getPayerId()) {
                payerIds.add(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerId(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerName(fscShouldPayPO.getPayerName());
            }
            if (null != fscShouldPayPO.getPayeeId()) {
                payeeIds.add(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeId(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeName(fscShouldPayPO.getPayeeName());
            }
            if (null != fscShouldPayPO.getPayType()) {
                payType.add(fscShouldPayPO.getPayType());
                busiReqBO.setPayType(fscShouldPayPO.getPayType());
            }
            if (StringUtils.hasText((String)fscShouldPayPO.getContractNo())) {
                contractNos.add(fscShouldPayPO.getContractNo());
                busiReqBO.setContractNo(fscShouldPayPO.getContractNo());
            }
            if (fscShouldPayPO.getContractId() != null) {
                busiReqBO.setContractId(fscShouldPayPO.getContractId());
            }
            if (!StringUtils.isEmpty((Object)fscShouldPayPO.getBuyerNo())) {
                busiReqBO.setBuynerNo(fscShouldPayPO.getBuyerNo());
            }
            if (!StringUtils.isEmpty((Object)fscShouldPayPO.getBuyerName())) {
                busiReqBO.setBuynerName(fscShouldPayPO.getBuyerName());
            }
        });
        if (payerIds.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payType.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5f0f\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (contractNos.size() > 1) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(orderIdList = poResult.stream().map(FscShouldPayPO::getOrderId).collect(Collectors.toList()))) {
            FscShouldPayPO fscShouldPayPOReq = new FscShouldPayPO();
            fscShouldPayPOReq.setOrderIds(orderIdList);
            fscShouldPayPOReq.setPayeeId((Long)payeeIds.iterator().next());
            fscShouldPayPOReq.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_GRADING_PAY);
            List payPOList = this.fscShouldPayMapper.getListByOrderId(fscShouldPayPOReq);
            if (!CollectionUtils.isEmpty((Collection)payPOList)) {
                String orderNo = payPOList.stream().map(FscShouldPayPO::getObjectNo).filter(objectNo -> !StringUtils.isEmpty((Object)objectNo)).distinct().collect(Collectors.joining(","));
                orderNo = StringUtils.isEmpty((Object)orderNo) ? "\u6240\u9009\u4ed8\u6b3e\u4f9d\u636e\u7f16\u53f7" : orderNo;
                throw new FscBusinessException("194203", orderNo + "\u5df2\u901a\u8fc7\u7279\u6b8a\u4ed8\u6b3e\u4e1a\u52a1\u53d1\u8d77\u4ed8\u6b3e");
            }
        }
        if (!FscConstants.ShouldPayType.PAYMENT_DAY_PAY.equals(busiReqBO.getShouldPayType()) && (FscOrderTypeEnum.INDIVIDUALLY.getCode().equals(busiReqBO.getOrderType()) || FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode().equals(busiReqBO.getOrderType()))) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setShouldPayIds(shouldPayIds);
            ArrayList<Integer> excludeOrderStates = new ArrayList<Integer>();
            excludeOrderStates.add(FscConstants.FscPayOrderState.CANCEL);
            excludeOrderStates.add(FscConstants.FscPayOrderState.DELETE);
            fscOrderPayItemPO.setExcludeOrderStates(excludeOrderStates);
            List itemPOS = this.fscOrderPayItemMapper.getListByOrder(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)itemPOS) && itemPOS.size() == shouldPayIds.size()) {
                HashSet payFscOrderIds = new HashSet();
                itemPOS.forEach(fscOrderPayItemPO1 -> payFscOrderIds.add(fscOrderPayItemPO1.getFscOrderId()));
                if (payFscOrderIds.size() != 1) throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5b58\u5728\u591a\u4e2a\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u8bf7\u5230\u4ed8\u6b3e\u7533\u8bf7\u9875\u9762\u8fdb\u884c\u652f\u4ed8\uff01");
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId((Long)payFscOrderIds.iterator().next());
                fscOrderPO.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
                FscOrderPO po = this.fscOrderMapper.getModelBy(fscOrderPO);
                if (po == null) throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5df2\u5b58\u5728\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4e14\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001\uff01");
                busiReqBO.setPayFscOrderId(po.getFscOrderId());
                FscOrderPO set = new FscOrderPO();
                FscOrderPO where = new FscOrderPO();
                set.setPayChannel(busiReqBO.getPayChannel());
                set.setPayMethod(busiReqBO.getPayMethod());
                where.setFscOrderId(po.getFscOrderId());
                fscOrderPayItemPO.setShouldPayIds(null);
                fscOrderPayItemPO.setFscOrderId(po.getFscOrderId());
                List payItemList = this.fscOrderPayItemMapper.getListByOrder(fscOrderPayItemPO);
                if (payItemList.size() != shouldPayIds.size()) {
                    int count;
                    ArrayList<Long> delPayItemIds = new ArrayList<Long>();
                    ArrayList<Long> updShouldPayIds = new ArrayList<Long>();
                    BigDecimal totalCharge = BigDecimal.ZERO;
                    for (FscOrderPayItemPO itemPO : payItemList) {
                        if (shouldPayIds.contains(itemPO.getShouldPayId())) {
                            totalCharge = totalCharge.add(itemPO.getPayAmount());
                            continue;
                        }
                        delPayItemIds.add(itemPO.getOrderPayItemId());
                        updShouldPayIds.add(itemPO.getShouldPayId());
                    }
                    set.setTotalCharge(totalCharge);
                    set.setToPayAmount(totalCharge);
                    if (!CollectionUtils.isEmpty(delPayItemIds) && (count = this.fscOrderPayItemMapper.deleteByItemIds(delPayItemIds)) != delPayItemIds.size()) {
                        throw new FscBusinessException("198888", "\u5220\u9664\u4ed8\u6b3e\u5173\u8054\u6570\u636e\u5931\u8d25\uff01");
                    }
                    if (!CollectionUtils.isEmpty(updShouldPayIds) && (count = this.fscShouldPayMapper.updatePayingAmtBatch(updShouldPayIds)) != updShouldPayIds.size()) {
                        throw new FscBusinessException("198888", "\u66f4\u65b0\u5e94\u4ed8\u5355\u4ed8\u6b3e\u4e2d\u91d1\u989d\u5931\u8d25\uff01");
                    }
                }
                if (where.getFscOrderId() == null) {
                    throw new FscBusinessException("190000", "\u7ed3\u7b97\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
                }
                this.fscOrderMapper.updateBy(set, where);
            }
        }
        Map shouldPayMap = poResult.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, Function.identity(), (k1, k2) -> k1));
        HashMap<String, FscShouldPayPO> shouldPayIdAndOrderIdMap = new HashMap<String, FscShouldPayPO>();
        ArrayList<FscShouldPayPO> fscShouldPayPOList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        for (FscOrderPayItemBO fscOrderPayItemBO : busiReqBO.getFscOrderPayItemBOS()) {
            FscPayItemSerialPO fscPayItemSerialPO;
            int count;
            FscShouldPayPO fscShouldPayPO2 = new FscShouldPayPO();
            fscShouldPayPO2.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            fscShouldPayPO2.setPayAmount(fscOrderPayItemBO.getPayAmount());
            if (fscOrderPayItemBO.getReduceAmt() != null) {
                fscShouldPayPO2.setPayAmount(fscShouldPayPO2.getPayAmount().add(fscOrderPayItemBO.getReduceAmt()));
            }
            if ((count = this.fscShouldPayMapper.updateAmount(fscShouldPayPO2)) != 1) {
                throw new FscBusinessException("194203", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
            }
            FscShouldPayPO shouldPayPO = (FscShouldPayPO)shouldPayMap.get(fscOrderPayItemBO.getShouldPayId());
            fscShouldPayPO2.setObjectId(shouldPayPO.getObjectId());
            fscShouldPayPO2.setObjectType(shouldPayPO.getObjectType());
            fscShouldPayPO2.setOrderId(shouldPayPO.getOrderId());
            fscShouldPayPO2.setOrderCodeStr(shouldPayPO.getOrderCodeStr());
            String shouldPayIdAndOrderId = fscShouldPayPO2.getShouldPayId() + "&" + fscShouldPayPO2.getOrderId();
            FscShouldPayPO fscShouldPayPO22 = (FscShouldPayPO)shouldPayIdAndOrderIdMap.get(shouldPayIdAndOrderId);
            if (fscShouldPayPO22 != null) {
                fscShouldPayPO22.setPayAmount(fscShouldPayPO22.getPayAmount().add(fscShouldPayPO2.getPayAmount()));
                shouldPayIdAndOrderIdMap.put(shouldPayIdAndOrderId, fscShouldPayPO22);
            } else {
                shouldPayIdAndOrderIdMap.put(shouldPayIdAndOrderId, fscShouldPayPO2);
            }
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setItemNo(fscOrderPayItemBO.getItemNo());
            po.setIsReduce(fscOrderPayItemBO.getIsReduce());
            if (po.getIsReduce() == null) {
                po.setIsReduce(FscConstants.NO);
            }
            po.setPaymentPhase(fscOrderPayItemBO.getPaymentPhase());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            po.setPayAmount(fscOrderPayItemBO.getPayAmount());
            po.setPayAmountLocal(fscOrderPayItemBO.getPayAmountLocal());
            po.setReduceAmt(fscOrderPayItemBO.getReduceAmt());
            po.setExt3(fscOrderPayItemBO.getExt3());
            po.setContractSegmentCode(fscOrderPayItemBO.getContractSegmentCode());
            po.setContractSegmentName(fscOrderPayItemBO.getContractSegmentName());
            if (po.getReduceAmt() == null) {
                po.setReduceAmt(BigDecimal.ZERO);
            }
            po.setExpType(fscOrderPayItemBO.getExpLineType());
            po.setExpTypeId(fscOrderPayItemBO.getExpTypeCode());
            if (StringUtils.isEmpty((Object)fscOrderPayItemBO.getShouldPayItemNo())) {
                po.setShouldPayItemNo(((FscShouldPayPO)shouldPayMap.get(fscOrderPayItemBO.getShouldPayId())).getShouldPayNo() + "-01");
            } else {
                po.setShouldPayItemNo(fscOrderPayItemBO.getShouldPayItemNo());
            }
            po.setShouldPayMethod(busiReqBO.getShouldPayMethod());
            fscOrderPayItemBO.setOrderPayItemId(po.getOrderPayItemId());
            List fscPayItemSerialPOList = this.fscPayItemSerialMapper.queryByShouldPayNo(fscOrderPayItemBO.getShouldPayNo());
            int serialNumber = 0;
            if (!CollectionUtils.isEmpty((Collection)fscPayItemSerialPOList)) {
                fscPayItemSerialPO = (FscPayItemSerialPO)fscPayItemSerialPOList.get(0);
                serialNumber = ((FscPayItemSerialPO)fscPayItemSerialPOList.get(0)).getSerialNumber();
                fscPayItemSerialPO.setSerialNumber(Integer.valueOf(++serialNumber));
                this.fscPayItemSerialMapper.update(fscPayItemSerialPO);
            } else {
                fscPayItemSerialPO = new FscPayItemSerialPO();
                fscPayItemSerialPO.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
                fscPayItemSerialPO.setShouldPayNo(fscOrderPayItemBO.getShouldPayNo());
                fscPayItemSerialPO.setSerialNumber(Integer.valueOf(++serialNumber));
                this.fscPayItemSerialMapper.insert(fscPayItemSerialPO);
            }
            fscOrderPayItemBO.setShouldPayItemNo(po.getShouldPayItemNo());
            if (FscConstants.PaymentMethod.SHOULD_PAY.equals(po.getShouldPayMethod())) {
                if (!StringUtils.isEmpty((Object)fscOrderPayItemBO.getObjectNo())) {
                    po.setFscBillOrderId(fscOrderPayItemBO.getObjectId() + "");
                    po.setFscBillOrderNo(fscOrderPayItemBO.getObjectNo());
                } else {
                    po.setFscBillOrderId(fscOrderPayItemBO.getFscBillOrderId());
                    po.setFscBillOrderNo(fscOrderPayItemBO.getFscBillOrderNo());
                }
            }
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO.getPayAmount());
            if (fscOrderPayItemBO.getReduceAmt() == null) continue;
            totalAmount = totalAmount.add(fscOrderPayItemBO.getReduceAmt());
        }
        if (!CollectionUtils.isEmpty(shouldPayIdAndOrderIdMap)) {
            shouldPayIdAndOrderIdMap.forEach((key, value) -> fscShouldPayPOList.add((FscShouldPayPO)value));
        }
        busiReqBO.setTotalAmount(totalAmount);
        UocSalesSingleDetailsListQueryRspBO uocSalesSingleDetailsListQueryRspBO = this.handlePayDetail(poResult, fscShouldPayPOList, busiReqBO, fscOrderId);
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
    }

    private void invokeUacNoTask(FscFinancePayBillCreateReqBO busiReqBO, Long fscOrderId) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO), FscOrderStatusStartAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        if (FscConstants.PaymentMethod.PRE_PAY.equals(busiReqBO.getShouldPayMethod())) {
            uacNoTaskAuditCreateReqBO.setMenuId("M003048");
        } else {
            uacNoTaskAuditCreateReqBO.setMenuId("M003049");
        }
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(fscOrderId);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(fscOrderId.toString());
        approvalObjBO.setObjName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        BigDecimal payAmount = BigDecimal.ZERO;
        for (FscOrderPayItemBO payItem : busiReqBO.getFscOrderPayItemBOS()) {
            payAmount = payAmount.add(payItem.getPayAmount());
        }
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("payAmount", payAmount);
        Long shouldPayId = ((FscOrderPayItemBO)busiReqBO.getFscOrderPayItemBOS().get(0)).getShouldPayId();
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setShouldPayId(shouldPayId);
        FscShouldPayPO model = this.fscShouldPayMapper.getModelBy(fscShouldPayPo);
        if (FscPayTypeEnum.ADVANCE_PAY.getCode().equals(busiReqBO.getShouldPayMethod())) {
            variables.put("payType", 1);
        } else {
            variables.put("payType", 2);
        }
        uacNoTaskAuditCreateReqBO.setVariables(variables);
        this.checkExistProcess(fscOrderId);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u4ed8\u6b3e\u5ba1\u6279\u6d41\uff01");
        }
        if (uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        }
        fscOrderStatusStartAtomReqBO.setTradeMode(model.getTradeMode());
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserName());
        fscOrderStatusStartAtomReqBO.setIndividually(busiReqBO.getIndividually());
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194203", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    public UocSalesSingleDetailsListQueryRspBO handlePayDetail(List<FscShouldPayPO> poResult, List<FscShouldPayPO> fscShouldPayPOList, FscFinancePayBillCreateReqBO busiReqBO, Long fscOrderId) {
        boolean temp = true;
        ArrayList<String> orderNoList = new ArrayList<String>();
        for (FscShouldPayPO fscShouldPayPO : poResult) {
            if (fscShouldPayPO.getOrderCodeStr() == null || "".equals(fscShouldPayPO.getOrderCodeStr())) continue;
            orderNoList.addAll(Arrays.asList(fscShouldPayPO.getOrderCodeStr().split(",")));
            if (!fscShouldPayPO.getOrderCodeStr().contains(",")) continue;
            temp = false;
        }
        List orderIdList = poResult.stream().map(FscShouldPayPO::getOrderId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderIdList)) {
            log.error("\u5f53\u524d\u5e94\u4ed8\u5355\u65e0\u8ba2\u5355\u53f7\u4fe1\u606f");
            return null;
        }
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setPageSize(1000);
        if (temp) {
            saleDetailsReqBO.setOrderIdList(orderIdList);
        } else {
            saleDetailsReqBO.setSaleVoucherNoList(orderNoList);
        }
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setIndividually("1");
        log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)saleDetailsReqBO));
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        log.debug("\u67e5\u8be2\u9500\u552e\u5355\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)saleDetailsRspBO));
        if (CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        FscOrderPayDetailPO fscOrderPayDetailPOReq = new FscOrderPayDetailPO();
        fscOrderPayDetailPOReq.setOrderIdList(orderIdList);
        fscOrderPayDetailPOReq.setRelType("0".equals(busiReqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
        List payDetailPOList = this.fscOrderPayDetailMapper.queryList(fscOrderPayDetailPOReq);
        Map<Object, Object> payDetailMap = !CollectionUtils.isEmpty((Collection)payDetailPOList) ? payDetailPOList.stream().collect(Collectors.groupingBy(FscOrderPayDetailPO::getOrderItemId, Collectors.mapping(FscOrderPayDetailPO::getPayAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))) : new HashMap();
        if (!CollectionUtils.isEmpty(fscShouldPayPOList)) {
            int count;
            ArrayList fscOrderPayDetailPOList = new ArrayList();
            HashMap collOrderCodeStrMap = new HashMap();
            saleDetailsRspBO.getRows().forEach(e -> {
                List collect = fscShouldPayPOList.stream().filter(m -> m.getOrderId() != null && (m.getOrderId() + "").equals(e.getOrderId()) || m.getOrderCodeStr() != null && m.getOrderCodeStr().contains(e.getSaleVoucherNo())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    throw new FscBusinessException("194203", e.getOrderId() + "\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u5e94\u4ed8\u6570\u636e");
                }
                if (collect.size() == 1 && ((FscShouldPayPO)collect.get(0)).getOrderCodeStr().contains(",")) {
                    FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)collect.get(0);
                    if (collOrderCodeStrMap.get(fscShouldPayPO.getOrderId()) != null) {
                        FscShouldPayPO fscShouldPayPO1 = (FscShouldPayPO)collOrderCodeStrMap.get(fscShouldPayPO.getOrderId());
                        collect.clear();
                        collect.add(fscShouldPayPO1);
                    } else {
                        collOrderCodeStrMap.put(fscShouldPayPO.getOrderId(), fscShouldPayPO);
                    }
                }
                block0: for (UocPebOrderItemAbilityBO item : ((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderItemList()) {
                    BigDecimal orderAmount = Objects.nonNull(busiReqBO.getIsprofess()) && "0".equals(busiReqBO.getIsprofess()) ? new BigDecimal(item.getPurchaseFeeMoney()) : new BigDecimal(item.getSaleFeeMoney());
                    BigDecimal initOrderAmt = orderAmount;
                    BigDecimal payOrderAmount = BigDecimal.ZERO;
                    if (Objects.nonNull(payDetailMap.get(Long.valueOf(item.getOrderItemId())))) {
                        payOrderAmount = (BigDecimal)payDetailMap.get(Long.valueOf(item.getOrderItemId()));
                    }
                    if (BigDecimal.ZERO.compareTo(orderAmount = orderAmount.subtract(payOrderAmount)) == 0) continue;
                    for (FscShouldPayPO fscShouldPayPO : collect) {
                        if (BigDecimal.ZERO.compareTo(orderAmount) == 0) continue block0;
                        if (fscShouldPayPO.getPayAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                        FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
                        fscOrderPayDetailPO.setPayDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                        fscOrderPayDetailPO.setSettleType(busiReqBO.getSettleType());
                        fscOrderPayDetailPO.setOrderId(Objects.isNull(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderId()) ? null : Long.valueOf(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderId()));
                        fscOrderPayDetailPO.setOrderItemId(Objects.isNull(item.getOrderItemId()) ? null : Long.valueOf(item.getOrderItemId()));
                        fscOrderPayDetailPO.setSaleVoucherId(Objects.isNull(e.getSaleVoucherId()) ? null : Long.valueOf(e.getSaleVoucherId()));
                        fscOrderPayDetailPO.setFscOrderId(fscOrderId);
                        fscOrderPayDetailPO.setShouldPayId(fscShouldPayPO.getShouldPayId());
                        fscOrderPayDetailPO.setOrderAmount(initOrderAmt);
                        fscOrderPayDetailPO.setBeforeLeaveAmount(orderAmount);
                        fscOrderPayDetailPO.setRelType("0".equals(busiReqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
                        fscOrderPayDetailPO.setCreateId(Objects.nonNull(busiReqBO.getUserId()) ? busiReqBO.getUserId().toString() : "");
                        fscOrderPayDetailPO.setCreateTime(new Date());
                        fscOrderPayDetailPO.setUpdateId(Objects.nonNull(busiReqBO.getUserId()) ? busiReqBO.getUserId().toString() : "");
                        fscOrderPayDetailPO.setUpdateTime(new Date());
                        if (fscShouldPayPO.getObjectType().equals(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER)) {
                            fscOrderPayDetailPO.setSettleId(fscShouldPayPO.getObjectId());
                        }
                        if (fscShouldPayPO.getPayAmount().compareTo(orderAmount) > 0) {
                            fscOrderPayDetailPO.setPayAmount(orderAmount);
                            fscShouldPayPO.setPayAmount(fscShouldPayPO.getPayAmount().subtract(orderAmount));
                            orderAmount = BigDecimal.ZERO;
                        } else {
                            fscOrderPayDetailPO.setPayAmount(fscShouldPayPO.getPayAmount());
                            fscShouldPayPO.setPayAmount(BigDecimal.ZERO);
                            orderAmount = orderAmount.subtract(fscShouldPayPO.getPayAmount());
                        }
                        if (fscShouldPayPO.getOrderCodeStr().contains(",")) {
                            collOrderCodeStrMap.put(fscShouldPayPO.getOrderId(), fscShouldPayPO);
                        }
                        fscOrderPayDetailPOList.add(fscOrderPayDetailPO);
                    }
                }
            });
            if (!CollectionUtils.isEmpty(fscOrderPayDetailPOList) && (count = this.fscOrderPayDetailMapper.insertBatch(fscOrderPayDetailPOList)) == 0) {
                throw new FscBusinessException("194203", "\u63d2\u5165\u8ba2\u5355\u652f\u4ed8\u660e\u7ec6\u5f02\u5e38");
            }
        }
        return saleDetailsRspBO;
    }

    private void insertFinanceInfo(FscFinancePayBillCreateReqBO reqBO, Long fscOrderId) {
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)financePO);
        financePO.setFscOrderId(fscOrderId);
        financePO.setCreateTime(new Date());
        financePO.setCreateUserId(reqBO.getUserName());
        financePO.setCreateUserName(reqBO.getName());
        financePO.setFinanceUserId(reqBO.getUserName());
        financePO.setFinanceUserName(reqBO.getName());
        financePO.setExt1(reqBO.getSupplierErpNo());
        int count = this.fscOrderFinanceMapper.insert(financePO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u8d22\u52a1\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        int count;
        if (CollectionUtils.isEmpty(attachmentBOList)) {
            return;
        }
        FscAttachmentPO deletePo = new FscAttachmentPO();
        deletePo.setFscOrderId(fscOrderId);
        deletePo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
        ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletePo);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS) && (count = this.fscAttachmentMapper.deleteBy(deletePo)) != fscAttachmentPOS.size()) {
            throw new FscBusinessException("198888", "\u5220\u9664\u4ed8\u6b3e\u5355\u9644\u4ef6\u5931\u8d25\uff01");
        }
        fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
        for (AttachmentBO attachmentBO : attachmentBOList) {
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            BeanUtils.copyProperties((Object)attachmentBO, (Object)fscAttachmentPo);
            fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAYMENT);
            fscAttachmentPo.setObjId(attachmentBO.getObjId());
            fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
            fscAttachmentPo.setFscOrderId(fscOrderId);
            fscAttachmentPOS.add(fscAttachmentPo);
        }
        count = this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        if (count != fscAttachmentPOS.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u5355\u9644\u4ef6\u5931\u8d25\uff01");
        }
    }

    private void checkExistProcess(Long fscOrderId) {
        int count = this.fscOrderMapper.selectStepIdCount(fscOrderId, FscConstants.AuditObjType.PAY_APPLY_ORDER);
        if (count > 0) {
            throw new FscBusinessException("191019", "\u8be5\u5355\u636e\u5df2\u63d0\u4ea4\u5ba1\u6279");
        }
    }
}

