/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.config;

import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.pay.config.OrderDelayTask;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Objects;
import java.util.concurrent.DelayQueue;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayTaskRunner
implements InitializingBean {
    @Autowired
    private DelayQueue<OrderDelayTask> orderDelayQueue;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    public void afterPropertiesSet() throws Exception {
        new Thread(() -> {
            try {
                OrderDelayTask task = (OrderDelayTask)this.orderDelayQueue.take();
                FscOrderPO fscOrderPOReq = new FscOrderPO();
                fscOrderPOReq.setFscOrderId(task.getFscOrderId());
                FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPOReq);
                if (Objects.nonNull(fscOrderPO) && FscConstants.FscPayOrderState.TO_PAY.equals(fscOrderPO.getOrderState())) {
                    fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAY_DISABLE);
                    this.fscOrderMapper.updateById(fscOrderPO);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }).start();
    }
}

