/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.pay.busi.api.FscPayBillCheckBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCheckBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCheckBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillCheckBusiServiceImpl
implements FscPayBillCheckBusiService {
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    public FscPayBillCheckBusiRspBO payBillCheck(FscPayBillCheckBusiReqBO reqBO) {
        FscPayBillCheckBusiRspBO rspBO = new FscPayBillCheckBusiRspBO();
        if (!FscConstants.ShouldPayType.PAYMENT_DAY_PAY.equals(reqBO.getShouldPayType())) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setShouldPayIds(reqBO.getShouldPayIdList());
            ArrayList<Integer> excludeOrderStates = new ArrayList<Integer>();
            excludeOrderStates.add(FscConstants.FscPayOrderState.CANCEL);
            fscOrderPayItemPO.setExcludeOrderStates(excludeOrderStates);
            List itemPOS = this.fscOrderPayItemMapper.getListByOrder(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)itemPOS) && itemPOS.size() == reqBO.getShouldPayIdList().size()) {
                HashSet payFscOrderIds = new HashSet();
                itemPOS.forEach(fscOrderPayItemPO1 -> payFscOrderIds.add(fscOrderPayItemPO1.getFscOrderId()));
                if (payFscOrderIds.size() == 1) {
                    FscOrderPO fscOrderPO = new FscOrderPO();
                    fscOrderPO.setFscOrderId((Long)payFscOrderIds.iterator().next());
                    fscOrderPO.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
                    FscOrderPO po = this.fscOrderMapper.getModelBy(fscOrderPO);
                    if (po == null) {
                        rspBO.setRespCode("190000");
                        rspBO.setRespDesc("\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5df2\u5b58\u5728\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4e14\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001\uff01");
                        return rspBO;
                    }
                } else {
                    rspBO.setRespCode("190000");
                    rspBO.setRespDesc("\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5b58\u5728\u591a\u4e2a\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u8bf7\u5230\u4ed8\u6b3e\u7533\u8bf7\u9875\u9762\u8fdb\u884c\u652f\u4ed8\uff01");
                    return rspBO;
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

