/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPayServiceBillCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillCreateBusiRspBO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayServiceBillCreateBusiServiceImpl
implements FscPayServiceBillCreateBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    private static final String BUSI_NAME = "\u670d\u52a1\u8d39\u4e3b\u5355\u521b\u5efa";
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public FscPayServiceBillCreateBusiRspBO dealPayServiceOrdCreate(FscPayServiceBillCreateBusiReqBO reqBO) {
        Long fscOrderId = Sequence.getInstance().nextId();
        this.insertOrder(reqBO, fscOrderId);
        if (!FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            this.insertOrderInvoice(reqBO, fscOrderId);
            if (!reqBO.getTaskFlag().booleanValue() || FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
                this.insertOrderRelation(reqBO, fscOrderId);
            }
        }
        this.invokeUacNoTaskAndStatusStart(reqBO, fscOrderId);
        FscPayServiceBillCreateBusiRspBO fscPayServiceBillCreateBusiRspBO = new FscPayServiceBillCreateBusiRspBO();
        fscPayServiceBillCreateBusiRspBO.setFscOrderId(fscOrderId);
        return fscPayServiceBillCreateBusiRspBO;
    }

    private void insertOrder(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderPO.class);
        fscOrderPO.setFscOrderId(fscOrderId);
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PL_SERVICE_FEE);
        }
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.MONTH_SERVICE_FEE);
        }
        if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE);
        }
        if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE);
        }
        fscOrderPO.setPayerId(busiReqBO.getSupplierId());
        fscOrderPO.setPayeeId(busiReqBO.getProOrgId());
        fscOrderPO.setPayeeBankAccount(busiReqBO.getAccount());
        fscOrderPO.setShouldPayType(FscConstants.ShouldPayType.DEAL_PAY);
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscOrderPO.setCreateOperName(busiReqBO.getLinkMan());
        } else {
            fscOrderPO.setCreateOperId(busiReqBO.getUserId());
            fscOrderPO.setCreateOperName(busiReqBO.getName());
        }
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(busiReqBO.getTotalCharge());
        fscOrderPO.setServiceFeeCycle(busiReqBO.getServiceFeeCycle());
        fscOrderPO.setServiceFeeRate(busiReqBO.getServiceFeeRate());
        if (FscConstants.AllowCreditEnable.NO.equals(busiReqBO.getAllowCreditEnable())) {
            busiReqBO.setCreditAmount(null);
        }
        fscOrderPO.setCreditAmount(busiReqBO.getCreditAmount());
        if (busiReqBO.getCreditAmount() != null) {
            fscOrderPO.setActualAmount(busiReqBO.getTotalCharge().subtract(busiReqBO.getCreditAmount()));
            CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
            encodedSerialGetServiceReqBO.setCenter("FSC");
            encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
            encodedSerialGetServiceReqBO.setOrgType("-1");
            if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
                encodedSerialGetServiceReqBO.setEncodedRuleCode("MONTH_DEAL_SERVICE_FEE_CREDIT_ORDER_NO");
            }
            if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(busiReqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
                encodedSerialGetServiceReqBO.setEncodedRuleCode("YEAR_DEAL_SERVICE_FEE_CREDIT_ORDER_NO");
            }
            if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
                encodedSerialGetServiceReqBO.setEncodedRuleCode("PLATFORM_SERVICE_FEE_CREDIT_ORDER_NO");
            }
            CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
            fscOrderPO.setCreditNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
            fscOrderPO.setDiscountOperId(busiReqBO.getUserName());
            fscOrderPO.setDiscountOperName(busiReqBO.getName());
            fscOrderPO.setDiscountOperTime(new Date());
        } else {
            fscOrderPO.setActualAmount(busiReqBO.getTotalCharge());
        }
        int insert = this.fscOrderMapper.insert(fscOrderPO);
        if (insert != 1) {
            throw new FscBusinessException("193207", "\u670d\u52a1\u8d39\u4e3b\u5355\u521b\u5efa----\u751f\u6210\u4ed8\u6b3e\u4e3b\u5355\u5931\u8d25");
        }
    }

    private void insertOrderInvoice(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        FscOrderInvoicePO fscOrderInvoicePO = (FscOrderInvoicePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderInvoicePO.class);
        fscOrderInvoicePO.setFscOrderId(fscOrderId);
        if (null != busiReqBO.getUserId()) {
            fscOrderInvoicePO.setBillOperId(busiReqBO.getUserId().toString());
        }
        fscOrderInvoicePO.setBillOperName(busiReqBO.getUserName());
        fscOrderInvoicePO.setBillTime(new Date());
        int insert = this.fscOrderInvoiceMapper.insert(fscOrderInvoicePO);
        if (insert != 1) {
            throw new FscBusinessException("193207", "\u670d\u52a1\u8d39\u4e3b\u5355\u521b\u5efa----\u751f\u6210\u53d1\u7968\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void insertOrderRelation(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        List fscOrderRelationPOS = JSON.parseArray((String)JSON.toJSONString(busiReqBO.getRelOrderBOList()), FscOrderRelationPO.class);
        for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPOS) {
            Long id = Sequence.getInstance().nextId();
            fscOrderRelationPO.setId(id);
            fscOrderRelationPO.setFscOrderId(fscOrderId);
            fscOrderRelationPO.setOrderNo(busiReqBO.getOrderNo());
        }
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOS)) {
            this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        }
    }

    private void invokeUacNoTaskAndStatusStart(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        if (FscConstants.AllowCreditEnable.NO.equals(busiReqBO.getAllowCreditEnable())) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag0);
        } else if ("0".equals(busiReqBO.getIsProfessionalOrgExt())) {
            if (busiReqBO.getCreditAmount() != null && BigDecimal.ZERO.compareTo(busiReqBO.getCreditAmount()) == -1) {
                UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
                uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
                uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
                uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
                uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
                uacNoTaskAuditCreateReqBO.setMenuId("fscServiceOrderProcess");
                uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
                ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
                UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
                uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
                uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
                uacNoTaskAuditCreateInfoReqBO.setOrderId(fscOrderId);
                createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
                ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
                ApprovalObjBO approvalObjBO = new ApprovalObjBO();
                approvalObjBO.setObjId(fscOrderId.toString());
                approvalObjBO.setObjName("\u670d\u52a1\u8d39\u51cf\u514d\u5904\u7406\u5355");
                approvalObjBO.setObjType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
                approvalObjInfo.add(approvalObjBO);
                uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
                uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
                UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
                if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
                    throw new FscBusinessException("193207", uacNoTaskAuditCreateRspBO.getRespDesc());
                }
                paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
                if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
                    paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag0);
                }
                if (uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
                    paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag0);
                }
            } else {
                paramMap.put("processFlag", FscConstants.ProcessParam.auditFlag0);
            }
        } else {
            paramMap.put("processFlag", FscConstants.ServiceFeeProcessFlag.UNDO);
        }
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.MONTH_SERVICE_FEE);
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        if (!FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getOrderFlow()) && !busiReqBO.getTaskFlag().booleanValue()) {
            fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserId().toString());
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193207", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }
}

