/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayRegisterCreateAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayRegisterCreateAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayRegisterCreateAtomRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayRegisterCreateAtomServiceImpl
implements FscPayRegisterCreateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayRegisterCreateAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;

    @Override
    public FscPayRegisterCreateAtomRspBO dealPayRegisterCreate(FscPayRegisterCreateAtomReqBO reqBO) {
        log.info("\u4ed8\u6b3e\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5b9e\u73b0\u5165\u53c2\uff1a" + JSON.toJSONString((Object)((Object)reqBO)));
        FscPayRegisterCreateAtomRspBO rspBO = new FscPayRegisterCreateAtomRspBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        BigDecimal totalAmount = new BigDecimal(0);
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        for (FscOrderPayItemBO fscOrderPayItemBO : reqBO.getFscOrderPayItemBOS()) {
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            po.setPayAmount(fscOrderPayItemBO.getRegisterAmount());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(po.getPayAmount());
        }
        reqBO.setTotalAmount(totalAmount);
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        FscOrderPO parentOrder = this.insertOrder(reqBO, fscOrderId);
        this.updateParentOrder(reqBO, parentOrder);
        this.invokeUacNoTask(reqBO, reqBO.getFscOrderId());
        rspBO.setFscOrderId(fscOrderId);
        rspBO.setParentOrderId(reqBO.getFscOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4ed8\u6b3e\u767b\u8bb0\u6210\u529f");
        return rspBO;
    }

    private void updateParentOrder(FscPayRegisterCreateAtomReqBO reqBO, FscOrderPO parentOrder) {
        FscOrderPO po = new FscOrderPO();
        po.setFscOrderId(reqBO.getFscOrderId());
        po.setPayAmount(reqBO.getTotalAmount());
        po.setPayTime(new Date());
        po.setPayOperId(reqBO.getUserName());
        po.setPayOperName(reqBO.getName());
        int count = this.fscOrderMapper.updateAmount(po);
        if (count != 1) {
            throw new FscBusinessException("194203", "\u767b\u8bb0\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
        }
    }

    private void invokeUacNoTask(FscPayRegisterCreateAtomReqBO reqBO, Long fscOrderId) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        FscOrderPO po = new FscOrderPO();
        po.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO parentOrder = this.fscOrderMapper.getModelBy(po);
        log.info("\u7236\u4ed8\u6b3e\u7533\u8bf7\u5355\u66f4\u65b0\u540e\u53c2\u6570:" + JSON.toJSONString((Object)parentOrder));
        if (parentOrder.getToPayAmount().compareTo(BigDecimal.ZERO) > 0) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag4);
        } else if (parentOrder.getToPayAmount().compareTo(BigDecimal.ZERO) == 0) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag1);
        } else {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusFlowAtomReqBO.class);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusFlowAtomReqBO.setCurStatus(parentOrder.getOrderState());
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }

    private FscOrderPO insertOrder(FscPayRegisterCreateAtomReqBO reqBO, Long fscOrderId) {
        FscOrderPO po = new FscOrderPO();
        po.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO parentOrder = this.fscOrderMapper.getModelBy(po);
        if (null == parentOrder) {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
        }
        if (!FscConstants.FscPayOrderState.TO_REGISTER.equals(parentOrder.getOrderState()) && !FscConstants.FscPayOrderState.PART_PAY.equals(parentOrder.getOrderState())) {
            throw new FscBusinessException("198888", "\u7236\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e0d\u4e3a\u5f85\u767b\u8bb0\u3001\u90e8\u5206\u4ed8\u6b3e\uff0c\u8bf7\u786e\u8ba4\u540e\u4ed8\u6b3e");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        BeanUtils.copyProperties((Object)parentOrder, (Object)fscOrderPO);
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setParentOrderId(reqBO.getFscOrderId());
        fscOrderPO.setOrderNo(reqBO.getOrderNo());
        fscOrderPO.setTotalCharge(reqBO.getTotalAmount());
        fscOrderPO.setToPayAmount(BigDecimal.ZERO);
        fscOrderPO.setPaidAmount(BigDecimal.ZERO);
        fscOrderPO.setPayingAmount(reqBO.getTotalAmount());
        fscOrderPO.setCreateOperId(reqBO.getUserId());
        fscOrderPO.setCreateOperName(reqBO.getName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(reqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(reqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(reqBO.getOrgId());
        fscOrderPO.setCreateOrgName(reqBO.getOrgName());
        fscOrderPO.setPayTime(new Date());
        fscOrderPO.setPayOperId(reqBO.getUserId().toString());
        fscOrderPO.setPayOperName(reqBO.getName());
        fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAIED_TO_COMFIR);
        this.fscOrderMapper.insert(fscOrderPO);
        return parentOrder;
    }
}

