/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayQueryShouldPayListAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayQueryShouldPayListAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayQueryShouldPayListAbilityRspBO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.umc.general.ability.api.UmcBuyerPermissionRecvAcceptQryAbilityService;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptBO;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptQryReqBO;
import com.tydic.umc.general.ability.bo.UmcBuyerPermissionRecvAcceptQryRspBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayQueryShouldPayListAbilityService"})
public class FscPayQueryShouldPayListAbilityServiceImpl
implements FscPayQueryShouldPayListAbilityService {
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private UmcBuyerPermissionRecvAcceptQryAbilityService umcBuyerPermissionRecvAcceptQryAbilityService;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryShouldPayList"})
    public FscPayQueryShouldPayListAbilityRspBO qryShouldPayList(@RequestBody FscPayQueryShouldPayListAbilityReqBO abilityReqBO) {
        ArrayList<Integer> orderTypeList;
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)fscShouldPayPO);
        String configurationMode = this.getConfigurationMode(abilityReqBO);
        if (!"0".equals(configurationMode)) {
            fscShouldPayPO.setCreateId(abilityReqBO.getUserId());
        }
        if (abilityReqBO.getIsprofess().equals("1")) {
            UmcBuyerPermissionRecvAcceptQryReqBO acceptQryReqBO = new UmcBuyerPermissionRecvAcceptQryReqBO();
            acceptQryReqBO.setErpCode(abilityReqBO.getUserName());
            UmcBuyerPermissionRecvAcceptQryRspBO qryRspBO = this.umcBuyerPermissionRecvAcceptQryAbilityService.qry(acceptQryReqBO);
            if (qryRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Collection)qryRspBO.getRows())) {
                ArrayList<String> buyerNoList = new ArrayList<String>();
                for (UmcBuyerPermissionRecvAcceptBO umcBuyerPermissionRecvAcceptBO : qryRspBO.getRows()) {
                    buyerNoList.add(String.valueOf(umcBuyerPermissionRecvAcceptBO.getBuyerOrgId()));
                }
                abilityReqBO.setBuyerNoList(buyerNoList);
                fscShouldPayPO.setPayerId(null);
                fscShouldPayPO.setBuyerNoList(buyerNoList);
            }
        }
        if (abilityReqBO.getBusiType() != null && abilityReqBO.getBusiType().toString().equals("1")) {
            orderTypeList = new ArrayList<Integer>();
            orderTypeList.add(PebExtConstant.OrderType.CX_AGR_GOODS);
            orderTypeList.add(PebExtConstant.OrderType.CX_AGR);
            fscShouldPayPO.setOrderTypeList(orderTypeList);
        } else if (abilityReqBO.getBusiType() != null && abilityReqBO.getBusiType().toString().equals("2")) {
            orderTypeList = new ArrayList();
            orderTypeList.add(PebExtConstant.OrderType.TH);
            orderTypeList.add(PebExtConstant.OrderType.GC);
            orderTypeList.add(PebExtConstant.OrderType.FL);
            fscShouldPayPO.setOrderTypeList(orderTypeList);
        } else if (abilityReqBO.getBusiType() != null) {
            orderTypeList = new ArrayList();
            orderTypeList.add(abilityReqBO.getBusiType());
            fscShouldPayPO.setOrderTypeList(orderTypeList);
        }
        Page page = new Page(abilityReqBO.getPageNo().intValue(), abilityReqBO.getPageSize().intValue());
        List listPage = null;
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderIds())) {
            fscShouldPayPO.setShouldPayTypeNot(FscConstants.ShouldPayType.PAYMENT_ADVANCE_PAY);
            listPage = this.fscShouldPayMapper.getListPage(fscShouldPayPO, page);
        } else {
            listPage = this.fscShouldPayMapper.getListPageWhthPayItem(fscShouldPayPO, page);
        }
        List fscShouldPayBOs = JSON.parseArray((String)JSON.toJSONString((Object)listPage), FscShouldPayBO.class);
        Map shouldPayTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC", "SHOULD_PAY_TYPE");
        Map shouldPayStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC", "SHOULD_PAY_STATUS");
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC", "FSC_ORDER_TYPE");
        List orgIdList = fscShouldPayBOs.stream().map(FscShouldPayBO::getPayeeId).collect(Collectors.toList());
        UmcEnterpriseOrgNameListQryAbilityReqBO orgListQryAbilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
        orgListQryAbilityReqBO.setOrgIdList(orgIdList);
        UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(orgListQryAbilityReqBO);
        Map orgMap = new HashMap();
        if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
            orgMap = rspBO.getOrgMap();
        }
        for (FscShouldPayBO fscShouldPayBO : fscShouldPayBOs) {
            if (fscShouldPayBO.getOrderId() == null) {
                fscShouldPayBO.setOrderId(fscShouldPayBO.getObjectId());
            }
            fscShouldPayBO.setShouldPayStatusStr((String)shouldPayStatusMap.get(fscShouldPayBO.getShouldPayStatus().toString()));
            fscShouldPayBO.setShouldPayTypeStr((String)shouldPayTypeMap.get(fscShouldPayBO.getShouldPayType().toString()));
            if (fscShouldPayBO.getOrderType() != null) {
                fscShouldPayBO.setOrderTypeStr((String)orderTypeMap.get(fscShouldPayBO.getOrderType().toString()));
            }
            if (orgMap.get(fscShouldPayBO.getPayeeId()) != null) {
                fscShouldPayBO.setPayeeName(((UmcDycEnterpriseOrgBO)orgMap.get(fscShouldPayBO.getPayeeId())).getOrgName());
            }
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getInvoiceNo()) || !fscShouldPayBO.getInvoiceNo().endsWith(",")) continue;
            fscShouldPayBO.setInvoiceNo(fscShouldPayBO.getInvoiceNo().substring(0, fscShouldPayBO.getInvoiceNo().length() - 1));
        }
        FscPayQueryShouldPayListAbilityRspBO abilityRspBO = new FscPayQueryShouldPayListAbilityRspBO();
        abilityRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        abilityRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        abilityRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setRespDesc("\u5e94\u4ed8\u8bb0\u5f55\u67e5\u8be2\u6210\u529f");
        abilityRspBO.setRows(fscShouldPayBOs);
        return abilityRspBO;
    }

    private String getConfigurationMode(FscPayQueryShouldPayListAbilityReqBO abilityReqBO) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("bill_auth");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(String.valueOf(abilityReqBO.getCompanyId()));
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191202", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPayApplyReq())) {
            throw new FscBusinessException("191202", "\u67e5\u8be2\u914d\u7f6e[payApplyReq]\u8fd4\u56de\u4e3a\u7a7a");
        }
        return fscCfcUniteParamQryListDetailExternalRspBO.getPayApplyReq();
    }
}

