/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscPenaltyOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPenaltyShouldPayCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPenaltyShouldPayCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPenaltyShouldPayCreateBusiRspBO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscPenaltyOrder;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscPenaltyShouldPayCreateBusiServiceImpl
implements FscPenaltyShouldPayCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPenaltyShouldPayCreateBusiServiceImpl.class);
    @Autowired
    private FscPenaltyOrderMapper fscPenaltyOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public FscPenaltyShouldPayCreateBusiRspBO dealPenaltyPayCreate(FscPenaltyShouldPayCreateBusiReqBO reqBO) {
        FscPenaltyShouldPayCreateBusiRspBO rspBO = new FscPenaltyShouldPayCreateBusiRspBO();
        if (null == reqBO || null == reqBO.getInspectionDetailsListBOList() || null == reqBO.getFscShouldPayPO()) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscShouldPayPO fscShouldPayPO = reqBO.getFscShouldPayPO();
        List<UocInspectionDetailsListBO> inspectionDetailsListBOList = reqBO.getInspectionDetailsListBOList();
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)FscConstants.ShouldPayType.OVERDUE_PENALTY_PAY).getDescr());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(inspectionDetailsListBOList.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        List shouldPayNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.OVERDUE_PENALTY.getDesc());
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO2 = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        List orderNoList = encodedSerialGetServiceRspBO2.getSerialNoList();
        ArrayList<FscShouldPayPO> fscShouldPayPOList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscPenaltyOrder> penaltyOrderList = new ArrayList<FscPenaltyOrder>();
        ArrayList<FscShouldPayPO> updateList = new ArrayList<FscShouldPayPO>();
        for (int i = 0; i < inspectionDetailsListBOList.size(); ++i) {
            Long shouldPayId = Sequence.getInstance().nextId();
            Long penaltyOrderId = Sequence.getInstance().nextId();
            UocInspectionDetailsListBO inspectionDetailsBO = inspectionDetailsListBOList.get(i);
            FscShouldPayPO po = new FscShouldPayPO();
            BeanUtils.copyProperties((Object)fscShouldPayPO, (Object)po);
            po.setShouldPayId(shouldPayId);
            po.setShouldPayNo((String)shouldPayNoList.get(i));
            po.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
            po.setShouldPayType(FscConstants.ShouldPayType.OVERDUE_PENALTY_PAY);
            BigDecimal originalAmount = BigDecimal.ZERO;
            originalAmount = StringUtils.isEmpty((Object)po.getBuyerNo()) ? inspectionDetailsBO.getInspTotalPurchaseMoney() : inspectionDetailsBO.getInspTotalPurchaseMoney();
            BigDecimal penaltyRatio = fscShouldPayPO.getPenaltyRatio();
            BigDecimal penalty = originalAmount.multiply(penaltyRatio.divide(new BigDecimal("100")));
            po.setShouldPayAmount(penalty);
            po.setToPayAmount(penalty);
            po.setPayingAmount(BigDecimal.ZERO);
            po.setPaidAmount(BigDecimal.ZERO);
            po.setCreateId(Long.valueOf(1L));
            po.setCreateName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            po.setCreateTime(new Date());
            po.setCreateCompanyId(Long.valueOf(1L));
            po.setCreateOrgName("root");
            po.setOrderType(inspectionDetailsBO.getOrderType());
            po.setOrderSource(Integer.valueOf(inspectionDetailsBO.getOrderSource()));
            po.setTradeMode(inspectionDetailsBO.getTradeMode());
            fscShouldPayPOList.add(po);
            FscPenaltyOrder penaltyOrder = new FscPenaltyOrder();
            penaltyOrder.setFscPenaltyOrderId(penaltyOrderId);
            penaltyOrder.setOrderNo((String)orderNoList.get(i));
            penaltyOrder.setShouldPayId(shouldPayId);
            penaltyOrder.setInspectionId(Long.valueOf(inspectionDetailsBO.getInspectionVoucherId()));
            penaltyOrder.setInspectionCode(inspectionDetailsBO.getInspectionVoucherCode());
            penaltyOrder.setOrderId(Long.valueOf(inspectionDetailsBO.getSaleVoucherId()));
            penaltyOrder.setOrderCode(inspectionDetailsBO.getSaleVoucherNo());
            penaltyOrder.setPurAccountId(Long.valueOf(inspectionDetailsBO.getPurAccount()));
            penaltyOrder.setPurAccountName(inspectionDetailsBO.getPurAccountName());
            penaltyOrder.setBusiType(inspectionDetailsBO.getOrderSource());
            penaltyOrder.setAmt(inspectionDetailsBO.getInspTotalSaleMoney());
            penaltyOrder.setOrderCreateTime(DateUtils.strToDate((String)inspectionDetailsBO.getOrderCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            penaltyOrder.setStatus("100");
            penaltyOrder.setPayRule(inspectionDetailsBO.getPayRule());
            penaltyOrder.setPayNode(inspectionDetailsBO.getPayNodeRule());
            penaltyOrder.setPaymentDay(inspectionDetailsBO.getPaymentDays());
            penaltyOrder.setCalcRule("\u5165\u5e93\u5355\u91d1\u989d * " + penaltyRatio.setScale(2, 5) + "% * \u903e\u671f\u5929\u6570");
            FscAccountPO accountPO = new FscAccountPO();
            accountPO.setOrgId(fscShouldPayPO.getPayerId());
            accountPO.setStatus(FscConstants.AccountStatus.VALID);
            accountPO = this.fscAccountMapper.getModelBy(accountPO);
            penaltyOrder.setAccountId(accountPO.getId());
            penaltyOrder.setOrgId(accountPO.getOrgId());
            penaltyOrderList.add(penaltyOrder);
            FscShouldPayPO penaltyPO = new FscShouldPayPO();
            penaltyPO.setShouldPayId(fscShouldPayPO.getShouldPayId());
            penaltyPO.setPenaltyShouldPayId(shouldPayId);
            updateList.add(penaltyPO);
        }
        this.fscShouldPayMapper.insertBatch(fscShouldPayPOList);
        this.fscPenaltyOrderMapper.insertBatch(penaltyOrderList);
        this.fscShouldPayMapper.updatePenaltyPayIdBatch(updateList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

