/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOverduePayItemMapper;
import com.tydic.fsc.dao.FscOverduePenaltyMapper;
import com.tydic.fsc.dao.FscPenaltyOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscReliefOverduePenaltyBusiService;
import com.tydic.fsc.pay.busi.bo.FscReliefOverduePenaltyBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscReliefOverduePenaltyBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOverduePayItem;
import com.tydic.fsc.po.FscOverduePenalty;
import com.tydic.fsc.po.FscPenaltyOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscReliefOverduePenaltyBusiServiceImpl
implements FscReliefOverduePenaltyBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscReliefOverduePenaltyBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOverduePayItemMapper fscOverduePayItemMapper;
    @Autowired
    private FscOverduePenaltyMapper fscOverduePenaltyMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscPenaltyOrderMapper fscPenaltyOrderMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public FscReliefOverduePenaltyBusiRspBO dealReliefOverduePenalty(FscReliefOverduePenaltyBusiReqBO reqBO) {
        log.info("\u903e\u671f\u8fdd\u7ea6\u91d1\u51cf\u514d\u7533\u8bf7busi\u670d\u52a1\u5b9e\u73b0\u5165\u53c2\uff1a" + JSON.toJSONString((Object)((Object)reqBO)));
        FscReliefOverduePenaltyBusiRspBO rspBO = new FscReliefOverduePenaltyBusiRspBO();
        List<FscShouldPayPO> shouldPayPOList = reqBO.getFscShouldPayPOList();
        long id = Sequence.getInstance().nextId();
        FscOverduePenalty overduePenalty = new FscOverduePenalty();
        ArrayList<FscOverduePayItem> fscOverduePayItemList = new ArrayList<FscOverduePayItem>();
        BigDecimal totalAmt = BigDecimal.ZERO;
        ArrayList<Long> shouldPayIds = new ArrayList<Long>();
        for (FscShouldPayPO fscShouldPayPO : shouldPayPOList) {
            FscOverduePayItem item = new FscOverduePayItem();
            long itemId = Sequence.getInstance().nextId();
            item.setOverduePayItemId(Long.valueOf(itemId));
            item.setAmount(fscShouldPayPO.getToPayAmount());
            item.setOverduePenatlyId(Long.valueOf(id));
            item.setShouldPayId(fscShouldPayPO.getShouldPayId());
            item.setItemStatus(Integer.valueOf(1));
            fscOverduePayItemList.add(item);
            totalAmt = totalAmt.add(fscShouldPayPO.getToPayAmount());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_RELIEF);
            shouldPayIds.add(fscShouldPayPO.getShouldPayId());
        }
        Long fscOrderId = shouldPayPOList.get(0).getObjectId();
        FscOrderPO po = new FscOrderPO();
        po.setFscOrderId(fscOrderId);
        FscOrderPO model = this.fscOrderMapper.getModelBy(po);
        if (null == model) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u8fd0\u8425\u4eba\u5458");
        }
        this.fscOverduePayItemMapper.insertBatch(fscOverduePayItemList);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.OVERDUE_PENALTY_RELIEF.getDesc());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        List orderNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        overduePenalty.setOverduePenaltyId(Long.valueOf(id));
        overduePenalty.setOverduePenaltyNo((String)orderNoList.get(0));
        overduePenalty.setAmt(totalAmt);
        overduePenalty.setStatus(FscConstants.ReliefOverDuePenaltyStatus.TO_AUDIT);
        overduePenalty.setCreateUserId(reqBO.getUserId());
        overduePenalty.setCreateUserName(reqBO.getName());
        overduePenalty.setCreateTime(new Date());
        overduePenalty.setCreateOrgId(reqBO.getCompanyId());
        overduePenalty.setCreateOrgName(reqBO.getCompanyName());
        overduePenalty.setBuynerNo(model.getBuynerNo());
        overduePenalty.setBuynerName(model.getBuynerName());
        this.fscOverduePenaltyMapper.insert(overduePenalty);
        this.fscShouldPayMapper.updateToReliefStatus(shouldPayPOList);
        if (!CollectionUtils.isEmpty(shouldPayIds)) {
            FscPenaltyOrderPO penaltyOrderPO = new FscPenaltyOrderPO();
            penaltyOrderPO.setFscShouldPayIds(shouldPayIds);
            penaltyOrderPO.setStatus("200");
            this.fscPenaltyOrderMapper.updateByContion(penaltyOrderPO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

