/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayBillCreateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscPayRegisterCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayRegisterCreateAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscMemPayCreateBusiService;
import com.tydic.fsc.pay.busi.api.FscPayBillCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscMemPayCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscMemPayCreateBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiRspBO;
import com.tydic.fsc.pay.busi.bo.FscPayRegisterCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayRegisterCreateBusiRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillCreateAbilityService"})
public class FscPayBillCreateAbilityServiceImpl
implements FscPayBillCreateAbilityService {
    @Autowired
    private FscPayBillCreateBusiService fscPayBillCreateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscMemPayCreateBusiService fscMemPayCreateBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @FscDuplicateCommitLimit
    @BigDecimalConvert
    @PostMapping(value={"dealPayBillCreate"})
    public FscPayBillCreateAbilityRspBO dealPayBillCreate(@RequestBody FscPayBillCreateAbilityReqBO abilityReqBO) {
        FscPayBillCreateAbilityRspBO abilityRspBO = new FscPayBillCreateAbilityRspBO();
        if (abilityReqBO.getMemFlag().booleanValue()) {
            this.validateMemParam(abilityReqBO);
            FscMemPayCreateBusiRspBO memPayCreateBusiRspBO = this.fscMemPayCreateBusiService.dealMemPayCreate((FscMemPayCreateBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscMemPayCreateBusiReqBO.class)));
            if ("0000".equals(memPayCreateBusiRspBO.getRespCode())) {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(memPayCreateBusiRspBO.getFscPayId());
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            }
            BeanUtils.copyProperties((Object)((Object)memPayCreateBusiRspBO), (Object)abilityRspBO);
        } else {
            this.validParam(abilityReqBO);
            FscPayBillCreateBusiReqBO fscPayBillCreateBusiReqBO = (FscPayBillCreateBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscPayBillCreateBusiReqBO.class));
            FscPayBillCreateBusiRspBO busiRspBO = this.fscPayBillCreateBusiService.dealPayBillCreate(fscPayBillCreateBusiReqBO);
            if ("0000".equals(busiRspBO.getRespCode())) {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            }
            BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        }
        return abilityRspBO;
    }

    @BigDecimalConvert(value=2)
    @PostMapping(value={"dealPayRegisterCreate"})
    public FscPayRegisterCreateAbilityRspBO dealPayRegisterCreate(@RequestBody FscPayRegisterCreateAbilityReqBO reqBO) {
        this.checkParam(reqBO);
        FscPayRegisterCreateBusiReqBO busiReqBO = (FscPayRegisterCreateBusiReqBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscPayRegisterCreateBusiReqBO.class));
        FscPayRegisterCreateBusiRspBO busiRspBO = this.fscPayBillCreateBusiService.dealPayRegisterCreate(busiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            fscComOrderListSyncAbilityReqBO.setFscOrderId(busiRspBO.getParentOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setObjId(reqBO.getFscOrderId());
        fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAY_EVIDENCE);
        ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPo);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            this.fscAttachmentMapper.deleteBy(fscAttachmentPo);
        }
        ArrayList fscAttachmentPOList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAttachmentList())) {
            fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
                fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPo.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                fscAttachmentPo.setAttachmentName(attachmentBO.getAttachmentName());
                fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAY_EVIDENCE);
                fscAttachmentPo.setObjId(reqBO.getFscOrderId());
                fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAY_EVIDENCE);
                fscAttachmentPOS.add(fscAttachmentPo);
            }
            fscAttachmentPOList.addAll(fscAttachmentPOS);
        }
        if (!CollectionUtils.isEmpty(fscAttachmentPOList)) {
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
        }
        return (FscPayRegisterCreateAbilityRspBO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscPayRegisterCreateAbilityRspBO.class);
    }

    private void checkParam(FscPayRegisterCreateAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderPayItemBOS())) {
            throw new FscBusinessException("191000", "\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u7236\u4ed8\u6b3e\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderNo())) {
            throw new FscBusinessException("191000", "\u7236\u4ed8\u6b3e\u7533\u8bf7\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
            if (fscOrderPayItemBO.getRegisterAmount() == null) {
                throw new FscBusinessException("191000", "\u767b\u8bb0\u91d1\u989d\u4e3a\u7a7a");
            }
            if (fscOrderPayItemBO.getShouldPayId() == null) {
                throw new FscBusinessException("191000", "\u5e94\u4ed8ID\u4e3a\u7a7a");
            }
            if (fscOrderPayItemBO.getRegisterAmount().compareTo(BigDecimal.ZERO) <= 0) {
                throw new FscBusinessException("191000", "\u767b\u8bb0\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8eO!");
            }
        });
    }

    private void validParam(FscPayBillCreateAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS()) && CollectionUtils.isEmpty((Collection)abilityReqBO.getFscShouldPayBOS())) {
            throw new FscBusinessException("191000", "\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u548c\u5e94\u4ed8\u8bb0\u5f55\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS())) {
            abilityReqBO.setFscShouldPayBOS(null);
            abilityReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
                if (fscOrderPayItemBO.getPayAmount() == null) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u4e3a\u7a7a");
                }
                if (fscOrderPayItemBO.getShouldPayId() == null) {
                    throw new FscBusinessException("191000", "\u5e94\u4ed8ID\u4e3a\u7a7a");
                }
                if (BigDecimal.ZERO.compareTo(fscOrderPayItemBO.getPayAmount()) >= 0) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8eO!");
                }
            });
            return;
        }
        if (abilityReqBO.getPayType() == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getShouldPayType() == null) {
            throw new FscBusinessException("191000", "\u5e94\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getPayeeId() == null) {
            throw new FscBusinessException("191000", "\u6536\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getPayerId() == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        abilityReqBO.getFscShouldPayBOS().forEach(fscShouldPayBO -> {
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getObjectNo())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7f16\u7801\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getShouldPayAmount())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5e94\u4ed8\u91d1\u989d\u4e3a\u7a7a\uff01");
            }
            if (null == fscShouldPayBO.getObjectId()) {
                throw new FscBusinessException("191000", "\u5355\u636eID\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getObjectType())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\uff01");
            }
            fscShouldPayBO.setPayeeId(abilityReqBO.getPayeeId());
            fscShouldPayBO.setPayeeName(abilityReqBO.getPayeeName());
            fscShouldPayBO.setPayerId(abilityReqBO.getPayerId());
            fscShouldPayBO.setPayerName(abilityReqBO.getPayerName());
            fscShouldPayBO.setContractNo(abilityReqBO.getContractNo());
            fscShouldPayBO.setPayType(abilityReqBO.getPayType());
            fscShouldPayBO.setShouldPayType(abilityReqBO.getShouldPayType());
        });
    }

    private void validateMemParam(FscPayBillCreateAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getPayAmount()) && BigDecimal.ZERO.compareTo(reqBO.getPayAmount()) >= 0) {
            throw new ZTBusinessException("\u4ed8\u6b3e\u91d1\u989d\u3010payAmount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setPayAmount(reqBO.getPayAmount().setScale(2, 4));
        if (ObjectUtil.isEmpty((Object)reqBO.getMemLevel())) {
            throw new ZTBusinessException("\u4f1a\u5458\u7b49\u7ea7\u3010memLevel\u3011\u5fc5\u987b\u5927\u4e8e0");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPayerId())) {
            throw new ZTBusinessException("\u4ed8\u6b3e\u65b9ID\u3010payerId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPayerName())) {
            throw new ZTBusinessException("\u4ed8\u6b3e\u65b9\u540d\u79f0\u3010payerName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getMemType())) {
            throw new ZTBusinessException("\u4f1a\u5458\u7c7b\u578b\u3010memType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getMemCycle())) {
            throw new ZTBusinessException("\u4f1a\u5458\u5468\u671f/\u5e74\u9650\u3010memCycle\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getEffDate())) {
            throw new ZTBusinessException("\u6709\u6548\u671f\u81f3\u3010effDate\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getEffDate().compareTo(new Date()) <= 0) {
            throw new ZTBusinessException("\u6709\u6548\u671f\u81f3\u3010effDate\u3011\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBuyName())) {
            throw new ZTBusinessException("\u53d1\u7968\u62ac\u5934\u3010buyName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getInvoiceType())) {
            throw new ZTBusinessException("\u53d1\u7968\u7c7b\u578b\u3010invoiceType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("01".equals(reqBO.getInvoiceType())) {
            if (ObjectUtil.isEmpty((Object)reqBO.getBank())) {
                throw new ZTBusinessException("\u53d1\u7968\u7c7b\u578b\u4e3a\u4e13\u7968\u65f6\uff0c\u5f00\u6237\u884c\u3010bank\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBO.getAccount())) {
                throw new ZTBusinessException("\u53d1\u7968\u7c7b\u578b\u4e3a\u4e13\u7968\u65f6\uff0c\u53d1\u7968\u5f00\u6237\u8d26\u53f7\u3010account\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBO.getAddress())) {
                throw new ZTBusinessException("\u53d1\u7968\u7c7b\u578b\u4e3a\u4e13\u7968\u65f6\uff0c\u53d1\u7968\u5730\u5740\u3010address\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBO.getPhone())) {
                throw new ZTBusinessException("\u53d1\u7968\u7c7b\u578b\u4e3a\u4e13\u7968\u65f6\uff0c\u53d1\u7968\u7535\u8bdd\u3010phone\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getInvoiceCategory())) {
            throw new ZTBusinessException("\u53d1\u7968\u7c7b\u522b\u3010invoiceCategory\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

