/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillOrderSettleCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSettleCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSettleCheckAbilityRspBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayBillCreateBySaleAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCreateBySaleBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiRspBO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.uoc.base.constants.UocCoreConstant;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillCreateBySaleAbilityService"})
public class FscPayBillCreateBySaleAbilityServiceImpl
implements FscPayBillCreateBySaleAbilityService {
    @Autowired
    private FscPayBillCreateBySaleBusiService fscPayBillCreateBySaleBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillOrderSettleCheckAbilityService fscBillOrderSettleCheckAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPayBillCreateBySale"})
    public FscPayBillCreateAbilityRspBO dealPayBillCreateBySale(@RequestBody FscPayBillCreateAbilityReqBO abilityReqBO) {
        FscPayBillCreateAbilityRspBO abilityRspBO = new FscPayBillCreateAbilityRspBO();
        this.validParam(abilityReqBO);
        FscBillOrderSettleCheckAbilityReqBO checkAbilityReqBO = new FscBillOrderSettleCheckAbilityReqBO();
        checkAbilityReqBO.setOrderIds(abilityReqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getOrderId).collect(Collectors.toList()));
        checkAbilityReqBO.setSettleType(abilityReqBO.getSettleType());
        checkAbilityReqBO.setUserType(!StringUtils.isEmpty((Object)abilityReqBO.getIsprofess()) && "0".equals(abilityReqBO.getIsprofess()) ? UocCoreConstant.UserType.PRO : UocCoreConstant.UserType.PUR);
        FscBillOrderSettleCheckAbilityRspBO checkAbilityRspBO = this.fscBillOrderSettleCheckAbilityService.dealOrderSettleCheck(checkAbilityReqBO);
        if (!checkAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(checkAbilityRspBO.getRespCode(), checkAbilityRspBO.getRespDesc());
        }
        FscPayBillCreateBusiReqBO fscPayBillCreateBusiReqBO = (FscPayBillCreateBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscPayBillCreateBusiReqBO.class));
        FscPayBillCreateBusiRspBO busiRspBO = this.fscPayBillCreateBySaleBusiService.dealPayBillBySaleCreate(fscPayBillCreateBusiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        return abilityRspBO;
    }

    private void validParam(FscPayBillCreateAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS())) {
            throw new FscBusinessException("191000", "\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS())) {
            abilityReqBO.setFscShouldPayBOS(null);
            abilityReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
                if (Objects.isNull(fscOrderPayItemBO.getOrderId())) {
                    throw new FscBusinessException("191000", "\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (fscOrderPayItemBO.getPayAmount() == null) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (fscOrderPayItemBO.getOrderId() == null) {
                    throw new FscBusinessException("191000", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (BigDecimal.ZERO.compareTo(fscOrderPayItemBO.getPayAmount()) >= 0) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8eO!");
                }
            });
            return;
        }
        if (abilityReqBO.getPayType() == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getShouldPayType() == null) {
            throw new FscBusinessException("191000", "\u5e94\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getPayeeId() == null) {
            throw new FscBusinessException("191000", "\u6536\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getPayerId() == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

