/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPurAdvanceInfoQryAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPurAdvanceInfoQryAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPurAdvanceInfoQryAbilityRspBO;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import java.math.BigDecimal;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPurAdvanceInfoQryAbilityService"})
public class FscPurAdvanceInfoQryAbilityServiceImpl
implements FscPurAdvanceInfoQryAbilityService {
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @PostMapping(value={"qryPurAdvanceInfo"})
    public FscPurAdvanceInfoQryAbilityRspBO qryPurAdvanceInfo(@RequestBody FscPurAdvanceInfoQryAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscPurAdvanceInfoQryAbilityRspBO rspBO = new FscPurAdvanceInfoQryAbilityRspBO();
        rspBO.setAdvanceAmt(BigDecimal.ZERO);
        rspBO.setAvailableAdvanceAmt(BigDecimal.ZERO);
        rspBO.setOverdraftAmt(BigDecimal.ZERO);
        rspBO.setAvailableOverdraftAmt(BigDecimal.ZERO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPayType(Integer.valueOf(-1));
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(this.operationOrgId);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayBusiSceneRangeLike("1");
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo.setEnable(Integer.valueOf(1));
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (null == fscMerchantPo) {
            throw new FscBusinessException("194304", "\u67e5\u8be2\u5546\u6237\u4e3a\u7a7a");
        }
        FscMerchantPO merchant = new FscMerchantPO();
        merchant.setPayBusiSceneRangeLike("1");
        merchant.setParentId(fscMerchantPo.getMerchantId());
        merchant.setDelFlag(FscConstants.DicDelFlag.NO);
        merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
        merchant.setPayObjId(Long.valueOf(reqBO.getBuyerId()));
        merchant.setEnable(Integer.valueOf(1));
        merchant = this.fscMerchantMapper.getModelBy(merchant);
        if (null != merchant) {
            BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
        }
        if (fscMerchantPo.getPayType() == null) {
            return rspBO;
        }
        rspBO.setPayType(fscMerchantPo.getPayType());
        if (!fscMerchantPo.getPayType().equals(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE)) {
            return rspBO;
        }
        FscAccountPO queryVo = new FscAccountPO();
        queryVo.setBusiType("1");
        queryVo.setStatus(Integer.valueOf(1));
        if (reqBO.getPurId() != null) {
            queryVo.setOrgId(reqBO.getPurId());
            FscAccountPO accountPO = this.fscAccountMapper.getModelBy(queryVo);
            if (accountPO == null || accountPO.getAdvanceAmount() == null || accountPO.getOverdraft() == null) {
                queryVo.setOrgCode(reqBO.getBuyerNo());
                queryVo.setOrgId(null);
                accountPO = this.fscAccountMapper.getModelBy(queryVo);
                if (accountPO != null) {
                    rspBO.setAdvanceAmt(accountPO.getAdvanceAmount());
                    rspBO.setAvailableAdvanceAmt(accountPO.getAdvanceAmount().subtract(accountPO.getFreezeAmount()).subtract(accountPO.getUseAmount()).subtract(accountPO.getDistributeAdvanceAmount()));
                    if (rspBO.getAvailableAdvanceAmt().compareTo(BigDecimal.ZERO) < 0) {
                        rspBO.setAvailableAdvanceAmt(BigDecimal.ZERO);
                    }
                    rspBO.setOverdraftAmt(fscMerchantPo.getOverdraft());
                    rspBO.setAvailableOverdraftAmt(fscMerchantPo.getOverdraft().subtract(accountPO.getOverdraftAmount()));
                    if (rspBO.getAvailableOverdraftAmt().compareTo(BigDecimal.ZERO) < 0) {
                        rspBO.setAvailableOverdraftAmt(BigDecimal.ZERO);
                    }
                    rspBO.setAccountNo(accountPO.getAccountNo());
                    rspBO.setPurOrgName(accountPO.getOrgName());
                }
            } else {
                rspBO.setAdvanceAmt(accountPO.getAdvanceAmount());
                rspBO.setAvailableAdvanceAmt(accountPO.getAdvanceAmount().subtract(accountPO.getFreezeAmount()).subtract(accountPO.getUseAmount()).subtract(accountPO.getDistributeAdvanceAmount()));
                if (rspBO.getAvailableAdvanceAmt().compareTo(BigDecimal.ZERO) < 0) {
                    rspBO.setAvailableAdvanceAmt(BigDecimal.ZERO);
                }
                rspBO.setOverdraftAmt(accountPO.getOverdraft());
                rspBO.setAvailableOverdraftAmt(fscMerchantPo.getOverdraft().subtract(accountPO.getOverdraftAmount()));
                if (rspBO.getAvailableOverdraftAmt().compareTo(BigDecimal.ZERO) < 0) {
                    rspBO.setAvailableOverdraftAmt(BigDecimal.ZERO);
                }
                rspBO.setAccountNo(accountPO.getAccountNo());
                rspBO.setPurOrgName(accountPO.getOrgName());
            }
        }
        return rspBO;
    }

    private void valid(FscPurAdvanceInfoQryAbilityReqBO reqBO) {
        if (reqBO.getPurId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4did[purId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getBuyerNo())) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e70\u53d7\u4eba\u7f16\u7801[buyerNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getBuyerId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u4e70\u53d7\u4ebaid[buyerId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

