/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillOrderSettleCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSettleCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSettleCheckAbilityRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPayItemSerialMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillCreateAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillCreateAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillCreateAtomRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscPayItemSerialPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillCreateAtomServiceImpl
implements FscPayBillCreateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCreateAtomServiceImpl.class);
    @Value(value="${saleOrderTabId:30001}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Resource
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Resource
    private FscPayItemSerialMapper fscPayItemSerialMapper;
    @Autowired
    private FscBillOrderSettleCheckAbilityService fscBillOrderSettleCheckAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private PebExtOrderSettleTypeUpdateAbilityService pebExtOrderSettleTypeUpdateAbilityService;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;

    @Override
    public FscPayBillCreateAtomRspBO dealPayBillCreate(FscPayBillCreateAtomReqBO atomReqBO) {
        FscPayBillCreateAtomRspBO atomRspBO = new FscPayBillCreateAtomRspBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        List<Long> orderIdList = null;
        String operationNo = String.valueOf(atomReqBO.getOrgId());
        if ("0".equals(atomReqBO.getIsprofess())) {
            String[] org = this.proOrg.split(",");
            String[] pur = atomReqBO.getOrgPath().split("-");
            block0: for (String pro : org) {
                for (String t : pur) {
                    if (!pro.equals(t)) continue;
                    operationNo = pro;
                    continue block0;
                }
            }
        }
        if (!CollectionUtils.isEmpty(atomReqBO.getFscOrderPayItemBOS())) {
            orderIdList = this.updateShouldPay(atomReqBO, fscOrderId, atomRspBO);
            if (atomReqBO.getPayFscOrderId() != null) {
                atomRspBO.setFscOrderId(atomReqBO.getPayFscOrderId());
                return atomRspBO;
            }
        } else {
            orderIdList = this.insertShouldPay(atomReqBO, fscOrderId, operationNo);
            FscBillOrderSettleCheckAbilityReqBO checkAbilityReqBO = new FscBillOrderSettleCheckAbilityReqBO();
            checkAbilityReqBO.setOrderIds(orderIdList);
            checkAbilityReqBO.setSettleType(atomReqBO.getSettleType());
            checkAbilityReqBO.setUserType(!StringUtils.isEmpty((Object)atomReqBO.getIsprofess()) && "0".equals(atomReqBO.getIsprofess()) ? UocCoreConstant.UserType.PRO : UocCoreConstant.UserType.PUR);
            FscBillOrderSettleCheckAbilityRspBO checkAbilityRspBO = this.fscBillOrderSettleCheckAbilityService.dealOrderSettleCheck(checkAbilityReqBO);
            if (!checkAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(checkAbilityRspBO.getRespCode(), checkAbilityRspBO.getRespDesc());
            }
        }
        this.insertOrder(atomReqBO, fscOrderId, operationNo);
        this.insertAttachment(atomReqBO.getAttachmentList(), fscOrderId);
        this.invokeUacNoTask(atomReqBO, fscOrderId);
        if (!CollectionUtils.isEmpty(orderIdList)) {
            PebExtOrderSettleTypeUpdateAbilityReqBO settleReqBO = new PebExtOrderSettleTypeUpdateAbilityReqBO();
            settleReqBO.setUserType("0".equals(atomReqBO.getIsprofess()) ? UocCoreConstant.UserType.PRO : UocCoreConstant.UserType.PUR);
            settleReqBO.setSettleType(FscConstants.SettleType.INSPECTION);
            settleReqBO.setOrderIds(orderIdList);
            PebExtOrderSettleTypeUpdateAbilityRspBO orderUpdateRspBO = this.pebExtOrderSettleTypeUpdateAbilityService.dealOrderSettleType(settleReqBO);
            if (!"0000".equals(orderUpdateRspBO.getRespCode())) {
                log.error("\u540c\u6b65\u8ba2\u5355\u7ed3\u7b97\u7c7b\u578b\u5931\u8d25\uff1a" + orderUpdateRspBO.getRespDesc());
            }
        }
        atomRspBO.setFscOrderId(fscOrderId);
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return atomRspBO;
    }

    private void invokeUacNoTask(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusStartAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        if (busiReqBO.getQueryAuditFlag().booleanValue()) {
            UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
            uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
            uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
            uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
            uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
            uacNoTaskAuditCreateReqBO.setMenuId("fscPayApplyOrder");
            uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
            ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
            UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
            uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
            uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
            uacNoTaskAuditCreateInfoReqBO.setOrderId(fscOrderId);
            createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
            ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
            ApprovalObjBO approvalObjBO = new ApprovalObjBO();
            approvalObjBO.setObjId(fscOrderId.toString());
            approvalObjBO.setObjName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
            approvalObjBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
            approvalObjInfo.add(approvalObjBO);
            uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
            uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
            BigDecimal payAmount = BigDecimal.ZERO;
            for (FscOrderPayItemBO payItem : busiReqBO.getFscOrderPayItemBOS()) {
                payAmount = payAmount.add(payItem.getPayAmount());
            }
            HashMap<String, Number> variables = new HashMap<String, Number>();
            variables.put("payAmount", payAmount);
            Long shouldPayId = busiReqBO.getFscOrderPayItemBOS().get(0).getShouldPayId();
            FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
            fscShouldPayPo.setShouldPayId(shouldPayId);
            FscShouldPayPO model = this.fscShouldPayMapper.getModelBy(fscShouldPayPo);
            if (FscPayTypeEnum.ADVANCE_PAY.getCode().equals(busiReqBO.getShouldPayMethod())) {
                variables.put("payType", 1);
            } else {
                variables.put("payType", 2);
            }
            uacNoTaskAuditCreateReqBO.setVariables(variables);
            UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
            log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
            if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
                throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
            }
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
                throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u4ed8\u6b3e\u5ba1\u6279\u6d41\uff01");
            }
            if (uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
                paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
            }
            fscOrderStatusStartAtomReqBO.setTradeMode(model.getTradeMode());
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserName());
        fscOrderStatusStartAtomReqBO.setIndividually(busiReqBO.getIndividually());
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194203", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private void insertOrder(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId, String operationNo) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscOrderPO.setPayerId(busiReqBO.getPayerId());
        fscOrderPO.setPayerName(busiReqBO.getPayerName());
        fscOrderPO.setPayeeId(busiReqBO.getPayeeId());
        fscOrderPO.setPayeeName(busiReqBO.getPayeeName());
        fscOrderPO.setPayeeAccountName(busiReqBO.getPayeeAccountName());
        fscOrderPO.setPayeeBankAccount(busiReqBO.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName(busiReqBO.getPayeeBankName());
        if (StringUtils.isEmpty((Object)fscOrderPO.getPayeeAccountName()) || StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankAccount()) || StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankName())) {
            FscMerchantPayeePO fscMerchantPayeePO = new FscMerchantPayeePO();
            fscMerchantPayeePO.setSupplierId(busiReqBO.getPayeeId());
            List fscMerchantPayeePOList = this.fscMerchantPayeeMapper.getList(fscMerchantPayeePO);
            if (!CollectionUtils.isEmpty((Collection)fscMerchantPayeePOList)) {
                fscMerchantPayeePO = (FscMerchantPayeePO)fscMerchantPayeePOList.get(0);
                fscOrderPO.setPayeeAccountName(fscMerchantPayeePO.getPayeeAccountName());
                fscOrderPO.setPayeeBankAccount(fscMerchantPayeePO.getPayeeBankAccount());
                fscOrderPO.setPayeeBankName(fscMerchantPayeePO.getPayeeBankName());
            } else {
                throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u672a\u914d\u7f6e\u6536\u6b3e\u8d26\u6237");
            }
        }
        fscOrderPO.setPayMethod(busiReqBO.getPayMethod());
        fscOrderPO.setPayType(busiReqBO.getPayType());
        fscOrderPO.setShouldPayType(busiReqBO.getShouldPayType());
        fscOrderPO.setPayChannel(busiReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(busiReqBO.getTotalAmount());
        fscOrderPO.setContractNo(busiReqBO.getContractNo());
        fscOrderPO.setContractId(busiReqBO.getContractId());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        fscOrderPO.setPaidAmount(BigDecimal.ZERO);
        fscOrderPO.setPayingAmount(BigDecimal.ZERO);
        fscOrderPO.setToPayAmount(busiReqBO.getTotalAmount());
        fscOrderPO.setYcDeptId(busiReqBO.getYcDeptId());
        fscOrderPO.setYcDeptName(busiReqBO.getYcDeptName());
        fscOrderPO.setYcUserId(busiReqBO.getYcUserId());
        fscOrderPO.setYcUserName(busiReqBO.getYcUserName());
        fscOrderPO.setBuynerNo(busiReqBO.getBuynerNo());
        fscOrderPO.setBuynerName(busiReqBO.getBuynerName());
        fscOrderPO.setOrderType(busiReqBO.getOrderType());
        fscOrderPO.setOrderSource(busiReqBO.getOrderSource());
        fscOrderPO.setTradeMode(busiReqBO.getTradeMode());
        fscOrderPO.setRemark(busiReqBO.getRemark());
        fscOrderPO.setPaymentMethod(busiReqBO.getPaymentMethod());
        fscOrderPO.setSettleType(busiReqBO.getSettleType());
        if ("0".equals(busiReqBO.getIsprofess())) {
            fscOrderPO.setOperatorId(busiReqBO.getUserId());
            fscOrderPO.setOperatorName(busiReqBO.getName());
            fscOrderPO.setOperationNo(operationNo);
            fscOrderPO.setOperationName(busiReqBO.getCompanyName());
        }
        if ("3".equals(busiReqBO.getPayChannel())) {
            if (null != busiReqBO.getUserId()) {
                fscOrderPO.setPayOperId(busiReqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(busiReqBO.getName());
        }
        this.fscOrderMapper.insert(fscOrderPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(fscOrderId);
        List invoicePOList = this.fscInvoiceMapper.getInvoiceByShouldPay(fscInvoicePO);
        if (CollectionUtils.isEmpty((Collection)invoicePOList)) {
            invoicePOList = this.fscInvoiceMapper.getInvoiceByAdvance(fscInvoicePO);
        }
        StringBuilder invoiceNo = new StringBuilder();
        StringBuilder invoiceCode = new StringBuilder();
        log.debug("invoicePoList:" + JSONObject.toJSONString((Object)invoicePOList));
        if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
            boolean flag = false;
            for (FscInvoicePO po : invoicePOList) {
                if (po == null) continue;
                flag = true;
                invoiceNo.append(po.getInvoiceNo()).append(",");
                invoiceCode.append(po.getInvoiceCode()).append(",");
            }
            if (flag) {
                fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderId);
                fscOrderPO.setInvoiceNo(invoiceNo.toString());
                fscOrderPO.setInvoiceCode(invoiceCode.toString());
                this.fscOrderMapper.updateById(fscOrderPO);
            }
        }
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        if (!CollectionUtils.isEmpty(attachmentBOList)) {
            FscAttachmentPO deletPo = new FscAttachmentPO();
            deletPo.setFscOrderId(fscOrderId);
            deletPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
            ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletPo);
            if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
                this.fscAttachmentMapper.deleteBy(deletPo);
            }
            fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : attachmentBOList) {
                FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPo.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                fscAttachmentPo.setAttachmentName(attachmentBO.getAttachmentName());
                fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAYMENT);
                fscAttachmentPo.setObjId(fscOrderId);
                fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
                fscAttachmentPo.setFscOrderId(fscOrderId);
                fscAttachmentPOS.add(fscAttachmentPo);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        }
    }

    private List<Long> updateShouldPay(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId, FscPayBillCreateAtomRspBO atomRspBO) {
        FscShouldPayPO fscShouldPayPO1 = new FscShouldPayPO();
        ArrayList shouldPayIds = new ArrayList();
        busiReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> shouldPayIds.add(fscOrderPayItemBO.getShouldPayId()));
        fscShouldPayPO1.setShouldPayIds(shouldPayIds);
        List poResult = this.fscShouldPayMapper.getList(fscShouldPayPO1);
        if (CollectionUtils.isEmpty((Collection)poResult)) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        HashSet shouldPayType = new HashSet();
        HashSet payerIds = new HashSet();
        HashSet payeeIds = new HashSet();
        HashSet contractNos = new HashSet();
        HashSet payType = new HashSet();
        poResult.forEach(fscShouldPayPO -> {
            if (null != fscShouldPayPO.getShouldPayType()) {
                shouldPayType.add(fscShouldPayPO.getShouldPayType());
                busiReqBO.setShouldPayType(fscShouldPayPO.getShouldPayType());
            }
            if (null != fscShouldPayPO.getPayerId()) {
                payerIds.add(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerId(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerName(fscShouldPayPO.getPayerName());
            }
            if (null != fscShouldPayPO.getPayeeId()) {
                payeeIds.add(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeId(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeName(fscShouldPayPO.getPayeeName());
            }
            if (null != fscShouldPayPO.getPayType()) {
                payType.add(fscShouldPayPO.getPayType());
                busiReqBO.setPayType(fscShouldPayPO.getPayType());
            }
            if (StringUtils.hasText((String)fscShouldPayPO.getContractNo())) {
                contractNos.add(fscShouldPayPO.getContractNo());
                busiReqBO.setContractNo(fscShouldPayPO.getContractNo());
            }
            if (fscShouldPayPO.getContractId() != null) {
                busiReqBO.setContractId(fscShouldPayPO.getContractId());
            }
            if (!StringUtils.isEmpty((Object)fscShouldPayPO.getBuyerNo())) {
                busiReqBO.setBuynerNo(fscShouldPayPO.getBuyerNo());
            }
            if (!StringUtils.isEmpty((Object)fscShouldPayPO.getBuyerName())) {
                busiReqBO.setBuynerName(fscShouldPayPO.getBuyerName());
            }
        });
        if (shouldPayType.size() > 1) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payerIds.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payType.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5f0f\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (contractNos.size() > 1) {
            throw new FscBusinessException("194203", "\u5408\u540c\u7f16\u53f7\u5fc5\u987b\u552f\u4e00\uff01");
        }
        List<Long> orderIdList = poResult.stream().map(FscShouldPayPO::getOrderId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(orderIdList)) {
            FscShouldPayPO fscShouldPayPOReq = new FscShouldPayPO();
            fscShouldPayPOReq.setOrderIds(orderIdList);
            fscShouldPayPOReq.setPayeeId((Long)payeeIds.iterator().next());
            fscShouldPayPOReq.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_GRADING_PAY);
            List payPOList = this.fscShouldPayMapper.getListByOrderId(fscShouldPayPOReq);
            if (!CollectionUtils.isEmpty((Collection)payPOList)) {
                String orderNo = payPOList.stream().map(FscShouldPayPO::getObjectNo).filter(objectNo -> !StringUtils.isEmpty((Object)objectNo)).distinct().collect(Collectors.joining(","));
                orderNo = StringUtils.isEmpty((Object)orderNo) ? "\u6240\u9009\u4ed8\u6b3e\u4f9d\u636e\u7f16\u53f7" : orderNo;
                throw new FscBusinessException("194203", orderNo + "\u5df2\u901a\u8fc7\u7279\u6b8a\u4ed8\u6b3e\u4e1a\u52a1\u53d1\u8d77\u4ed8\u6b3e");
            }
        }
        if (!FscConstants.ShouldPayType.PAYMENT_DAY_PAY.equals(busiReqBO.getShouldPayType()) && (FscOrderTypeEnum.INDIVIDUALLY.getCode().equals(busiReqBO.getOrderType()) || FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode().equals(busiReqBO.getOrderType()))) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setShouldPayIds(shouldPayIds);
            ArrayList<Integer> excludeOrderStates = new ArrayList<Integer>();
            excludeOrderStates.add(FscConstants.FscPayOrderState.CANCEL);
            excludeOrderStates.add(FscConstants.FscPayOrderState.DELETE);
            fscOrderPayItemPO.setExcludeOrderStates(excludeOrderStates);
            List itemPOS = this.fscOrderPayItemMapper.getListByOrder(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)itemPOS) && itemPOS.size() == shouldPayIds.size()) {
                HashSet payFscOrderIds = new HashSet();
                itemPOS.forEach(fscOrderPayItemPO1 -> payFscOrderIds.add(fscOrderPayItemPO1.getFscOrderId()));
                if (payFscOrderIds.size() == 1) {
                    FscOrderPO fscOrderPO = new FscOrderPO();
                    fscOrderPO.setFscOrderId((Long)payFscOrderIds.iterator().next());
                    fscOrderPO.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
                    FscOrderPO po = this.fscOrderMapper.getModelBy(fscOrderPO);
                    if (po != null) {
                        busiReqBO.setPayFscOrderId(po.getFscOrderId());
                        FscOrderPO set = new FscOrderPO();
                        FscOrderPO where = new FscOrderPO();
                        set.setPayChannel(busiReqBO.getPayChannel());
                        set.setPayMethod(busiReqBO.getPayMethod());
                        where.setFscOrderId(po.getFscOrderId());
                        this.fscOrderMapper.updateBy(set, where);
                        return null;
                    }
                    throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5df2\u5b58\u5728\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4e14\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001\uff01");
                }
                throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5b58\u5728\u591a\u4e2a\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u8bf7\u5230\u4ed8\u6b3e\u7533\u8bf7\u9875\u9762\u8fdb\u884c\u652f\u4ed8\uff01");
            }
        }
        Map shouldPayMap = poResult.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, Function.identity(), (k1, k2) -> k1));
        HashMap<Long, FscShouldPayPO> payItemMap = new HashMap<Long, FscShouldPayPO>();
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        for (FscOrderPayItemBO fscOrderPayItemBO2 : busiReqBO.getFscOrderPayItemBOS()) {
            FscPayItemSerialPO fscPayItemSerialPO;
            FscShouldPayPO fscShouldPayPO2 = new FscShouldPayPO();
            fscShouldPayPO2.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            fscShouldPayPO2.setPayAmount(fscOrderPayItemBO2.getPayAmount());
            int count = this.fscShouldPayMapper.updateAmount(fscShouldPayPO2);
            if (count != 1) {
                throw new FscBusinessException("194203", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
            }
            payItemMap.put(((FscShouldPayPO)shouldPayMap.get(fscOrderPayItemBO2.getShouldPayId())).getOrderId(), fscShouldPayPO2);
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            po.setPayAmount(fscOrderPayItemBO2.getPayAmount());
            if (StringUtils.isEmpty((Object)fscOrderPayItemBO2.getShouldPayItemNo())) {
                po.setShouldPayItemNo(((FscShouldPayPO)shouldPayMap.get(fscOrderPayItemBO2.getShouldPayId())).getShouldPayNo() + "-01");
            } else {
                po.setShouldPayItemNo(fscOrderPayItemBO2.getShouldPayItemNo());
            }
            po.setShouldPayMethod(busiReqBO.getShouldPayMethod());
            List fscPayItemSerialPOList = this.fscPayItemSerialMapper.queryByShouldPayNo(fscOrderPayItemBO2.getShouldPayNo());
            int serialNumber = 0;
            if (!CollectionUtils.isEmpty((Collection)fscPayItemSerialPOList)) {
                fscPayItemSerialPO = (FscPayItemSerialPO)fscPayItemSerialPOList.get(0);
                serialNumber = ((FscPayItemSerialPO)fscPayItemSerialPOList.get(0)).getSerialNumber();
                fscPayItemSerialPO.setSerialNumber(Integer.valueOf(++serialNumber));
                this.fscPayItemSerialMapper.update(fscPayItemSerialPO);
            } else {
                fscPayItemSerialPO = new FscPayItemSerialPO();
                fscPayItemSerialPO.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
                fscPayItemSerialPO.setShouldPayNo(fscOrderPayItemBO2.getShouldPayNo());
                fscPayItemSerialPO.setSerialNumber(Integer.valueOf(++serialNumber));
                this.fscPayItemSerialMapper.insert(fscPayItemSerialPO);
            }
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO2.getPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        atomRspBO.setPayeeId((Long)payeeIds.iterator().next());
        atomRspBO.setPayerId((Long)payerIds.iterator().next());
        this.handlePayDetail(poResult, payItemMap, busiReqBO, fscOrderId);
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        return orderIdList;
    }

    private List<Long> insertShouldPay(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId, String operationNo) {
        List fscShouldPayPOS = JSON.parseArray((String)JSON.toJSONString(busiReqBO.getFscShouldPayBOS()), FscShouldPayPO.class);
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        List serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()) == null) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(fscShouldPayPOS.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()).getDescr());
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        for (int i = 0; i < fscShouldPayPOS.size(); ++i) {
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayPOS.get(i);
            Long shouldPayId = Sequence.getInstance().nextId();
            fscShouldPayPO.setShouldPayId(shouldPayId);
            fscShouldPayPO.setCreateId(busiReqBO.getUserId());
            fscShouldPayPO.setCreateName(busiReqBO.getName());
            fscShouldPayPO.setCreateAccount(busiReqBO.getUserName());
            fscShouldPayPO.setCreateTime(new Date());
            fscShouldPayPO.setCreateCompanyId(busiReqBO.getCompanyId());
            fscShouldPayPO.setCreateCompanyName(busiReqBO.getCompanyName());
            fscShouldPayPO.setCreateOrgId(busiReqBO.getOrgId());
            fscShouldPayPO.setCreateOrgName(busiReqBO.getOrgName());
            fscShouldPayPO.setPayingAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setPaidAmount(new BigDecimal(0));
            fscShouldPayPO.setToPayAmount(new BigDecimal(0));
            fscShouldPayPO.setShouldPayNo((String)serialNoList.get(i));
            fscShouldPayPO.setPenalty(new BigDecimal(0));
            fscShouldPayPO.setOriginalAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
            fscShouldPayPO.setPayMethod(FscPayTypeEnum.SHOULD_PAY.getCode());
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(shouldPayId);
            po.setPayAmount(fscShouldPayPO.getShouldPayAmount());
            po.setShouldPayMethod(FscPayTypeEnum.ADVANCE_PAY.getCode());
            po.setShouldPayItemNo(fscShouldPayPO.getShouldPayNo() + "-01");
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscShouldPayPO.getShouldPayAmount());
            if ("0".equals(busiReqBO.getIsprofess())) {
                fscShouldPayPO.setOperatorId(busiReqBO.getUserId());
                fscShouldPayPO.setOperationNo(operationNo);
            }
            if (!StringUtils.isEmpty((Object)fscShouldPayPO.getAgreementId())) continue;
            fscShouldPayPO.setAgreementId(null);
        }
        busiReqBO.setTotalAmount(totalAmount);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOS)) {
            this.fscShouldPayMapper.insertBatch(fscShouldPayPOS);
        }
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        return fscShouldPayPOS.stream().map(FscShouldPayPO::getOrderId).collect(Collectors.toList());
    }

    public void handlePayDetail(List<FscShouldPayPO> poResult, Map<Long, FscShouldPayPO> payItemMap, FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId) {
        List orderIdList = poResult.stream().map(FscShouldPayPO::getOrderId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderIdList)) {
            log.error("\u5f53\u524d\u5e94\u4ed8\u5355\u65e0\u8ba2\u5355\u53f7\u4fe1\u606f");
            return;
        }
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setPageSize(1000);
        saleDetailsReqBO.setOrderIdList(orderIdList);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setIndividually("1");
        log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)saleDetailsReqBO));
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        log.debug("\u67e5\u8be2\u9500\u552e\u5355\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)saleDetailsRspBO));
        if (CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        FscOrderPayDetailPO fscOrderPayDetailPOReq = new FscOrderPayDetailPO();
        fscOrderPayDetailPOReq.setOrderIdList(orderIdList);
        fscOrderPayDetailPOReq.setRelType("0".equals(busiReqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
        List payDetailPOList = this.fscOrderPayDetailMapper.queryList(fscOrderPayDetailPOReq);
        Map<Object, Object> payDetailMap = !CollectionUtils.isEmpty((Collection)payDetailPOList) ? payDetailPOList.stream().collect(Collectors.groupingBy(FscOrderPayDetailPO::getOrderItemId, Collectors.mapping(FscOrderPayDetailPO::getPayAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))) : new HashMap();
        if (!CollectionUtils.isEmpty(payItemMap)) {
            ArrayList fscOrderPayDetailPOList = new ArrayList();
            saleDetailsRspBO.getRows().forEach(e -> ((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderItemList().forEach(item -> {
                FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)payItemMap.get(Long.valueOf(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderId()));
                if (Objects.isNull(fscShouldPayPO)) {
                    throw new FscBusinessException("194203", e.getOrderId() + "\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u5e94\u4ed8\u6570\u636e");
                }
                if (fscShouldPayPO.getPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
                    return;
                }
                BigDecimal orderAmount = Objects.nonNull(busiReqBO.getIsprofess()) && "0".equals(busiReqBO.getIsprofess()) ? new BigDecimal(item.getPurchaseFeeMoney()) : new BigDecimal(item.getSaleFeeMoney());
                BigDecimal initOrderAmt = orderAmount;
                BigDecimal payOrderAmount = BigDecimal.ZERO;
                if (Objects.nonNull(payDetailMap.get(Long.valueOf(item.getOrderItemId())))) {
                    payOrderAmount = (BigDecimal)payDetailMap.get(Long.valueOf(item.getOrderItemId()));
                }
                if (BigDecimal.ZERO.compareTo(orderAmount = orderAmount.subtract(payOrderAmount)) == 0) {
                    return;
                }
                FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
                fscOrderPayDetailPO.setPayDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderPayDetailPO.setSettleType(busiReqBO.getSettleType());
                fscOrderPayDetailPO.setOrderId(Objects.isNull(e.getOrderId()) ? null : Long.valueOf(e.getOrderId()));
                fscOrderPayDetailPO.setOrderItemId(Objects.isNull(item.getOrderItemId()) ? null : Long.valueOf(item.getOrderItemId()));
                fscOrderPayDetailPO.setSaleVoucherId(Objects.isNull(e.getSaleVoucherId()) ? null : Long.valueOf(e.getSaleVoucherId()));
                fscOrderPayDetailPO.setFscOrderId(fscOrderId);
                fscOrderPayDetailPO.setShouldPayId(fscShouldPayPO.getShouldPayId());
                fscOrderPayDetailPO.setOrderAmount(initOrderAmt);
                fscOrderPayDetailPO.setBeforeLeaveAmount(orderAmount);
                fscOrderPayDetailPO.setRelType("0".equals(busiReqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
                fscOrderPayDetailPO.setCreateId(Objects.nonNull(busiReqBO.getUserId()) ? busiReqBO.getUserId().toString() : "");
                fscOrderPayDetailPO.setCreateTime(new Date());
                fscOrderPayDetailPO.setUpdateId(Objects.nonNull(busiReqBO.getUserId()) ? busiReqBO.getUserId().toString() : "");
                fscOrderPayDetailPO.setUpdateTime(new Date());
                if (fscShouldPayPO.getPayAmount().compareTo(orderAmount) > 0) {
                    fscOrderPayDetailPO.setPayAmount(orderAmount);
                    fscShouldPayPO.setPayAmount(fscShouldPayPO.getPayAmount().subtract(orderAmount));
                } else {
                    fscOrderPayDetailPO.setPayAmount(fscShouldPayPO.getPayAmount());
                    fscShouldPayPO.setPayAmount(BigDecimal.ZERO);
                }
                fscOrderPayDetailPOList.add(fscOrderPayDetailPO);
            }));
            int count = this.fscOrderPayDetailMapper.insertBatch(fscOrderPayDetailPOList);
            if (count == 0) {
                throw new FscBusinessException("194203", "\u63d2\u5165\u8ba2\u5355\u652f\u4ed8\u660e\u7ec6\u5f02\u5e38");
            }
        }
    }
}

