/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayItemSerialMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillCreateBySaleAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillCreateAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillCreateAtomRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPayItemSerialPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.api.PebExtOrderSettleTypeUpdateAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderSettleTypeUpdateAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillCreateBySaleAtomServiceImpl
implements FscPayBillCreateBySaleAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCreateBySaleAtomServiceImpl.class);
    @Value(value="${saleOrderTabId:80014}")
    private Integer SALE_ORDER_TAB_ID;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Resource
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Resource
    private FscPayItemSerialMapper fscPayItemSerialMapper;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private PebExtOrderSettleTypeUpdateAbilityService pebExtOrderSettleTypeUpdateAbilityService;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;

    @Override
    public FscPayBillCreateAtomRspBO dealPayBillCreateBySale(FscPayBillCreateAtomReqBO reqBO) {
        List<Long> orderIdList;
        boolean operationFlag;
        FscPayBillCreateAtomRspBO atomRspBO = new FscPayBillCreateAtomRspBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        String operationNo = String.valueOf(reqBO.getOrgId());
        boolean bl = operationFlag = !StringUtils.isEmpty((Object)reqBO.getIsprofess()) && "0".equals(reqBO.getIsprofess());
        if (operationFlag) {
            String[] org = this.proOrg.split(",");
            String[] pur = reqBO.getOrgPath().split("-");
            block0: for (String pro : org) {
                for (String t : pur) {
                    if (!pro.equals(t)) continue;
                    operationNo = pro;
                    continue block0;
                }
            }
        }
        if (CollectionUtils.isEmpty(orderIdList = reqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getOrderId).collect(Collectors.toList()))) {
            throw new FscBusinessException("194203", "\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List relationPOList = this.fscOrderRelationMapper.queryTransitList(orderIdList);
        if (!CollectionUtils.isEmpty((Collection)relationPOList)) {
            throw new FscBusinessException("194203", ((FscOrderRelationPO)relationPOList.get(0)).getOrderNo() + "\u8ba2\u5355\u5b58\u5728\u5f00\u7968\u7533\u8bf7\uff0c\u8bf7\u5c06\u5f00\u7968\u7533\u8bf7\u6d41\u7a0b\u5b8c\u6210\u540e\uff0c\u91cd\u65b0\u53d1\u8d77\u4ed8\u6b3e\uff01");
        }
        FscShouldPayPO fscShouldPayPO = this.handleShouldPay(reqBO, fscOrderId, orderIdList, operationFlag);
        this.insertOrder(reqBO, fscOrderId, operationNo, fscShouldPayPO, operationFlag);
        this.insertAttachment(reqBO.getAttachmentList(), fscOrderId);
        this.invokeUacNoTask(reqBO, fscOrderId, fscShouldPayPO);
        PebExtOrderSettleTypeUpdateAbilityReqBO settleReqBO = new PebExtOrderSettleTypeUpdateAbilityReqBO();
        settleReqBO.setUserType(operationFlag ? UocCoreConstant.UserType.PRO : UocCoreConstant.UserType.PUR);
        settleReqBO.setSettleType(FscConstants.SettleType.ORDER);
        settleReqBO.setOrderIds(orderIdList);
        PebExtOrderSettleTypeUpdateAbilityRspBO orderUpdateRspBO = this.pebExtOrderSettleTypeUpdateAbilityService.dealOrderSettleType(settleReqBO);
        if (!"0000".equals(orderUpdateRspBO.getRespCode())) {
            log.error("\u540c\u6b65\u8ba2\u5355\u7ed3\u7b97\u7c7b\u578b\u5931\u8d25\uff1a" + orderUpdateRspBO.getRespDesc());
        }
        atomRspBO.setFscOrderId(fscOrderId);
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return atomRspBO;
    }

    private void invokeUacNoTask(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId, FscShouldPayPO model) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusStartAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("fscPayApplyOrder");
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(fscOrderId);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(fscOrderId.toString());
        approvalObjBO.setObjName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        BigDecimal payAmount = BigDecimal.ZERO;
        for (FscOrderPayItemBO payItem : busiReqBO.getFscOrderPayItemBOS()) {
            payAmount = payAmount.add(payItem.getPayAmount());
        }
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("payAmount", payAmount);
        if (FscPayTypeEnum.ADVANCE_PAY.getCode().equals(busiReqBO.getShouldPayMethod())) {
            variables.put("payType", 1);
        } else {
            variables.put("payType", 2);
        }
        uacNoTaskAuditCreateReqBO.setVariables(variables);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("194203", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u4ed8\u6b3e\u5ba1\u6279\u6d41\uff01");
        }
        if (uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        }
        fscOrderStatusStartAtomReqBO.setTradeMode(model.getTradeMode());
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserName());
        fscOrderStatusStartAtomReqBO.setIndividually(busiReqBO.getIndividually());
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194203", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private void insertOrder(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId, String operationNo, FscShouldPayPO fscShouldPayPO, boolean operationFlag) {
        BigDecimal totalAmount = busiReqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscOrderPO.setPayerId(fscShouldPayPO.getPayerId());
        fscOrderPO.setPayerName(fscShouldPayPO.getPayerName());
        fscOrderPO.setPayeeId(fscShouldPayPO.getPayeeId());
        fscOrderPO.setPayeeName(fscShouldPayPO.getPayeeName());
        fscOrderPO.setPayeeAccountName(busiReqBO.getPayeeAccountName());
        fscOrderPO.setPayeeBankAccount(busiReqBO.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName(busiReqBO.getPayeeBankName());
        if (StringUtils.isEmpty((Object)fscOrderPO.getPayeeAccountName()) || StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankAccount()) || StringUtils.isEmpty((Object)fscOrderPO.getPayeeBankName())) {
            FscMerchantPayeePO fscMerchantPayeePO = new FscMerchantPayeePO();
            fscMerchantPayeePO.setSupplierId(busiReqBO.getPayeeId());
            List fscMerchantPayeePOList = this.fscMerchantPayeeMapper.getList(fscMerchantPayeePO);
            if (!CollectionUtils.isEmpty((Collection)fscMerchantPayeePOList)) {
                fscMerchantPayeePO = (FscMerchantPayeePO)fscMerchantPayeePOList.get(0);
                fscOrderPO.setPayeeAccountName(fscMerchantPayeePO.getPayeeAccountName());
                fscOrderPO.setPayeeBankAccount(fscMerchantPayeePO.getPayeeBankAccount());
                fscOrderPO.setPayeeBankName(fscMerchantPayeePO.getPayeeBankName());
            } else {
                throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u672a\u914d\u7f6e\u6536\u6b3e\u8d26\u6237");
            }
        }
        fscOrderPO.setPayMethod(busiReqBO.getPayMethod());
        fscOrderPO.setPayType(busiReqBO.getPayType());
        fscOrderPO.setShouldPayType(fscShouldPayPO.getShouldPayType());
        fscOrderPO.setPayChannel(busiReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(totalAmount);
        fscOrderPO.setContractNo(fscShouldPayPO.getContractNo());
        fscOrderPO.setContractId(fscShouldPayPO.getContractId());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        fscOrderPO.setPaidAmount(BigDecimal.ZERO);
        fscOrderPO.setPayingAmount(BigDecimal.ZERO);
        fscOrderPO.setToPayAmount(totalAmount);
        fscOrderPO.setYcDeptId(busiReqBO.getYcDeptId());
        fscOrderPO.setYcDeptName(busiReqBO.getYcDeptName());
        fscOrderPO.setYcUserId(busiReqBO.getYcUserId());
        fscOrderPO.setYcUserName(busiReqBO.getYcUserName());
        fscOrderPO.setOrderType(busiReqBO.getOrderType());
        fscOrderPO.setOrderSource(busiReqBO.getOrderSource());
        fscOrderPO.setTradeMode(busiReqBO.getTradeMode());
        fscOrderPO.setRemark(busiReqBO.getRemark());
        fscOrderPO.setPaymentMethod(busiReqBO.getPaymentMethod());
        fscOrderPO.setSettleType(FscConstants.SettleType.ORDER);
        if (operationFlag) {
            fscOrderPO.setOperatorId(busiReqBO.getUserId());
            fscOrderPO.setOperatorName(busiReqBO.getName());
            fscOrderPO.setOperationNo(operationNo);
            fscOrderPO.setOperationName(busiReqBO.getCompanyName());
        } else {
            fscOrderPO.setBuynerNo(busiReqBO.getBuynerNo());
            fscOrderPO.setBuynerName(busiReqBO.getBuynerName());
        }
        if ("3".equals(busiReqBO.getPayChannel())) {
            if (null != busiReqBO.getUserId()) {
                fscOrderPO.setPayOperId(busiReqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(busiReqBO.getName());
        }
        this.fscOrderMapper.insert(fscOrderPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(fscOrderId);
        List invoicePOList = this.fscInvoiceMapper.getInvoiceByShouldPay(fscInvoicePO);
        if (CollectionUtils.isEmpty((Collection)invoicePOList)) {
            invoicePOList = this.fscInvoiceMapper.getInvoiceByAdvance(fscInvoicePO);
        }
        StringBuilder invoiceNo = new StringBuilder();
        StringBuilder invoiceCode = new StringBuilder();
        log.debug("invoicePoList:" + JSONObject.toJSONString((Object)invoicePOList));
        if (!CollectionUtils.isEmpty((Collection)invoicePOList)) {
            boolean flag = false;
            for (FscInvoicePO po : invoicePOList) {
                if (po == null) continue;
                flag = true;
                invoiceNo.append(po.getInvoiceNo()).append(",");
                invoiceCode.append(po.getInvoiceCode()).append(",");
            }
            if (flag) {
                fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(fscOrderId);
                fscOrderPO.setInvoiceNo(invoiceNo.toString());
                fscOrderPO.setInvoiceCode(invoiceCode.toString());
                this.fscOrderMapper.updateById(fscOrderPO);
            }
        }
    }

    private void insertAttachment(List<AttachmentBO> attachmentBOList, Long fscOrderId) {
        if (!CollectionUtils.isEmpty(attachmentBOList)) {
            FscAttachmentPO deletPo = new FscAttachmentPO();
            deletPo.setFscOrderId(fscOrderId);
            deletPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
            ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(deletPo);
            if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
                this.fscAttachmentMapper.deleteBy(deletPo);
            }
            fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : attachmentBOList) {
                FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
                fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPo.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                fscAttachmentPo.setAttachmentName(attachmentBO.getAttachmentName());
                fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.PAYMENT);
                fscAttachmentPo.setObjId(fscOrderId);
                fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.PAYMENT);
                fscAttachmentPo.setFscOrderId(fscOrderId);
                fscAttachmentPOS.add(fscAttachmentPo);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        }
    }

    private FscShouldPayPO handleShouldPay(FscPayBillCreateAtomReqBO reqBO, Long fscOrderId, List<Long> orderIdList, boolean operationFlag) {
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setPageSize(1000);
        saleDetailsReqBO.setOrderIdList(orderIdList);
        saleDetailsReqBO.setTabId(this.SALE_ORDER_TAB_ID);
        saleDetailsReqBO.setIndividually("1");
        log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)saleDetailsReqBO));
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!"0000".equals(saleDetailsRspBO.getRespCode())) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)saleDetailsRspBO.getRows())) {
            throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        HashSet payerIds = new HashSet();
        HashSet payeeIds = new HashSet();
        HashSet payType = new HashSet();
        HashSet contractNos = new HashSet();
        saleDetailsRspBO.getRows().forEach(e -> {
            if (PebExtConstant.Modelsettle.CH.toString().equals(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getTradeMode())) {
                payerIds.add(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getCompanyId());
                payeeIds.add(Objects.nonNull(e.getSupNo()) ? Long.valueOf(e.getSupNo()) : null);
            } else if (operationFlag) {
                payerIds.add(Objects.nonNull(e.getProNo()) ? Long.valueOf(e.getProNo()) : null);
                payeeIds.add(Objects.nonNull(e.getSupNo()) ? Long.valueOf(e.getSupNo()) : null);
            } else {
                payerIds.add(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getCompanyId());
                payeeIds.add(Objects.nonNull(e.getProNo()) ? Long.valueOf(e.getProNo()) : null);
            }
            payType.add(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getPayType());
            contractNos.add(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getModelContractNo());
        });
        if (payerIds.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payType.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5f0f\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (contractNos.size() > 1) {
            throw new FscBusinessException("194203", "\u5408\u540c\u7f16\u53f7\u5fc5\u987b\u552f\u4e00\uff01");
        }
        List serialNoList = new ArrayList();
        int count = (int)reqBO.getFscOrderPayItemBOS().stream().filter(e -> !Objects.nonNull(e.getShouldPayId())).count();
        if (count > 0) {
            CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
            encodedSerialGetServiceReqBO.setCenter("FSC");
            encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.PAYMENT_FJD_PAY.getDescr());
            encodedSerialGetServiceReqBO.setNum(Integer.valueOf(count));
            encodedSerialGetServiceReqBO.setOrgType("-1");
            CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
            serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        }
        Map itemBOMap = reqBO.getFscOrderPayItemBOS().stream().collect(Collectors.toMap(FscOrderPayItemBO::getOrderId, Function.identity(), (k1, k2) -> k1));
        List fscOrderRelationPOList = this.fscOrderRelationMapper.getByOrderIds(orderIdList);
        Map<Long, BigDecimal> settleAmtMap = fscOrderRelationPOList.stream().collect(Collectors.toMap(FscOrderRelationPO::getOrderId, FscOrderRelationPO::getSettleAmt, (k1, k2) -> k1));
        ArrayList<FscShouldPayPO> fscShouldPayPOList = new ArrayList<FscShouldPayPO>();
        int i = 0;
        for (UocPebUpperOrderAbilityBO e2 : saleDetailsRspBO.getRows()) {
            FscPayItemSerialPO fscPayItemSerialPO;
            Long orderId = Long.valueOf(e2.getOrderId());
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            if (Objects.isNull(((FscOrderPayItemBO)itemBOMap.get(orderId)).getShouldPayId())) {
                BigDecimal toPayAmount;
                Integer tradeMode = StringUtils.isEmpty((Object)((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getTradeMode()) ? null : Integer.valueOf(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getTradeMode());
                BigDecimal purPrice = ((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOrderItemList().stream().map(item -> new BigDecimal(item.getPurchasingPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sellPrice = ((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOrderItemList().stream().map(item -> new BigDecimal(item.getSellingPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal purCount = ((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOrderItemList().stream().map(item -> new BigDecimal(item.getPurchaseCount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal returnCount = ((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOrderItemList().stream().map(item -> new BigDecimal(item.getReturnCount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refuseCount = ((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOrderItemList().stream().map(item -> new BigDecimal(item.getRefuseCount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalCount = purCount.subtract(returnCount).subtract(refuseCount);
                BigDecimal purTotalAmt = purPrice.multiply(totalCount);
                BigDecimal sellTotalAmt = sellPrice.multiply(totalCount);
                BigDecimal bigDecimal = toPayAmount = operationFlag ? purTotalAmt.subtract(((FscOrderPayItemBO)itemBOMap.get(orderId)).getPayAmount()) : sellTotalAmt.subtract(((FscOrderPayItemBO)itemBOMap.get(orderId)).getPayAmount());
                if (FscPayTypeEnum.ADVANCE_PAY.getCode().equals(reqBO.getShouldPayMethod()) && !CollectionUtils.isEmpty(settleAmtMap) && Objects.nonNull(settleAmtMap.get(orderId)) && toPayAmount.subtract(settleAmtMap.get(orderId)).compareTo(((FscOrderPayItemBO)itemBOMap.get(orderId)).getPayAmount()) < 0) {
                    throw new FscBusinessException("194203", e2.getSaleVoucherNo() + "\u8ba2\u5355\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\uff0c\u5f53\u524d\u9009\u62e9\u9884\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\uff08\u8ba2\u5355\u5e94\u4ed8\u91d1\u989d-\u5df2\u5f00\u7968\u91d1\u989d\uff09");
                }
                fscShouldPayPO.setShouldPayId(Long.valueOf(Sequence.getInstance().nextId()));
                fscShouldPayPO.setShouldPayNo((String)serialNoList.get(i++));
                fscShouldPayPO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_GRADING_PAY);
                fscShouldPayPO.setObjectType(FscConstants.ShouldObjectType.SALE_ORDER);
                fscShouldPayPO.setObjectId(Long.valueOf(e2.getOrderId()));
                fscShouldPayPO.setObjectNo(e2.getSaleVoucherNo());
                fscShouldPayPO.setOrderId(orderId);
                fscShouldPayPO.setShouldPayAmount(operationFlag ? purTotalAmt : sellTotalAmt);
                fscShouldPayPO.setPaidAmount(BigDecimal.ZERO);
                fscShouldPayPO.setPayingAmount(((FscOrderPayItemBO)itemBOMap.get(orderId)).getPayAmount());
                fscShouldPayPO.setToPayAmount(toPayAmount);
                fscShouldPayPO.setOriginalAmount(operationFlag ? purTotalAmt : sellTotalAmt);
                fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
                fscShouldPayPO.setPayeeId((Long)payeeIds.iterator().next());
                fscShouldPayPO.setPayeeName(PebExtConstant.Modelsettle.CH.equals(tradeMode) ? e2.getSupName() : (operationFlag ? e2.getSupName() : e2.getProName()));
                fscShouldPayPO.setPayerId((Long)payerIds.iterator().next());
                fscShouldPayPO.setPayerName(operationFlag ? e2.getProName() : ((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getCompanyName());
                fscShouldPayPO.setCreateOrgId(reqBO.getOrgId());
                fscShouldPayPO.setCreateOrgName(reqBO.getOrgName());
                fscShouldPayPO.setCreateCompanyId(reqBO.getCompanyId());
                fscShouldPayPO.setCreateCompanyName(reqBO.getCompanyName());
                fscShouldPayPO.setCreateId(reqBO.getUserId());
                fscShouldPayPO.setCreateAccount(reqBO.getUserName());
                fscShouldPayPO.setCreateTime(new Date());
                fscShouldPayPO.setContractId(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getModelContractId());
                fscShouldPayPO.setContractNo(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getModelContractNo());
                fscShouldPayPO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                fscShouldPayPO.setPenaltyRatio(operationFlag ? ((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getPayBreakScale() : ((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getProPayBreakScale());
                fscShouldPayPO.setSaleVoucherId(Long.valueOf(e2.getSaleVoucherId()));
                String invoiceNo = this.fscOrderRelationMapper.getInvoiceNoByOrderId(orderId);
                fscShouldPayPO.setInvoiceNo(invoiceNo);
                fscShouldPayPO.setBuyerNo(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getBuynerNo());
                fscShouldPayPO.setBuyerName(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getBuynerName());
                fscShouldPayPO.setOrderType(StringUtils.isEmpty((Object)e2.getOrderType()) ? null : Integer.valueOf(e2.getOrderType()));
                fscShouldPayPO.setOrderSource(StringUtils.isEmpty((Object)e2.getOrderSource()) ? null : Integer.valueOf(e2.getOrderSource()));
                fscShouldPayPO.setTradeMode(tradeMode);
                fscShouldPayPO.setOrderOperStr(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOperatorId());
                fscShouldPayPO.setOrderCodeStr(e2.getSaleVoucherNo());
                if (operationFlag) {
                    fscShouldPayPO.setOperatorId(StringUtils.isEmpty((Object)((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOperatorId()) ? null : Long.valueOf(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOperatorId()));
                    fscShouldPayPO.setOperationNo(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOperationNo());
                }
                fscShouldPayPO.setOperatorName(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOperatorName());
                fscShouldPayPO.setAgreementId(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getProtocolId());
                fscShouldPayPO.setAgreementNo(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getPlaAgreementCode());
                fscShouldPayPO.setPurPlaceOrderName(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getPurPlaceOrderName());
                fscShouldPayPO.setOrderCreateTime(DateUtil.strToDate((String)e2.getCreateTime()));
                fscShouldPayPO.setPayMethod(FscPayTypeEnum.ADVANCE_PAY.getCode());
                fscShouldPayPO.setPayAmount(((FscOrderPayItemBO)itemBOMap.get(orderId)).getPayAmount());
                FscShouldPayPO fscShouldPayPOReq = new FscShouldPayPO();
                fscShouldPayPOReq.setOrderIds(orderIdList);
                fscShouldPayPOReq.setPayeeId(fscShouldPayPO.getPayeeId());
                fscShouldPayPOReq.setShouldPayTypeNot(FscConstants.ShouldPayType.PAYMENT_GRADING_PAY);
                List payPOList = this.fscShouldPayMapper.getListByOrderId(fscShouldPayPOReq);
                if (!CollectionUtils.isEmpty((Collection)payPOList)) {
                    String orderNo = payPOList.stream().map(FscShouldPayPO::getObjectNo).filter(objectNo -> !StringUtils.isEmpty((Object)objectNo)).distinct().collect(Collectors.joining(","));
                    orderNo = StringUtils.isEmpty((Object)orderNo) ? "\u6240\u9009\u4ed8\u6b3e\u4f9d\u636e\u7f16\u53f7" : orderNo;
                    throw new FscBusinessException("194203", orderNo + "\u5df2\u901a\u8fc7\u6b63\u5e38\u4ed8\u6b3e\u4e1a\u52a1\u53d1\u8d77\u4ed8\u6b3e");
                }
                this.fscShouldPayMapper.updateByOrderIdList(fscShouldPayPOReq);
                this.fscShouldPayMapper.insert(fscShouldPayPO);
            } else {
                fscShouldPayPO.setShouldPayId(((FscOrderPayItemBO)itemBOMap.get(orderId)).getShouldPayId());
                fscShouldPayPO = this.fscShouldPayMapper.getModelBy(fscShouldPayPO);
                if (Objects.isNull(fscShouldPayPO) || !FscConstants.ShouldPayType.PAYMENT_GRADING_PAY.equals(fscShouldPayPO.getShouldPayType())) {
                    throw new FscBusinessException("194203", "\u672a\u67e5\u8be2\u5230\u7279\u6b8a\u5e94\u4ed8\u5355\u4fe1\u606f\uff01");
                }
                if (FscPayTypeEnum.ADVANCE_PAY.getCode().equals(reqBO.getShouldPayMethod()) && !CollectionUtils.isEmpty(settleAmtMap) && Objects.nonNull(settleAmtMap.get(orderId)) && fscShouldPayPO.getToPayAmount().subtract(settleAmtMap.get(orderId)).compareTo(((FscOrderPayItemBO)itemBOMap.get(orderId)).getPayAmount()) < 0) {
                    throw new FscBusinessException("194203", e2.getSaleVoucherNo() + "\u8ba2\u5355\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\uff0c\u5f53\u524d\u9009\u62e9\u9884\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\uff08\u8ba2\u5355\u5e94\u4ed8\u91d1\u989d-\u5df2\u5f00\u7968\u91d1\u989d\uff09");
                }
                fscShouldPayPO.setPayAmount(((FscOrderPayItemBO)itemBOMap.get(orderId)).getPayAmount());
                int updateCount = this.fscShouldPayMapper.updateAmount(fscShouldPayPO);
                if (updateCount == 0) {
                    throw new FscBusinessException("194203", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
                }
            }
            Long shouldPayId = fscShouldPayPO.getShouldPayId();
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(shouldPayId);
            po.setPayAmount(((FscOrderPayItemBO)itemBOMap.get(orderId)).getPayAmount());
            po.setShouldPayMethod(reqBO.getShouldPayMethod());
            if (!StringUtils.isEmpty((Object)((FscOrderPayItemBO)itemBOMap.get(orderId)).getShouldPayItemNo())) {
                po.setShouldPayItemNo(((FscOrderPayItemBO)itemBOMap.get(orderId)).getShouldPayItemNo());
            } else {
                po.setShouldPayItemNo(fscShouldPayPO.getShouldPayNo() + "-01");
            }
            fscOrderPayItemPOs.add(po);
            List fscPayItemSerialPOList = this.fscPayItemSerialMapper.queryByShouldPayNo(fscShouldPayPO.getShouldPayNo());
            int serialNumber = 0;
            if (!CollectionUtils.isEmpty((Collection)fscPayItemSerialPOList)) {
                fscPayItemSerialPO = (FscPayItemSerialPO)fscPayItemSerialPOList.get(0);
                serialNumber = ((FscPayItemSerialPO)fscPayItemSerialPOList.get(0)).getSerialNumber();
                fscPayItemSerialPO.setSerialNumber(Integer.valueOf(++serialNumber));
                this.fscPayItemSerialMapper.update(fscPayItemSerialPO);
            } else {
                fscPayItemSerialPO = new FscPayItemSerialPO();
                fscPayItemSerialPO.setSerialId(Long.valueOf(Sequence.getInstance().nextId()));
                fscPayItemSerialPO.setShouldPayNo(fscShouldPayPO.getShouldPayNo());
                fscPayItemSerialPO.setSerialNumber(Integer.valueOf(++serialNumber));
                this.fscPayItemSerialMapper.insert(fscPayItemSerialPO);
            }
            fscShouldPayPOList.add(fscShouldPayPO);
            reqBO.getFscOrderPayItemBOS().forEach(itemBO -> {
                if (itemBO.getOrderId().toString().equals(((UocPebChildOrderAbilityBO)e2.getChildOrderList().get(0)).getOrderId())) {
                    itemBO.setShouldPayId(shouldPayId);
                }
            });
        }
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        if (FscPayTypeEnum.SHOULD_PAY.getCode().equals(reqBO.getShouldPayMethod())) {
            this.handleOrderPayDetail(fscShouldPayPOList, reqBO, fscOrderId);
        } else {
            this.handlePayDetail(fscShouldPayPOList, reqBO, fscOrderId, operationFlag, saleDetailsRspBO, orderIdList);
        }
        return (FscShouldPayPO)fscShouldPayPOList.get(0);
    }

    public void handleOrderPayDetail(List<FscShouldPayPO> poResult, FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId) {
        ArrayList fscOrderPayDetailPOList = new ArrayList();
        Map shouldPayByIdMap = poResult.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, Function.identity(), (k1, k2) -> k1));
        busiReqBO.getFscOrderPayItemBOS().forEach(e -> {
            if (CollectionUtils.isEmpty((Collection)e.getFscBillOrderIdList())) {
                throw new FscBusinessException("194203", ((FscShouldPayPO)shouldPayByIdMap.get(e.getShouldPayId())).getOrderCodeStr() + "\u8ba2\u5355\u672a\u9009\u62e9\u7ed3\u7b97\u5355\uff01");
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(e.getFscBillOrderIdList());
            fscOrderPO.setOrderBy("create_time asc");
            List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderPOList)) {
                throw new FscBusinessException("194203", ((FscShouldPayPO)shouldPayByIdMap.get(e.getShouldPayId())).getOrderCodeStr() + "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u5355");
            }
            BigDecimal totalToPayAmount = fscOrderPOList.stream().map(FscOrderPO::getToPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (Objects.isNull(totalToPayAmount)) {
                throw new FscBusinessException("194203", "\u6240\u9009\u7ed3\u7b97\u5355\u5747\u65e0\u5f85\u652f\u4ed8\u989d\u5ea6");
            }
            BigDecimal payAmount = e.getPayAmount();
            if (totalToPayAmount.compareTo(payAmount) < 0) {
                throw new FscBusinessException("194203", "\u6240\u9009\u7ed3\u7b97\u5355\u5f85\u652f\u4ed8\u989d\u5ea6\u4e4b\u548c\u4e0d\u5f97\u5c0f\u4e8e\u5f53\u524d\u652f\u4ed8\u91d1\u989d");
            }
            ArrayList<String> fscOrderNoList = new ArrayList<String>();
            ArrayList<String> fscOrderIdList = new ArrayList<String>();
            for (FscOrderPO order : fscOrderPOList) {
                fscOrderNoList.add(order.getOrderNo());
                fscOrderIdList.add(String.valueOf(order.getFscOrderId()));
                FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
                fscOrderPayDetailPO.setPayDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderPayDetailPO.setOrderId(e.getOrderId());
                fscOrderPayDetailPO.setSettleType(busiReqBO.getSettleType());
                fscOrderPayDetailPO.setFscOrderId(fscOrderId);
                fscOrderPayDetailPO.setShouldPayId(e.getShouldPayId());
                fscOrderPayDetailPO.setOrderAmount(order.getTotalCharge());
                fscOrderPayDetailPO.setBeforeLeaveAmount(order.getToPayAmount());
                fscOrderPayDetailPO.setRelType("0".equals(busiReqBO.getIsprofess()) ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
                fscOrderPayDetailPO.setCreateId(Objects.nonNull(busiReqBO.getUserId()) ? busiReqBO.getUserId().toString() : "");
                fscOrderPayDetailPO.setCreateTime(new Date());
                fscOrderPayDetailPO.setUpdateId(Objects.nonNull(busiReqBO.getUserId()) ? busiReqBO.getUserId().toString() : "");
                fscOrderPayDetailPO.setUpdateTime(new Date());
                fscOrderPayDetailPO.setSettleId(order.getFscOrderId());
                if (order.getToPayAmount().compareTo(payAmount) >= 0) {
                    fscOrderPayDetailPO.setPayAmount(payAmount);
                    order.setPayingAmount(order.getPayingAmount().add(payAmount));
                    order.setToPayAmount(order.getToPayAmount().subtract(payAmount));
                    this.fscOrderMapper.updateById(order);
                    fscOrderPayDetailPOList.add(fscOrderPayDetailPO);
                    break;
                }
                fscOrderPayDetailPO.setPayAmount(order.getToPayAmount());
                payAmount = payAmount.subtract(order.getToPayAmount());
                order.setPayingAmount(order.getPayingAmount().add(order.getToPayAmount()));
                order.setToPayAmount(BigDecimal.ZERO);
                this.fscOrderMapper.updateById(order);
                fscOrderPayDetailPOList.add(fscOrderPayDetailPO);
            }
            if (!CollectionUtils.isEmpty(fscOrderNoList)) {
                FscOrderPayItemPO set = new FscOrderPayItemPO();
                set.setFscBillOrderNo(String.join((CharSequence)",", fscOrderNoList));
                set.setFscBillOrderId(String.join((CharSequence)",", fscOrderIdList));
                FscOrderPayItemPO where = new FscOrderPayItemPO();
                where.setShouldPayId(e.getShouldPayId());
                where.setFscOrderId(fscOrderId);
                this.fscOrderPayItemMapper.updateBy(set, where);
            }
        });
        int count = this.fscOrderPayDetailMapper.insertBatch(fscOrderPayDetailPOList);
        if (count == 0) {
            throw new FscBusinessException("194203", "\u63d2\u5165\u8ba2\u5355\u652f\u4ed8\u660e\u7ec6\u5f02\u5e38");
        }
    }

    public void handlePayDetail(List<FscShouldPayPO> fscShouldPayPOList, FscPayBillCreateAtomReqBO reqBO, Long fscOrderId, boolean operationFlag, UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO, List<Long> orderIdList) {
        Map payItemMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        FscOrderPayDetailPO fscOrderPayDetailPOReq = new FscOrderPayDetailPO();
        fscOrderPayDetailPOReq.setOrderIdList(orderIdList);
        fscOrderPayDetailPOReq.setRelType(operationFlag ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
        List payDetailPOList = this.fscOrderPayDetailMapper.queryList(fscOrderPayDetailPOReq);
        Map<Object, Object> payDetailMap = !CollectionUtils.isEmpty((Collection)payDetailPOList) ? payDetailPOList.stream().collect(Collectors.groupingBy(FscOrderPayDetailPO::getOrderItemId, Collectors.mapping(FscOrderPayDetailPO::getPayAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))) : new HashMap();
        if (!CollectionUtils.isEmpty(payItemMap)) {
            ArrayList fscOrderPayDetailPOList = new ArrayList();
            saleDetailsRspBO.getRows().forEach(e -> ((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderItemList().forEach(item -> {
                FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)payItemMap.get(Long.valueOf(((UocPebChildOrderAbilityBO)e.getChildOrderList().get(0)).getOrderId()));
                if (Objects.isNull(fscShouldPayPO)) {
                    throw new FscBusinessException("194203", e.getOrderId() + "\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u5e94\u4ed8\u6570\u636e");
                }
                if (fscShouldPayPO.getPayAmount().compareTo(BigDecimal.ZERO) <= 0) {
                    return;
                }
                BigDecimal orderAmount = operationFlag ? new BigDecimal(item.getPurchaseFeeMoney()) : new BigDecimal(item.getSaleFeeMoney());
                BigDecimal initOrderAmt = orderAmount;
                BigDecimal payOrderAmount = BigDecimal.ZERO;
                if (Objects.nonNull(payDetailMap.get(Long.valueOf(item.getOrderItemId())))) {
                    payOrderAmount = (BigDecimal)payDetailMap.get(Long.valueOf(item.getOrderItemId()));
                }
                if (BigDecimal.ZERO.compareTo(orderAmount = orderAmount.subtract(payOrderAmount)) == 0) {
                    return;
                }
                FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
                fscOrderPayDetailPO.setPayDetailId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderPayDetailPO.setSettleType(reqBO.getSettleType());
                fscOrderPayDetailPO.setOrderId(Objects.isNull(e.getOrderId()) ? null : Long.valueOf(e.getOrderId()));
                fscOrderPayDetailPO.setOrderItemId(Objects.isNull(item.getOrderItemId()) ? null : Long.valueOf(item.getOrderItemId()));
                fscOrderPayDetailPO.setSaleVoucherId(Objects.isNull(e.getSaleVoucherId()) ? null : Long.valueOf(e.getSaleVoucherId()));
                fscOrderPayDetailPO.setFscOrderId(fscOrderId);
                fscOrderPayDetailPO.setShouldPayId(fscShouldPayPO.getShouldPayId());
                fscOrderPayDetailPO.setOrderAmount(initOrderAmt);
                fscOrderPayDetailPO.setBeforeLeaveAmount(orderAmount);
                fscOrderPayDetailPO.setRelType(operationFlag ? FscConstants.FscRelType.PRO_INVOICE : FscConstants.FscRelType.TRADE_INVOICE);
                fscOrderPayDetailPO.setCreateId(Objects.nonNull(reqBO.getUserId()) ? reqBO.getUserId().toString() : "");
                fscOrderPayDetailPO.setCreateTime(new Date());
                fscOrderPayDetailPO.setUpdateId(Objects.nonNull(reqBO.getUserId()) ? reqBO.getUserId().toString() : "");
                fscOrderPayDetailPO.setUpdateTime(new Date());
                if (fscShouldPayPO.getPayAmount().compareTo(orderAmount) > 0) {
                    fscOrderPayDetailPO.setPayAmount(orderAmount);
                    fscShouldPayPO.setPayAmount(fscShouldPayPO.getPayAmount().subtract(orderAmount));
                } else {
                    fscOrderPayDetailPO.setPayAmount(fscShouldPayPO.getPayAmount());
                    fscShouldPayPO.setPayAmount(BigDecimal.ZERO);
                }
                fscOrderPayDetailPOList.add(fscOrderPayDetailPO);
            }));
            int count = this.fscOrderPayDetailMapper.insertBatch(fscOrderPayDetailPOList);
            if (count == 0) {
                throw new FscBusinessException("194203", "\u63d2\u5165\u8ba2\u5355\u652f\u4ed8\u660e\u7ec6\u5f02\u5e38");
            }
        }
    }
}

