/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillBusiRspBO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillBusiServiceImpl
implements FscPayBillBusiService {
    @Autowired
    private FscPayBillAtomService fscPayBillAtomService;
    @Resource
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;

    @Override
    public FscPayBillBusiRspBO dealPayBill(FscPayBillBusiReqBO busiReqBO) {
        FscPayBillBusiRspBO busiRspBO = new FscPayBillBusiRspBO();
        FscPayBillAtomReqBO fscPayBillAtomReqBO = (FscPayBillAtomReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscPayBillAtomReqBO.class));
        FscPayBillAtomRspBO atomRspBO = this.fscPayBillAtomService.dealPayBill(fscPayBillAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getFscOrderIds())) {
            busiReqBO.getFscOrderIds().stream().filter(Objects::nonNull).forEach(this::handleSettleOrder);
        }
        busiRspBO.setResultFscOrderIds(atomRspBO.getResultFscOrderIds());
        busiRspBO.setUrl(atomRspBO.getUrl());
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u652f\u4ed8\u8c03\u7528\u6210\u529f");
        return busiRspBO;
    }

    private void handleSettleOrder(Long fscOrderId) {
        FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
        fscOrderPayDetailPO.setFscOrderId(fscOrderId);
        List fscOrderPayDetailPOList = this.fscOrderPayDetailMapper.queryListWithSettleId(fscOrderPayDetailPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderPayDetailPOList)) {
            return;
        }
        List settleIds = fscOrderPayDetailPOList.stream().map(FscOrderPayDetailPO::getSettleId).collect(Collectors.toList());
        List relationPOList = this.fscOrderRelationMapper.queryAmountByFscOrderIds(settleIds);
        if (CollectionUtils.isEmpty((Collection)relationPOList)) {
            return;
        }
        Map<Long, BigDecimal> payMap = fscOrderPayDetailPOList.stream().filter(e -> Objects.nonNull(e.getPayAmount())).collect(Collectors.toMap(FscOrderPayDetailPO::getSettleId, FscOrderPayDetailPO::getPayAmount, (k1, k2) -> k1));
        relationPOList.forEach(e -> {
            if (((BigDecimal)payMap.get(e.getFscOrderId())).compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            BigDecimal availPayAmount = e.getSettleAmt().subtract(e.getAmount());
            if (availPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            if (availPayAmount.compareTo((BigDecimal)payMap.get(e.getFscOrderId())) >= 0) {
                e.setAmount(e.getAmount().add((BigDecimal)payMap.get(e.getFscOrderId())));
                payMap.put(e.getFscOrderId(), BigDecimal.ZERO);
            } else {
                e.setAmount(e.getSettleAmt());
                payMap.put(e.getFscOrderId(), ((BigDecimal)payMap.get(e.getFscOrderId())).subtract(availPayAmount));
            }
            this.fscOrderRelationMapper.updateById(e);
        });
    }
}

