/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscDealPayRegisterSuccessAtomService;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.api.FscPayConfirmDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscPayConfirmBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayConfirmBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayConfirmBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfirmBusiServiceImpl
implements FscPayConfirmBusiService {
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscDealPayRegisterSuccessAtomService fscDealPayRegisterSuccessAtomService;
    @Autowired
    private FscPayConfirmDealPaySuccessAtomService fscPayConfirmDealPaySuccessAtomService;

    @Override
    public FscPayConfirmBusiRspBO dealPayConfirm(FscPayConfirmBusiReqBO busiReqBO) {
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>();
        FscOrderPO set = new FscOrderPO();
        set.setPayConfirmId(busiReqBO.getUserName());
        set.setPayConfirmName(busiReqBO.getName());
        set.setPayConfirmTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(busiReqBO.getFscOrderIds());
        this.fscOrderMapper.updateBy(set, where);
        this.invokeFscOrderStatusFlow(busiReqBO);
        if (busiReqBO.getPayFlag().booleanValue()) {
            FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
            fscDealPaySuccessAtomReqBO.setPayFscOrderId(busiReqBO.getFscOrderIds());
            FscDealPaySuccessAtomRspBO atomRspBO = new FscDealPaySuccessAtomRspBO();
            atomRspBO = busiReqBO.getIsDownFlow() != null && busiReqBO.getIsDownFlow() == 1 ? this.fscPayConfirmDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO) : this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty(atomRspBO.getResultFscOrderIds())) {
                resultFscOrderIds.addAll(atomRspBO.getResultFscOrderIds());
            }
        }
        resultFscOrderIds.addAll(busiReqBO.getFscOrderIds());
        FscPayConfirmBusiRspBO busiRspBO = new FscPayConfirmBusiRspBO();
        busiRspBO.setResultFscOrderIds(resultFscOrderIds);
        return busiRspBO;
    }

    @Override
    public FscPayConfirmBusiRspBO dealPayRegisterConfirm(FscPayConfirmBusiReqBO reqBO) {
        FscPayConfirmBusiRspBO rspBO = new FscPayConfirmBusiRspBO();
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>();
        FscOrderPO po = new FscOrderPO();
        po.setFscOrderIds(reqBO.getFscOrderIds());
        List fscOrderPOS = this.fscOrderMapper.getList(po);
        if (CollectionUtils.isEmpty((Collection)fscOrderPOS)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u65e0\u4ed8\u6b3e\u7533\u8bf7\u5355");
        }
        FscOrderPO set = new FscOrderPO();
        set.setPayConfirmId(reqBO.getUserName());
        set.setPayConfirmName(reqBO.getName());
        set.setPayConfirmTime(new Date());
        set.setOrderState(FscConstants.FscPayOrderState.PAIED);
        set.setUpdateOperId(reqBO.getUserId().toString());
        set.setUpdateOperName(reqBO.getUserName());
        set.setUpdateTime(new Date());
        set.setUpdateTimeEnd(new Date());
        set.setPayTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(reqBO.getFscOrderIds());
        this.fscOrderMapper.updateBy(set, where);
        List<Long> parentOrderIds = this.updateParentOrderAmount(fscOrderPOS);
        List<FscOrderPO> parentOrders = this.invokeParentOrderStatusFlow(reqBO, parentOrderIds);
        FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
        fscDealPaySuccessAtomReqBO.setPayFscOrderId(reqBO.getFscOrderIds());
        fscDealPaySuccessAtomReqBO.setRegisterComfirmFlag("1");
        FscDealPaySuccessAtomRspBO atomRspBO = this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193205", atomRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty(atomRspBO.getResultFscOrderIds())) {
            resultFscOrderIds.addAll(atomRspBO.getResultFscOrderIds());
        }
        resultFscOrderIds.addAll(parentOrderIds);
        resultFscOrderIds.addAll(reqBO.getFscOrderIds());
        rspBO.setResultFscOrderIds(resultFscOrderIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<FscOrderPO> invokeParentOrderStatusFlow(FscPayConfirmBusiReqBO reqBO, List<Long> parentOrderIds) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusFlowAtomReqBO.class);
        HashMap paramMap = new HashMap();
        FscOrderPO po = new FscOrderPO();
        po.setFscOrderIds(parentOrderIds);
        List parentOrders = this.fscOrderMapper.getList(po);
        if (CollectionUtils.isEmpty((Collection)parentOrders)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u7236\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e3a\u7a7a");
        }
        parentOrders.forEach(fscOrderPO -> {
            if (!FscConstants.FscPayOrderState.PAIED_TO_COMFIR.equals(fscOrderPO.getOrderState()) && !FscConstants.FscPayOrderState.PART_COMFIR.equals(fscOrderPO.getOrderState())) {
                throw new FscBusinessException("198888", "\u7236\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e0d\u4e3a\u652f\u4ed8\u5f85\u786e\u8ba4\u6216\u90e8\u5206\u4ed8\u6b3e\u5f85\u786e\u8ba4");
            }
            BigDecimal paidAmount = fscOrderPO.getPaidAmount();
            BigDecimal totalCharge = fscOrderPO.getTotalCharge();
            if (FscConstants.FscPayOrderState.PAIED_TO_COMFIR.equals(fscOrderPO.getOrderState())) {
                if (totalCharge.subtract(paidAmount).compareTo(BigDecimal.ZERO) != 0) {
                    throw new FscBusinessException("198888", "\u5df2\u4ed8\u91d1\u989d\u4e0e\u603b\u91d1\u989d\u4e0d\u7b49\uff0c\u72b6\u6001\u6d41\u8f6c\u5931\u8d25");
                }
                paramMap.put("payFlag", FscConstants.ProcessParam.payFlag1);
            }
            fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPO.getOrderState());
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPO.getFscOrderId());
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
        });
        return parentOrders;
    }

    private List<Long> updateParentOrderAmount(List<FscOrderPO> fscOrderPOS) {
        int count;
        ArrayList<Long> parentOrderIds = new ArrayList<Long>();
        ArrayList<FscOrderPO> parentOrders = new ArrayList<FscOrderPO>();
        for (FscOrderPO fscOrderPO : fscOrderPOS) {
            if (null == fscOrderPO.getParentOrderId()) {
                throw new FscBusinessException("198888", "\u6b64\u4ed8\u6b3e\u7533\u8bf7\u5355\u65e0\u7236\u5355\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u8fd0\u8425\u4eba\u5458");
            }
            FscOrderPO po = new FscOrderPO();
            po.setFscOrderId(fscOrderPO.getParentOrderId());
            po.setPayAmount(fscOrderPO.getTotalCharge());
            parentOrders.add(po);
            parentOrderIds.add(fscOrderPO.getParentOrderId());
        }
        if (!CollectionUtils.isEmpty(parentOrders) && (count = this.fscOrderMapper.updateAmountBatch(parentOrders)) < parentOrders.size()) {
            throw new FscBusinessException("198888", "\u7236\u5355\u91d1\u989d\u66f4\u65b0\u5931\u8d25");
        }
        return parentOrderIds;
    }

    private void invokeFscOrderStatusFlow(FscPayConfirmBusiReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (busiReqBO.getPayFlag().booleanValue()) {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag1);
        } else {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag0);
        }
        if (busiReqBO.getYcPayFlag() != null && busiReqBO.getYcPayFlag().booleanValue()) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        }
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.PAIED_TO_COMFIR);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193205", atomRspBO.getRespDesc());
            }
        });
    }
}

