/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderFailLogUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePrePaymentBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePrePaymentLineBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPrePayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPrePayBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcPayBillService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPushYcIndividuallyPayBillBusiService;
import com.tydic.fsc.pay.busi.bo.FscPushYcIndividuallyPayBillBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPushYcIndividuallyPayBillBusiRspBO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPushYcIndividuallyPayBillBusiServiceImpl
implements FscPushYcIndividuallyPayBillBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPushYcPayBillService fscPushYcPayBillService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscOrderFailLogUpdateAtomService fscOrderFailLogUpdateAtomService;

    @Override
    public FscPushYcIndividuallyPayBillBusiRspBO dealPushYcIndividuallyPay(FscPushYcIndividuallyPayBillBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        List list = this.fscShouldPayMapper.getByFscOrderId(reqBO.getFscOrderId());
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscOrderPo.getPayeeId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
        if (!umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") || ObjectUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO())) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (StringUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode())) {
            throw new FscBusinessException("190000", "\u4f9b\u5e94\u5546erp\u7f16\u7801\u4e3a\u7a7a\uff01\u8bf7\u5148\u7ef4\u62a4\u4f9b\u5e94\u5546erp\u7f16\u7801\uff01");
        }
        FscPushYcIndividuallyPayBillBusiRspBO rspBO = new FscPushYcIndividuallyPayBillBusiRspBO();
        FscPushYcPrePayBillReqBO prePayBillReqBO = new FscPushYcPrePayBillReqBO();
        FscPurchasePrePaymentBO prePaymentBO = new FscPurchasePrePaymentBO();
        prePaymentBO.setORG_ID(this.operationOrgId);
        prePaymentBO.setORG_NAME(this.operationOrgName);
        prePaymentBO.setDEPT_ID(fscOrderPo.getYcDeptId());
        prePaymentBO.setDEPT_NAME(fscOrderPo.getYcDeptName());
        prePaymentBO.setPERSON_ID(fscOrderPo.getYcUserId());
        prePaymentBO.setPERSON_NAME(fscOrderPo.getYcUserName());
        prePaymentBO.setPREPAY_NUMBER(fscOrderPo.getOrderNo());
        prePaymentBO.setPREPAY_NAME("");
        FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
        eternalPo.setPCode("FSC_PAY_TYPE");
        Map<String, String> dicMap = this.getDicMap(eternalPo);
        prePaymentBO.setPREPAY_TYPE(dicMap.get(fscOrderPo.getOrderType().toString()));
        prePaymentBO.setCONTRACT_NUMBER(fscOrderPo.getContractNo());
        prePaymentBO.setPREPAY_DATE(DateFormatUtils.format((Date)fscOrderPo.getCreateTime(), (String)"yyyy-MM-dd"));
        prePaymentBO.setCOMMENTS("");
        prePaymentBO.setCONTRACT_NAME("");
        prePaymentBO.setVENDOR_NUMBER(Long.valueOf(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode()));
        prePaymentBO.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
        prePaymentBO.setAMOUNT(fscOrderPo.getToPayAmount() == null ? BigDecimal.ZERO : fscOrderPo.getToPayAmount());
        prePaymentBO.setTESCO_ID(fscOrderPo.getFscOrderId());
        LinkedList<FscPurchasePrePaymentLineBO> paymentLineBoList = new LinkedList<FscPurchasePrePaymentLineBO>();
        FscPurchasePrePaymentLineBO prePaymentLineBO = new FscPurchasePrePaymentLineBO();
        prePaymentLineBO.setVENDOR_NUMBER(Long.valueOf(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode()));
        prePaymentLineBO.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
        prePaymentLineBO.setBANK_ACCOUNT_NAME(fscOrderPo.getPayeeAccountName());
        if (fscOrderPo.getPaymentMethod() != null) {
            eternalPo.setPCode("FSC_PAYMENT_TYPE");
            Map<String, String> payMethodMap = this.getDicMap(eternalPo);
            prePaymentLineBO.setPAY_MODE(payMethodMap.get(fscOrderPo.getPaymentMethod().toString()));
        }
        prePaymentLineBO.setBANK_NAME(fscOrderPo.getPayeeBankName());
        prePaymentLineBO.setBANK_ACCOUNT_NUM(fscOrderPo.getPayeeBankAccount() == null ? "0" : fscOrderPo.getPayeeBankAccount());
        prePaymentLineBO.setAMOUNT(fscOrderPo.getToPayAmount() == null ? BigDecimal.ZERO : fscOrderPo.getToPayAmount());
        prePaymentLineBO.setTESCO_ID(fscOrderPo.getFscOrderId());
        paymentLineBoList.add(prePaymentLineBO);
        prePayBillReqBO.setPurchaseAdPayment(prePaymentBO);
        prePayBillReqBO.setPurchaseAdPaymentLine(paymentLineBoList);
        prePayBillReqBO.setUserId(fscOrderPo.getPayerId());
        FscPushYcPrePayBillRspBO billRspBO = this.fscPushYcPayBillService.pushYcPrePayBill(prePayBillReqBO);
        if (!billRspBO.getRespCode().equals("0000")) {
            this.writeFailLog(fscOrderPo, billRspBO.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
    }

    private void writeFailLog(FscOrderPO fscOrderPo, String failDesc) {
        FscOrderFailLogUpdateAtomReqBO fscOrderFailLogUpdateAtomReqBO = new FscOrderFailLogUpdateAtomReqBO();
        long id = Sequence.getInstance().nextId();
        fscOrderFailLogUpdateAtomReqBO.setId(Long.valueOf(id));
        fscOrderFailLogUpdateAtomReqBO.setObjId(fscOrderPo.getFscOrderId());
        fscOrderFailLogUpdateAtomReqBO.setObjNo(fscOrderPo.getOrderNo());
        fscOrderFailLogUpdateAtomReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_PUSH_INDIVIDUALLY_PAY_FAIL);
        fscOrderFailLogUpdateAtomReqBO.setBusiFailDesc(failDesc);
        FscOrderFailLogUpdateAtomRspBO fscOrderFailLogUpdateAtomRspBO = this.fscOrderFailLogUpdateAtomService.dealInsert(fscOrderFailLogUpdateAtomReqBO);
        if (!"0000".equals(fscOrderFailLogUpdateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("198888", fscOrderFailLogUpdateAtomRspBO.getRespDesc());
        }
    }
}

