/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.config;

import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceCheckMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.pay.config.OrderDelayTask;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.DelayQueue;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OrderDelayQueueConfig {
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscInvoiceCheckMapper fscInvoiceCheckMapper;

    @Bean(value={"orderDelayQueue"})
    public DelayQueue<OrderDelayTask> orderDelayQueue() {
        DelayQueue<OrderDelayTask> delayQueue = new DelayQueue<OrderDelayTask>();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.MEMBER_FEE_PAY);
        List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
        if (CollectionUtils.isNotEmpty((Collection)fscOrderPOList)) {
            fscOrderPOList.forEach(e -> {
                long diffTime = System.currentTimeMillis() - e.getCreateTime().getTime();
                if (diffTime > 1800000L) {
                    e.setOrderState(FscConstants.FscPayOrderState.PAY_DISABLE);
                    this.fscOrderMapper.updateById(e);
                } else {
                    delayQueue.add(new OrderDelayTask(e.getFscOrderId(), 1800000L - diffTime));
                }
            });
        }
        this.fscInvoiceCheckMapper.deleteAll();
        return delayQueue;
    }
}

