/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mmc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.tydic.mmc.ability.bo.MmcShopHomePageListBO;
import com.tydic.mmc.ability.bo.MmcSupplierSalesCategoryBO;
import com.tydic.mmc.busi.api.MmcQryShopHomePageListBusiService;
import com.tydic.mmc.busi.bo.MmcQryShopHomePageListBusiReqBO;
import com.tydic.mmc.busi.bo.MmcQryShopHomePageListBusiRspBO;
import com.tydic.mmc.dao.MmcShopMapper;
import com.tydic.mmc.dao.MmcSupplierSalesCategoryMapper;
import com.tydic.mmc.po.MmcShopExtPo;
import com.tydic.mmc.po.MmcShopPo;
import com.tydic.mmc.po.MmcSupplierSalesCategoryExtPo;
import com.tydic.mmc.po.MmcSupplierSalesCategoryPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MmcQryShopHomePageListBusiServiceImpl
implements MmcQryShopHomePageListBusiService {
    @Autowired
    private MmcShopMapper mmcShopMapper;
    @Autowired
    private MmcSupplierSalesCategoryMapper mmcSupplierSalesCategoryMapper;

    @Override
    public MmcQryShopHomePageListBusiRspBO qryShopHomePageList(MmcQryShopHomePageListBusiReqBO busiReqBO) {
        MmcQryShopHomePageListBusiRspBO rsp = new MmcQryShopHomePageListBusiRspBO();
        MmcShopExtPo mmcShopExtPo = new MmcShopExtPo();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)mmcShopExtPo);
        mmcShopExtPo.setStatus("3");
        Page page = new Page(busiReqBO.getPageNo(), busiReqBO.getPageSize());
        List<MmcShopPo> mmcShopPos = this.mmcShopMapper.selectShopHomePage((Page<MmcShopPo>)page, mmcShopExtPo);
        if (CollectionUtils.isEmpty(mmcShopPos)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        List<MmcShopHomePageListBO> rows = this.transReultData(mmcShopPos);
        rsp.setRows(rows);
        rsp.setPageNo(page.getPageNo());
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5e97\u94fa\u9996\u9875\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private List<MmcShopHomePageListBO> transReultData(List<MmcShopPo> result) {
        String resultJsonStr = JSON.toJSONString(result);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(MmcShopHomePageListBO.class);
        ArrayList<Long> shopIds = new ArrayList<Long>();
        for (MmcShopHomePageListBO bo : rows) {
            shopIds.add(bo.getShopId());
        }
        MmcSupplierSalesCategoryExtPo mmcSupplierSalesCategoryExtPo = new MmcSupplierSalesCategoryExtPo();
        mmcSupplierSalesCategoryExtPo.setShopIds(shopIds);
        List<MmcSupplierSalesCategoryPo> mmcSupplierSalesCategoryExtPoList = this.mmcSupplierSalesCategoryMapper.getList(mmcSupplierSalesCategoryExtPo);
        if (!CollectionUtils.isEmpty(mmcSupplierSalesCategoryExtPoList)) {
            List<Object> salesCategoreBOs;
            HashMap shopSalesCategoreMap = new HashMap(16);
            for (MmcSupplierSalesCategoryPo po : mmcSupplierSalesCategoryExtPoList) {
                salesCategoreBOs = (ArrayList<MmcSupplierSalesCategoryBO>)shopSalesCategoreMap.get(po.getShopId());
                if (null == salesCategoreBOs) {
                    salesCategoreBOs = new ArrayList<MmcSupplierSalesCategoryBO>();
                }
                MmcSupplierSalesCategoryBO mmcSupplierSalesCategoryBO = new MmcSupplierSalesCategoryBO();
                BeanUtils.copyProperties((Object)po, (Object)mmcSupplierSalesCategoryBO);
                salesCategoreBOs.add(mmcSupplierSalesCategoryBO);
                shopSalesCategoreMap.put(po.getShopId(), salesCategoreBOs);
            }
            for (MmcShopHomePageListBO bo : rows) {
                salesCategoreBOs = (List)shopSalesCategoreMap.get(bo.getShopId());
                if (CollectionUtils.isEmpty(salesCategoreBOs)) continue;
                bo.setMmcSupplierSalesCategoryBOs(salesCategoreBOs);
            }
        }
        return rows;
    }
}

