/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mmc.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.mmc.atom.api.MmcDealApprovalAtomService;
import com.tydic.mmc.atom.bo.MmcDealApprovalAtomReqBO;
import com.tydic.mmc.atom.bo.MmcDealApprovalAtomRspBO;
import com.tydic.mmc.busi.api.MmcOperShopChangeAuditBusiService;
import com.tydic.mmc.busi.bo.MmcOperShopChangeAuditBusiReqBO;
import com.tydic.mmc.busi.bo.MmcOperShopChangeAuditBusiRspBO;
import com.tydic.mmc.constants.MmcConstant;
import com.tydic.mmc.dao.MmcAuditRecordMapper;
import com.tydic.mmc.dao.MmcShopAccessoryMapper;
import com.tydic.mmc.dao.MmcShopChangeMapper;
import com.tydic.mmc.dao.MmcShopContactsMapper;
import com.tydic.mmc.dao.MmcShopMapper;
import com.tydic.mmc.po.MmcAuditRecordPo;
import com.tydic.mmc.po.MmcShopAccessoryPo;
import com.tydic.mmc.po.MmcShopChangePo;
import com.tydic.mmc.po.MmcShopContactsPo;
import com.tydic.mmc.po.MmcShopPo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MmcOperShopChangeAuditBusiServiceImpl
implements MmcOperShopChangeAuditBusiService {
    @Autowired
    private MmcDealApprovalAtomService mmcDealApprovalAtomService;
    @Autowired
    private MmcShopMapper mmcShopMapper;
    @Autowired
    private MmcAuditRecordMapper mmcAuditRecordMapper;
    @Autowired
    private MmcShopChangeMapper mmcShopChangeMapper;
    @Autowired
    private MmcShopAccessoryMapper mmcShopAccessoryMapper;
    @Autowired
    private MmcShopContactsMapper mmcShopContactsMapper;

    @Override
    public MmcOperShopChangeAuditBusiRspBO operShopChangeAudit(MmcOperShopChangeAuditBusiReqBO reqBO) {
        MmcOperShopChangeAuditBusiRspBO rspBO = new MmcOperShopChangeAuditBusiRspBO();
        MmcDealApprovalAtomRspBO mmcDealApprovalAtomRspBO = this.approvalShopCreate(reqBO);
        MmcAuditRecordPo auditRecordInfoPo = this.queryOriginalAuditRecord(reqBO.getShopId(), reqBO.getStepId());
        if (!mmcDealApprovalAtomRspBO.getFinish().booleanValue()) {
            auditRecordInfoPo.setStepId(mmcDealApprovalAtomRspBO.getStepId());
            auditRecordInfoPo.setNextApprovalId(mmcDealApprovalAtomRspBO.getNextApprovalId());
            this.updateAuditRecord(auditRecordInfoPo);
        } else {
            if (MmcConstant.AuditResult.AUDIT_RESULT_YES.equals(reqBO.getAuditResult())) {
                auditRecordInfoPo.setAuditStatus("2");
            } else {
                auditRecordInfoPo.setAuditStatus("3");
            }
            auditRecordInfoPo.setAuditRemark(reqBO.getAuditAdvice());
            this.updateAuditRecord(auditRecordInfoPo);
            MmcShopPo shopInfoPo = this.queryOriginalShopInfo(reqBO.getShopId());
            if (MmcConstant.AuditResult.AUDIT_RESULT_YES.equals(reqBO.getAuditResult())) {
                MmcShopChangePo shopChangeInfo = this.queryShopChangeInfo(reqBO.getShopId());
                BeanUtils.copyProperties((Object)shopChangeInfo, (Object)shopInfoPo);
                shopInfoPo.setStatus("3");
                this.updateShopInfo(shopInfoPo, reqBO);
                this.deleteShopChangeInfo(shopChangeInfo.getShopChangeId());
                this.updateShopAccessoryInfo(reqBO.getShopId(), shopChangeInfo.getShopChangeId());
                this.updateShopContactsInfo(reqBO.getShopId(), shopChangeInfo.getShopChangeId());
            } else if (MmcConstant.AuditResult.AUDIT_RESULT_NO.equals(reqBO.getAuditResult())) {
                shopInfoPo.setStatus("3");
                this.updateShopInfo(shopInfoPo, reqBO);
            } else {
                throw new ZTBusinessException("\u9519\u8bef\u7684\u5ba1\u6279\u7ed3\u679c");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5e97\u94fa\u53d8\u66f4\u5ba1\u6279\u6210\u529f");
        return rspBO;
    }

    private void updateShopContactsInfo(Long shopId, Long shopChangeId) {
        MmcShopContactsPo queryShopContactsPo = new MmcShopContactsPo();
        queryShopContactsPo.setRelativeId(shopChangeId);
        queryShopContactsPo.setShopId(shopId);
        queryShopContactsPo.setRelativeType("2");
        List<MmcShopContactsPo> shopChangeContactsPos = this.mmcShopContactsMapper.selectByCondition(queryShopContactsPo);
        MmcShopContactsPo deleteMmcShopChangeContactsPo = new MmcShopContactsPo();
        deleteMmcShopChangeContactsPo.setShopId(shopId);
        deleteMmcShopChangeContactsPo.setRelativeType("2");
        this.mmcShopContactsMapper.deleteByCondition(deleteMmcShopChangeContactsPo);
        MmcShopContactsPo deleteMmcShopContactsPo = new MmcShopContactsPo();
        deleteMmcShopContactsPo.setShopId(shopId);
        deleteMmcShopContactsPo.setRelativeType("1");
        this.mmcShopContactsMapper.deleteByCondition(deleteMmcShopContactsPo);
        if (!CollectionUtils.isEmpty(shopChangeContactsPos)) {
            ArrayList<MmcShopContactsPo> newShopContactsPos = new ArrayList<MmcShopContactsPo>();
            for (MmcShopContactsPo shopChangeContactPo : shopChangeContactsPos) {
                MmcShopContactsPo newShopContactPo = new MmcShopContactsPo();
                newShopContactPo.setContractId(Sequence.getInstance().nextId());
                newShopContactPo.setShopId(shopId);
                newShopContactPo.setRelativeId(shopId);
                newShopContactPo.setRelativeType("1");
                newShopContactPo.setContactPhone(shopChangeContactPo.getContactPhone());
                newShopContactPo.setContractName(shopChangeContactPo.getContractName());
                newShopContactPo.setPosition(shopChangeContactPo.getPosition());
                newShopContactPo.setRemark(shopChangeContactPo.getRemark());
                newShopContactsPos.add(newShopContactPo);
            }
            this.mmcShopContactsMapper.insertBatch(newShopContactsPos);
        }
    }

    private void updateShopAccessoryInfo(Long shopId, Long shopChangeId) {
        MmcShopAccessoryPo queryShopAccessoryPo = new MmcShopAccessoryPo();
        queryShopAccessoryPo.setRelativeId(shopChangeId);
        queryShopAccessoryPo.setShopId(shopId);
        queryShopAccessoryPo.setRelativeType("2");
        List<MmcShopAccessoryPo> shopChangeAccessoryPos = this.mmcShopAccessoryMapper.selectByCondition(queryShopAccessoryPo);
        MmcShopAccessoryPo deleteMmcShopChangeAccessoryPo = new MmcShopAccessoryPo();
        deleteMmcShopChangeAccessoryPo.setShopId(shopId);
        deleteMmcShopChangeAccessoryPo.setRelativeType("2");
        this.mmcShopAccessoryMapper.deleteByCondition(deleteMmcShopChangeAccessoryPo);
        MmcShopAccessoryPo deleteMmcShopAccessoryPo = new MmcShopAccessoryPo();
        deleteMmcShopAccessoryPo.setShopId(shopId);
        deleteMmcShopAccessoryPo.setRelativeType("1");
        this.mmcShopAccessoryMapper.deleteByCondition(deleteMmcShopAccessoryPo);
        if (!CollectionUtils.isEmpty(shopChangeAccessoryPos)) {
            ArrayList<MmcShopAccessoryPo> newShopAccessoryPos = new ArrayList<MmcShopAccessoryPo>();
            for (MmcShopAccessoryPo shopChangeAccessoryPo : shopChangeAccessoryPos) {
                MmcShopAccessoryPo newShopAccessoryPo = new MmcShopAccessoryPo();
                newShopAccessoryPo.setAccessoryId(Sequence.getInstance().nextId());
                newShopAccessoryPo.setShopId(shopId);
                newShopAccessoryPo.setRelativeId(shopId);
                newShopAccessoryPo.setRelativeType("1");
                newShopAccessoryPo.setAccessoryUrl(shopChangeAccessoryPo.getAccessoryUrl());
                newShopAccessoryPo.setAccessoryName(shopChangeAccessoryPo.getAccessoryName());
                newShopAccessoryPo.setAccessorySerial(shopChangeAccessoryPo.getAccessorySerial());
                newShopAccessoryPos.add(newShopAccessoryPo);
            }
            this.mmcShopAccessoryMapper.insertBatch(newShopAccessoryPos);
        }
    }

    private MmcShopChangePo queryShopChangeInfo(Long shopId) {
        MmcShopChangePo queryShopChangePo = new MmcShopChangePo();
        queryShopChangePo.setShopId(shopId);
        List<MmcShopChangePo> mmcShopChangePos = this.mmcShopChangeMapper.selectByCondition(queryShopChangePo);
        if (!CollectionUtils.isEmpty(mmcShopChangePos) && mmcShopChangePos.size() == 1) {
            return mmcShopChangePos.get(0);
        }
        if (!CollectionUtils.isEmpty(mmcShopChangePos) && mmcShopChangePos.size() > 1) {
            throw new ZTBusinessException("\u5b58\u5728\u591a\u6761\u5e97\u94fa\u53d8\u66f4\u4fe1\u606f");
        }
        throw new ZTBusinessException("\u5e97\u94fa\u53d8\u66f4\u8bb0\u5f55\u4e0d\u5b58\u5728");
    }

    private void deleteShopChangeInfo(Long shopChangeId) {
        int deleteResult = this.mmcShopChangeMapper.deleteByPrimaryKey(shopChangeId);
        if (1 != deleteResult) {
            throw new ZTBusinessException("\u5220\u9664\u5e97\u94fa\u53d8\u66f4\u4fe1\u606f\u5931\u8d25");
        }
    }

    private MmcShopPo queryOriginalShopInfo(Long shopId) {
        MmcShopPo originalShopPo = this.mmcShopMapper.selectByPrimaryKey(shopId);
        if (null != originalShopPo) {
            return originalShopPo;
        }
        throw new ZTBusinessException("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
    }

    private void updateShopInfo(MmcShopPo updateShopPo, MmcOperShopChangeAuditBusiReqBO reqBO) {
        updateShopPo.setUpdateUserId(reqBO.getUserId());
        updateShopPo.setUpdateUserName(reqBO.getUserName());
        updateShopPo.setUpdateTime(new Date());
        int updateShopInfoResult = this.mmcShopMapper.updateByPrimaryKeySelective(updateShopPo);
        if (1 != updateShopInfoResult) {
            throw new ZTBusinessException("\u5e97\u94fa\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
    }

    private MmcDealApprovalAtomRspBO approvalShopCreate(MmcOperShopChangeAuditBusiReqBO reqBO) {
        MmcDealApprovalAtomReqBO mmcDealApprovalAtomReqBO = new MmcDealApprovalAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)mmcDealApprovalAtomReqBO);
        mmcDealApprovalAtomReqBO.setObjType(Integer.valueOf("2"));
        MmcDealApprovalAtomRspBO mmcDealApprovalAtomRspBO = this.mmcDealApprovalAtomService.dealApproval(mmcDealApprovalAtomReqBO);
        if (!"0000".equals(mmcDealApprovalAtomRspBO.getRespCode())) {
            throw new ZTBusinessException(mmcDealApprovalAtomRspBO.getRespDesc());
        }
        return mmcDealApprovalAtomRspBO;
    }

    private void updateAuditRecord(MmcAuditRecordPo updateAuditRecordPo) {
        int updateResult = this.mmcAuditRecordMapper.updateByPrimaryKeySelective(updateAuditRecordPo);
        if (1 != updateResult) {
            throw new ZTBusinessException("\u5e97\u94fa\u521b\u5efa\u5ba1\u6279\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25");
        }
    }

    private MmcAuditRecordPo queryOriginalAuditRecord(Long shopId, String stepId) {
        MmcAuditRecordPo queryAuditRecordPo = new MmcAuditRecordPo();
        queryAuditRecordPo.setShopId(shopId);
        queryAuditRecordPo.setAuditType("2");
        queryAuditRecordPo.setStepId(stepId);
        List<MmcAuditRecordPo> mmcAuditRecordPos = this.mmcAuditRecordMapper.selectByCondition(queryAuditRecordPo);
        if (!CollectionUtils.isEmpty(mmcAuditRecordPos) && mmcAuditRecordPos.size() == 1) {
            return mmcAuditRecordPos.get(0);
        }
        if (!CollectionUtils.isEmpty(mmcAuditRecordPos) && mmcAuditRecordPos.size() > 1) {
            throw new ZTBusinessException("\u5b58\u5728\u591a\u6761\u5e97\u94fa\u53d8\u66f4\u5ba1\u6279\u8bb0\u5f55");
        }
        throw new ZTBusinessException("\u5e97\u94fa\u53d8\u66f4\u5ba1\u6279\u8bb0\u5f55\u4e0d\u5b58\u5728");
    }
}

