var cashierDeskInfo = null;

var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
$(document).ready(function () {
    // 返回收银台
    $("#payment_a").on("click", function () {
        clearInterval(timersearch);
        qryPayResult(payOrderInfo.payOrderId, 2);// 1 轮询   2 返回操作
    });
    init();
});
var init = function () {
    $('#orderId').text(payOrderInfo.orderId);
    $('#realFee').text(payOrderInfo.realFee / 100.00);

    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = '/cashierDesk/queryCashierDesk';
    data.successF = function (returnData) {
        cashierDeskInfo = returnData;
        getWxQrCode();
        util.countdown('#remainingTime', returnData.payTimeLeft, function (timeLeft) {
            if (timeLeft <= 0) {
                util.dialog.alert('订单已超时，点击确定返回重新下单', function () {
                    window.history.back();
                });
            }
        });
    };
    loadingMask('正在获取支付信息...');
    util.ajax(data);
};
function getWxQrCode() {
    loadingQrcode();

    var data = {};
    data.params = {
        busiCode: cashierDeskInfo.busiCode,
        merchantId: cashierDeskInfo.merchantId,
        outOrderId: cashierDeskInfo.outOrderId,
        totalFee: Number.parseInt(cashierDeskInfo.totalFee),
        payMethod: payOrderInfo.payMethod,
        reqWay: cashierDeskInfo.reqWay,
        detailName: cashierDeskInfo.detailName,
        channelId: cashierDeskInfo.channelId,
        cityId: cashierDeskInfo.cityId,
        createOperId: cashierDeskInfo.createOperId,
        createIpAddress:"219.143.69.220",
        districtId: cashierDeskInfo.districtId,
        provinceId: cashierDeskInfo.provinceId,
        notifyUrl: cashierDeskInfo.notifyUrl,
        redirectUrl: cashierDeskInfo.redirectUrl
    };
    data.params.service = "/payPro/dealOrder";
    data.contentType = 'json';
    data.successF = function (returnData) {
        payOrderInfo.payOrderId = returnData.payOrderId;
        if(returnData.effectiveSeconds){
            payTimeout = returnData.effectiveSeconds;
        }
        createQrcode(returnData.qrCode);
        timersearch = setInterval(function () {
            payWaiting(returnData);
        }, 1000);
    };
    loadingMask("正在生成二维码...");
    util.ajax(data);
}

var timersearch = null;
var payTimeout = 120;
var payWaiting = function (returnData) {
    $('#curtimes').text(payTimeout);
    console.log(payTimeout)
    if (payTimeout-- > 0) {
        qryPayResult(returnData.payOrderId,1);
    } else {
        clearInterval(timersearch);
        util.dialog.alert('二维码失效，请手动刷新页面', function () {
            window.location.reload();
        });
    }
};

var qryPayResult = function (payOrderId,oper) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = '/pay/pollingPayState';
    data.successF = function (returnData) {
        if (returnData.payStatus == 'SUCCESS') {
            clearInterval(timersearch);
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            location.replace('payResult.html?payStatus=' + returnData.payStatus + "&rspName=" + returnData.rspName);
        } else {
            if (oper == 2) {//返回操作
                closeOrder(returnData.payOrderId);
            }
        }
    };
    data.failF = function (returnData) {
        // TODO
    };
    util.ajax(data);
};
var closeOrder = function (payOrderId) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = '/pay/closeOrder';
    data.successF = function (returnData) {
        window.history.back();
    };
    util.ajax(data);
};

// 生成二维码
function createQrcode(content) {
    $('#qrCode').empty().qrcode({
        width: 280, // 宽度
        height: 280, // 高度
        correctLevel: 0,
        render: "canvas",
        text: content // 二维码内容
    });
}

// 正在加载二维码
function loadingQrcode() {
    $('#qrCode').html('正在加载...');
}