var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));

$(document).ready(function () {
    $('#closeBtn').on('click', function() {
        closeEvent();
    });

    if (payOrderInfo) {
        init();
    } else {
        payOrderInfo = {
            orderId: util.getQueryString('orderId')
        };
        var data = {};
        data.params = {
            orderId: payOrderInfo.orderId
        };
        data.params.service = 'paymentMethodInquiryService';
        data.successF = function(returnData) {
            payOrderInfo.totalFee = returnData.totalFee;
            payOrderInfo.redirectUrl = returnData.redirectUrl;
            init();
        };
        loadingMask('正在加载撤单结果...');
        util.ajax(data);
    }
});

var init = function() {
    $('#orderId').text(payOrderInfo.orderId);
    $('#totalFee').text(payOrderInfo.totalFee.indexOf('.') >= 0 ? payOrderInfo.totalFee : payOrderInfo.totalFee + '.00');

    var payStatus = util.getQueryString('payStatus');
    if (payStatus == 'SUCCESS') {
        $('#payResult .icon-result').addClass('icon-result-succ');
        $('#payResult .result-control .result-title').text('撤单成功');
        $('#closeBtn').removeClass('btn-red').addClass('btn-green').show();
    } else {
        $('#payResult .icon-result').addClass('icon-result-false');
        $('#payResult .result-control .result-title').text('撤单失败');
        $('#closeBtn').removeClass('btn-green').addClass('btn-red').show();
    }
    var countDown = setInterval(function() {
        var curTime = parseInt($('#countDown').text()) - 1;
        $('#countDown').text(curTime);
        if (curTime == 0) {
            clearInterval(countDown);
            closeEvent(); //立即关闭
        }
    }, 1000);
};

var closeEvent = function() {
    if (navigator.userAgent.indexOf('MSIE') > 0) { // close IE
        if (navigator.userAgent.indexOf('MSIE 6.0') > 0) {
            window.opener = null;
            window.close();
        } else {
            window.open('', '_top');
            window.top.close();
        }
    }
    else if (navigator.userAgent.indexOf("Firefox") > 0) { // close firefox
        window.location.replace('about:blank')
    } else { // close chrome;It is effective when it is only one.
        window.opener=null;
        window.open('', '_self');
        window.close();
    }
};
