var callingSearch = false; //是否在执行轮询操作
var timersearch = null;
var maxtimes = 20;
var curtimes = 0;
var pertime = 2000;		//2秒钟执行一次
var pay_order_id = null;

var payOrderInfo = JSON.parse(sessionStorage.getItem('payOrderInfo'));
$(document).ready(function () {
    // 返回收银台
    $("#payment_a").on("click", function () {
        window.history.back();
    });
    $('#scanBtn').on('click', scanSubmit);
    $('#authCode').on('keyup', function (e) {
        if (e.keyCode == 13) {
            scanSubmit();
        }
    });

    init();
    $("#authCode").focus();
});

var init = function () {
    $('#orderId').text(payOrderInfo.orderId);
    $('#realFee').text(payOrderInfo.realFee / 100.00);

    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId
    };
    data.params.service = '/cashierDesk/queryCashierDesk';
    data.successF = function (returnData) {
        util.countdown('#remainingTime', returnData.payTimeLeft, function (timeLeft) {
            if (timeLeft <= 0) {
                util.dialog.alert('订单已超时，点击确定返回重新下单', function () {
                    window.history.back();
                });
            }
        });
    };
    loadingMask('正在获取支付信息...');
    util.ajax(data);
};

var scanSubmit = function () {
    var authCode = $('#authCode').val();
    if (authCode == '') {
        util.dialog.alert('请用扫描枪或手输用户的付款条码串号');
        return;
    } else if (authCode.length != 18) {
        util.dialog.alert('付款条码串号必须为18位');
        return;
    }
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        key: payOrderInfo.key,
        realFee: payOrderInfo.realFee,
        payMethod: payOrderInfo.payMethod,
        authCode: $('#authCode').val()
    };
    data.params.service = "/pay/uniPay";
    data.successF = function (returnData) {
        payWaiting(returnData);
    };
    loadingMask("等待支付结果...");
    util.ajax(data);
};

var payTimeout = 6;
var payWaiting = function (returnData) {
    if (payTimeout-- > 0) {
        if (returnData.payStatus == 'PAYING') { // 需要用户输入支付密码
            loadingMask(returnData.rspName);
            setTimeout(function () {
                qryPayResult(returnData.payOrderId);
            }, 5000);
        } else {
            payTimeout = 6;
            sessionStorage.setItem('payOrderInfo', JSON.stringify(payOrderInfo));
            location.replace('payResult.html?payStatus=' + returnData.payStatus + "&rspName=" + returnData.rspName);
        }
    } else {
        payTimeout = 6;
        util.dialog.alert('支付超时，请刷新页面');
    }
};

var qryPayResult = function (payOrderId) {
    var data = {};
    data.params = {
        orderId: payOrderInfo.orderId,
        payOrderId: payOrderId,
        payMethod: payOrderInfo.payMethod
    };
    data.params.service = '/pay/orderQuery';
    data.successF = function (returnData) {
        payWaiting(returnData);
    };
    loadingMask("查询支付结果...");
    util.ajax(data);
};
