/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chinapay.secss.SecssConstants;
import com.chinapay.secss.SecssUtil;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.busi.PayProGetParamsBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleChinaPayNotifyDataBean;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryRefundStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryRefundStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.busi.bo.PayProGetParamsBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProGetParamsBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractChinaPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractChinaPayAble.class);
    private static final String CHINA_PAY_SUCCESS = "0000";
    private static final String CHINA_PAY_REFUND_SUBMITTED = "1003";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayProGetParamsBusiService payProGetParamsBusiService;
    @Autowired
    private FileClient fileClient;

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u4e2d\u56fd\u94f6\u8054\u65b0\u4e00\u4ee3\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\u5904\u7406\u9000\u6b3e\u5f00\u59cb\uff1a{}", (Object)reqBo);
        }
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validateStr = this.validateRefundArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String chinaPayRefundUrl = this.payPropertiesVo.getValueByKey("china.pay.refund.url");
        if (StringUtils.isEmpty((Object)chinaPayRefundUrl)) {
            log.error("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u9000\u6b3e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.pay.refund.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u9000\u6b3e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.pay.refund.url");
            return retBo;
        }
        String chinaPayNotifyUrl = this.payPropertiesVo.getValueByKey("china.pay.refund.notify.url");
        if (StringUtils.isEmpty((Object)chinaPayNotifyUrl)) {
            log.error("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u9000\u6b3e\u56de\u8c03\u901a\u77e5\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.pay.refund.notify.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u9000\u6b3e\u56de\u8c03\u901a\u77e5\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.pay.refund.notify.url");
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        DateTime tradeTime = DateTime.parse((String)reqBo.getTradeTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
        DateTime noTime = new DateTime();
        HashMap<String, String> refundReqMap = new HashMap<String, String>(16);
        refundReqMap.put("Version", "20140728");
        refundReqMap.put("AccessType", "0");
        refundReqMap.put("MerId", (String)paraMap.get("MerId"));
        refundReqMap.put("MerOrderNo", reqBo.getRefundOrderId());
        refundReqMap.put("TranDate", noTime.toString("yyyyMMdd"));
        refundReqMap.put("TranTime", noTime.toString("HHmmss"));
        refundReqMap.put("OriOrderNo", reqBo.getPayOrderId());
        refundReqMap.put("OriTranDate", tradeTime.toString("yyyyMMdd"));
        refundReqMap.put("RefundAmt", reqBo.getRefundFee().toString());
        refundReqMap.put("TranType", "0401");
        refundReqMap.put("BusiType", "0001");
        refundReqMap.put("MerBgUrl", chinaPayNotifyUrl);
        SecssUtil secssUtil = this.getSecssUtil(paraMap);
        secssUtil.sign(refundReqMap);
        if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
            log.error("\u7b7e\u540d\u5931\u8d25\uff1a{}\uff1a{}", (Object)secssUtil.getErrCode(), (Object)secssUtil.getErrMsg());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u7b7e\u540d\u5931\u8d25\uff1a" + secssUtil.getErrMsg());
            return retBo;
        }
        refundReqMap.put("Signature", secssUtil.getSign());
        String result = HttpUtil.post((String)chinaPayRefundUrl, refundReqMap);
        log.info("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u9000\u6b3e\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a", (Object)result);
        JSONObject retJson = this.dealResult(result);
        secssUtil.verify((Map)retJson);
        if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
            log.error("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25\uff1a{}", (Object)secssUtil.getErrMsg());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25\uff1a" + secssUtil.getErrMsg());
            return retBo;
        }
        String resultCode = retJson.getString("respCode");
        if (!CHINA_PAY_SUCCESS.equals(resultCode) && !CHINA_PAY_REFUND_SUBMITTED.equals(resultCode)) {
            log.error("\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff1a{}", retJson.get((Object)"respMsg"));
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff1a" + retJson.get((Object)"respMsg"));
            return retBo;
        }
        reqBo.setTradeTime("");
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRespCode(CHINA_PAY_SUCCESS);
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        boolean isSuccess;
        if (log.isDebugEnabled()) {
            log.debug("\u4e2d\u56fd\u94f6\u8054\u65b0\u4e00\u4ee3\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\u89e3\u6790\u5f02\u6b65\u901a\u77e5\u53c2\u6570\u5f00\u59cb\uff1a{}", (Object)reqBo);
        }
        PayAbleCallBackRspBo retBo = new PayAbleCallBackRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            log.error("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        JSONObject notifyJson = JSON.parseObject((String)reqBo.getReqData());
        PayAbleChinaPayNotifyDataBean notifyDataBean = (PayAbleChinaPayNotifyDataBean)JSON.parseObject((String)notifyJson.toJSONString(), PayAbleChinaPayNotifyDataBean.class);
        String payOrderId = notifyDataBean.getMerOrderNo();
        try {
            isSuccess = this.signatureValidate(notifyJson, payOrderId, reqBo.isRefund());
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25\uff1a" + e.getMessage());
            return retBo;
        }
        if (!isSuccess) {
            log.error("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
            return retBo;
        }
        if (!CHINA_PAY_SUCCESS.equals(notifyDataBean.getOrderStatus())) {
            log.error("\u652f\u4ed8\u673a\u6784\u56de\u8c03\u901a\u77e5\uff0c\u7ed3\u679c\u4e3a\u5931\u8d25");
            retBo.setRespCode(CHINA_PAY_SUCCESS);
            retBo.setRespDesc("\u652f\u4ed8\u673a\u6784\u56de\u8c03\u901a\u77e5\uff0c\u7ed3\u679c\u4e3a\u5931\u8d25");
            return retBo;
        }
        String tradTimeStr = notifyDataBean.getCompleteDate() + notifyDataBean.getCompleteTime();
        retBo.setPayOrderId(payOrderId);
        retBo.setPayNotifyTransId(notifyDataBean.getAcqSeqId());
        retBo.setTradeTime(tradTimeStr);
        retBo.setRespCode(CHINA_PAY_SUCCESS);
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateStr = this.validateQryArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String chinaPayQueryUrl = this.payPropertiesVo.getValueByKey("china.pay.trans.query.url");
        if (StringUtils.isEmpty((Object)chinaPayQueryUrl)) {
            log.error("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u4ea4\u6613\u67e5\u8be2\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.pay.trans.query.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u4ea4\u6613\u67e5\u8be2\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.pay.trans.query.url");
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        String merId = (String)paraMap.get("MerId");
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        DateTime tradDate = formatter.parseDateTime(reqBo.getTradeTime());
        HashMap<String, String> requestMap = new HashMap<String, String>(16);
        requestMap.put("Version", "20150922");
        requestMap.put("AccessType", "0");
        requestMap.put("MerId", merId);
        requestMap.put("MerOrderNo", reqBo.getPayOrderId());
        requestMap.put("TranDate", tradDate.toString("yyyyMMdd"));
        requestMap.put("TranType", "0502");
        requestMap.put("BusiType", "0001");
        SecssUtil secssUtil = this.getSecssUtil(paraMap);
        secssUtil.sign(requestMap);
        if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
            log.error("\u7b7e\u540d\u5931\u8d25\uff1a{}\uff1a{}", (Object)secssUtil.getErrCode(), (Object)secssUtil.getErrMsg());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u7b7e\u540d\u5931\u8d25\uff1a" + secssUtil.getErrMsg());
            return retBo;
        }
        requestMap.put("Signature", secssUtil.getSign());
        String result = HttpUtil.post((String)chinaPayQueryUrl, requestMap);
        log.info("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u4ea4\u6613\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)result);
        JSONObject retJson = this.dealResult(result);
        secssUtil.verify((Map)retJson);
        if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
            log.error("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25\uff1a{}", (Object)secssUtil.getErrMsg());
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25\uff1a" + secssUtil.getErrMsg());
            return retBo;
        }
        if (!CHINA_PAY_SUCCESS.equals(retJson.get((Object)"respCode"))) {
            log.error("\u4ea4\u6613\u67e5\u8be2\u5931\u8d25\uff1a{}", retJson.get((Object)"respMsg"));
            retBo.setRespCode("8888");
            retBo.setRespDesc(retJson.getString("respMsg"));
            return retBo;
        }
        this.sortQryStatusRetBo(reqBo, retBo, retJson);
        return retBo;
    }

    public PayAbleQryRefundStatusRspBo qryRefundStatus(PayAbleQryRefundStatusReqBo reqBo) {
        PayAbleQryRefundStatusRspBo retBo = new PayAbleQryRefundStatusRspBo();
        PayAbleQryPayStatusReqBo statusReqBo = new PayAbleQryPayStatusReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)statusReqBo);
        if (StringUtils.isEmpty((Object)reqBo.getTradeTime())) {
            statusReqBo.setTradeTime(new DateTime((Object)reqBo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        }
        statusReqBo.setPayOrderId(reqBo.getRefundOrderId());
        PayAbleQryPayStatusRspBo statusRspBo = this.qryPayStatus(statusReqBo);
        BeanUtils.copyProperties((Object)statusRspBo, (Object)retBo);
        retBo.setRefundOrderId(reqBo.getRefundOrderId());
        retBo.setRefundStatus(statusRspBo.getPayStatus());
        retBo.setStatusDesc(statusRspBo.getPayStatusMsg());
        return retBo;
    }

    private void sortQryStatusRetBo(PayAbleQryPayStatusReqBo reqBo, PayAbleQryPayStatusRspBo retBo, JSONObject retJson) {
        String tradeStatus;
        retBo.setOrderId(reqBo.getOrderId());
        retBo.setPayOrderId(reqBo.getPayOrderId());
        retBo.setRespCode(CHINA_PAY_SUCCESS);
        retBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        switch (tradeStatus = retJson.getString("OrderStatus")) {
            case "0000": 
            case "1013": {
                String tradeDate = retJson.getString("CompleteDate") + retJson.getString("CompleteTime");
                retBo.setTradeTime(tradeDate);
                retBo.setPayNotifyTransId(retJson.getString("AcqSeqId"));
                retBo.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((String)retJson.getString("OrderAmt")).longValue()));
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg("\u6210\u529f(chinaPay)");
                break;
            }
            case "0012": {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u8ba2\u5355\u5df2\u64a4\u9500(chinaPay)");
                break;
            }
            case "0001": 
            case "1015": {
                retBo.setPayStatus("PAYING");
                retBo.setPayStatusMsg("\u4ea4\u6613\u5df2\u63d0\u4ea4(chinaPay)");
                break;
            }
            case "1003": {
                retBo.setPayStatus("SUBMITTED");
                retBo.setPayStatusMsg("\u5546\u6237\u5df2\u5ba1\u6838(chinaPay)");
                break;
            }
            default: {
                retBo.setRespCode("212008");
                retBo.setRespDesc("\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u503c");
                retBo.setPayStatus("FAIL");
            }
        }
    }

    private String validateQryArgs(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return this.validateParaMap(reqBo.getParaMap());
    }

    protected String doSign(Map<String, String> paramMap, Map<String, String> dataMap) {
        SecssUtil secssUtil = this.getSecssUtil(paramMap);
        secssUtil.sign(dataMap);
        if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
            log.error("\u7b7e\u540d\u5931\u8d25\uff1a{}\uff1a{}", (Object)secssUtil.getErrCode(), (Object)secssUtil.getErrMsg());
            return null;
        }
        String sign = secssUtil.getSign();
        log.info("\u5f97\u5230\u7684\u7b7e\u540d\u4e3a\uff1a{}", (Object)sign);
        return sign;
    }

    protected String doVerify(Map<String, String> paramMap, Map<String, String> dataMap) {
        SecssUtil secssUtil = this.getSecssUtil(paramMap);
        secssUtil.verify(dataMap);
        return secssUtil.getErrCode();
    }

    private boolean signatureValidate(JSONObject notifyJson, String payOrderId, boolean isRefund) {
        log.info("\u6821\u9a8c\u7b7e\u540d\u5f00\u59cb");
        String sign = notifyJson.getString("Signature");
        if (StringUtils.isEmpty((Object)sign)) {
            log.error("ChinaPay\u8fd4\u56de\u7684\u53c2\u6570\u4e2d\uff0c\u6ca1\u6709\u83b7\u53d6\u5230'Signature'");
            return false;
        }
        PayProGetParamsBusiReqBo getParamsBusiReqBo = new PayProGetParamsBusiReqBo();
        getParamsBusiReqBo.setPayOrderId(payOrderId);
        getParamsBusiReqBo.setRefund(isRefund);
        PayProGetParamsBusiRspBo getParamsBusiRspBo = this.payProGetParamsBusiService.getParamMap(getParamsBusiReqBo);
        if (!CHINA_PAY_SUCCESS.equals(getParamsBusiRspBo.getRespCode())) {
            log.error("\u83b7\u53d6\u652f\u4ed8\u673a\u6784\u53c2\u6570map\u5931\u8d25\uff1a{}", (Object)getParamsBusiRspBo.getRespDesc());
            return false;
        }
        if (CollectionUtils.isEmpty((Map)getParamsBusiRspBo.getParamMap())) {
            log.error("\u83b7\u53d6\u652f\u4ed8\u673a\u6784\u53c2\u6570map\u8fd4\u56de\u4e3a\u7a7a");
            return false;
        }
        SecssUtil secssUtil = this.getSecssUtil(getParamsBusiRspBo.getParamMap());
        secssUtil.verify((Map)notifyJson);
        if (!SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
            log.error("ChinaPay\u8fd4\u56de\u7684\u5e94\u7b54\u6570\u636e\u3010\u9a8c\u7b7e\u3011\u5931\u8d25:{}", (Object)secssUtil.getErrMsg());
            return false;
        }
        return true;
    }

    private SecssUtil getSecssUtil(Map<String, String> paraMap) {
        String chinaPayCertPath = paraMap.get("chinaPayCert");
        String merPfxPath = paraMap.get("merpfx");
        String merPassword = paraMap.get("merPassword");
        log.info("\u7b7e\u540d\u53c2\u6570\uff1a{}", paraMap);
        try {
            File chinaPayPublicFile = this.fileClient.downloadToFile(chinaPayCertPath);
            chinaPayCertPath = chinaPayPublicFile.getAbsolutePath();
            File chinaPayPrivateFile = this.fileClient.downloadToFile(merPfxPath);
            merPfxPath = chinaPayPrivateFile.getAbsolutePath();
        }
        catch (Exception e) {
            log.error("\u4ecefastdfs\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("216038", "\u4ecefastdfs\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38\uff1a" + e);
        }
        SecssUtil secssUtil = new SecssUtil();
        Properties properties = new Properties();
        properties.setProperty(SecssConstants.SIGN_CERT_TYPE, "PKCS12");
        properties.setProperty(SecssConstants.SIGN_INVALID_FIELDS, "Signature,CertId");
        properties.setProperty(SecssConstants.SIGNATURE_FIELD, "Signature");
        properties.setProperty(SecssConstants.SECSS_PRIVATEALG, "SM2");
        properties.setProperty(SecssConstants.SECSS_PRIVATEPATH, merPfxPath);
        properties.setProperty(SecssConstants.SECSS_PRIVATEPWD, merPassword);
        properties.setProperty(SecssConstants.SECSS_PUBLICALG, "SM2");
        properties.setProperty(SecssConstants.SECSS_PUBLICPATH, chinaPayCertPath);
        properties.setProperty(SecssConstants.SECSS_EXCLUDEEXPIREDCERT, "true");
        boolean bool = secssUtil.init(properties);
        if (!bool) {
            log.error("ChinaPay\u4ea4\u6613\u8bc1\u4e66\u3001\u9a8c\u7b7e\u8bc1\u4e66\u521d\u59cb\u5316\u5931\u8d25\uff1a" + secssUtil.getErrCode() + "\uff1a" + secssUtil.getErrMsg());
            throw new BusinessException("216038", "ChinaPay\u4ea4\u6613\u8bc1\u4e66\u3001\u9a8c\u7b7e\u8bc1\u4e66\u521d\u59cb\u5316\u5931\u8d25");
        }
        log.debug("ChinaPay\u4ea4\u6613\u8bc1\u4e66\u3001\u9a8c\u7b7e\u8bc1\u4e66\u521d\u59cb\u5316\u6210\u529f\uff01");
        return secssUtil;
    }

    protected JSONObject dealResult(String result) {
        String[] retStrs;
        JSONObject jsonObject = new JSONObject();
        for (String str : retStrs = result.split("&")) {
            String[] keyValues = str.split("=");
            jsonObject.put(keyValues[0], (Object)keyValues[1]);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u89e3\u6790\u5f97\u5230\u7684JSON\u5bf9\u8c61\u4e3a\uff1a{}", (Object)jsonObject.toJSONString());
        }
        return jsonObject;
    }

    private String validateRefundArgs(PayAbleRefundReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paramMap = reqBo.getParaMap();
        if (StringUtils.isEmpty((Object)paramMap)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'refundOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTradeTime())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'tradeTime'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return this.validateParaMap(reqBo.getParaMap());
    }

    protected String validateParaMap(Map<String, String> paraMap) {
        if (StringUtils.isEmpty(paraMap)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paraMap.get("MerId"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'MerId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paraMap.get("chinaPayCert"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'chinaPayCert'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paraMap.get("merpfx"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'merpfx'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)paraMap.get("merPassword"))) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2d\u7684'merPassword'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

