/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSONObject;
import com.chinapay.secss.SecssConstants;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractChinaPayAble;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ChinaPayQrPayAbleImpl
extends AbstractChinaPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(ChinaPayQrPayAbleImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Value(value="${china.pay.time.out:6}")
    private Integer payTimeOut;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.CHINA_PAY_QR.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String chinaPayUrl = this.payPropertiesVo.getValueByKey("china.pay.qr.url");
        if (StringUtils.isEmpty((Object)chinaPayUrl)) {
            log.error("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u4e8c\u7ef4\u7801\u652f\u4ed8\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.pay.qr.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u4e8c\u7ef4\u7801\u652f\u4ed8\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.pay.qr.url");
            return retBo;
        }
        String chinaPayNotifyUrl = this.payPropertiesVo.getValueByKey("china.pay.notify.url");
        if (StringUtils.isEmpty((Object)chinaPayNotifyUrl)) {
            log.error("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u652f\u4ed8\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0{}", (Object)"china.pay.notify.url");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e2d\u56fd\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u652f\u4ed8\u56de\u8c03\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0china.pay.notify.url");
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        String merId = (String)paraMap.get("MerId");
        DateTime nowTime = new DateTime();
        HashMap<String, String> requestMap = new HashMap<String, String>(16);
        requestMap.put("Version", "20140728");
        requestMap.put("AccessType", "0");
        requestMap.put("MerId", merId);
        requestMap.put("MerOrderNo", reqBo.getPayOrderId());
        requestMap.put("TranDate", nowTime.toString("yyyyMMdd"));
        requestMap.put("TranTime", nowTime.toString("HHmmss"));
        requestMap.put("OrderAmt", reqBo.getPayFee().toString());
        requestMap.put("TranType", "0009");
        requestMap.put("BusiType", "0001");
        requestMap.put("CurryNo", "CNY");
        requestMap.put("MerBgUrl", chinaPayNotifyUrl);
        JSONObject orderReserved = new JSONObject();
        DateTime timeExpire = nowTime.plusMinutes(this.payTimeOut.intValue());
        orderReserved.put("OrderType", (Object)"0001");
        orderReserved.put("OrderValidTime", (Object)timeExpire.toString("yyyyMMddHHmmss"));
        orderReserved.put("qrPattern", (Object)"link");
        requestMap.put("OrderReserved", orderReserved.toJSONString());
        String signature = super.doSign(paraMap, requestMap);
        requestMap.put("Signature", signature);
        Map rspData = AcpService.post(requestMap, (String)chinaPayUrl, (String)"UTF-8");
        if (rspData.isEmpty()) {
            retBo.setRespCode("212000");
            retBo.setRespDesc("\u94f6\u8054\uff08\u65b0\u4e00\u4ee3\uff09\u4e8c\u7ef4\u7801\u8bf7\u6c42\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a");
            return retBo;
        }
        if (!SecssConstants.SUCCESS.equals(super.doVerify(paraMap, rspData))) {
            retBo.setRespCode("212001");
            retBo.setRespDesc("\u6821\u9a8c\u8fd4\u56de\u7b7e\u540d\u5931\u8d25\uff01");
            return retBo;
        }
        String respCode = (String)rspData.get("respCode");
        if (!"0000".equals(respCode)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc((String)rspData.get("respMsg"));
            return retBo;
        }
        String qrCode = (String)rspData.get("PayReserved");
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u83b7\u53d6\u4e8c\u7ef4\u7801\u6210\u529f\uff01");
        retBo.setQrCodeUrl(qrCode);
        DateTime newTime = new DateTime();
        Integer seconds = Seconds.secondsBetween((ReadableInstant)newTime, (ReadableInstant)nowTime).getSeconds();
        String effectiveSeconds = String.valueOf(seconds);
        retBo.setEffectiveSeconds(effectiveSeconds);
        return retBo;
    }

    @Override
    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        PayAbleCallBackRspBo retBo = super.dealCallBack(reqBo);
        if (reqBo.isRefund()) {
            retBo.setRefundOrderId(retBo.getPayOrderId());
            retBo.setRefundNotifyTransId(retBo.getPayNotifyTransId());
        }
        return retBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'reqBo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

